-----------------------------------------------------------------------
--
--  File:        nt_console.ads
--  Description: Win95/NT console support
--  Rev:         0.3
--  Date:        08-june-1999
--  Author:      Jerry van Dijk
--  Mail:        jdijk@acm.org
--
--  Copyright (c) Jerry van Dijk, 1997, 1998, 1999
--  Billie Holidaystraat 28
--  2324 LK  LEIDEN
--  THE NETHERLANDS
--  tel int + 31 71 531 43 65
--
--  Permission granted to use for any purpose, provided this copyright
--  remains attached and unmodified.
--
--  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
--  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
--  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  Rev:         0.3.1
--  Date:        08-November-2008
--  Little_Improver:
--  Krzysiek Wesolowski
--  Mail:        kwesoly@kwesoly.net
--
--	Change Log:
--	Added Standard Ascii Character Constants (Letters, Numbers and Return)
--	Added Wait_For_Any_Key procedure (useful when program ends and it
--		should not close it's window or just to avoid using constructs like
--		Get_Immediate(temp) with temp declared much earlier in code
--	Removed unused code and added few syntax fixes (lack of constants)
-----------------------------------------------------------------------

package NT_Console is

   ----------------------
   -- TYPE DEFINITIONS --
   ----------------------

   subtype X_Pos is Natural range 0 .. 79;
   subtype Y_Pos is Natural range 0 .. 24;

   type Color_Type is
     (Black, Blue, Green, Cyan, Red, Magenta, Brown, Gray,
      Light_Blue, Light_Green, Light_Cyan, Light_Red,
      Light_Magenta, Yellow, White);

   ----------------------
   -- STANDARD PC KEYS --
   ----------------------

   Key_0          		: constant Character := Character'Val ( 48);
   Key_1          		: constant Character := Character'Val ( 49);
   Key_2          		: constant Character := Character'Val ( 50);
   Key_3          		: constant Character := Character'Val ( 51);
   Key_4          		: constant Character := Character'Val ( 52);
   Key_5          		: constant Character := Character'Val ( 53);
   Key_6          		: constant Character := Character'Val ( 54);
   Key_7          		: constant Character := Character'Val ( 55);
   Key_8          		: constant Character := Character'Val ( 56);
   Key_9         		: constant Character := Character'Val ( 57);

   Key_A_Upper          : constant Character := Character'Val ( 65);
   Key_B_Upper          : constant Character := Character'Val ( 66);
   Key_C_Upper          : constant Character := Character'Val ( 67);
   Key_D_Upper          : constant Character := Character'Val ( 68);
   Key_E_Upper          : constant Character := Character'Val ( 69);
   Key_F_Upper          : constant Character := Character'Val ( 70);
   Key_G_Upper          : constant Character := Character'Val ( 71);
   Key_H_Upper          : constant Character := Character'Val ( 72);
   Key_I_Upper          : constant Character := Character'Val ( 73);
   Key_J_Upper          : constant Character := Character'Val ( 74);
   Key_K_Upper          : constant Character := Character'Val ( 75);
   Key_L_Upper          : constant Character := Character'Val ( 76);
   Key_M_Upper          : constant Character := Character'Val ( 77);
   Key_N_Upper          : constant Character := Character'Val ( 78);
   Key_O_Upper          : constant Character := Character'Val ( 79);
   Key_P_Upper          : constant Character := Character'Val ( 80);
   Key_Q_Upper          : constant Character := Character'Val ( 81);
   Key_R_Upper          : constant Character := Character'Val ( 82);
   Key_S_Upper          : constant Character := Character'Val ( 83);
   Key_T_Upper          : constant Character := Character'Val ( 84);
   Key_U_Upper          : constant Character := Character'Val ( 85);
   Key_V_Upper          : constant Character := Character'Val ( 86);
   Key_W_Upper          : constant Character := Character'Val ( 87);
   Key_X_Upper          : constant Character := Character'Val ( 88);
   Key_Y_Upper          : constant Character := Character'Val ( 89);
   Key_Z_Upper          : constant Character := Character'Val ( 90);

   Key_A_Lower          : constant Character := Character'Val ( 97);
   Key_B_Lower          : constant Character := Character'Val ( 98);
   Key_C_Lower          : constant Character := Character'Val ( 99);
   Key_D_Lower          : constant Character := Character'Val ( 100);
   Key_E_Lower          : constant Character := Character'Val ( 101);
   Key_F_Lower          : constant Character := Character'Val ( 102);
   Key_G_Lower          : constant Character := Character'Val ( 103);
   Key_H_Lower          : constant Character := Character'Val ( 104);
   Key_I_Lower          : constant Character := Character'Val ( 105);
   Key_J_Lower          : constant Character := Character'Val ( 106);
   Key_K_Lower          : constant Character := Character'Val ( 107);
   Key_L_Lower          : constant Character := Character'Val ( 108);
   Key_M_Lower          : constant Character := Character'Val ( 109);
   Key_N_Lower          : constant Character := Character'Val ( 110);
   Key_O_Lower          : constant Character := Character'Val ( 111);
   Key_P_Lower          : constant Character := Character'Val ( 112);
   Key_Q_Lower          : constant Character := Character'Val ( 113);
   Key_R_Lower          : constant Character := Character'Val ( 114);
   Key_S_Lower          : constant Character := Character'Val ( 115);
   Key_T_Lower          : constant Character := Character'Val ( 116);
   Key_U_Lower          : constant Character := Character'Val ( 117);
   Key_V_Lower          : constant Character := Character'Val ( 118);
   Key_W_Lower          : constant Character := Character'Val ( 119);
   Key_X_Lower          : constant Character := Character'Val ( 120);
   Key_Y_Lower          : constant Character := Character'Val ( 121);
   Key_Z_Lower          : constant Character := Character'Val ( 122);

   Key_Return       	: constant Character := Character'Val ( 13);

   ----------------------
   -- EXTENDED PC KEYS --
   ----------------------

   Key_Alt_Escape       : constant Character := Character'Val (16#01#);
   Key_Control_At       : constant Character := Character'Val (16#03#);
   Key_Alt_Backspace    : constant Character := Character'Val (16#0e#);
   Key_Backtab          : constant Character := Character'Val (16#0f#);
   Key_Alt_Q            : constant Character := Character'Val (16#10#);
   Key_Alt_W            : constant Character := Character'Val (16#11#);
   Key_Alt_E            : constant Character := Character'Val (16#12#);
   Key_Alt_R            : constant Character := Character'Val (16#13#);
   Key_Alt_T            : constant Character := Character'Val (16#14#);
   Key_Alt_Y            : constant Character := Character'Val (16#15#);
   Key_Alt_U            : constant Character := Character'Val (16#16#);
   Key_Alt_I            : constant Character := Character'Val (16#17#);
   Key_Alt_O            : constant Character := Character'Val (16#18#);
   Key_Alt_P            : constant Character := Character'Val (16#19#);
   Key_Alt_Lbracket     : constant Character := Character'Val (16#1a#);
   Key_Alt_Rbracket     : constant Character := Character'Val (16#1b#);
   Key_Alt_Return       : constant Character := Character'Val (16#1c#);
   Key_Alt_A            : constant Character := Character'Val (16#1e#);
   Key_Alt_S            : constant Character := Character'Val (16#1f#);
   Key_Alt_D            : constant Character := Character'Val (16#20#);
   Key_Alt_F            : constant Character := Character'Val (16#21#);
   Key_Alt_G            : constant Character := Character'Val (16#22#);
   Key_Alt_H            : constant Character := Character'Val (16#23#);
   Key_Alt_J            : constant Character := Character'Val (16#24#);
   Key_Alt_K            : constant Character := Character'Val (16#25#);
   Key_Alt_L            : constant Character := Character'Val (16#26#);
   Key_Alt_Semicolon    : constant Character := Character'Val (16#27#);
   Key_Alt_Quote        : constant Character := Character'Val (16#28#);
   Key_Alt_Backquote    : constant Character := Character'Val (16#29#);
   Key_Alt_Backslash    : constant Character := Character'Val (16#2b#);
   Key_Alt_Z            : constant Character := Character'Val (16#2c#);
   Key_Alt_X            : constant Character := Character'Val (16#2d#);
   Key_Alt_C            : constant Character := Character'Val (16#2e#);
   Key_Alt_V            : constant Character := Character'Val (16#2f#);
   Key_Alt_B            : constant Character := Character'Val (16#30#);
   Key_Alt_N            : constant Character := Character'Val (16#31#);
   Key_Alt_M            : constant Character := Character'Val (16#32#);
   Key_Alt_Comma        : constant Character := Character'Val (16#33#);
   Key_Alt_Period       : constant Character := Character'Val (16#34#);
   Key_Alt_Slash        : constant Character := Character'Val (16#35#);
   Key_Alt_Kpstar       : constant Character := Character'Val (16#37#);
   Key_F1               : constant Character := Character'Val (16#3b#);
   Key_F2               : constant Character := Character'Val (16#3c#);
   Key_F3               : constant Character := Character'Val (16#3d#);
   Key_F4               : constant Character := Character'Val (16#3e#);
   Key_F5               : constant Character := Character'Val (16#3f#);
   Key_F6               : constant Character := Character'Val (16#40#);
   Key_F7               : constant Character := Character'Val (16#41#);
   Key_F8               : constant Character := Character'Val (16#42#);
   Key_F9               : constant Character := Character'Val (16#43#);
   Key_F10              : constant Character := Character'Val (16#44#);
   Key_Home             : constant Character := Character'Val (16#47#);
   Key_Up               : constant Character := Character'Val (16#48#);
   Key_Pageup           : constant Character := Character'Val (16#49#);
   Key_Alt_Kpminus      : constant Character := Character'Val (16#4a#);
   Key_Left             : constant Character := Character'Val (16#4b#);
   Key_Center           : constant Character := Character'Val (16#4c#);
   Key_Right            : constant Character := Character'Val (16#4d#);
   Key_Alt_Kpplus       : constant Character := Character'Val (16#4e#);
   Key_End              : constant Character := Character'Val (16#4f#);
   Key_Down             : constant Character := Character'Val (16#50#);
   Key_Pagedown         : constant Character := Character'Val (16#51#);
   Key_Insert           : constant Character := Character'Val (16#52#);
   Key_Delete           : constant Character := Character'Val (16#53#);
   Key_Shift_F1         : constant Character := Character'Val (16#54#);
   Key_Shift_F2         : constant Character := Character'Val (16#55#);
   Key_Shift_F3         : constant Character := Character'Val (16#56#);
   Key_Shift_F4         : constant Character := Character'Val (16#57#);
   Key_Shift_F5         : constant Character := Character'Val (16#58#);
   Key_Shift_F6         : constant Character := Character'Val (16#59#);
   Key_Shift_F7         : constant Character := Character'Val (16#5a#);
   Key_Shift_F8         : constant Character := Character'Val (16#5b#);
   Key_Shift_F9         : constant Character := Character'Val (16#5c#);
   Key_Shift_F10        : constant Character := Character'Val (16#5d#);
   Key_Control_F1       : constant Character := Character'Val (16#5e#);
   Key_Control_F2       : constant Character := Character'Val (16#5f#);
   Key_Control_F3       : constant Character := Character'Val (16#60#);
   Key_Control_F4       : constant Character := Character'Val (16#61#);
   Key_Control_F5       : constant Character := Character'Val (16#62#);
   Key_Control_F6       : constant Character := Character'Val (16#63#);
   Key_Control_F7       : constant Character := Character'Val (16#64#);
   Key_Control_F8       : constant Character := Character'Val (16#65#);
   Key_Control_F9       : constant Character := Character'Val (16#66#);
   Key_Control_F10      : constant Character := Character'Val (16#67#);
   Key_Alt_F1           : constant Character := Character'Val (16#68#);
   Key_Alt_F2           : constant Character := Character'Val (16#69#);
   Key_Alt_F3           : constant Character := Character'Val (16#6a#);
   Key_Alt_F4           : constant Character := Character'Val (16#6b#);
   Key_Alt_F5           : constant Character := Character'Val (16#6c#);
   Key_Alt_F6           : constant Character := Character'Val (16#6d#);
   Key_Alt_F7           : constant Character := Character'Val (16#6e#);
   Key_Alt_F8           : constant Character := Character'Val (16#6f#);
   Key_Alt_F9           : constant Character := Character'Val (16#70#);
   Key_Alt_F10          : constant Character := Character'Val (16#71#);
   Key_Control_Left     : constant Character := Character'Val (16#73#);
   Key_Control_Right    : constant Character := Character'Val (16#74#);
   Key_Control_End      : constant Character := Character'Val (16#75#);
   Key_Control_Pagedown : constant Character := Character'Val (16#76#);
   Key_Control_Home     : constant Character := Character'Val (16#77#);
   Key_Alt_1            : constant Character := Character'Val (16#78#);
   Key_Alt_2            : constant Character := Character'Val (16#79#);
   Key_Alt_3            : constant Character := Character'Val (16#7a#);
   Key_Alt_4            : constant Character := Character'Val (16#7b#);
   Key_Alt_5            : constant Character := Character'Val (16#7c#);
   Key_Alt_6            : constant Character := Character'Val (16#7d#);
   Key_Alt_7            : constant Character := Character'Val (16#7e#);
   Key_Alt_8            : constant Character := Character'Val (16#7f#);
   Key_Alt_9            : constant Character := Character'Val (16#80#);
   Key_Alt_0            : constant Character := Character'Val (16#81#);
   Key_Alt_Dash         : constant Character := Character'Val (16#82#);
   Key_Alt_Equals       : constant Character := Character'Val (16#83#);
   Key_Control_Pageup   : constant Character := Character'Val (16#84#);
   Key_F11              : constant Character := Character'Val (16#85#);
   Key_F12              : constant Character := Character'Val (16#86#);
   Key_Shift_F11        : constant Character := Character'Val (16#87#);
   Key_Shift_F12        : constant Character := Character'Val (16#88#);
   Key_Control_F11      : constant Character := Character'Val (16#89#);
   Key_Control_F12      : constant Character := Character'Val (16#8a#);
   Key_Alt_F11          : constant Character := Character'Val (16#8b#);
   Key_Alt_F12          : constant Character := Character'Val (16#8c#);
   Key_Control_Up       : constant Character := Character'Val (16#8d#);
   Key_Control_Kpdash   : constant Character := Character'Val (16#8e#);
   Key_Control_Center   : constant Character := Character'Val (16#8f#);
   Key_Control_Kpplus   : constant Character := Character'Val (16#90#);
   Key_Control_Down     : constant Character := Character'Val (16#91#);
   Key_Control_Insert   : constant Character := Character'Val (16#92#);
   Key_Control_Delete   : constant Character := Character'Val (16#93#);
   Key_Control_Kpslash  : constant Character := Character'Val (16#95#);
   Key_Control_Kpstar   : constant Character := Character'Val (16#96#);
   Key_Alt_Ehome        : constant Character := Character'Val (16#97#);
   Key_Alt_Eup          : constant Character := Character'Val (16#98#);
   Key_Alt_Epageup      : constant Character := Character'Val (16#99#);
   Key_Alt_Eleft        : constant Character := Character'Val (16#9b#);
   Key_Alt_Eright       : constant Character := Character'Val (16#9d#);
   Key_Alt_Eend         : constant Character := Character'Val (16#9f#);
   Key_Alt_Edown        : constant Character := Character'Val (16#A0#);
   Key_Alt_Epagedown    : constant Character := Character'Val (16#A1#);
   Key_Alt_Einsert      : constant Character := Character'Val (16#A2#);
   Key_Alt_Edelete      : constant Character := Character'Val (16#A3#);
   Key_Alt_Kpslash      : constant Character := Character'Val (16#A4#);
   Key_Alt_Tab          : constant Character := Character'Val (16#A5#);
   Key_Alt_Enter        : constant Character := Character'Val (16#A6#);

   --------------------
   -- CURSOR CONTROL --
   --------------------
   -- Check if cursor is visible
   function  Cursor_Visible return Boolean;

   --You can hide flashing cursor with Set_Cursor(False);
   procedure Set_Cursor (Visible : in Boolean);

   --You can read current position
   function Where_X return X_Pos;
   function Where_Y return Y_Pos;

   -- Or change it
   procedure Goto_Xy
     (X : in X_Pos := X_Pos'First;
      Y : in Y_Pos := Y_Pos'First);

   -------------------
   -- COLOR CONTROL --
   -------------------

   -- Check current colors
   function Get_Foreground return Color_Type;
   function Get_Background return Color_Type;

   -- And set them
   procedure Set_Foreground (Color : in Color_Type := Gray);
   procedure Set_Background (Color : in Color_Type := Black);

   --------------------
   -- SCREEN CONTROL --
   --------------------
   -- Fills console with Color
   procedure Clear_Screen (Color : in Color_Type := Black);

   -------------------
   -- SOUND CONTROL --
   -------------------
   -- Use system Beep
   procedure Bleep;

   -------------------
   -- INPUT CONTROL --
   -------------------

   -- Get one character from input buffer
   function Get_Key return Character;

   -- check if character waits in input buffer
   function Key_Available return Boolean;

   -- stop program until character appear in buffer
   -- after that buffer is flushed
   procedure Wait_For_Any_Key;

end NT_Console;
