with win32.glu; use win32.glu;
with win32.glut; use win32.glut;

with Interfaces.C.Strings;
use type Interfaces.C.unsigned;
use type Interfaces.C.unsigned_char;

package body my_OpenGL is

   procedure Init_OpenGL(Title : in String; Window : out Integer) is
      Argc : aliased Integer;
      pragma Import (C, Argc, "gnat_argc");

      type Chars_Ptr_Ptr_Type is access Interfaces.C.Strings.chars_ptr;
      Argv : Chars_Ptr_Ptr_Type;
      pragma Import (C, Argv, "gnat_argv");

   begin
      GlutInit (Argc'Access, Argv);
      GlutInitDisplayMode (GLUT_DOUBLE or GLUT_RGB or GLUT_DEPTH);

      GlutInitWindowSize(640, 480);
      GlutInitWindowPosition(400,200);
      Window := GlutCreateWindow(Title);

      GlutDisplayFunc (Display2'Unrestricted_Access);
      GlutReshapeFunc (Reshape2'Unrestricted_Access);
      glutSpecialFunc (specialKeyPressed'Unrestricted_Access);


      GlClearColor(1.0, 1.0, 1.0, 1.0);
      glEnable(GL_COLOR_MATERIAL);

   end Init_OpenGL;

   procedure Display is
   begin
      gluLookAt(eyex    => 10.0,
                eyey    => 10.0,
                eyez    => 10.0,
                centerx => 0.0,
                centery => 0.0,
                centerz => 0.0,
                upx     => 0.0,
                upy     => 0.0,
                upz     => 1.0);

      glClearColor (1.0,1.0,1.0,0.0);
      glClear (GL_COLOR_BUFFER_BIT);

      glBegin (GL_LINES);
      glColor3d (1.0,0.0,0.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (1.0, 0.0, 0.0);

      glColor3d (0.0,1.0,0.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (0.0, 1.0, 0.0);

      glColor3d (0.0,0.0,1.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (0.0, 0.0, 1.0);
      glEnd;

      glutSwapBuffers;
   end Display;

   procedure Display1 is
   begin
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity;

      gluLookAt(eyex    => 10.0,
                eyey    => 10.0,
                eyez    => 10.0,
                centerx => 0.0,
                centery => 0.0,
                centerz => 0.0,
                upx     => 0.0,
                upy     => 0.0,
                upz     => 1.0);

      glClearColor (1.0,1.0,1.0,0.0);
      glClear (GL_COLOR_BUFFER_BIT);

      glBegin (GL_LINES);
      glColor3d (1.0,0.0,0.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (1.0, 0.0, 0.0);

      glColor3d (0.0,1.0,0.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (0.0, 1.0, 0.0);

      glColor3d (0.0,0.0,1.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (0.0, 0.0, 1.0);
      glEnd;

      glTranslatef(1.0,2.0,3.0);
      glBegin(GL_QUADS);
      glColor3d (0.6,0.8,0.8);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (1.0, 0.0, 0.0);
      glVertex3f (1.0, 1.0, 0.0);
      glVertex3f (0.0, 1.0, 0.0);
      glEnd;

      glTranslatef(1.0,2.0,3.0);
      glBegin(GL_QUADS);
      glColor3d (0.6,0.8,0.8);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (1.0, 0.0, 0.0);
      glVertex3f (1.0, 1.0, 0.0);
      glVertex3f (0.0, 1.0, 0.0);
      glEnd;

      glutSwapBuffers;
   end Display1;

   procedure Display2 is
   begin
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity;

      gluLookAt(eyex    => 10.0,
                eyey    => 10.0,
                eyez    => 10.0,
                centerx => 0.0,
                centery => 0.0,
                centerz => 0.0,
                upx     => 0.0,
                upy     => 0.0,
                upz     => 1.0);

      glRotated(angle => rotateZ,
                x     => 0.0,
                y     => 0.0,
                z     => 1.0);

      glClearColor (1.0,1.0,1.0,0.0);
      glClear (GL_COLOR_BUFFER_BIT);

      glBegin (GL_LINES);
      glColor3d (1.0,0.0,0.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (1.0, 0.0, 0.0);

      glColor3d (0.0,1.0,0.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (0.0, 1.0, 0.0);

      glColor3d (0.0,0.0,1.0);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (0.0, 0.0, 1.0);
      glEnd;

      glPushMatrix;

      glTranslatef(1.0,2.0,3.0);
      glBegin(GL_QUADS);
      glColor3d (0.6,0.8,0.8);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (1.0, 0.0, 0.0);
      glVertex3f (1.0, 1.0, 0.0);
      glVertex3f (0.0, 1.0, 0.0);
      glEnd;

      glPopMatrix;
      glPushMatrix;

      glTranslatef(-1.0,-2.0,-3.0);
      glBegin(GL_QUADS);
      glColor3d (0.6,0.8,0.8);
      glVertex3f (0.0, 0.0, 0.0);
      glVertex3f (1.0, 0.0, 0.0);
      glVertex3f (1.0, 1.0, 0.0);
      glVertex3f (0.0, 1.0, 0.0);
      glEnd;

      glPopMatrix;
      glPushMatrix;

      glTranslatef(2.0,2.0,0.0);
      glutWireOctahedron;

      glPopMatrix;

      glTranslatef(-2.0,-2.0,-1.0);
      glutWireCube(1.0);

      glutSwapBuffers;
   end Display2;

   procedure Reshape1(width: integer; height: integer) is
   begin
      glMatrixMode (GL_PROJECTION);
      glLoadIdentity;
      gluPerspective(30.0, 1.0, 1.0, 300.0);
      glMatrixMode (GL_MODELVIEW);
      glViewport (0, 0, GLsizei(width), GLsizei(height));
   end Reshape1;

   procedure Reshape2(width: integer; height: integer) is
   begin
      glMatrixMode (GL_PROJECTION);
      glLoadIdentity;
      gluPerspective(30.0, 1.0, 1.0, 300.0);
      glMatrixMode (GL_MODELVIEW);
      glViewport (GLint((width-640)/2), GLint((height-480)/2), 640, 480);
   end Reshape2;

   procedure specialKeyPressed(i: in integer; x: in integer; y: in integer) is
   begin
      case i is
         when GLUT_KEY_LEFT => rotateZ := rotateZ + 3.0;
         when GLUT_KEY_RIGHT => rotateZ := rotateZ - 3.0;
         when others => NULL;
      end case;
      glutPostRedisplay;
   end specialKeyPressed;

end my_OpenGL;
