pragma Ada_95;
pragma Source_File_Name (ada_main, Spec_File_Name => "b~pierwszy.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b~pierwszy.adb");

package body ada_main is
   pragma Warnings (Off);

   procedure Do_Finalize;
   pragma Import (C, Do_Finalize, "system__standard_library__adafinal");

   Local_Priority_Specific_Dispatching : constant String := "";
   Local_Interrupt_States : constant String := "";

   procedure adainit is
      E20 : Boolean; pragma Import (Ada, E20, "system__secondary_stack_E");
      E16 : Boolean; pragma Import (Ada, E16, "system__soft_links_E");
      E26 : Boolean; pragma Import (Ada, E26, "system__exception_table_E");
      E08 : Boolean; pragma Import (Ada, E08, "interfaces__c_E");
      E49 : Boolean; pragma Import (Ada, E49, "interfaces__c__strings_E");
      E51 : Boolean; pragma Import (Ada, E51, "win32_E");
      E05 : Boolean; pragma Import (Ada, E05, "my_opengl_E");
      E53 : Boolean; pragma Import (Ada, E53, "win32__glu_E");
      E56 : Boolean; pragma Import (Ada, E56, "win32__glut_E");

      Main_Priority : Integer;
      pragma Import (C, Main_Priority, "__gl_main_priority");
      Time_Slice_Value : Integer;
      pragma Import (C, Time_Slice_Value, "__gl_time_slice_val");
      WC_Encoding : Character;
      pragma Import (C, WC_Encoding, "__gl_wc_encoding");
      Locking_Policy : Character;
      pragma Import (C, Locking_Policy, "__gl_locking_policy");
      Queuing_Policy : Character;
      pragma Import (C, Queuing_Policy, "__gl_queuing_policy");
      Task_Dispatching_Policy : Character;
      pragma Import (C, Task_Dispatching_Policy, "__gl_task_dispatching_policy");
      Priority_Specific_Dispatching : System.Address;
      pragma Import (C, Priority_Specific_Dispatching, "__gl_priority_specific_dispatching");
      Num_Specific_Dispatching : Integer;
      pragma Import (C, Num_Specific_Dispatching, "__gl_num_specific_dispatching");
      Interrupt_States : System.Address;
      pragma Import (C, Interrupt_States, "__gl_interrupt_states");
      Num_Interrupt_States : Integer;
      pragma Import (C, Num_Interrupt_States, "__gl_num_interrupt_states");
      Unreserve_All_Interrupts : Integer;
      pragma Import (C, Unreserve_All_Interrupts, "__gl_unreserve_all_interrupts");
      Zero_Cost_Exceptions : Integer;
      pragma Import (C, Zero_Cost_Exceptions, "__gl_zero_cost_exceptions");
      Detect_Blocking : Integer;
      pragma Import (C, Detect_Blocking, "__gl_detect_blocking");
      Default_Stack_Size : Integer;
      pragma Import (C, Default_Stack_Size, "__gl_default_stack_size");
      Leap_Seconds_Support : Integer;
      pragma Import (C, Leap_Seconds_Support, "__gl_leap_seconds_support");

      procedure Install_Handler;
      pragma Import (C, Install_Handler, "__gnat_install_handler");

      Handler_Installed : Integer;
      pragma Import (C, Handler_Installed, "__gnat_handler_installed");
   begin
      Main_Priority := -1;
      Time_Slice_Value := -1;
      WC_Encoding := 'b';
      Locking_Policy := ' ';
      Queuing_Policy := ' ';
      Task_Dispatching_Policy := ' ';
      Priority_Specific_Dispatching :=
        Local_Priority_Specific_Dispatching'Address;
      Num_Specific_Dispatching := 0;
      Interrupt_States := Local_Interrupt_States'Address;
      Num_Interrupt_States := 0;
      Unreserve_All_Interrupts := 0;
      Zero_Cost_Exceptions := 1;
      Detect_Blocking := 0;
      Default_Stack_Size := -1;
      Leap_Seconds_Support := 0;

      if Handler_Installed = 0 then
         Install_Handler;
      end if;

      System.Soft_Links'Elab_Body;
      E16 := True;
      System.Secondary_Stack'Elab_Body;
      E20 := True;
      System.Exception_Table'Elab_Body;
      E26 := True;
      Interfaces.C'Elab_Spec;
      E08 := True;
      Interfaces.C.Strings'Elab_Spec;
      E49 := True;
      E51 := True;
      E53 := True;
      E56 := True;
      E05 := True;
   end adainit;

   procedure adafinal is
   begin
      Do_Finalize;
   end adafinal;

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure initialize (Addr : System.Address);
      pragma Import (C, initialize, "__gnat_initialize");

      procedure finalize;
      pragma Import (C, finalize, "__gnat_finalize");

      procedure Ada_Main_Program;
      pragma Import (Ada, Ada_Main_Program, "_ada_pierwszy");

      SEH : aliased array (1 .. 2) of Integer;

      Ensure_Reference : aliased System.Address := Ada_Main_Program_Name'Address;
      pragma Volatile (Ensure_Reference);

   begin
      gnat_argc := argc;
      gnat_argv := argv;
      gnat_envp := envp;

      Initialize (SEH'Address);
      adainit;
      Break_Start;
      Ada_Main_Program;
      Do_Finalize;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   c:\gnat\2008\lib\win32ada\win32.o
   --   c:\gnat\2008\lib\win32ada\win32-gl.o
   --   c:\gnat\2008\lib\win32ada\win32-glut.o
   --   d:\eclipse\gnat\ws\pierwszy\objs\my_OpenGL.o
   --   d:\eclipse\gnat\ws\pierwszy\objs\pierwszy.o
   --   -Ld:\eclipse\gnat\ws\pierwszy\objs\
   --   -Lc:\gnat\2008\lib\win32ada\
   --   -Lc:\gnat\2008\bindings\glut-3.7\
   --   -LC:/GNAT/2008/lib/gcc/pentium-mingw32msv/4.1.3/adalib/
   --   -lopengl32
   --   -lglu32
   --   -lglut32
   --   -lwin32ada
   --   -luser32
   --   -lgdi32
   --   -lcomdlg32
   --   -static
   --   -lgnat
   --   -Wl,--stack=0x2000000
--  END Object file/option list   

end ada_main;
