pragma Ada_95;
with System;
package ada_main is
   pragma Warnings (Off);

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: GPL 2008 (20080521)";
   pragma Export (C, GNAT_Version, "__gnat_version");

   Ada_Main_Program_Name : constant String := "_ada_pierwszy" & ASCII.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adafinal;
   pragma Export (C, adafinal, "adafinal");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   procedure Break_Start;
   pragma Import (C, Break_Start, "__gnat_break_start");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#a0ebbad5#;
   u00002 : constant Version_32 := 16#4b33036a#;
   u00003 : constant Version_32 := 16#03570e27#;
   u00004 : constant Version_32 := 16#e0c30560#;
   u00005 : constant Version_32 := 16#a8fcd680#;
   u00006 : constant Version_32 := 16#a69cad5c#;
   u00007 : constant Version_32 := 16#59507545#;
   u00008 : constant Version_32 := 16#e98c0dd7#;
   u00009 : constant Version_32 := 16#fbef5e54#;
   u00010 : constant Version_32 := 16#c18f1a41#;
   u00011 : constant Version_32 := 16#9c7dd3ea#;
   u00012 : constant Version_32 := 16#9201cee0#;
   u00013 : constant Version_32 := 16#e3d85f73#;
   u00014 : constant Version_32 := 16#f47f7e1a#;
   u00015 : constant Version_32 := 16#b6c89fbe#;
   u00016 : constant Version_32 := 16#6820c3b1#;
   u00017 : constant Version_32 := 16#2ea84b20#;
   u00018 : constant Version_32 := 16#075128f3#;
   u00019 : constant Version_32 := 16#6ad13d41#;
   u00020 : constant Version_32 := 16#624725c8#;
   u00021 : constant Version_32 := 16#55ef7c79#;
   u00022 : constant Version_32 := 16#19e913e9#;
   u00023 : constant Version_32 := 16#e1e7b9d6#;
   u00024 : constant Version_32 := 16#3c922801#;
   u00025 : constant Version_32 := 16#fcfb2939#;
   u00026 : constant Version_32 := 16#fad48c61#;
   u00027 : constant Version_32 := 16#1a63fe0c#;
   u00028 : constant Version_32 := 16#82df390a#;
   u00029 : constant Version_32 := 16#5b8b9839#;
   u00030 : constant Version_32 := 16#e4c038da#;
   u00031 : constant Version_32 := 16#0a4e56be#;
   u00032 : constant Version_32 := 16#70200cc8#;
   u00033 : constant Version_32 := 16#573451fa#;
   u00034 : constant Version_32 := 16#86b16e79#;
   u00035 : constant Version_32 := 16#9c49ee35#;
   u00036 : constant Version_32 := 16#9e11aaf2#;
   u00037 : constant Version_32 := 16#348684ff#;
   u00038 : constant Version_32 := 16#743d3d0d#;
   u00039 : constant Version_32 := 16#5f7df983#;
   u00040 : constant Version_32 := 16#ccde3404#;
   u00041 : constant Version_32 := 16#db0ab672#;
   u00042 : constant Version_32 := 16#2c57c517#;
   u00043 : constant Version_32 := 16#d4eef2e5#;
   u00044 : constant Version_32 := 16#300a43f3#;
   u00045 : constant Version_32 := 16#ffc7ae95#;
   u00046 : constant Version_32 := 16#99c8a881#;
   u00047 : constant Version_32 := 16#49205949#;
   u00048 : constant Version_32 := 16#258ddf68#;
   u00049 : constant Version_32 := 16#38237c53#;
   u00050 : constant Version_32 := 16#30239ec5#;
   u00051 : constant Version_32 := 16#8373cfb5#;
   u00052 : constant Version_32 := 16#0dee1f01#;
   u00053 : constant Version_32 := 16#5c28e8f6#;
   u00054 : constant Version_32 := 16#b66daeb9#;
   u00055 : constant Version_32 := 16#315b1e24#;
   u00056 : constant Version_32 := 16#99b8a091#;
   u00057 : constant Version_32 := 16#14db7cbc#;
   u00058 : constant Version_32 := 16#f028357e#;

   pragma Export (C, u00001, "pierwszyB");
   pragma Export (C, u00002, "system__standard_libraryB");
   pragma Export (C, u00003, "system__standard_libraryS");
   pragma Export (C, u00004, "my_openglB");
   pragma Export (C, u00005, "my_openglS");
   pragma Export (C, u00006, "interfacesS");
   pragma Export (C, u00007, "interfaces__cB");
   pragma Export (C, u00008, "interfaces__cS");
   pragma Export (C, u00009, "ada__exceptionsB");
   pragma Export (C, u00010, "ada__exceptionsS");
   pragma Export (C, u00011, "adaS");
   pragma Export (C, u00012, "ada__exceptions__last_chance_handlerB");
   pragma Export (C, u00013, "ada__exceptions__last_chance_handlerS");
   pragma Export (C, u00014, "systemS");
   pragma Export (C, u00015, "system__soft_linksB");
   pragma Export (C, u00016, "system__soft_linksS");
   pragma Export (C, u00017, "system__parametersB");
   pragma Export (C, u00018, "system__parametersS");
   pragma Export (C, u00019, "system__secondary_stackB");
   pragma Export (C, u00020, "system__secondary_stackS");
   pragma Export (C, u00021, "system__storage_elementsB");
   pragma Export (C, u00022, "system__storage_elementsS");
   pragma Export (C, u00023, "system__stack_checkingB");
   pragma Export (C, u00024, "system__stack_checkingS");
   pragma Export (C, u00025, "system__exception_tableB");
   pragma Export (C, u00026, "system__exception_tableS");
   pragma Export (C, u00027, "system__htableB");
   pragma Export (C, u00028, "system__htableS");
   pragma Export (C, u00029, "system__exceptionsB");
   pragma Export (C, u00030, "system__exceptionsS");
   pragma Export (C, u00031, "system__string_opsB");
   pragma Export (C, u00032, "system__string_opsS");
   pragma Export (C, u00033, "system__string_ops_concat_3B");
   pragma Export (C, u00034, "system__string_ops_concat_3S");
   pragma Export (C, u00035, "system__tracebackB");
   pragma Export (C, u00036, "system__tracebackS");
   pragma Export (C, u00037, "system__unsigned_typesS");
   pragma Export (C, u00038, "system__wch_conB");
   pragma Export (C, u00039, "system__wch_conS");
   pragma Export (C, u00040, "system__wch_stwB");
   pragma Export (C, u00041, "system__wch_stwS");
   pragma Export (C, u00042, "system__wch_cnvB");
   pragma Export (C, u00043, "system__wch_cnvS");
   pragma Export (C, u00044, "system__wch_jisB");
   pragma Export (C, u00045, "system__wch_jisS");
   pragma Export (C, u00046, "system__traceback_entriesB");
   pragma Export (C, u00047, "system__traceback_entriesS");
   pragma Export (C, u00048, "interfaces__c__stringsB");
   pragma Export (C, u00049, "interfaces__c__stringsS");
   pragma Export (C, u00050, "win32B");
   pragma Export (C, u00051, "win32S");
   pragma Export (C, u00052, "win32__gluB");
   pragma Export (C, u00053, "win32__gluS");
   pragma Export (C, u00054, "win32__glS");
   pragma Export (C, u00055, "win32__glutB");
   pragma Export (C, u00056, "win32__glutS");
   pragma Export (C, u00057, "system__memoryB");
   pragma Export (C, u00058, "system__memoryS");

   --  BEGIN ELABORATION ORDER
   --  ada%s
   --  interfaces%s
   --  system%s
   --  system.htable%s
   --  system.htable%b
   --  system.parameters%s
   --  system.parameters%b
   --  system.standard_library%s
   --  system.exceptions%s
   --  system.exceptions%b
   --  system.storage_elements%s
   --  system.storage_elements%b
   --  system.secondary_stack%s
   --  system.stack_checking%s
   --  system.stack_checking%b
   --  system.string_ops%s
   --  system.string_ops%b
   --  system.string_ops_concat_3%s
   --  system.string_ops_concat_3%b
   --  system.traceback%s
   --  system.traceback%b
   --  system.traceback_entries%s
   --  system.traceback_entries%b
   --  ada.exceptions%s
   --  ada.exceptions.last_chance_handler%s
   --  system.soft_links%s
   --  system.soft_links%b
   --  ada.exceptions.last_chance_handler%b
   --  system.secondary_stack%b
   --  system.exception_table%s
   --  system.exception_table%b
   --  interfaces.c%s
   --  interfaces.c%b
   --  interfaces.c.strings%s
   --  interfaces.c.strings%b
   --  system.memory%s
   --  system.memory%b
   --  system.standard_library%b
   --  system.unsigned_types%s
   --  system.wch_con%s
   --  system.wch_con%b
   --  system.wch_cnv%s
   --  system.wch_jis%s
   --  system.wch_jis%b
   --  system.wch_cnv%b
   --  system.wch_stw%s
   --  system.wch_stw%b
   --  ada.exceptions%b
   --  win32%s
   --  win32%b
   --  win32.gl%s
   --  my_opengl%s
   --  win32.glu%s
   --  win32.glu%b
   --  win32.glut%s
   --  win32.glut%b
   --  my_opengl%b
   --  pierwszy%b
   --  END ELABORATION ORDER

end ada_main;
