/*!
 * @file HBFormatPanel.cpp
 * This File holds implementations of all methods from class HBFormatPanel
 * @author Krzysztof Wesołowski
 */

#include "HBFormatPanel.h"
#include <QtGui/QFontDialog>
#include <QtGui/QPalette>
#include <QtGui/QColorDialog>

HBFormatPanel::HBFormatPanel(QWidget * parent,HighlightBlock * _block): QGroupBox(parent)
{
    block=_block;
    this->setTitle("Font and colors settings");
    mainLayout=new QVBoxLayout(this);
    editFontButton=new QPushButton("Change Font");
    fontSample=new QLabel("Sample formatted text");
    updateSample();
    mainLayout->addWidget(fontSample);

    buttonsLayout=new QHBoxLayout();
    editFontButton=new QPushButton("Change Font Style");;
    editFColorButton=new QPushButton("Change Foreground Color");
    editBColorButton=new QPushButton("Change Background Color");

    buttonsLayout->addWidget(editFontButton);
    buttonsLayout->addWidget(editFColorButton);
    buttonsLayout->addWidget(editBColorButton);

    mainLayout->addLayout(buttonsLayout);
    connect(editFontButton,SIGNAL(clicked()),this,SLOT(showFontDialog()));
    connect(editFColorButton,SIGNAL(clicked()),this,SLOT(showFColorDialog()));
    connect(editBColorButton,SIGNAL(clicked()),this,SLOT(showBColorDialog()));
};
void HBFormatPanel::updateSample()
{
    fontSample->setFont(block->getFont());
    QPalette temp=fontSample->palette();
    temp.setColor(QPalette::WindowText,block->getForegroundColor());
    temp.setColor(fontSample->backgroundRole(),block->getBackgroundColor());
    fontSample->setPalette(temp);
    fontSample->setAutoFillBackground(true);
}
void HBFormatPanel::showFontDialog()
{
    bool ok;
    block->setFont(QFontDialog::getFont(&ok,block->getFont(),this));
    if(ok)
        updateSample();

}
void HBFormatPanel::showFColorDialog()
{
    block->setForegroundColor(QColorDialog::getColor(block->getForegroundColor(),this));
    updateSample();
}
void HBFormatPanel::showBColorDialog()
{
    block->setBackgroundColor(QColorDialog::getColor(block->getBackgroundColor(),this));
    updateSample();
}
