/*!
 * @file HBFormatPanel.h
 * This File holds declaration a class HBFormatPanel
 * @author Krzysztof Wesołowski
 */

#ifndef HBFORMATPANEL_H_
#define HBFORMATPANEL_H_

#include <QtGui/QGroupBox>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QSpacerItem>

#include "HighlightBlock.h"

/*!
 * @brief Class specifying look and behavior of panel used to edit HighlightBlock formating
 */
class HBFormatPanel : public QGroupBox
{
    Q_OBJECT
private:
    HighlightBlock * block; ///<Currently edited block
    QVBoxLayout * mainLayout; ///<Layout organizing sample and buttons layout in 2 rows
    QHBoxLayout * buttonsLayout; ///<Layout organizing buttons in columns
    QLabel * fontSample; ///< Label with presentation of sample text using current formating
    QPushButton * editFontButton; ///< button used to edit font
    QPushButton * editFColorButton; ///< button used to edit foreground color
    QPushButton * editBColorButton; ///< button used to edit background color
    /*!
     * @brief  function used to update sample label with font, usually after font is changed.
     */
    void updateSample();
public:
    /*!
     * @brief Constructor of this panel.
     * Setups edited block and UI
     * it also connects all buttons with appropriate slots
     * @param parent QWidget's parent
     * @param _block block pointing to edited block
     */
    HBFormatPanel(QWidget * parent,HighlightBlock * _block);

private slots:

    /*!
     * @brief Shows QFontDialog, allowing user to edit font of current block,
     * and then updates sample with updateSample();
     */
    void showFontDialog();

    /*!
     * @brief Shows QColorDialog, allowing user to edit foreground color of current block,
     * and then updates sample with updateSample();
     */
    void showFColorDialog();

    /*!
     * @brief Shows QColorDialog, allowing user to edit background color of current block,
     * and then updates sample with updateSample();
     */
    void showBColorDialog();
};

#endif /* HBFORMATPANEL_H_ */
