/*!
* @file HBInfoPanel.h
* This File holds declaration a class HBInfoPanel
* @author Krzysztof Wesołowski
*/

#ifndef HBINFOPANEL_H_
#define HBINFOPANEL_H_

#include <QtGui/QGroupBox>
#include <QtGui/QVBoxLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLineEdit>
#include <QtGui/QLabel>
#include <QtGui/QPlainTextEdit>

#include "HighlightBlock.h"
#include "HSyntaxHighlighterSettings.h"

/*!
* @brief Class specifying look and behavior of panel used to edit HighlightBlock formating
*/
class HBInfoPanel : public QGroupBox
{
    Q_OBJECT
private:
    HighlightBlock * block; ///<Currently edited block
    HSyntaxHighlighterSettings * settings;///<currently edited settings(just for HSyntaxHighlighterSettings::renameBlock)
    QVBoxLayout * mainLayout; ///<Layout organizing QGroupBox
    QPlainTextEdit * descriptionEdit; ///< Edit for description editing
    QLabel * descriptionLabel; ///<Label above description Edit
public:
    /*!
    * @brief Constructor of this panel.
    * Setups edited block and UI
    * it also connects all edits with appropriate slots
    * @param parent QWidget's parent
    * @param _block block pointing to edited block
    */
    HBInfoPanel(QWidget * parent,HighlightBlock * _block)
    {
        block=_block;
        this->setTitle("Basic Info");
        mainLayout=new QVBoxLayout(this);

        descriptionEdit=new QPlainTextEdit(block->getDescription(),this);
        descriptionLabel=new QLabel("Block description:");
        mainLayout->addWidget(descriptionLabel);
        mainLayout->addWidget(descriptionEdit);

        connect(descriptionEdit,SIGNAL(textChanged()),this,SLOT(descriptionChanged()));
    }

private slots:
/*!
 * @brief updating description in real time
 */
void descriptionChanged()
{
    block->setDescription(descriptionEdit->toPlainText());
}
};

#endif /* HBINFOPANEL_H_ */
