/*!
* @file HBSettingsPanel.cpp
* This File holds implementations of methods from class  HBSettingsPanel
* @author Krzysztof Wesołowski
*/


#include "HBSettingsPanel.h"

HBSettingsPanel::HBSettingsPanel(QWidget * parent,HighlightBlock * _block): QGroupBox(parent)
{
    block=_block;
    this->setTitle(block->getName()+" settings");
    groupLayout=new QVBoxLayout(this);
    infoSettings=new HBInfoPanel(this,block);
    groupLayout->addWidget(infoSettings);
    formatSettings=new HBFormatPanel(this,block);
    groupLayout->addWidget(formatSettings);
    if(block->type()==HighlightBlock::sl)
        patternSettings=new HBslPatternsPanel(this,block);
    else
        patternSettings=new HBmlPatternsPanel(this,block);
    groupLayout->addWidget(patternSettings);
};
