/*!
* @file HBslPatternsPanel.h
* This File holds declaration and implementation of class HBslPatternsPanel
* @author Krzysztof Wesołowski
*/

#ifndef HBSLPATTERNSPANEL_H_
#define HBSLPATTERNSPANEL_H_

#include <QtGui/QGroupBox>
#include <QtGui/QLabel>
#include <QtGui/QPlainTextEdit>
#include <QtGui/QVBoxLayout>
#include <QtCore/QDebug>

#include "HighlightBlock.h"

/*!
* @brief Single Line block pattern editing panel
* Class used to display and edit single text pattern form SingleLineHighlightBlock
*/
class HBslPatternsPanel : public QGroupBox
{
    Q_OBJECT
private:
    SingleLineHighlightBlock * block; ///< pointer to currently edited block
    QLabel * patternLabel; ///<Label showing basic info
    QPlainTextEdit * patternEdit; ///< Plain Text Edit where pattern is edited
    QVBoxLayout * layout; ///<layout used to organize this Widgets
public:
    /*!
    * @brief Constructor of this panel
    * This constructor setups edited block and User interface.
    * He also connects signal textChanged() with slot patternEditChanged(),
    * so any changes made to text in editing field affects block
    * @param parent QWidget's parent
    * @param _block block pointing to edited block
    */
    HBslPatternsPanel(QWidget * parent,HighlightBlock * _block): QGroupBox(parent)
    {
        block=static_cast<SingleLineHighlightBlock*>(_block);
        this->setTitle("Regular expression pattern settings");

        layout=new QVBoxLayout(this);
        patternLabel=new QLabel("Edit matching pattern",this);
        patternEdit=new QPlainTextEdit(block->getPattern(),this);
        layout->addWidget(patternLabel);
        layout->addWidget(patternEdit);
        connect(patternEdit,SIGNAL(textChanged()),this,SLOT(patternEditChanged()));
        patternEditChanged();
    };
private slots:
    /*!
    * slot for updating pattern after any change
    */
    void patternEditChanged()
    {
        QString pattern=patternEdit->document()->toPlainText();
        block->setPattern(pattern);
        QPalette palette=patternEdit->palette();
        if (QRegExp(pattern).isValid())
            palette.setColor(QPalette::Base,QColor(150,255,150));
        else
            palette.setColor(QPalette::Base,QColor(255,150,150));
        patternEdit->setPalette(palette);
    }
};

#endif /* HBSLPATTERNSPANEL_H_ */
