/*!
* @file HSyntaxHighlighterDialog.cpp
* @brief Syntax Highlighter dialog implementation files.
* contains implementation of methods from class HSyntaxHighlighterDialog
* @author Krzysztof Wesołowski
*/
#include "HSyntaxHighlighterDialog.h"
#include "HBSettingsPanel.h"

HSyntaxHighlighterDialog::HSyntaxHighlighterDialog(QWidget *parent)
: QDialog(parent)
{
    userInterface.setupUi(this);
    connect(userInterface.HighlightBlocks,SIGNAL(currentTextChanged (const QString &)),this,SLOT(editedItemChanged(const QString &)));
    connect(userInterface.addBlockButton,SIGNAL(clicked()),this,SLOT(addNewItem()));
    connect(userInterface.removeBlockButton,SIGNAL(clicked()),this,SLOT(removeCurrentItem()));
    connect(userInterface.renameBlockButton,SIGNAL(clicked()),this,SLOT(renameCurrentItem()));
}

HSyntaxHighlighterDialog::~HSyntaxHighlighterDialog()
{

}

void HSyntaxHighlighterDialog::setSettings(HSyntaxHighlighterSettings _settings)
{
    settings = _settings;
    this->constructBlockList();
}
HSyntaxHighlighterSettings HSyntaxHighlighterDialog::getSettings()
{
    settings.modified=true;
    return settings;
}
void HSyntaxHighlighterDialog::constructBlockList()
{
    userInterface.HighlightBlocks->clear();

    int i=0;
    foreach(const SingleLineHighlightBlock block,settings.singleLine.values())
    {
        if(!block.getName().isEmpty())
            {
                userInterface.HighlightBlocks->addItem(block.getName());
                userInterface.HighlightBlocks->item(i)->setToolTip(block.getDescription());
                ++i;
            }
    }
    foreach(const MultiLinesHighlightBlock block,settings.multiLines.values())
    {
        if(!block.getName().isEmpty())
            {
                userInterface.HighlightBlocks->addItem(block.getName());
                userInterface.HighlightBlocks->item(i)->setToolTip(block.getDescription());
                ++i;
            }
    }
}

void HSyntaxHighlighterDialog::editedItemChanged(const QString& _name)
{
    QGroupBox * temp=userInterface.blockSettings;
    userInterface.horizontalLayout->removeWidget(userInterface.blockSettings);
    HighlightBlock * block;
    if(settings.singleLine.contains(_name))
        block=&(settings.singleLine[_name]);
    else
        block=&(settings.multiLines[_name]);
    userInterface.blockSettings=new HBSettingsPanel(this,block);
    userInterface.horizontalLayout->addWidget(userInterface.blockSettings);
    delete temp;
}





