/*!
 * @file HSyntaxHighlighterNewBlock.cpp
 * File contains implementation of HSyntaxHighlighterNewBlock class
 * @author Krzysztof Wesołowski
 */
#include <QtGui/QMessageBox>

#include "HSyntaxHighlighterNewBlock.h"


HSyntaxHighlighterNewBlock::HSyntaxHighlighterNewBlock(HSyntaxHighlighterSettings* _settings, QWidget *parent)
    : QDialog(parent)
{
    settings=_settings;
	ui.setupUi(this);
	connect(ui.cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
	connect(ui.acceptButton,SIGNAL(clicked()),this,SLOT(addName()));

}

HSyntaxHighlighterNewBlock::~HSyntaxHighlighterNewBlock()
{

}
void HSyntaxHighlighterNewBlock::addName()
{
    name=ui.editNameEdit->text();
    if(name.isEmpty())
        {
            QMessageBox::warning(this,"Name is null","Cannot add a new block, because block names are required to be not-null");
        }
    else if (settings->blockExists(name))
        {
            QMessageBox::warning(this,"Name already exists","Cannot add a new block, because block names are required to be unique");
        }
    else
        {
            if (ui.slRadio->isChecked())
                settings->addBlock(name,HighlightBlock::sl);
            else
                settings->addBlock(name,HighlightBlock::ml);
            accept();
        }
}




