/*!
 * @file HSyntaxHighlighterNewBlock.h
 * File contains declaration of HSyntaxHighlighterNewBlock class
 * @author Krzysztof Wesołowski
 */
#ifndef HSYNTAXHIGHLIGHTERNEWBLOCK_H
#define HSYNTAXHIGHLIGHTERNEWBLOCK_H

#include <QtGui/QDialog>
#include "ui_HSyntaxHighlighterNewBlock.h"

#include "HSyntaxHighlighterSettings.h"

/*!
 * @brief Class provides a simple dialog for creating new blocks
 */
class HSyntaxHighlighterNewBlock : public QDialog
{
    Q_OBJECT

public:

    /*!
     * @brief Constructs dialog with settings pointer
     * @param _settings pointer to affected settings
     * @param parent owner widget
     */
    HSyntaxHighlighterNewBlock(HSyntaxHighlighterSettings* _settings, QWidget *parent = 0);
    /*!
     * Default destructor
     */
    ~HSyntaxHighlighterNewBlock();
    /*!
     * @brief you can check used name
     * @return Name that user entered
     */
    const QString& getName()
    {
        return name;
    }
private:
    Ui::HSyntaxHighlighterNewBlockClass ui; ///< auto generated GUI
    HSyntaxHighlighterSettings * settings; ///< pinter to settings
    QString name; ///<stored name of new block
private slots:
    /*!
     * @brief Checks if it is possible and creates new highlight block.
     */
    void addName();
};

#endif // HSYNTAXHIGHLIGHTERNEWBLOCK_H
