/*!
* @file HSyntaxHighlighterSettings.cpp
* @brief Syntax Highlighter Settings implementation files.
* File contains implementation of methods form class  HSyntaxHighlighterSettings
* @author Krzysztof Wesołowski
*/

#include <QtCore/QSettings>

#include "HSyntaxHighlighterSettings.h"

HSyntaxHighlighterSettings::HSyntaxHighlighterSettings()
{
   modified=true;
}



void HSyntaxHighlighterSettings::saveConfig(QString _fileName) const
{
    QSettings settings(_fileName,QSettings::IniFormat);
    settings.clear();
    QStringList blNames;
    foreach(SingleLineHighlightBlock block,singleLine.values())
    {
        blNames.append(block.getName());
    }
    settings.setValue("General/Single_Lines_Names",blNames.join("|"));
    blNames.clear();

    foreach(SingleLineHighlightBlock block,singleLine.values())
    {
        settings.setValue(block.getName()+"/description",block.getDescription());
        settings.setValue(block.getName()+"/pattern",block.getPattern());

        QFont font=block.getFont();
        settings.setValue(block.getName()+"/Font Family",font.family());
        settings.setValue(block.getName()+"/Font Size",font.pointSize());
        settings.setValue(block.getName()+"/Font Italic",font.italic());
        settings.setValue(block.getName()+"/Font Bold",font.bold());
        settings.setValue(block.getName()+"/Font Underline",font.underline());
        settings.setValue(block.getName()+"/Font StrikeOut",font.strikeOut());

        QString hexColor=QString::number(block.getForegroundColor().rgb(),16);
        settings.setValue(block.getName()+"/Foreground Color",hexColor);
        hexColor=QString::number(block.getBackgroundColor().rgb(),16);
        settings.setValue(block.getName()+"/Background Color",hexColor);
    }

    foreach(MultiLinesHighlightBlock block, multiLines)
    {
        blNames.append(block.getName());
    }
    settings.setValue("General/Multiple_Lines_Names",blNames.join("|"));

    foreach(MultiLinesHighlightBlock block, multiLines)
    {
        settings.setValue(block.getName()+"/description",block.getDescription());
        settings.setValue(block.getName()+"/starting pattern",block.getStartingPattern());
        settings.setValue(block.getName()+"/ending pattern",block.getEndingPattern());

        QFont font=block.getFont();
        settings.setValue(block.getName()+"/Font Family",font.family());
        settings.setValue(block.getName()+"/Font Size",font.pointSize());
        settings.setValue(block.getName()+"/Font Italic",font.italic());
        settings.setValue(block.getName()+"/Font Bold",font.bold());
        settings.setValue(block.getName()+"/Font Underline",font.underline());
        settings.setValue(block.getName()+"/Font StrikeOut",font.strikeOut());

        QString hexColor=QString::number(block.getForegroundColor().rgb(),16);
        settings.setValue(block.getName()+"/Foreground Color",hexColor);
        hexColor=QString::number(block.getBackgroundColor().rgb(),16);
        settings.setValue(block.getName()+"/Background Color",hexColor);
    }
}

void HSyntaxHighlighterSettings::loadConfig(QString  _fileName)
{

    QSettings settings(_fileName,QSettings::IniFormat);
    QStringList blNames;

    blNames=settings.value("General/Single_Lines_Names").toString().split("|");
    singleLine.clear();
    foreach(QString name,blNames)
    {
        if(!name.isEmpty())
            {
                SingleLineHighlightBlock block;
                block.setName(name);
                block.setDescription(settings.value(block.getName()+"/description").toString());
                block.setPattern(settings.value(block.getName()+"/pattern").toString());

                QFont font;
                font.setFamily(settings.value(block.getName()+"/Font Family").toString());
                int pointSize=settings.value(block.getName()+"/Font Size").toInt();
                font.setPointSize(pointSize > 0 ? pointSize : 8);
                font.setItalic(settings.value(block.getName()+"/Font Italic").toBool());
                font.setBold(settings.value(block.getName()+"/Font Bold").toBool());
                font.setUnderline(settings.value(block.getName()+"/Font Underline").toBool());
                font.setStrikeOut(settings.value(block.getName()+"/Font StrikeOut").toBool());
                block.setFont(font);

                QColor color=QColor::fromRgb(settings.value(block.getName()+"/Foreground Color").toString().toUInt(0,16));
                block.setForegroundColor(color);
                color=QColor::fromRgb(settings.value(block.getName()+"/Background Color").toString().toUInt(0,16));
                block.setBackgroundColor(color);
                singleLine[name]=block;
            }
    }

    blNames=settings.value("General/Multiple_Lines_Names").toString().split("|");
    multiLines.clear();
    foreach(QString name,blNames)
    {
        if(!name.isEmpty())
            {
                MultiLinesHighlightBlock block;
                block.setName(name);
                block.setDescription(settings.value(block.getName()+"/description").toString());
                block.setStartingPattern(settings.value(block.getName()+"/starting pattern").toString());
                block.setEndingPattern(settings.value(block.getName()+"/ending pattern").toString());

                QFont font;
                font.setFamily(settings.value(block.getName()+"/Font Family").toString());
                int pointSize=settings.value(block.getName()+"/Font Size").toInt();
                font.setPointSize(pointSize>0 ? pointSize : 8);
                font.setItalic(settings.value(block.getName()+"/Font Italic").toBool());
                font.setBold(settings.value(block.getName()+"/Font Bold").toBool());
                font.setUnderline(settings.value(block.getName()+"/Font Underline").toBool());
                font.setStrikeOut(settings.value(block.getName()+"/Font StrikeOut").toBool());
                block.setFont(font);

                QColor color=QColor::fromRgb(settings.value(block.getName()+"/Foreground Color").toString().toUInt(0,16));
                block.setForegroundColor(color);
                color=QColor::fromRgb(settings.value(block.getName()+"/Background Color").toString().toUInt(0,16));
                block.setBackgroundColor(color);

                multiLines[name]=block;
            }
    }
    modified=true;
}
QVector<mlFormatingRule> HSyntaxHighlighterSettings::getMultiLinesRules() const
{
    mlFormatingRule rule;
    QVector<mlFormatingRule> result;

    foreach(MultiLinesHighlightBlock block,multiLines)
    {
        rule.beginingExp=block.getStartingExp();
        rule.endingExp=block.getEndingExp();
        rule.format=block.getFormat();
        result.append(rule);
    }
    return result;
}
QVector<slFormatingRule> HSyntaxHighlighterSettings::getSingleLineRules() const
{
    slFormatingRule rule;
    QVector<slFormatingRule> result;

    foreach(SingleLineHighlightBlock block,singleLine)
    {
        rule.exp=block.getExp();
        rule.format=block.getFormat();
        result.append(rule);
    }
    return result;
}



