/*!
 * @file SyntaxHighlighterWindow.h
 * @brief Syntax Highlighter declaration files
 * contains class SyntaxHighlighterWindow, which specify a sample program,
 * using Syntax Highlighting form QT's QSyntaxHighlighter
 * @author Krzysztof Wesołowski
 */
#ifndef SYNTAXHIGLIGHTERWINDOW_H
#define SYNTAXHIGLIGHTERWINDOW_H

#include <QtGui/QWidget>
#include "HSyntaxHighlighter.h"

#include "ui_sh.h"

/*!
 * @class SyntaxHighlighterWindow
 * @brief Main program window class.
 * This class contains basic user interface generated by QtDesigner,
 * with 3 buttons and text edit, and highlighter it presents.
 * The only purpose of this class is to show how HSyntaxHighlighter works,
 * and make some configurations available.
 */
class SyntaxHighlighterWindow : public QWidget
{
    Q_OBJECT

public:

    /*!
     * @brief Default constructor
     * Constructor creating whole main program interface,
     * highlighter and connecting signal & slots
     */
    SyntaxHighlighterWindow(QWidget *parent = 0);
    /*!
     * Default destructor
     */
    ~SyntaxHighlighterWindow();

private:
    Ui::SyntaxHighlighterWindowClass ui;        ///< auto generated user interface class
    HSyntaxHighlighter * highlighter;           ///< highlighter pointer, holds ui.highlightedEdit syntax highlighter
};

#endif // SYNTAXHIGLIGHTERWINDOW_H
