/*!
 * @file HBslPatternsPanel.h
 * This File holds declaration a class HBSettingsPanel
  * @author Krzysztof Wesołowski
 */


#ifndef HBSETTINGSPANEL_H_
#define HBSETTINGSPANEL_H_
#include <QtGui/QGroupBox>
#include <QtGui/QVBoxLayout>

#include "HighlightBlock.h"

#include "HBFormatPanel.h"
#include "HBslPatternsPanel.h"
#include "HBmlPatternsPanel.h"
/*!
 * @class QGroupBox
 * @brief Qt class providing basic group of other widgets
 */
/*!
 * @brief This class provides GroupBox with all panels needed to edit block
 */
class HBSettingsPanel : public QGroupBox
{
    Q_OBJECT
public:
    /*!
     * @brief Constructor of this panel
     * setups edited block and UI (with call to createUI()).
     * @param parent QWidget's parent
     * @param _block block pointing to edited block
     */
    HBSettingsPanel(QWidget * parent,HighlightBlock * _block): QGroupBox(parent)
    {
        block=_block;
        createUI();
    };

    /*!
     * @brief Function used to create User interface
     * initializes settings panels, and depending on blocks type HighlightBlock::type(),
     * Creates right one patterns panel
     */
    void createUI();

private:
    HighlightBlock * block; ///<currently edited block pointer
    QVBoxLayout * groupLayout; ///Layout organizing formatSettings and patternSettings
    HBFormatPanel * formatSettings; ///< Panel for editing formating
    QGroupBox * patternSettings; ///<Panel for editing pattern(s) could be HB(sl|ml)PatternsPanel
};

#endif /* HBSETTINGSPANEL_H_ */
