/*!
 * @file HBslPatternsPanel.h
 * This File holds declaration and implementation of class HBslPatternsPanel
 * @author Krzysztof Wesołowski
 */

#ifndef HBMLPATTERNSPANEL_H_
#define HBMLPATTERNSPANEL_H_

#include <QtGui/QGroupBox>
#include <QtGui/QLabel>
#include <QtGui/QPlainTextEdit>
#include <QtGui/QVBoxLayout>

#include "HighlightBlock.h"

/*!
 * @brief Multiple Line block pattern editing panel.
 * class used to display and edit both text patterns form MultiLinesHighlightBlock
 */
class HBmlPatternsPanel : public QGroupBox
{
        Q_OBJECT
private:
        MultiLinesHighlightBlock * block;  ///< pointer to currently edited block
        QLabel * sPatternLabel; ///<Label showing basic info above starting pattern edit
        QPlainTextEdit * sPatternEdit; ///< Plain Text Edit where starting pattern is edited
        QLabel * ePatternLabel; ///<Label showing basic info above ending pattern edit
        QPlainTextEdit * ePatternEdit; ///< Plain Text Edit where ending pattern is edited
        QVBoxLayout * layout;
public:
    /*!
     * @brief Constructor of this panel.
     * This constructor setups edited block and User interface.
     * He also connects signals textChanged() form both edits with slot patternEditChanged(),
     * so any changes made to text in editing fields affects block
     * @param parent QWidget's parent
     * @param _block block pointing to edited block
     */
    HBmlPatternsPanel(QWidget * parent,HighlightBlock * _block): QGroupBox(parent)
        {
               block=static_cast<MultiLinesHighlightBlock*>(_block);
               this->setTitle(block->getName()+" pattern settings");

               layout=new QVBoxLayout(this);
               sPatternLabel=new QLabel("Edit starting pattern",this);
               sPatternEdit=new QPlainTextEdit(block->getStartingPattern(),this);
               ePatternLabel=new QLabel("Edit ending pattern",this);
               ePatternEdit=new QPlainTextEdit(block->getEndingPattern(),this);

               layout->addWidget(sPatternLabel);
               layout->addWidget(sPatternEdit);
               layout->addWidget(ePatternLabel);
               layout->addWidget(ePatternEdit);

               connect(sPatternEdit,SIGNAL(textChanged()),this,SLOT(patternEditChanged()));
               connect(ePatternEdit,SIGNAL(textChanged()),this,SLOT(patternEditChanged()));
        };
private slots:
    /*!
      * slot for updating both patterns after any change
    */
    void patternEditChanged()
    {
        block->setStartingPattern(sPatternEdit->document()->toPlainText());
        block->setEndingPattern(ePatternEdit->document()->toPlainText());
    }
};

#endif /* HBMLPATTERNSPANEL_H_ */
