/*!
 * @file HSyntaxHighlighterDialog.cpp
 * @brief Syntax Highlighter dialog implementation files.
 * contains implementation of methods from class HSyntaxHighlighterDialog
 * @author Krzysztof Wesołowski
 */
#include "HSyntaxHighlighterDialog.h"
#include "HBSettingsPanel.h"

HSyntaxHighlighterDialog::HSyntaxHighlighterDialog(QWidget *parent)
: QDialog(parent)
{
    slBlocks=NULL;
    mlBlocks=NULL;
    userInterface.setupUi(this);
}

HSyntaxHighlighterDialog::~HSyntaxHighlighterDialog()
{
    if(slBlocks!=NULL)
        {
            delete slBlocks;
        }
    slBlocks=NULL;
    if(mlBlocks!=NULL)
        {
            delete mlBlocks;
        }
    mlBlocks=NULL;
}

void HSyntaxHighlighterDialog::setSettings(HSyntaxHighlighterSettings _settings)
{
    settings = _settings;
    allBlocks.clear();

    if(slBlocks!=NULL)
        {
            delete slBlocks;
        }
    slBlocks=new SingleLineHighlightBlock[settings.singleLine.count()];
    for (int i = 0; i < settings.singleLine.size(); ++i) {
        slBlocks[i]=settings.singleLine[i];
        allBlocks.append(slBlocks+i);
    }

    if(mlBlocks!=NULL)
        {
            delete mlBlocks;
        }
    mlBlocks=new MultiLinesHighlightBlock[settings.multiLines.count()];
    for (int i = 0; i < settings.multiLines.size(); ++i) {
        mlBlocks[i]=settings.multiLines[i];
        allBlocks.append(mlBlocks+i);
    }
    this->constructBlockList();
}
HSyntaxHighlighterSettings HSyntaxHighlighterDialog::getSettings()
{
    for (int i = 0; i < settings.singleLine.size(); ++i) {
        settings.singleLine[i]=slBlocks[i];
    }

    for (int i = 0; i < settings.multiLines.size(); ++i) {
        settings.multiLines[i]=mlBlocks[i];
    }

    return settings;
}
void HSyntaxHighlighterDialog::constructBlockList()
{

    int i=0;
    foreach(const HighlightBlock* block,allBlocks)
    {
        userInterface.HighlightBlocks->addItem(block->getName());
        userInterface.HighlightBlocks->item(i)->setToolTip(block->getDescription());
        ++i;
    }

    connect(userInterface.HighlightBlocks,SIGNAL(currentRowChanged(int)),this,SLOT(editedItemChanged(int)));
}

void HSyntaxHighlighterDialog::editedItemChanged(int _number)
{
    QGroupBox * temp=userInterface.groupBox;
    userInterface.horizontalLayout->removeWidget(userInterface.groupBox);
    userInterface.groupBox=new HBSettingsPanel(this,allBlocks[_number]);
    userInterface.horizontalLayout->addWidget(userInterface.groupBox);
    delete temp;
}





