/*!
 * @file HSyntaxHighlighterDialog.h
 * File contains declaration of HSyntaxHighlighterDialog class
 * @author Krzysztof Wesołowski
 */
#ifndef HSYNTAXHIGHLIGHTERSETTINGSDIALOG_H
#define HSYNTAXHIGHLIGHTERSETTINGSDIALOG_H

#include <QtGui/QDialog>

#include "ui_HSyntaxHighlighterDialog.h"
#include "HSyntaxHighlighterSettings.h"
#include "HighlightBlock.h"
/*!
 * @class QDialog
 * @brief Base class for all dialog windows/widgets, providing exec(), accepted() and rejected()
 */
/*!
 * @brief Class implementing Dialog,
 * which is used to edit HSyntaxHighlighterSettings,
 * it contains list of all HighlightBlock s and QGroupBox with editing panel.
 */
class HSyntaxHighlighterDialog : public QDialog
{
    Q_OBJECT
private:
    /*!
     * Copying constructor.
     * Provided to ensure object ISN'T copied.
     */
    HSyntaxHighlighterDialog(const HSyntaxHighlighterDialog&);

    Ui::HSyntaxHighlighterDialogClass userInterface; ///< Qt Designer Generated basic UI for this dialog
    HSyntaxHighlighterSettings settings; ///< Local copy of settings, user edit it, and any time it can be read via getSettings()
    SingleLineHighlightBlock    *slBlocks; ///<Pointers to single line blocks, used for storing  SingleLineHighlightBlock elements copied from  settings
    MultiLinesHighlightBlock     *mlBlocks; ///<Pointers to multiple line blocks, used for storing  MultiLinesHighlightBlock elements copied from  settings
    QVector<HighlightBlock*> allBlocks; ///< QVector of all HighlightBlock pointers from  slBlocks and  mlBlocks, used with  HBSettingsPanel
    /*!
     * Function filling userInterface.HighlightBlocks QListWidget with all HighlightBlocks pointed by  allBlocks
     */
    void constructBlockList();
private slots:
    /*!
     * Slot called to change edited item, after calling it destroys current userInterface.groupBox
     * and then replaces it with new appropriate  HBSettingPanel
     * @param _number new HighlightBlock number to edit now.
     */
    void editedItemChanged(int _number);
public:
    /*!
     * @brief Constructor
     * creates UI and initialize  slBlocks and  mlBlocks with NULL
     * @param parent Pointer to parent QWidget, used by QDialog constructor
     */
    HSyntaxHighlighterDialog(QWidget *parent = 0);
    /*!
     * @brief Destructor
     * If settings were set, it deletes HighlightBlocks pointed by  slBlocks and  mlBlocks
     */
    ~HSyntaxHighlighterDialog();

    /*!
     * @brief settings getter
     * This function modify current settings, by copying HighlightBlocks stored,
     * and possibly modified in  slBlocks and  mlBlocks into settings
     * @return Possibly modified  HSyntaxHighlighter settings.
     */
    HSyntaxHighlighterSettings getSettings();

    /*!
     * @brief Set up initial settings
     * This function is used to setup initial settings of  HSyntaxHighlighterDialog,
     * it should be used before executing dialog, if you forget about it behavior may be unexpected
     * @param _settings Initial settings to store in  settings
     */
    void setSettings(HSyntaxHighlighterSettings _settings);

};

#endif // HSYNTAXHIGHLIGHTERSETTINGSDIALOG_H
