--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Computer_Steering
-- Krtki opis:		Pakiet przechowujacy zadanie odpowiedzialne za sterowanie komputerowe.
--------------------------------------------------------------------------------

with Ada.Calendar,Ada.Numerics.Float_Random,Ada.Exceptions,Win32.GL,Common_Data,Game_State_Package,Process_Input_Package,Runtime_Log;
use Ada.Calendar,Ada.Numerics,Ada.Exceptions,Win32.GL,Common_Data,Game_State_Package,Process_Input_Package,Runtime_Log;


package body Computer_Steering is

    task body Computer_Steering is
        Do_Kiedy:Time;
        fgen : Float_Random.Generator;
    begin
        Float_Random.Reset(Fgen);
        loop
            select
                accept Start;
                Log.Info("Gracz zielony przelaczony na sterowanie automatyczne");
                Main_Driver:
                loop
                    Do_Kiedy:=Clock+PC_Sampling_Clock;
                    if Float_Random.Random(fgen)>PC_fail_rate then
                        declare
                            Pad : constant Common_Data.Pad_Type:=Board_State.Get_Pad2;
                            Ball : constant Common_Data.Ball_Type:=Board_State.Get_Ball;
                        begin
                            if Pad.Position.X - Pad.Width/4.0 > Ball.Pos.X then
                                Keyboard_State.Set_Key_Down(PC_Left);
                                Keyboard_State.Set_Key_Up(PC_Right);
                            elsif Pad.Position.X + Pad.Width/4.0 < Ball.Pos.X then
                                Keyboard_State.Set_Key_Down(PC_Right);
                                Keyboard_State.Set_Key_Up(PC_Left);
                            elsif Pad.Position.X - Pad.Width/16.0 < Ball.Pos.X then
                                Keyboard_State.Set_Key_Up(PC_Right);
                                Keyboard_State.Set_Key_Up(PC_Left);
                            elsif Pad.Position.X + Pad.Width/16.0 > Ball.Pos.X then
                                Keyboard_State.Set_Key_Up(PC_Right);
                                Keyboard_State.Set_Key_Up(PC_Left);
                            else
                                Keyboard_State.Set_Key_Up(PC_Right);
                                Keyboard_State.Set_Key_Up(PC_Left);
                            end if;
                        end;
                    else
                        Keyboard_State.Set_Key_Up(PC_Right);
                        Keyboard_State.Set_Key_Up(PC_Left);
                    end if;
                    select
                        accept Stop;
                        Log.Info("Gracz zielony przelaczony na sterowanie reczne");
                        exit Main_Driver;
                    or
                        accept Start;
                    or
                        delay until Do_Kiedy;
                    end select;
                end loop Main_Driver;
            or
                accept Stop;
            end select;
        end loop;
    exception
        when Event: others =>
            Log.Error("Nastapil wyjatek w module autopilota, nazwa: "
                      &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
    end Computer_Steering;

end Computer_Steering;
