pragma Ada_95;
pragma Source_File_Name (ada_main, Spec_File_Name => "b~multiplayer_arkanoid.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b~multiplayer_arkanoid.adb");

with System.Restrictions;

package body ada_main is
   pragma Warnings (Off);

   procedure Do_Finalize;
   pragma Import (C, Do_Finalize, "system__standard_library__adafinal");

   Local_Priority_Specific_Dispatching : constant String := "";
   Local_Interrupt_States : constant String := "";

   procedure adainit is
      E015 : Boolean; pragma Import (Ada, E015, "system__secondary_stack_E");
      E011 : Boolean; pragma Import (Ada, E011, "system__soft_links_E");
      E021 : Boolean; pragma Import (Ada, E021, "system__exception_table_E");
      E065 : Boolean; pragma Import (Ada, E065, "ada__calendar_E");
      E082 : Boolean; pragma Import (Ada, E082, "ada__calendar__delays_E");
      E135 : Boolean; pragma Import (Ada, E135, "ada__calendar__time_zones_E");
      E127 : Boolean; pragma Import (Ada, E127, "ada__io_exceptions_E");
      E054 : Boolean; pragma Import (Ada, E054, "ada__numerics_E");
      E099 : Boolean; pragma Import (Ada, E099, "ada__strings_E");
      E045 : Boolean; pragma Import (Ada, E045, "ada__tags_E");
      E120 : Boolean; pragma Import (Ada, E120, "ada__streams_E");
      E072 : Boolean; pragma Import (Ada, E072, "interfaces__c_E");
      E211 : Boolean; pragma Import (Ada, E211, "gnat__calendar_E");
      E213 : Boolean; pragma Import (Ada, E213, "gnat__calendar__time_io_E");
      E077 : Boolean; pragma Import (Ada, E077, "interfaces__c__strings_E");
      E119 : Boolean; pragma Import (Ada, E119, "system__finalization_root_E");
      E148 : Boolean; pragma Import (Ada, E148, "system__os_lib_E");
      E105 : Boolean; pragma Import (Ada, E105, "ada__strings__maps_E");
      E141 : Boolean; pragma Import (Ada, E141, "ada__strings__maps__constants_E");
      E122 : Boolean; pragma Import (Ada, E122, "system__finalization_implementation_E");
      E117 : Boolean; pragma Import (Ada, E117, "ada__finalization_E");
      E145 : Boolean; pragma Import (Ada, E145, "ada__finalization__list_controller_E");
      E101 : Boolean; pragma Import (Ada, E101, "ada__strings__unbounded_E");
      E131 : Boolean; pragma Import (Ada, E131, "ada__directories_E");
      E143 : Boolean; pragma Import (Ada, E143, "ada__directories__validity_E");
      E159 : Boolean; pragma Import (Ada, E159, "system__file_control_block_E");
      E158 : Boolean; pragma Import (Ada, E158, "system__file_io_E");
      E152 : Boolean; pragma Import (Ada, E152, "system__regexp_E");
      E154 : Boolean; pragma Import (Ada, E154, "ada__text_io_E");
      E174 : Boolean; pragma Import (Ada, E174, "system__task_info_E");
      E190 : Boolean; pragma Import (Ada, E190, "system__tasking__initialization_E");
      E196 : Boolean; pragma Import (Ada, E196, "system__tasking__protected_objects_E");
      E208 : Boolean; pragma Import (Ada, E208, "ada__real_time_E");
      E198 : Boolean; pragma Import (Ada, E198, "system__tasking__protected_objects__entries_E");
      E202 : Boolean; pragma Import (Ada, E202, "system__tasking__queuing_E");
      E219 : Boolean; pragma Import (Ada, E219, "system__tasking__stages_E");
      E086 : Boolean; pragma Import (Ada, E086, "computer_steering_E");
      E080 : Boolean; pragma Import (Ada, E080, "process_graphics_E");
      E224 : Boolean; pragma Import (Ada, E224, "process_input_package_E");
      E233 : Boolean; pragma Import (Ada, E233, "process_physics_package_E");
      E164 : Boolean; pragma Import (Ada, E164, "runtime_log_E");
      E075 : Boolean; pragma Import (Ada, E075, "win32_E");
      E053 : Boolean; pragma Import (Ada, E053, "common_data_E");
      E129 : Boolean; pragma Import (Ada, E129, "brick_matrix_package_E");
      E098 : Boolean; pragma Import (Ada, E098, "game_state_package_E");
      E226 : Boolean; pragma Import (Ada, E226, "gl_draw_E");
      E228 : Boolean; pragma Import (Ada, E228, "win32__glu_E");
      E230 : Boolean; pragma Import (Ada, E230, "win32__glut_E");

      Main_Priority : Integer;
      pragma Import (C, Main_Priority, "__gl_main_priority");
      Time_Slice_Value : Integer;
      pragma Import (C, Time_Slice_Value, "__gl_time_slice_val");
      WC_Encoding : Character;
      pragma Import (C, WC_Encoding, "__gl_wc_encoding");
      Locking_Policy : Character;
      pragma Import (C, Locking_Policy, "__gl_locking_policy");
      Queuing_Policy : Character;
      pragma Import (C, Queuing_Policy, "__gl_queuing_policy");
      Task_Dispatching_Policy : Character;
      pragma Import (C, Task_Dispatching_Policy, "__gl_task_dispatching_policy");
      Priority_Specific_Dispatching : System.Address;
      pragma Import (C, Priority_Specific_Dispatching, "__gl_priority_specific_dispatching");
      Num_Specific_Dispatching : Integer;
      pragma Import (C, Num_Specific_Dispatching, "__gl_num_specific_dispatching");
      Interrupt_States : System.Address;
      pragma Import (C, Interrupt_States, "__gl_interrupt_states");
      Num_Interrupt_States : Integer;
      pragma Import (C, Num_Interrupt_States, "__gl_num_interrupt_states");
      Unreserve_All_Interrupts : Integer;
      pragma Import (C, Unreserve_All_Interrupts, "__gl_unreserve_all_interrupts");
      Zero_Cost_Exceptions : Integer;
      pragma Import (C, Zero_Cost_Exceptions, "__gl_zero_cost_exceptions");
      Detect_Blocking : Integer;
      pragma Import (C, Detect_Blocking, "__gl_detect_blocking");
      Default_Stack_Size : Integer;
      pragma Import (C, Default_Stack_Size, "__gl_default_stack_size");
      Leap_Seconds_Support : Integer;
      pragma Import (C, Leap_Seconds_Support, "__gl_leap_seconds_support");

      procedure Install_Handler;
      pragma Import (C, Install_Handler, "__gnat_install_handler");

      Handler_Installed : Integer;
      pragma Import (C, Handler_Installed, "__gnat_handler_installed");
   begin
      Main_Priority := -1;
      Time_Slice_Value := -1;
      WC_Encoding := 'b';
      Locking_Policy := ' ';
      Queuing_Policy := ' ';
      Task_Dispatching_Policy := ' ';
      System.Restrictions.Run_Time_Restrictions :=
        (Set =>
          (False, False, False, False, False, False, False, False, 
           False, False, False, False, False, False, False, False, 
           False, False, False, False, False, False, False, False, 
           False, False, False, False, False, False, False, False, 
           False, False, False, False, False, False, False, False, 
           False, False, False, False, False, False, False, False, 
           False, False, False, False, False, False, False, False, 
           False, False, False, False, False, False, False, False, 
           False, False, False),
         Value => (0, 0, 0, 0, 0, 0, 0),
         Violated =>
          (False, False, True, True, False, True, True, True, 
           True, True, False, False, True, False, False, True, 
           True, False, True, True, True, True, True, True, 
           False, False, True, False, True, False, True, False, 
           True, True, False, True, False, True, True, True, 
           False, False, False, False, False, True, False, True, 
           True, True, False, False, True, False, True, True, 
           False, True, True, True, False, True, True, True, 
           False, True, False),
         Count => (0, 3, 3, 6, 0, 4, 0),
         Unknown => (False, False, False, False, False, True, False));
      Priority_Specific_Dispatching :=
        Local_Priority_Specific_Dispatching'Address;
      Num_Specific_Dispatching := 0;
      Interrupt_States := Local_Interrupt_States'Address;
      Num_Interrupt_States := 0;
      Unreserve_All_Interrupts := 0;
      Zero_Cost_Exceptions := 1;
      Detect_Blocking := 0;
      Default_Stack_Size := -1;
      Leap_Seconds_Support := 0;

      if Handler_Installed = 0 then
         Install_Handler;
      end if;

      System.Soft_Links'Elab_Body;
      E011 := True;
      System.Secondary_Stack'Elab_Body;
      E015 := True;
      System.Exception_Table'Elab_Body;
      E021 := True;
      Ada.Calendar'Elab_Spec;
      Ada.Calendar'Elab_Body;
      E065 := True;
      Ada.Calendar.Time_Zones'Elab_Spec;
      E135 := True;
      Ada.Io_Exceptions'Elab_Spec;
      E127 := True;
      Ada.Numerics'Elab_Spec;
      E054 := True;
      Ada.Strings'Elab_Spec;
      E099 := True;
      Ada.Tags'Elab_Spec;
      Ada.Streams'Elab_Spec;
      E120 := True;
      Interfaces.C'Elab_Spec;
      E072 := True;
      Gnat.Calendar'Elab_Spec;
      E211 := True;
      Gnat.Calendar.Time_Io'Elab_Spec;
      Interfaces.C.Strings'Elab_Spec;
      E077 := True;
      System.Finalization_Root'Elab_Spec;
      E119 := True;
      System.Os_Lib'Elab_Body;
      E148 := True;
      Ada.Calendar.Delays'Elab_Body;
      E082 := True;
      Ada.Strings.Maps'Elab_Spec;
      E105 := True;
      Ada.Strings.Maps.Constants'Elab_Spec;
      E141 := True;
      System.Finalization_Implementation'Elab_Spec;
      System.Finalization_Implementation'Elab_Body;
      E122 := True;
      Ada.Finalization'Elab_Spec;
      E117 := True;
      Ada.Finalization.List_Controller'Elab_Spec;
      E145 := True;
      Ada.Strings.Unbounded'Elab_Spec;
      E101 := True;
      Ada.Directories'Elab_Spec;
      Ada.Directories.Validity'Elab_Body;
      E143 := True;
      System.File_Control_Block'Elab_Spec;
      E159 := True;
      System.File_Io'Elab_Body;
      E158 := True;
      System.Regexp'Elab_Spec;
      E152 := True;
      Ada.Directories'Elab_Body;
      E131 := True;
      Ada.Tags'Elab_Body;
      E045 := True;
      Ada.Text_Io'Elab_Spec;
      Ada.Text_Io'Elab_Body;
      E154 := True;
      E213 := True;
      System.Task_Info'Elab_Spec;
      E174 := True;
      System.Tasking.Initialization'Elab_Body;
      E190 := True;
      System.Tasking.Protected_Objects'Elab_Body;
      E196 := True;
      Ada.Real_Time'Elab_Spec;
      E208 := True;
      System.Tasking.Protected_Objects.Entries'Elab_Spec;
      E198 := True;
      System.Tasking.Queuing'Elab_Body;
      E202 := True;
      System.Tasking.Stages'Elab_Body;
      E219 := True;
      Computer_Steering'Elab_Spec;
      Process_Graphics'Elab_Spec;
      Process_Input_Package'Elab_Spec;
      Process_Physics_Package'Elab_Spec;
      Runtime_Log'Elab_Spec;
      Runtime_Log'Elab_Body;
      E164 := True;
      E075 := True;
      Common_Data'Elab_Spec;
      E053 := True;
      Brick_Matrix_Package'Elab_Body;
      E129 := True;
      Game_State_Package'Elab_Spec;
      Game_State_Package'Elab_Body;
      E098 := True;
      Process_Physics_Package'Elab_Body;
      E233 := True;
      Process_Input_Package'Elab_Body;
      E224 := True;
      Computer_Steering'Elab_Body;
      E086 := True;
      E228 := True;
      E230 := True;
      E226 := True;
      Process_Graphics'Elab_Body;
      E080 := True;
   end adainit;

   procedure adafinal is
   begin
      Do_Finalize;
   end adafinal;

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure initialize (Addr : System.Address);
      pragma Import (C, initialize, "__gnat_initialize");

      procedure finalize;
      pragma Import (C, finalize, "__gnat_finalize");

      procedure Ada_Main_Program;
      pragma Import (Ada, Ada_Main_Program, "_ada_multiplayer_arkanoid");

      SEH : aliased array (1 .. 2) of Integer;

      Ensure_Reference : aliased System.Address := Ada_Main_Program_Name'Address;
      pragma Volatile (Ensure_Reference);

   begin
      gnat_argc := argc;
      gnat_argv := argv;
      gnat_envp := envp;

      Initialize (SEH'Address);
      adainit;
      Break_Start;
      Ada_Main_Program;
      Do_Finalize;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\runtime_log.o
   --   c:\gnat\2008\lib\win32ada\win32.o
   --   c:\gnat\2008\lib\win32ada\win32-gl.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\common_data.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\multiplayer_arkanoid.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\brick_matrix_package.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\game_state_package.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\process_physics_package.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\process_input_package.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\computer_steering.o
   --   c:\gnat\2008\lib\win32ada\win32-glut.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\gl_draw.o
   --   e:\mojedokumenty\eclipseada\arkanoid\debug_objs\process_graphics.o
   --   -Le:\mojedokumenty\eclipseada\arkanoid\debug_objs\
   --   -Lc:\gnat\2008\lib\win32ada\
   --   -LC:/GNAT/2008/lib/gcc/pentium-mingw32msv/4.1.3/adalib/
   --   -lopengl32
   --   -lglu32
   --   -lglut32
   --   -lwin32ada
   --   -luser32
   --   -lgdi32
   --   -lcomdlg32
   --   -static
   --   -lgnarl
   --   -lgnat
   --   -Xlinker
   --   --stack=0x200000,0x1000
   --   -mthreads
   --   -Wl,--stack=0x2000000
--  END Object file/option list   

end ada_main;
