pragma Ada_95;
with System;
package ada_main is
   pragma Warnings (Off);

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: GPL 2008 (20080521)";
   pragma Export (C, GNAT_Version, "__gnat_version");

   Ada_Main_Program_Name : constant String := "_ada_multiplayer_arkanoid" & ASCII.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adafinal;
   pragma Export (C, adafinal, "adafinal");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   procedure Break_Start;
   pragma Import (C, Break_Start, "__gnat_break_start");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#c61e5d43#;
   u00002 : constant Version_32 := 16#4b33036a#;
   u00003 : constant Version_32 := 16#03570e27#;
   u00004 : constant Version_32 := 16#9c7dd3ea#;
   u00005 : constant Version_32 := 16#fbef5e54#;
   u00006 : constant Version_32 := 16#c18f1a41#;
   u00007 : constant Version_32 := 16#9201cee0#;
   u00008 : constant Version_32 := 16#e3d85f73#;
   u00009 : constant Version_32 := 16#f47f7e1a#;
   u00010 : constant Version_32 := 16#b6c89fbe#;
   u00011 : constant Version_32 := 16#6820c3b1#;
   u00012 : constant Version_32 := 16#2ea84b20#;
   u00013 : constant Version_32 := 16#075128f3#;
   u00014 : constant Version_32 := 16#6ad13d41#;
   u00015 : constant Version_32 := 16#624725c8#;
   u00016 : constant Version_32 := 16#55ef7c79#;
   u00017 : constant Version_32 := 16#19e913e9#;
   u00018 : constant Version_32 := 16#e1e7b9d6#;
   u00019 : constant Version_32 := 16#3c922801#;
   u00020 : constant Version_32 := 16#fcfb2939#;
   u00021 : constant Version_32 := 16#fad48c61#;
   u00022 : constant Version_32 := 16#1a63fe0c#;
   u00023 : constant Version_32 := 16#82df390a#;
   u00024 : constant Version_32 := 16#5b8b9839#;
   u00025 : constant Version_32 := 16#e4c038da#;
   u00026 : constant Version_32 := 16#0a4e56be#;
   u00027 : constant Version_32 := 16#70200cc8#;
   u00028 : constant Version_32 := 16#573451fa#;
   u00029 : constant Version_32 := 16#86b16e79#;
   u00030 : constant Version_32 := 16#9c49ee35#;
   u00031 : constant Version_32 := 16#9e11aaf2#;
   u00032 : constant Version_32 := 16#348684ff#;
   u00033 : constant Version_32 := 16#743d3d0d#;
   u00034 : constant Version_32 := 16#5f7df983#;
   u00035 : constant Version_32 := 16#ccde3404#;
   u00036 : constant Version_32 := 16#db0ab672#;
   u00037 : constant Version_32 := 16#2c57c517#;
   u00038 : constant Version_32 := 16#d4eef2e5#;
   u00039 : constant Version_32 := 16#a69cad5c#;
   u00040 : constant Version_32 := 16#300a43f3#;
   u00041 : constant Version_32 := 16#ffc7ae95#;
   u00042 : constant Version_32 := 16#99c8a881#;
   u00043 : constant Version_32 := 16#49205949#;
   u00044 : constant Version_32 := 16#f6ee8365#;
   u00045 : constant Version_32 := 16#3a34b445#;
   u00046 : constant Version_32 := 16#647de85b#;
   u00047 : constant Version_32 := 16#d5b9c9c1#;
   u00048 : constant Version_32 := 16#8213b492#;
   u00049 : constant Version_32 := 16#ae510376#;
   u00050 : constant Version_32 := 16#44c7af1b#;
   u00051 : constant Version_32 := 16#65e56d1e#;
   u00052 : constant Version_32 := 16#dc8fb4ea#;
   u00053 : constant Version_32 := 16#c32f251c#;
   u00054 : constant Version_32 := 16#808e35e2#;
   u00055 : constant Version_32 := 16#b3ddb2e1#;
   u00056 : constant Version_32 := 16#e9d51972#;
   u00057 : constant Version_32 := 16#45aed95a#;
   u00058 : constant Version_32 := 16#3cdf3a90#;
   u00059 : constant Version_32 := 16#14a226f9#;
   u00060 : constant Version_32 := 16#91e94b6e#;
   u00061 : constant Version_32 := 16#e0683b80#;
   u00062 : constant Version_32 := 16#b3adf911#;
   u00063 : constant Version_32 := 16#811baeec#;
   u00064 : constant Version_32 := 16#8488033d#;
   u00065 : constant Version_32 := 16#8535bfda#;
   u00066 : constant Version_32 := 16#aca0f2c0#;
   u00067 : constant Version_32 := 16#8c362764#;
   u00068 : constant Version_32 := 16#d85b2138#;
   u00069 : constant Version_32 := 16#bca545d7#;
   u00070 : constant Version_32 := 16#991a1265#;
   u00071 : constant Version_32 := 16#59507545#;
   u00072 : constant Version_32 := 16#e98c0dd7#;
   u00073 : constant Version_32 := 16#a8c5b005#;
   u00074 : constant Version_32 := 16#30239ec5#;
   u00075 : constant Version_32 := 16#8373cfb5#;
   u00076 : constant Version_32 := 16#258ddf68#;
   u00077 : constant Version_32 := 16#38237c53#;
   u00078 : constant Version_32 := 16#b66daeb9#;
   u00079 : constant Version_32 := 16#ab3631b5#;
   u00080 : constant Version_32 := 16#aeac5d77#;
   u00081 : constant Version_32 := 16#00329e17#;
   u00082 : constant Version_32 := 16#dc2d9adb#;
   u00083 : constant Version_32 := 16#499c33c1#;
   u00084 : constant Version_32 := 16#74618b89#;
   u00085 : constant Version_32 := 16#e91ac4f2#;
   u00086 : constant Version_32 := 16#e28282cc#;
   u00087 : constant Version_32 := 16#ec713313#;
   u00088 : constant Version_32 := 16#85b99f0a#;
   u00089 : constant Version_32 := 16#0255db5c#;
   u00090 : constant Version_32 := 16#03026d26#;
   u00091 : constant Version_32 := 16#5251306e#;
   u00092 : constant Version_32 := 16#ed6c6bf2#;
   u00093 : constant Version_32 := 16#9a7bf588#;
   u00094 : constant Version_32 := 16#486e5939#;
   u00095 : constant Version_32 := 16#294c3b74#;
   u00096 : constant Version_32 := 16#264d77c8#;
   u00097 : constant Version_32 := 16#33bfdf69#;
   u00098 : constant Version_32 := 16#0649b52a#;
   u00099 : constant Version_32 := 16#1bc9f0e1#;
   u00100 : constant Version_32 := 16#dc80ce83#;
   u00101 : constant Version_32 := 16#bb19d785#;
   u00102 : constant Version_32 := 16#70f768a2#;
   u00103 : constant Version_32 := 16#f0ddc3f6#;
   u00104 : constant Version_32 := 16#eccbd1ca#;
   u00105 : constant Version_32 := 16#3c09e836#;
   u00106 : constant Version_32 := 16#acd437d0#;
   u00107 : constant Version_32 := 16#04e247f8#;
   u00108 : constant Version_32 := 16#cc1134cf#;
   u00109 : constant Version_32 := 16#b9828a2f#;
   u00110 : constant Version_32 := 16#3ab3e7b1#;
   u00111 : constant Version_32 := 16#54ed61ee#;
   u00112 : constant Version_32 := 16#55412952#;
   u00113 : constant Version_32 := 16#477e033d#;
   u00114 : constant Version_32 := 16#330db175#;
   u00115 : constant Version_32 := 16#37653831#;
   u00116 : constant Version_32 := 16#fcec4850#;
   u00117 : constant Version_32 := 16#16dfe486#;
   u00118 : constant Version_32 := 16#6d0998e1#;
   u00119 : constant Version_32 := 16#853bbf87#;
   u00120 : constant Version_32 := 16#a8d17654#;
   u00121 : constant Version_32 := 16#31db65a3#;
   u00122 : constant Version_32 := 16#c8488301#;
   u00123 : constant Version_32 := 16#293ff6f7#;
   u00124 : constant Version_32 := 16#a2ffe026#;
   u00125 : constant Version_32 := 16#2461b049#;
   u00126 : constant Version_32 := 16#0aa29e81#;
   u00127 : constant Version_32 := 16#2274d34a#;
   u00128 : constant Version_32 := 16#4c10843c#;
   u00129 : constant Version_32 := 16#3878bca4#;
   u00130 : constant Version_32 := 16#00553ebb#;
   u00131 : constant Version_32 := 16#aa87599d#;
   u00132 : constant Version_32 := 16#ea46279d#;
   u00133 : constant Version_32 := 16#aeb09f88#;
   u00134 : constant Version_32 := 16#94f0a15f#;
   u00135 : constant Version_32 := 16#47117e84#;
   u00136 : constant Version_32 := 16#c9db2a5e#;
   u00137 : constant Version_32 := 16#10b94449#;
   u00138 : constant Version_32 := 16#d4a0971e#;
   u00139 : constant Version_32 := 16#b061ea80#;
   u00140 : constant Version_32 := 16#8cddb9b3#;
   u00141 : constant Version_32 := 16#ec7a3063#;
   u00142 : constant Version_32 := 16#16c5c4d5#;
   u00143 : constant Version_32 := 16#7b8906f0#;
   u00144 : constant Version_32 := 16#923573c8#;
   u00145 : constant Version_32 := 16#183b4446#;
   u00146 : constant Version_32 := 16#9e231c52#;
   u00147 : constant Version_32 := 16#83c49e64#;
   u00148 : constant Version_32 := 16#d29733c2#;
   u00149 : constant Version_32 := 16#3f280002#;
   u00150 : constant Version_32 := 16#2cebee07#;
   u00151 : constant Version_32 := 16#33a67f90#;
   u00152 : constant Version_32 := 16#7017f548#;
   u00153 : constant Version_32 := 16#f4e49680#;
   u00154 : constant Version_32 := 16#7e7d766c#;
   u00155 : constant Version_32 := 16#62e56d2b#;
   u00156 : constant Version_32 := 16#de0efd54#;
   u00157 : constant Version_32 := 16#9c656d98#;
   u00158 : constant Version_32 := 16#a14e9d46#;
   u00159 : constant Version_32 := 16#33f70a49#;
   u00160 : constant Version_32 := 16#434cbdc2#;
   u00161 : constant Version_32 := 16#822205c7#;
   u00162 : constant Version_32 := 16#946d438b#;
   u00163 : constant Version_32 := 16#bcb471c3#;
   u00164 : constant Version_32 := 16#43b59197#;
   u00165 : constant Version_32 := 16#21e1d94c#;
   u00166 : constant Version_32 := 16#72e809c8#;
   u00167 : constant Version_32 := 16#5318fd3c#;
   u00168 : constant Version_32 := 16#cc055108#;
   u00169 : constant Version_32 := 16#c9716058#;
   u00170 : constant Version_32 := 16#93a84e08#;
   u00171 : constant Version_32 := 16#5e518a52#;
   u00172 : constant Version_32 := 16#0b9f3773#;
   u00173 : constant Version_32 := 16#e57328c3#;
   u00174 : constant Version_32 := 16#da1de0ef#;
   u00175 : constant Version_32 := 16#dcdd8806#;
   u00176 : constant Version_32 := 16#b05de465#;
   u00177 : constant Version_32 := 16#1f039ff8#;
   u00178 : constant Version_32 := 16#4e405353#;
   u00179 : constant Version_32 := 16#218c434b#;
   u00180 : constant Version_32 := 16#f66d9f86#;
   u00181 : constant Version_32 := 16#b5e3620d#;
   u00182 : constant Version_32 := 16#820cd1a8#;
   u00183 : constant Version_32 := 16#f5269f91#;
   u00184 : constant Version_32 := 16#63db7cf0#;
   u00185 : constant Version_32 := 16#9b936ce6#;
   u00186 : constant Version_32 := 16#c093cfd6#;
   u00187 : constant Version_32 := 16#8f3a57de#;
   u00188 : constant Version_32 := 16#1bb057ca#;
   u00189 : constant Version_32 := 16#d9af87b0#;
   u00190 : constant Version_32 := 16#467aed83#;
   u00191 : constant Version_32 := 16#320f53b8#;
   u00192 : constant Version_32 := 16#1de34b3f#;
   u00193 : constant Version_32 := 16#3ad1331d#;
   u00194 : constant Version_32 := 16#e6129a88#;
   u00195 : constant Version_32 := 16#8810a4ad#;
   u00196 : constant Version_32 := 16#6d1d86da#;
   u00197 : constant Version_32 := 16#be7a43c0#;
   u00198 : constant Version_32 := 16#3e2eb851#;
   u00199 : constant Version_32 := 16#c5b874a6#;
   u00200 : constant Version_32 := 16#88fc3543#;
   u00201 : constant Version_32 := 16#6a76a80a#;
   u00202 : constant Version_32 := 16#90d469b5#;
   u00203 : constant Version_32 := 16#73e8726b#;
   u00204 : constant Version_32 := 16#0fd630f2#;
   u00205 : constant Version_32 := 16#a9b1294b#;
   u00206 : constant Version_32 := 16#fbc101b3#;
   u00207 : constant Version_32 := 16#4756a3d4#;
   u00208 : constant Version_32 := 16#c59c6f02#;
   u00209 : constant Version_32 := 16#96410e68#;
   u00210 : constant Version_32 := 16#50817d2f#;
   u00211 : constant Version_32 := 16#9a5b28d1#;
   u00212 : constant Version_32 := 16#a7b302f0#;
   u00213 : constant Version_32 := 16#9862375c#;
   u00214 : constant Version_32 := 16#ccd92b43#;
   u00215 : constant Version_32 := 16#7a4f25f8#;
   u00216 : constant Version_32 := 16#3e7d115b#;
   u00217 : constant Version_32 := 16#f92c7022#;
   u00218 : constant Version_32 := 16#3d80adba#;
   u00219 : constant Version_32 := 16#ee428f6f#;
   u00220 : constant Version_32 := 16#91f9f4f9#;
   u00221 : constant Version_32 := 16#2786449c#;
   u00222 : constant Version_32 := 16#c059b001#;
   u00223 : constant Version_32 := 16#ff675ab6#;
   u00224 : constant Version_32 := 16#a8e5b631#;
   u00225 : constant Version_32 := 16#5d1f039a#;
   u00226 : constant Version_32 := 16#0d20fbeb#;
   u00227 : constant Version_32 := 16#0dee1f01#;
   u00228 : constant Version_32 := 16#5c28e8f6#;
   u00229 : constant Version_32 := 16#315b1e24#;
   u00230 : constant Version_32 := 16#99b8a091#;
   u00231 : constant Version_32 := 16#8031da97#;
   u00232 : constant Version_32 := 16#491fde59#;
   u00233 : constant Version_32 := 16#b1f5b1cf#;
   u00234 : constant Version_32 := 16#14db7cbc#;
   u00235 : constant Version_32 := 16#f028357e#;

   pragma Export (C, u00001, "multiplayer_arkanoidB");
   pragma Export (C, u00002, "system__standard_libraryB");
   pragma Export (C, u00003, "system__standard_libraryS");
   pragma Export (C, u00004, "adaS");
   pragma Export (C, u00005, "ada__exceptionsB");
   pragma Export (C, u00006, "ada__exceptionsS");
   pragma Export (C, u00007, "ada__exceptions__last_chance_handlerB");
   pragma Export (C, u00008, "ada__exceptions__last_chance_handlerS");
   pragma Export (C, u00009, "systemS");
   pragma Export (C, u00010, "system__soft_linksB");
   pragma Export (C, u00011, "system__soft_linksS");
   pragma Export (C, u00012, "system__parametersB");
   pragma Export (C, u00013, "system__parametersS");
   pragma Export (C, u00014, "system__secondary_stackB");
   pragma Export (C, u00015, "system__secondary_stackS");
   pragma Export (C, u00016, "system__storage_elementsB");
   pragma Export (C, u00017, "system__storage_elementsS");
   pragma Export (C, u00018, "system__stack_checkingB");
   pragma Export (C, u00019, "system__stack_checkingS");
   pragma Export (C, u00020, "system__exception_tableB");
   pragma Export (C, u00021, "system__exception_tableS");
   pragma Export (C, u00022, "system__htableB");
   pragma Export (C, u00023, "system__htableS");
   pragma Export (C, u00024, "system__exceptionsB");
   pragma Export (C, u00025, "system__exceptionsS");
   pragma Export (C, u00026, "system__string_opsB");
   pragma Export (C, u00027, "system__string_opsS");
   pragma Export (C, u00028, "system__string_ops_concat_3B");
   pragma Export (C, u00029, "system__string_ops_concat_3S");
   pragma Export (C, u00030, "system__tracebackB");
   pragma Export (C, u00031, "system__tracebackS");
   pragma Export (C, u00032, "system__unsigned_typesS");
   pragma Export (C, u00033, "system__wch_conB");
   pragma Export (C, u00034, "system__wch_conS");
   pragma Export (C, u00035, "system__wch_stwB");
   pragma Export (C, u00036, "system__wch_stwS");
   pragma Export (C, u00037, "system__wch_cnvB");
   pragma Export (C, u00038, "system__wch_cnvS");
   pragma Export (C, u00039, "interfacesS");
   pragma Export (C, u00040, "system__wch_jisB");
   pragma Export (C, u00041, "system__wch_jisS");
   pragma Export (C, u00042, "system__traceback_entriesB");
   pragma Export (C, u00043, "system__traceback_entriesS");
   pragma Export (C, u00044, "ada__tagsB");
   pragma Export (C, u00045, "ada__tagsS");
   pragma Export (C, u00046, "system__val_unsB");
   pragma Export (C, u00047, "system__val_unsS");
   pragma Export (C, u00048, "system__val_utilB");
   pragma Export (C, u00049, "system__val_utilS");
   pragma Export (C, u00050, "system__case_utilB");
   pragma Export (C, u00051, "system__case_utilS");
   pragma Export (C, u00052, "common_dataB");
   pragma Export (C, u00053, "common_dataS");
   pragma Export (C, u00054, "ada__numericsS");
   pragma Export (C, u00055, "ada__numerics__elementary_functionsB");
   pragma Export (C, u00056, "ada__numerics__elementary_functionsS");
   pragma Export (C, u00057, "ada__numerics__auxB");
   pragma Export (C, u00058, "ada__numerics__auxS");
   pragma Export (C, u00059, "system__fat_llfS");
   pragma Export (C, u00060, "system__machine_codeS");
   pragma Export (C, u00061, "system__exn_llfB");
   pragma Export (C, u00062, "system__exn_llfS");
   pragma Export (C, u00063, "system__fat_fltS");
   pragma Export (C, u00064, "ada__calendarB");
   pragma Export (C, u00065, "ada__calendarS");
   pragma Export (C, u00066, "system__arith_64B");
   pragma Export (C, u00067, "system__arith_64S");
   pragma Export (C, u00068, "system__os_primitivesB");
   pragma Export (C, u00069, "system__os_primitivesS");
   pragma Export (C, u00070, "system__win32S");
   pragma Export (C, u00071, "interfaces__cB");
   pragma Export (C, u00072, "interfaces__cS");
   pragma Export (C, u00073, "system__win32__extS");
   pragma Export (C, u00074, "win32B");
   pragma Export (C, u00075, "win32S");
   pragma Export (C, u00076, "interfaces__c__stringsB");
   pragma Export (C, u00077, "interfaces__c__stringsS");
   pragma Export (C, u00078, "win32__glS");
   pragma Export (C, u00079, "process_graphicsB");
   pragma Export (C, u00080, "process_graphicsS");
   pragma Export (C, u00081, "ada__calendar__delaysB");
   pragma Export (C, u00082, "ada__calendar__delaysS");
   pragma Export (C, u00083, "system__tracesB");
   pragma Export (C, u00084, "system__tracesS");
   pragma Export (C, u00085, "computer_steeringB");
   pragma Export (C, u00086, "computer_steeringS");
   pragma Export (C, u00087, "ada__numerics__float_randomB");
   pragma Export (C, u00088, "ada__numerics__float_randomS");
   pragma Export (C, u00089, "system__img_intB");
   pragma Export (C, u00090, "system__img_intS");
   pragma Export (C, u00091, "system__string_ops_concat_5B");
   pragma Export (C, u00092, "system__string_ops_concat_5S");
   pragma Export (C, u00093, "system__string_ops_concat_4B");
   pragma Export (C, u00094, "system__string_ops_concat_4S");
   pragma Export (C, u00095, "system__val_intB");
   pragma Export (C, u00096, "system__val_intS");
   pragma Export (C, u00097, "game_state_packageB");
   pragma Export (C, u00098, "game_state_packageS");
   pragma Export (C, u00099, "ada__stringsS");
   pragma Export (C, u00100, "ada__strings__unboundedB");
   pragma Export (C, u00101, "ada__strings__unboundedS");
   pragma Export (C, u00102, "ada__strings__fixedB");
   pragma Export (C, u00103, "ada__strings__fixedS");
   pragma Export (C, u00104, "ada__strings__mapsB");
   pragma Export (C, u00105, "ada__strings__mapsS");
   pragma Export (C, u00106, "system__bit_opsB");
   pragma Export (C, u00107, "system__bit_opsS");
   pragma Export (C, u00108, "ada__charactersS");
   pragma Export (C, u00109, "ada__characters__latin_1S");
   pragma Export (C, u00110, "ada__strings__searchB");
   pragma Export (C, u00111, "ada__strings__searchS");
   pragma Export (C, u00112, "system__compare_array_unsigned_8B");
   pragma Export (C, u00113, "system__compare_array_unsigned_8S");
   pragma Export (C, u00114, "system__address_operationsB");
   pragma Export (C, u00115, "system__address_operationsS");
   pragma Export (C, u00116, "ada__finalizationB");
   pragma Export (C, u00117, "ada__finalizationS");
   pragma Export (C, u00118, "system__finalization_rootB");
   pragma Export (C, u00119, "system__finalization_rootS");
   pragma Export (C, u00120, "ada__streamsS");
   pragma Export (C, u00121, "system__finalization_implementationB");
   pragma Export (C, u00122, "system__finalization_implementationS");
   pragma Export (C, u00123, "system__restrictionsB");
   pragma Export (C, u00124, "system__restrictionsS");
   pragma Export (C, u00125, "system__stream_attributesB");
   pragma Export (C, u00126, "system__stream_attributesS");
   pragma Export (C, u00127, "ada__io_exceptionsS");
   pragma Export (C, u00128, "brick_matrix_packageB");
   pragma Export (C, u00129, "brick_matrix_packageS");
   pragma Export (C, u00130, "ada__directoriesB");
   pragma Export (C, u00131, "ada__directoriesS");
   pragma Export (C, u00132, "ada__calendar__formattingB");
   pragma Export (C, u00133, "ada__calendar__formattingS");
   pragma Export (C, u00134, "ada__calendar__time_zonesB");
   pragma Export (C, u00135, "ada__calendar__time_zonesS");
   pragma Export (C, u00136, "system__val_realB");
   pragma Export (C, u00137, "system__val_realS");
   pragma Export (C, u00138, "system__powten_tableS");
   pragma Export (C, u00139, "ada__characters__handlingB");
   pragma Export (C, u00140, "ada__characters__handlingS");
   pragma Export (C, u00141, "ada__strings__maps__constantsS");
   pragma Export (C, u00142, "ada__directories__validityB");
   pragma Export (C, u00143, "ada__directories__validityS");
   pragma Export (C, u00144, "ada__finalization__list_controllerB");
   pragma Export (C, u00145, "ada__finalization__list_controllerS");
   pragma Export (C, u00146, "system__crtlS");
   pragma Export (C, u00147, "system__os_libB");
   pragma Export (C, u00148, "system__os_libS");
   pragma Export (C, u00149, "system__stringsB");
   pragma Export (C, u00150, "system__stringsS");
   pragma Export (C, u00151, "system__regexpB");
   pragma Export (C, u00152, "system__regexpS");
   pragma Export (C, u00153, "ada__text_ioB");
   pragma Export (C, u00154, "ada__text_ioS");
   pragma Export (C, u00155, "interfaces__c_streamsB");
   pragma Export (C, u00156, "interfaces__c_streamsS");
   pragma Export (C, u00157, "system__file_ioB");
   pragma Export (C, u00158, "system__file_ioS");
   pragma Export (C, u00159, "system__file_control_blockS");
   pragma Export (C, u00160, "ada__text_io__unbounded_ioS");
   pragma Export (C, u00161, "ada__strings__unbounded__text_ioB");
   pragma Export (C, u00162, "ada__strings__unbounded__text_ioS");
   pragma Export (C, u00163, "runtime_logB");
   pragma Export (C, u00164, "runtime_logS");
   pragma Export (C, u00165, "system__tasking__rendezvousB");
   pragma Export (C, u00166, "system__tasking__rendezvousS");
   pragma Export (C, u00167, "system__task_primitivesS");
   pragma Export (C, u00168, "system__os_interfaceS");
   pragma Export (C, u00169, "system__task_primitives__operationsB");
   pragma Export (C, u00170, "system__task_primitives__operationsS");
   pragma Export (C, u00171, "system__interrupt_managementB");
   pragma Export (C, u00172, "system__interrupt_managementS");
   pragma Export (C, u00173, "system__task_infoB");
   pragma Export (C, u00174, "system__task_infoS");
   pragma Export (C, u00175, "system__taskingB");
   pragma Export (C, u00176, "system__taskingS");
   pragma Export (C, u00177, "system__stack_usageB");
   pragma Export (C, u00178, "system__stack_usageS");
   pragma Export (C, u00179, "system__ioB");
   pragma Export (C, u00180, "system__ioS");
   pragma Export (C, u00181, "system__tasking__debugB");
   pragma Export (C, u00182, "system__tasking__debugS");
   pragma Export (C, u00183, "system__img_enum_newB");
   pragma Export (C, u00184, "system__img_enum_newS");
   pragma Export (C, u00185, "system__img_unsB");
   pragma Export (C, u00186, "system__img_unsS");
   pragma Export (C, u00187, "system__tasking__entry_callsB");
   pragma Export (C, u00188, "system__tasking__entry_callsS");
   pragma Export (C, u00189, "system__tasking__initializationB");
   pragma Export (C, u00190, "system__tasking__initializationS");
   pragma Export (C, u00191, "system__soft_links__taskingB");
   pragma Export (C, u00192, "system__soft_links__taskingS");
   pragma Export (C, u00193, "ada__exceptions__is_null_occurrenceB");
   pragma Export (C, u00194, "ada__exceptions__is_null_occurrenceS");
   pragma Export (C, u00195, "system__tasking__protected_objectsB");
   pragma Export (C, u00196, "system__tasking__protected_objectsS");
   pragma Export (C, u00197, "system__tasking__protected_objects__entriesB");
   pragma Export (C, u00198, "system__tasking__protected_objects__entriesS");
   pragma Export (C, u00199, "system__tasking__protected_objects__operationsB");
   pragma Export (C, u00200, "system__tasking__protected_objects__operationsS");
   pragma Export (C, u00201, "system__tasking__queuingB");
   pragma Export (C, u00202, "system__tasking__queuingS");
   pragma Export (C, u00203, "system__tasking__utilitiesB");
   pragma Export (C, u00204, "system__tasking__utilitiesS");
   pragma Export (C, u00205, "system__traces__taskingB");
   pragma Export (C, u00206, "system__traces__taskingS");
   pragma Export (C, u00207, "ada__real_timeB");
   pragma Export (C, u00208, "ada__real_timeS");
   pragma Export (C, u00209, "gnatS");
   pragma Export (C, u00210, "gnat__calendarB");
   pragma Export (C, u00211, "gnat__calendarS");
   pragma Export (C, u00212, "gnat__calendar__time_ioB");
   pragma Export (C, u00213, "gnat__calendar__time_ioS");
   pragma Export (C, u00214, "gnat__case_utilB");
   pragma Export (C, u00215, "gnat__case_utilS");
   pragma Export (C, u00216, "system__img_lluB");
   pragma Export (C, u00217, "system__img_lluS");
   pragma Export (C, u00218, "system__tasking__stagesB");
   pragma Export (C, u00219, "system__tasking__stagesS");
   pragma Export (C, u00220, "system__address_imageB");
   pragma Export (C, u00221, "system__address_imageS");
   pragma Export (C, u00222, "text_ioS");
   pragma Export (C, u00223, "process_input_packageB");
   pragma Export (C, u00224, "process_input_packageS");
   pragma Export (C, u00225, "gl_drawB");
   pragma Export (C, u00226, "gl_drawS");
   pragma Export (C, u00227, "win32__gluB");
   pragma Export (C, u00228, "win32__gluS");
   pragma Export (C, u00229, "win32__glutB");
   pragma Export (C, u00230, "win32__glutS");
   pragma Export (C, u00231, "gnat__os_libS");
   pragma Export (C, u00232, "process_physics_packageB");
   pragma Export (C, u00233, "process_physics_packageS");
   pragma Export (C, u00234, "system__memoryB");
   pragma Export (C, u00235, "system__memoryS");

   --  BEGIN ELABORATION ORDER
   --  ada%s
   --  ada.characters%s
   --  ada.characters.handling%s
   --  ada.characters.latin_1%s
   --  gnat%s
   --  interfaces%s
   --  system%s
   --  system.address_image%s
   --  system.address_operations%s
   --  system.address_operations%b
   --  system.arith_64%s
   --  system.bit_ops%s
   --  system.case_util%s
   --  system.case_util%b
   --  gnat.case_util%s
   --  gnat.case_util%b
   --  system.compare_array_unsigned_8%s
   --  system.exn_llf%s
   --  system.exn_llf%b
   --  system.htable%s
   --  system.htable%b
   --  system.img_enum_new%s
   --  system.img_int%s
   --  system.img_int%b
   --  system.io%s
   --  system.io%b
   --  system.machine_code%s
   --  system.os_primitives%s
   --  system.parameters%s
   --  system.parameters%b
   --  system.crtl%s
   --  interfaces.c_streams%s
   --  interfaces.c_streams%b
   --  system.powten_table%s
   --  system.restrictions%s
   --  system.restrictions%b
   --  system.standard_library%s
   --  system.exceptions%s
   --  system.exceptions%b
   --  system.storage_elements%s
   --  system.storage_elements%b
   --  system.img_enum_new%b
   --  system.compare_array_unsigned_8%b
   --  system.secondary_stack%s
   --  system.address_image%b
   --  system.stack_checking%s
   --  system.stack_checking%b
   --  system.stack_usage%s
   --  system.string_ops%s
   --  system.string_ops%b
   --  system.string_ops_concat_3%s
   --  system.string_ops_concat_3%b
   --  system.string_ops_concat_4%s
   --  system.string_ops_concat_4%b
   --  system.string_ops_concat_5%s
   --  system.string_ops_concat_5%b
   --  system.stack_usage%b
   --  system.strings%s
   --  system.strings%b
   --  system.traceback%s
   --  system.traceback%b
   --  system.traceback_entries%s
   --  system.traceback_entries%b
   --  ada.exceptions%s
   --  system.arith_64%b
   --  ada.exceptions.is_null_occurrence%s
   --  ada.exceptions.is_null_occurrence%b
   --  ada.exceptions.last_chance_handler%s
   --  system.soft_links%s
   --  system.soft_links%b
   --  ada.exceptions.last_chance_handler%b
   --  system.secondary_stack%b
   --  system.exception_table%s
   --  system.exception_table%b
   --  ada.calendar%s
   --  ada.calendar%b
   --  ada.calendar.delays%s
   --  ada.calendar.time_zones%s
   --  ada.calendar.time_zones%b
   --  ada.calendar.formatting%s
   --  ada.io_exceptions%s
   --  ada.numerics%s
   --  ada.numerics.aux%s
   --  ada.numerics.float_random%s
   --  ada.strings%s
   --  ada.tags%s
   --  ada.streams%s
   --  interfaces.c%s
   --  interfaces.c%b
   --  gnat.calendar%s
   --  gnat.calendar%b
   --  gnat.calendar.time_io%s
   --  interfaces.c.strings%s
   --  interfaces.c.strings%b
   --  system.finalization_root%s
   --  system.finalization_root%b
   --  system.memory%s
   --  system.memory%b
   --  system.standard_library%b
   --  system.os_lib%s
   --  system.os_lib%b
   --  gnat.os_lib%s
   --  system.soft_links.tasking%s
   --  system.traces%s
   --  system.traces%b
   --  ada.calendar.delays%b
   --  system.unsigned_types%s
   --  system.bit_ops%b
   --  ada.strings.maps%s
   --  ada.strings.maps%b
   --  ada.strings.fixed%s
   --  ada.strings.maps.constants%s
   --  ada.characters.handling%b
   --  ada.strings.search%s
   --  ada.strings.search%b
   --  ada.strings.fixed%b
   --  system.fat_flt%s
   --  ada.numerics.elementary_functions%s
   --  ada.numerics.elementary_functions%b
   --  system.fat_llf%s
   --  ada.numerics.aux%b
   --  system.img_llu%s
   --  system.img_llu%b
   --  system.img_uns%s
   --  system.img_uns%b
   --  system.stream_attributes%s
   --  system.stream_attributes%b
   --  system.finalization_implementation%s
   --  system.finalization_implementation%b
   --  ada.finalization%s
   --  ada.finalization%b
   --  ada.finalization.list_controller%s
   --  ada.finalization.list_controller%b
   --  ada.strings.unbounded%s
   --  ada.strings.unbounded%b
   --  ada.directories%s
   --  ada.directories.validity%s
   --  ada.directories.validity%b
   --  system.file_control_block%s
   --  system.file_io%s
   --  system.file_io%b
   --  system.regexp%s
   --  system.regexp%b
   --  ada.directories%b
   --  system.val_int%s
   --  ada.numerics.float_random%b
   --  system.val_real%s
   --  ada.calendar.formatting%b
   --  system.val_uns%s
   --  system.val_util%s
   --  system.val_util%b
   --  system.val_uns%b
   --  system.val_real%b
   --  system.val_int%b
   --  system.wch_con%s
   --  system.wch_con%b
   --  system.wch_cnv%s
   --  system.wch_jis%s
   --  system.wch_jis%b
   --  system.wch_cnv%b
   --  system.wch_stw%s
   --  system.wch_stw%b
   --  ada.tags%b
   --  ada.exceptions%b
   --  ada.text_io%s
   --  ada.text_io%b
   --  gnat.calendar.time_io%b
   --  ada.strings.unbounded.text_io%s
   --  ada.strings.unbounded.text_io%b
   --  ada.text_io.unbounded_io%s
   --  system.win32%s
   --  system.os_interface%s
   --  system.interrupt_management%s
   --  system.interrupt_management%b
   --  system.task_info%s
   --  system.task_info%b
   --  system.task_primitives%s
   --  system.tasking%s
   --  system.task_primitives.operations%s
   --  system.tasking%b
   --  system.soft_links.tasking%b
   --  system.tasking.debug%s
   --  system.tasking.debug%b
   --  system.tasking.entry_calls%s
   --  system.tasking.initialization%s
   --  system.tasking.initialization%b
   --  system.tasking.protected_objects%s
   --  system.tasking.protected_objects%b
   --  system.tasking.utilities%s
   --  system.traces.tasking%s
   --  system.traces.tasking%b
   --  system.win32.ext%s
   --  system.task_primitives.operations%b
   --  system.os_primitives%b
   --  ada.real_time%s
   --  ada.real_time%b
   --  system.tasking.protected_objects.entries%s
   --  system.tasking.protected_objects.entries%b
   --  system.tasking.queuing%s
   --  system.tasking.queuing%b
   --  system.tasking.utilities%b
   --  system.tasking.rendezvous%s
   --  system.tasking.protected_objects.operations%s
   --  system.tasking.protected_objects.operations%b
   --  system.tasking.rendezvous%b
   --  system.tasking.entry_calls%b
   --  system.tasking.stages%s
   --  system.tasking.stages%b
   --  text_io%s
   --  computer_steering%s
   --  process_graphics%s
   --  process_input_package%s
   --  process_physics_package%s
   --  runtime_log%s
   --  runtime_log%b
   --  win32%s
   --  win32%b
   --  win32.gl%s
   --  common_data%s
   --  common_data%b
   --  multiplayer_arkanoid%b
   --  brick_matrix_package%s
   --  brick_matrix_package%b
   --  game_state_package%s
   --  game_state_package%b
   --  process_physics_package%b
   --  process_input_package%b
   --  computer_steering%b
   --  gl_draw%s
   --  win32.glu%s
   --  win32.glu%b
   --  win32.glut%s
   --  win32.glut%b
   --  gl_draw%b
   --  process_graphics%b
   --  END ELABORATION ORDER

end ada_main;
