--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Gl_Draw
--------------------------------------------------------------------------------

with Win32.GLU,Win32.GL,Win32.Glut,Common_Data,Gnat.Calendar;
use Win32.GLU,Win32.GL,Win32.Glut,Common_Data,Gnat.Calendar;

package body Gl_Draw is

    OD_En : Boolean:=False;
    Painter_HPos : GLInt;
    ----------------
    -- Draw_Brick --
    ----------------
    procedure Draw_All_Bricks(All_Bricks: in Brick_Matrix_Package.Brick_Matrix) is
    begin
        for I in 1..Rozmiar_Planszy
        loop
            GlPushMatrix;
            GlTranslatef(X => 0.0,
                         Y => GLfloat(I-1),
                         Z => 0.0);
            for J in 1..Rozmiar_Planszy
            loop
                GlPushMatrix;
                GlTranslatef(X => GLfloat(J-1),
                             Y => 0.0,
                             Z => 0.0);
                Draw_Brick(Single_Brick => All_Bricks(I,J));
                GlPopMatrix;
            end loop;
            GlPopMatrix;
        end loop;
    end;

    procedure Draw_Brick (Single_Brick : in Common_Data.Brick) is
        obiekt:PGLUquadricObj;
    begin
        if Single_Brick.Exists then
            glColor3f(red   => Single_Brick.Color(R),
                      green => Single_Brick.Color(G),
                      Blue  => Single_Brick.Color(B));

            GlPushMatrix;
            GlTranslatef(x => 0.5,
                         y => 0.5,
                         z => 0.0);
            --GlutSolidSphere(0.49,20,20);
            obiekt:=gluNewQuadric;
            gluQuadricNormals(quadObject => obiekt,
                              Normals    => GLU_FLAT);

            gluQuadricOrientation(quadObject  => obiekt,
                                  Orientation => GLU_OUTSIDE);

            gluQuadricDrawStyle(quadObject => obiekt,
                                DrawStyle  => GLU_FILL);

            glRotatef(angle => 45.0,
                      x     => 0.0,
                      y     => 0.0,
                      z     => 1.0);
            GluCylinder(Qobj       =>obiekt,
                        BaseRadius =>1.0/1.4142135623730950488016887242097,
                        TopRadius  =>1.0/1.4142135623730950488016887242097,
                        Height     =>1.0,
                        Slices     =>4,
                        Stacks     =>1);

            GluCylinder(Qobj       =>Obiekt,
                        BaseRadius =>1.0/1.4142135623730950488016887242097,
                        TopRadius  =>0.0,
                        Height     =>0.1,
                        Slices     =>4,
                        Stacks     =>1);
            glTranslatef(x => 0.0,
                         y => 0.0,
                         Z => 1.0);
            GluCylinder(Qobj       =>Obiekt,
                        BaseRadius =>1.0/1.4142135623730950488016887242097,
                        TopRadius  =>0.0,
                        Height     =>0.2,
                        Slices     =>4,
                        Stacks     =>1);

            gluDeleteQuadric(obiekt);
            GlPopMatrix;

        end if;

    end Draw_Brick;

    procedure Draw_Pad(Pad : in Common_Data.Pad_Type) is
        obiekt : PGLUquadricObj;
    begin
        GlPushMatrix;

        GlColor3f(Red   => Pad.Color(R),
                  Green => Pad.Color(G),
                  Blue  => Pad.Color(B));
        glTranslatef(x => glfloat(Pad.Position.X),
                     y => glfloat(Pad.Position.Y),
                     Z => 0.0);
        glRotatef(angle => 90.0,
                  x     => 0.0,
                  y     => 1.0,
                  Z     => 0.0);
        glTranslatef(x => -0.5,
                     y => 0.0,
                     z => -0.5*Pad.Width);
        obiekt:=gluNewQuadric;

        GlColor3f(Red   => Pad.Color(R),
                  Green => Pad.Color(G),
                  Blue  => Pad.Color(B));
        gluCylinder(qobj       => obiekt,
                    baseRadius => 0.49,
                    topRadius  => 0.49,
                    height     => GLdouble(Pad.Width),
                    slices     => 11,
                    Stacks     => 11);
        GluCylinder(Qobj       => Obiekt,
                    BaseRadius => 0.49,
                    TopRadius  => 0.0,
                    Height     => 0.0,
                    Slices     => 11,
                    Stacks     => 11);
        glTranslatef(x => 0.0,
                     y => 0.0,
                     z => PAd.Width);
        GluCylinder(Qobj       => Obiekt,
                    BaseRadius => 0.49,
                    TopRadius  => 0.0,
                    Height     => 0.0,
                    Slices     => 11,
                    Stacks     => 11);
        glPopMatrix;
        gluDeleteQuadric(obiekt);
    end;

    procedure Draw_Ball(Ball : in Common_Data.Ball_Type)
    is
    begin
        GlPushMatrix;
        GlColor3f(Red   => Ball.Color(R),
                  Green => Ball.Color(G),
                  Blue  => Ball.Color(B));

        glTranslatef(x => Ball.Pos.X,
                     y => Ball.Pos.Y,
                     z => 0.5);
        glutSolidSphere(radius => 0.49,
                        slices => 20,
                        Stacks => 20);
        glPopMatrix;
    end;
    procedure Draw_Axis is
    begin
        GlBegin(GL_LINES);
        GlColor3f(1.0,0.0,0.0);
        GlVertex3f(0.0,0.0,0.0);
        GlVertex3f(4.0,0.0,0.0);
        Glend;

        GlBegin(GL_LINES);
        GlColor3f(0.0,1.0,0.0);
        GlVertex3f(0.0,0.0,0.0);
        GlVertex3f(0.0,4.0,0.0);
        Glend;

        GlBegin(GL_LINES);
        GlColor3f(0.0,0.0,1.0);
        GlVertex3f(0.0,0.0,0.0);
        GlVertex3f(0.0,0.0,4.0);
        Glend;
    end;

    procedure Draw_Floor is
    begin
        GlBegin(GL_POLYGON);
        GlColor3f(0.4,0.4,0.4);
        GlVertex3f(0.0,0.0,-0.05);
        GlVertex3f(GLfloat(Rozmiar_Planszy),0.0,-0.05);
        GlVertex3f(GLfloat(Rozmiar_Planszy),GLfloat(Rozmiar_Planszy),-0.05);
        GlVertex3f(0.0,GLfloat(Rozmiar_Planszy),-0.05);
        Glend;
    end Draw_Floor;
    procedure Draw_String(Napis : in String) is
    begin
        GlColor3f(1.0,1.0,1.0);
        glRasterPos2i(10,Painter_HPos);
        Painter_HPos:=Painter_HPos+13;

        for I in Napis'Range
        loop
            glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12,Character'Pos(Napis(I)));
        end loop;
    end;
    procedure Draw_Time(Prefix : in String; Czas : in Duration) is
        Text : String :="00:00:00";
        Raw_Seconds : constant Integer := Integer(Czas) mod (24*60*60);
        Sec : Second_Number;
        Min : Minute_Number;
        Hour : Hour_Number;
    begin
        Sec := Raw_Seconds mod 60;
        Min := Raw_Seconds/60 mod 60;
        Hour := Raw_Seconds/3600 mod 24;
        if Hour>9 then Text(1):=Character'Val(Character'Pos('0')+Hour/10);end if;
        Text(2):=Character'Val(Character'Pos('0')+(Hour mod 10));

        if Min>9 then Text(4):=Character'Val(Character'Pos('0')+Min/10);end if;
        Text(5):=Character'Val(Character'Pos('0')+(Min mod 10));

        if Sec>9 then Text(7):=Character'Val(Character'Pos('0')+Sec/10);end if;
        Text(8):=Character'Val(Character'Pos('0')+(Sec mod 10));

        Draw_String(Prefix & text);
    end;

    procedure String_Draw(Enable : in Boolean) is
    begin
        if Enable and then not OD_En then
            Gldisable(GL_LIGHTING);
            GlMatrixMode(GL_PROJECTION);
            GlPushMatrix;
            GlLoadIdentity;	
            GlMatrixMode(GL_MODELVIEW);
            GlPushMatrix;						
            GlLoadIdentity;							


            GlOrtho(left   => 0.0,
                    right  => gldouble(glutGet(GLUT_WINDOW_WIDTH)),
                    bottom => gldouble(glutGet(GLUT_WINDOW_HEIGHT)),
                    top    => 0.0,
                    zNear  => -1.0,
                    ZFar   => 1.0);
            OD_En:=True;
            Painter_HPos:=22;
        elsif not Enable and then OD_En then
            GlEnable(GL_LIGHTING);
            GlMatrixMode(GL_PROJECTION);
            GlPopMatrix;						
            GlMatrixMode(GL_MODELVIEW);
            GlPopMatrix;
            OD_en:=false;
        end if;
    end;





end Gl_Draw;
