--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Process_Graphics
-- Krtki opis:		Pakiet odpowiedzialny za wyswietlanie grafiki.
--					zawiera funkcje sluzace do rysowania i obslugi zdarzen
--					zawiera zadanie ktore wykonuje sie jako osobny proces
--					Ew obsuga polega gownie na modyfikacji stanw.
--------------------------------------------------------------------------------
with Ada.Exceptions,Ada.Calendar,Computer_Steering,
     Win32.Gl,Win32.Glut,Win32.Glu,GNAT.OS_Lib,Gl_Draw,
     Common_Data,Game_State_Package,Process_Input_Package,
     Interfaces.C.Strings,Runtime_Log;
use  Ada.Exceptions,Ada.Calendar,Computer_Steering,
     Win32.Gl,Win32.Glut,Win32.Glu,GNAT.OS_Lib,Gl_Draw,
     Common_Data,Game_State_Package,Process_Input_Package,
     Interfaces.C.Strings,Runtime_Log;

package body Process_Graphics is
    procedure Create_Menus;

    Previous_Mouse_X: Integer:=0;
    Previous_Mouse_Y: Integer:=0;

    procedure Display is
        current_distance : constant GLdouble:=View_State.Get.Distance;
    begin
        GlClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
        GlMatrixMode(GL_MODELVIEW);
        GlLoadIdentity;

        gluLookAt(eyex    => current_distance,
                  eyey    => current_distance,
                  eyez    => current_distance,
                  centerx => gldouble(Rozmiar_Planszy/2),
                  centery => gldouble(Rozmiar_Planszy/2),
                  centerz => 0.0,
                  upx     => 0.0,
                  upy     => 0.0,
                  Upz     => 1.0);
        glTranslatef(x => glfloat(Rozmiar_Planszy/2),
                     y => glfloat(Rozmiar_Planszy/2),
                     z => 0.0);
        glRotatef(angle => View_State.Get.Horizontal_Angle,
                  X     => -1.0,
                  Y     => 1.0,
                  Z     => 0.0);
        GlRotatef(Angle =>  View_State.Get.Vertical_Angle,
                  X     => 0.0,
                  Y     => 0.0,
                  Z     => 1.0);
        GlTranslatef(X => -Glfloat(Rozmiar_Planszy/2),
                     Y => -Glfloat(Rozmiar_Planszy/2),
                     Z => 0.0);

        Draw_Floor;

        Draw_All_Bricks(Board_State.Get_Brick_Matrix_State);
        Draw_Pad(Pad => Board_State.Get_Pad1);
        Draw_Pad(Pad => Board_State.Get_Pad2);
        Draw_Ball(Ball => Board_State.Get_Ball);

        Rysowanie_Informacji:
        begin
            String_Draw(True);
            Draw_String("Multiplayer Arkanoid " & Game_Version);
            Draw_String("Autor: Krzysztof Wesolowski, http://kwesoly.net");
            Draw_String("");
            Draw_Time("Czas od uruchomienia programu: ",Ada.Calendar.Clock-Program_Started);
            Draw_Time("Czas biezacej rozgrywki: ",Ada.Calendar.Clock-Board_State.Started);

            Draw_String("Gracz czerwony: "&Players_State.R1'Img);
            Draw_String("Gracz zielony: "&Players_State.R2'Img);
            Draw_String("Predkosc kulki wynosi:" & Integer(Lenght(Board_State.Get_Ball.Velocity))'Img);
            Draw_String(Board_State.Get_Info);
            String_Draw(false);
        end Rysowanie_Informacji;


        GlutSwapBuffers;
    end Display;


    procedure Redraw is
    begin
        GlutPostRedisplay;
        Update_Joy;
    end;

    procedure Update_Joy is
    begin
        GlutForceJoystickFunc;
    end;



    -------------
    -- Reshape --
    -------------

    procedure Reshape (W : in Integer; H : in Integer) is
    begin
        GlMatrixMode(GL_PROJECTION);
        glLoadIdentity;
        glViewport(x      => 0,
                   y      => 0,
                   width  => GLsizei(W),
                   Height => GLsizei(H));
        GluPerspective(fovy   => 20.0 ,
                       aspect => GLdouble(w)/GLdouble(h),
                       zNear  => 0.1,
                       zFar   => 100.0);
        GlMatrixMode(GL_MODELVIEW);
    end Reshape;

    procedure MotionFunc(X : in Integer;Y : in Integer) is
        ChX : GLfloat;
        chY : GLfloat;
    begin
        -- Put_Line("Ruch z "& Previous_Mouse_X &",")
        ChX:=GLfloat(X-Previous_Mouse_X)/5.0;
        ChY:=GLfloat(Y-Previous_Mouse_Y)/5.0;
        View_State.Angle_Change(delta_H => ChY,
                                Delta_V => ChX);
        Previous_Mouse_X:=X;
        Previous_Mouse_Y:=Y;
    end;

    procedure MouseFunc(Button : in Integer;State : in Integer; X : in Integer;Y : in Integer) is
        pragma Unreferenced (State, Button);
    begin
        Previous_Mouse_X:=X;
        Previous_Mouse_Y:=Y;
    end;

    procedure KeyboardFunc(Znak : in Interfaces.C.unsigned_char; X : in Integer;Y : in Integer) is
        pragma Unreferenced (X, Y);
    begin
        Process_Input_Package.Keyboard_State.Set_Key_Down(Character'Val(Znak));
    end;

    procedure KeyboardUpFunc(Znak : in Interfaces.C.Unsigned_Char; X : in Integer;Y : in Integer) is
        pragma Unreferenced (X, Y);
    begin
        Process_Input_Package.Keyboard_State.Set_Key_Up(Character'val(Znak));
    end;
    procedure JoystickFunc(Button_Mask : in Interfaces.C.Unsigned;X,Y,Z : Integer) is
        pragma Unreferenced(Button_Mask,Y,Z);
    begin
        if (X>10) then
            Process_Input_Package.Keyboard_State.Set_Key_Down(Joy_Right);
            Process_Input_Package.Keyboard_State.Set_Key_Up(Joy_Left);
        elsif X<-10 then
            Process_Input_Package.Keyboard_State.Set_Key_Up(Joy_Right);
            Process_Input_Package.Keyboard_State.Set_Key_Down(Joy_Left);
        else
            Process_Input_Package.Keyboard_State.Set_Key_Up(Joy_Right);
            Process_Input_Package.Keyboard_State.Set_Key_Up(Joy_Left);
        end if;
    end JoystickFunc;

    ----------
    -- Init --
    ----------

    procedure Init is
        Light_Ambient : array (0 .. 3) of aliased GLfloat
          := (0.2, 0.2, 0.2, 1.0);
        Light_Diffuse : array (0 .. 3) of aliased GLfloat
          := (0.4, 0.4, 0.4, 1.0);
        Light_Specular : array (0 .. 3) of aliased GLfloat
          := (0.4, 0.4, 0.4, 1.0);
        Light_Position : array (0 .. 3) of aliased GLfloat
          := (3.0, 3.0, 3.0, 0.0);

    begin
        GlutDisplayFunc (Display'Access);
        GlutReshapeFunc (Reshape'Access);
        GlutMotionFunc (MotionFunc'Access);
        GlutMouseFunc (MouseFunc'Access);
        GlutKeyboardFunc(KeyboardFunc'Access);
        GlutKeyboardUpFunc(KeyboardUpFunc'Access);
        GlutJoystickFunc(Func         => JoystickFunc'Access,
                         PollInterval => 20);
        GlutMenuStateFunc(MenuStateFunc'Access);


        GlClearColor (0.5, 0.5, 0.5, 0.0);
        GlLightfv (GL_LIGHT0, GL_AMBIENT, Light_Ambient (0)'Unchecked_Access);
        GlLightfv (GL_LIGHT0, GL_DIFFUSE, Light_Diffuse (0)'Unchecked_Access);
        GlLightfv (GL_LIGHT0, GL_SPECULAR, Light_Specular (0)'Unchecked_Access);
        GlLightfv (GL_LIGHT0, GL_POSITION, Light_Position (0)'Unchecked_Access);

        GlShadeModel(GL_SHADE_MODEL);
        GlEnable(GL_LIGHTING);
        GlEnable(GL_LIGHT0);
        GlEnable(GL_DEPTH_TEST);
        GlEnable(GL_COLOR_MATERIAL);
        GlColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);

        GlEnable(GL_BLEND);
        GlBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        GlEnable(GL_LINE_SMOOTH);
        GlEnable(GL_POLYGON_SMOOTH);
        GlEnable(GL_POINT_SMOOTH);
        GlLineWidth(0.0);

        glutPostRedisplay;
    end Init;


    ----------
    -- Menu --
    ----------
    procedure Change_Board(Numer : in Integer) is
    begin
        Board_Pattern(8):=Character'val(Character'pos('0')+Numer);
        Board_State.Reset;
        Players_State.Reset_Players;
    end;

    procedure Menu (Value : in Integer) is
        tmp:integer;
        pragma Unreferenced (tmp);
    begin
        case Value is
            when 100..109 => Change_Board(Value-100);
            when 200 => Board_State.Stop;
            when 300 => Board_State.Start;
            when 411 => Players_State.Set1(AD);
            when 412 => Players_State.Set1(JL);
            when 413 => Players_State.Set1(Pad);
            when 421 => Players_State.Set2(AD);Computer_Steering.Computer_Steering.Stop;
            when 422 => Players_State.Set2(JL);Computer_Steering.Computer_Steering.Stop;
            when 423 => Players_State.Set2(Pad);Computer_Steering.Computer_Steering.Stop;
            when 424 =>
                Players_State.Set2(Computer);
                Computer_Steering.Computer_Steering.Start;


            when 501 => GlutPositionWindow(Window_Pos_X,Window_Pos_Y);
                glutReshapeWindow(Window_Width,Window_height);
            when 502 => GlutFullScreen;

            when 600 => Log.info("Zakoczono dzialanie programu");GNat.OS_Lib.OS_Exit(0);
            when others => null;
        end case;
        GlutPostRedisplay;
    end Menu;

    procedure MenuStateFunc(Status: in Integer)
    is
    begin
        if Status=GLUT_MENU_IN_USE then
            Board_State.Stop;
        elsif Status=GLUT_MENU_NOT_IN_USE then
            Board_State.Start;
        end if;
    end;


    task body Processing_Graphics is
        Win : Integer;
        pragma Unreferenced (Win);
        Argc : aliased Integer;
        pragma Import(C, Argc, "gnat_argc");

        type Chars_Ptr_Ptr is access Interfaces.C.Strings.Chars_Ptr;
        Argv : Chars_Ptr_Ptr;
        pragma Import(C, Argv, "gnat_argv");
    begin
        accept Start;

        GlutInit (Argc'Access, Argv);

        GlutInitDisplayMode (GLUT_RGB or GLUT_DEPTH or GLUT_DOUBLE);
        glutInitWindowPosition(x => Window_Pos_X,
                               Y => Window_Pos_Y);
        glutInitWindowSize(width  => Window_Width,
                           height => Window_height);
        Win := GlutCreateWindow ("Multiplayer Arkanoid " & Game_Version);


        Init;
        Create_Menus;

        accept Wait_For_Initialization;
        Redrawing.Start;
        GlutMainLoop;
    exception
        when Event: others =>
            Log.Error("Nastapil wyjatek w module obslugi grafiki, nazwa: "
                      &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
    end Processing_Graphics;

    procedure Create_Menus is
        Main_Menu,New_Game_Menu,Sterowanie_Menu,Gracz1_Menu,Gracz2_Menu, Okno_Menu : Integer;
        pragma Unreferenced (Main_Menu);
    begin
        New_Game_Menu:= GlutCreateMenu (Menu'Access);
        for I in 0..9
        loop
            GlutAddMenuEntry ("Wybierz plansze nr:"&I'img,100+I);
        end loop;

        Gracz1_Menu := GlutCreateMenu (Menu'Access);
        GlutAddMenuEntry ("A,D",411);
        GlutAddMenuEntry ("J,L", 412);
        GlutAddMenuEntry ("Pad", 413);
        Gracz2_Menu := GlutCreateMenu (Menu'Access);
        GlutAddMenuEntry ("A,D",421);
        GlutAddMenuEntry ("J,L", 422);
        GlutAddMenuEntry ("Pad", 423);
        GlutAddMenuEntry ("Komputer", 424);

        Sterowanie_Menu := GlutCreateMenu (Menu'Access);
        GlutAddSubMenu("Gracz czerwony",Gracz1_Menu);
        GlutAddSubMenu("Gracz zielony",Gracz2_Menu);

        Okno_Menu := GlutCreateMenu (Menu'Access);
        GlutAddMenuEntry ("Oknto domylne",501);
        GlutAddMenuEntry ("Pelny Ekran", 502);
        Main_Menu := GlutCreateMenu (Menu'Access);

        GlutAddSubMenu ("Nowa Gra",New_Game_Menu);
        GlutAddMenuEntry ("Zatrzymaj", 200);
        GlutAddMenuEntry ("Wznow", 300);
        GlutAddSubMenu ("Sterowanie", Sterowanie_Menu);
        GlutAddSubMenu ("Rozmiar Okna", Okno_Menu);
        GlutAddMenuEntry ("Zakoncz", 600);

        GlutAttachMenu (GLUT_RIGHT_BUTTON);
    exception
        when Event: others =>
            Log.Error("Nastapil wyjatek w module obslugi grafiki - tworzenie menu, nazwa: "
                      &Exception_Name(Event)&" jego opis: "& Exception_Message(Event));
    end;

    task body Redrawing is
        Czekaj :constant Duration :=Duration((1.0/Float(Frame_Rate)));
        do_kiedy:Time;
    begin
        accept Start;
        loop
            do_kiedy:=Clock+Czekaj;
            Redraw;
            delay until do_kiedy;
        end loop;
    end;

end Process_Graphics;
