--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Runtime_Log
--------------------------------------------------------------------------------
with Ada.Text_Io,Ada.Directories,Ada.Strings.Unbounded,Ada.Exceptions,Ada.Calendar;
use  Ada.Text_Io,Ada.Directories,Ada.Strings.Unbounded,Ada.Exceptions;

package body Runtime_Log is

    task body Log is
        function Current_Time(format:in Picture_String:=Time_Date_Format)
                            return String;
        File_Name_Full :Unbounded_String;
        type Console_Line_Number_Type is mod Console_Line_Limit;
        type File_Line_Number_Type is mod File_Line_Limit;
        File_Line_Number : File_Line_Number_Type:=0;
        Console_Line_Number : Console_Line_Number_Type:=0;
        header :constant String :="Typ          |Data              |Opis";
        Plik:File_Type;

        procedure New_File is
        begin
            Ada.Directories.Create_Path(File_Relative_Dir);
            if File_Relative_Dir(File_Relative_Dir'Last)='/' or else File_Relative_Dir(File_Relative_Dir'Last)='\' then
                File_Name_Full:=To_Unbounded_String(File_Relative_Dir & File_Name_Prefix & Current_Time("_%Y_%m_%d_%H-%M-%S-%i")&".log");
            else
                File_Name_Full:=To_Unbounded_String(File_Relative_Dir & "/" & File_Name_Prefix & Current_Time("_%Y_%m_%d_%H-%M-%S-%i")&".log");
            end if;

            if Exists(To_String(File_Name_Full)) then
                Open(Plik,Out_File,To_String(File_Name_Full));
            else
                Create(Plik,Out_File,To_String(File_Name_Full));
            end if;

            Put_Line(File => Plik,
                     Item    => Header);
            Close(Plik);
            File_Line_Number:=File_Line_Number+1;
        end New_File;
        procedure New_Console is
        begin
            Console_Line_Number := Console_Line_Number + 1;
            Put_Line(Header);
        end;


        procedure Log_Line(Typ: Rodzaj_Wpisu;Tresc :String) is
        begin
            if Log_To_File(Typ) then
                if File_Line_Number=0 then New_File;
                end if;

                Open(Plik,Append_File,To_String(File_Name_Full));

                Put_Line(File => Plik,
                         Item    => Opisy_Typow(Typ) & " | " & Current_Time & " | " & Tresc);
                File_Line_Number:=File_Line_Number+1;
                Close(Plik);
            end if;

            if Log_To_Console(Typ) then
                if Console_Line_Number=0 then
                    New_Console;
                end if;
                Put_Line(Opisy_Typow(Typ) & " | " & Current_Time & " | " & Tresc);
                Console_Line_Number:=Console_Line_Number+1;
            end if;
        end Log_Line;


        function Current_Time(format:in Picture_String:=Time_Date_Format) return String is
        begin
            return Image(Ada.Calendar.Clock,format);
        end;
        Temp : Unbounded_String;
        colog: Rodzaj_Wpisu;
    begin
        loop

            select
                accept Info(Text : in String) do
                    Temp :=To_Unbounded_String(Text);
                    Colog:=Info;
                end Info;
            or
                accept Warning(Text : in String) do
                    Temp :=To_Unbounded_String(Text);
                    Colog:=Warning;
                end Warning;
            or
                accept Error(Text : in String) do
                    Temp :=To_Unbounded_String(text);
                    colog:=Error;
                end Error;
            end select;
            Log_Line(colog,To_String(Temp));
        end loop;
    exception
        when Event: others =>Put_Line("Log sie zespula");
            Put_Line(Exception_Name(Event));
            Put_Line(Exception_Message(Event));
    end Log;

end Runtime_Log;