--------------------------------------------------------------------------------
-- Autor: 			Krzysztof Wesoowski
-- Nazwa Pakietu:	Runtime_Log
-- Krtki opis:		Pakiet odpowiedzialny za zapisywanie waznych zdarzen do pliko/konsoli
--					Ponizej za pomoca staych mozna przedefiniowac jego dzialanie,
--					zwaszcza wybrac ktore informacje gdzie beda zapisywane.
--					Nalezy pamietac o nie korzystaniu z konsoli po wylaczeniu jej -mwindows
--------------------------------------------------------------------------------

with Gnat.Calendar.Time_Io;use Gnat.Calendar.Time_Io;

package Runtime_Log is
    type Rodzaj_Wpisu is (Info,Warning,Error);

    File_Relative_Dir: 	constant String:="logs";
    File_Name_Prefix: 	constant String:="log";
    Program_Name: 		constant String:="Simple Menu with background Tasks";
    Time_Date_Format:	constant Picture_String:="%T  %i ms";
    Opisy_Typow : 		constant array(Rodzaj_Wpisu) of String(1..12) :=("Informacja  ","Ostrzezenie ","Blad        ");
    Log_To_Console : 	constant array(Rodzaj_Wpisu) of Boolean := (False,False,False);
    Log_To_File : 		constant array(Rodzaj_Wpisu) of Boolean := (True,True,True);
    File_Line_Limit : 	constant Integer :=1000;
    Console_Line_Limit : constant Integer:=20;
	
    task Log is
        entry Info(Text : in String);
        entry Warning(Text : in String);
        entry Error(Text : in String);
    end Log;

end Runtime_Log;
