/*!
* \file ds1338.h
* \author Krzysztof Wesolowski
* \date September 09, 2009
*/
#ifndef DS1338_H_
#define DS1338_H_

#include <stdint.h>

/*!
 * Union storing Date/Time data, compiler dependant, tested only with AVR-GCC
 */
typedef union ds1338DateTimeControl
{
	struct
	{
		uint8_t Seconds:7;
		uint8_t ClockHalt:1;

		uint8_t Minutes;

		uint8_t Hour:6;
		uint8_t AMPMEnable:1;
		uint8_t :1;

		uint8_t Day;
		uint8_t Date;
		uint8_t Month;
		uint8_t Year;
		struct
		{
			uint8_t RateSelect:2;
			uint8_t :2;
			uint8_t SquareWaveEnable:1;
			uint8_t OscillatorStopFlag:1;
			uint8_t :1;
			uint8_t OutPin:1;
		} ControlRegister;
	};
	uint8_t rawData[8];
} ds1338TDC;

#define DEVICE 0xD0 ///<DS1338 7 bit Address (aligned to left)
#define WRITE 0x00	///<I2C write command
#define READ 0x01	///<I2C read command

#define TWI_BITRATE 25000	///<TWI bitrate
void ds1338_setup(); //Setups TWI interface

/*!
 * ds1338 related function can return one of this return-codes
 */
typedef enum
{
NO_ERROR,            //!< NO_ERROR
LOCATION_OUTOFBOUNDS,//!< LOCATION_OUTOFBOUNDS
RANGE_OUTOFBOUNDS,   //!< RANGE_OUTOFBOUNDS
NO_DEVICE,           //!< NO_DEVICE
DEVICE_BUSY,         //!< DEVICE_BUSY
BUS_ERROR            //!< BUS_ERROR
} ds1338_status; //Stores comunication status

ds1338_status ds1338_readTimeDateControl(ds1338TDC * data);

ds1338_status ds1338_writeTimeDateControl(ds1338TDC * data);//read Time/Date Structure

ds1338_status ds1338_writeBufferToNVRAM(uint8_t start,uint8_t lenght, uint8_t * data);
ds1338_status ds1338_readBufferFromNVRAM(uint8_t start,uint8_t lenght, uint8_t * data);
ds1338_status ds1338_writeByteToNVRAM(uint8_t location, uint8_t data);
ds1338_status ds1338_readByteFromNVRAM(uint8_t location, uint8_t * data);


#endif /* DS1338_H_ */
