/*!
* This file ilustrates use of ds1338 lib
* \file example.c
* \author Krzysztof Wesolowski
* \date September 09, 2009
*/

#include <stdint.h>
#include "ds1338/ds1338.h"

ds1338TDC g_DateTime; ///< Variable that stores date/Time and config register

void shownum(uint8_t num){};
//This is example output function, you can use LCD, UART or any other thing that accepts numbers.
//Remember that Time/Date numbers are all Binary-Coded Decimals

/*!
 * Test ds1338 lib
 */
int main()
{
	ds1338_setup();
	if(ds1338_readTimeDateControl(&g_DateTime)==NO_ERROR)
	{
		shownum(g_DateTime.Hour);
		shownum(g_DateTime.Year);
	}

	uint8_t test_buffer[5]={12,23,45,76,123};

	if(ds1338_writeBufferToNVRAM(20,5,test_buffer)==NO_ERROR)
	{
		uint8_t buffer[5];
		ds1338_readBufferFromNVRAM(20,5,buffer);
		int i;
		for (i = 0; i < 5; ++i) {
			shownum(buffer[i]);
		}
	}
	return 0;
}

