/*!
 * \file twi_basics.h
 * \author Krzysztof Wesolowski
 * \date September 09, 2009
 */

#ifndef TWI_BASICS_H_
#define TWI_BASICS_H_

#include <stdint.h>
#include <avr/io.h>

/*!
 * twi related functions exept twi_stop() return this status
 */
typedef uint8_t twi_status;

/*!
 * Configures TWBR
 * @param bps Desired bitrate
 */
inline static void twi_set_bitrate(bps)
{
	TWBR = (F_CPU/(bps) - 16)/2;
}

/*!
 * Init TWI lines (internall pull-ups are sometimes enough), enable TWI
 */
inline static void twi_init()
{
	DDRC&=((1<<PC4)|(1<<PC5));
	PORTC|=((1<<PC4)|(1<<PC5));
	TWCR=(1<<TWEN);
}

twi_status twi_start();

twi_status twi_send(uint8_t data);

twi_status twi_receive(uint8_t * where,uint8_t ack);

void twi_stop();


#endif /* TWI_BASICS_H_ */
