#include "AbstractSolver.h"
#include "Graph.h"
#include <QDateTime>

#include <QDebug>

AbstractSolver::AbstractSolver(Graph * graph, QWidget *parent)
    : QDialog(parent), m_graph(graph)
{
	ui.setupUi(this);
	ui.graphView->setScene(graph);
	ui.graphView->setRenderHints(QPainter::Antialiasing | QPainter::SmoothPixmapTransform | QPainter::HighQualityAntialiasing);
	m_graph->changeState(Graph::IdleEdit);
	connect(ui.stepForwardButton,SIGNAL(clicked()),this,SLOT(stepForwardButtonClicked()));
}
void AbstractSolver::setInstruction(const QString& instruction)
{
    ui.currentInfoLabel->setText(instruction);

}
void AbstractSolver::addLogLine(const QString& line)
{
    QString label=QDateTime::currentDateTime().time().toString()+" - "+line;
    ui.eventLogWidget->insertItem(0,label);
}
void AbstractSolver::setAlgorithmName(QString name)
{
    this->setWindowTitle(name);
}

void AbstractSolver::stepForwardButtonClicked()
{
    this->stepForward();
}
void AbstractSolver::addRightPanel(QWidget * panel)
{
    ui.inheritedWidgetContainer->layout()->addWidget(panel);
}

void AbstractSolver::enableStepForward()
{
    ui.stepForwardButton->setEnabled(true);
}
void AbstractSolver::disableStepForward()
{
    ui.stepForwardButton->setEnabled(false);
}
AbstractSolver::~AbstractSolver()
{

}
