/*!
* \file AbstractSolver.h
* \author Krzysztof Wesolowski
* \author http://kwesoly.net
* This file contains an abstract Solver class, which all solvers can (and should) inherit
*/
#ifndef ABSTRACTSOLVER_H
#define ABSTRACTSOLVER_H

#include <QtGui/QDialog>
#include "ui_AbstractSolver.h"


class Graph;

/*!
* Class which take care of some basics - it stores graph pointer and manages GUI.
* this class provides spaca for small custom widget \sa addRightPanel(QWidget * panel)
*/
class AbstractSolver : public QDialog
{
    Q_OBJECT

public:
    /*!
    * Constructor. It construct User Interface and connect slot \sa stepForwardButtonClicked(), \sa ui
    * @param graph Graph That will be solved, and also graph for showing extra info (colors, etc)
    * @param parent Parent widget
    */
    AbstractSolver(Graph * graph,QWidget * parent=0);

    /*!
    * Destructor
    */
    ~AbstractSolver();

protected: //[methods]

    /*!
     * Set algorithm name
     * @param name nazwa
     */
    void setAlgorithmName(QString name);
    /*!
    * This shows current instruction on the big label, just  below graph view.
    * @param instruction Instruction to be shown.
    */
    void setInstruction(const QString& instruction);

    /*!
    * This add single log line, starting with current hour.
    * @param line Log Line to be appended to time and added to log box
    */
    void addLogLine(const QString& line);

    /*!
    * This function adds widget to right custom panel. Derived class should is this space for class specific GUI
    * @param panel Widget to be added.
    */
    void addRightPanel(QWidget * panel); //wasza klasa ma przekazac tutaj gotowy panel z własnymi opcjami/danymi, szerokość 200px.

    /*!
    * Pure virtual method, called when users click appropriate button
    * developer MUST overide it to solve graph problems.
    */
    virtual void stepForward()=0;//w tej funkcji musicie tez uaktualniac opisy(log i instruction)

    /*!
     * Enables stepping forward button
     */
    void enableStepForward();

    /*!
     * disables stepping forward button
     */
    void disableStepForward();

protected: //[data]
    /*!
    * Pointer to Graph, needed for all algorithm data and progress presentation
    */
    Graph * m_graph;

private: //[gui]
    /*!
    * Main user interface, Qt generated. Containst all User Interface except of alrorith specific part
    */
    Ui::AbstractSolverClass ui;

private slots: //
    /*!
    * Simple function, needed for forwarding signal info to \sa stepForward()
    * Doeasn't need to be overloaded, it's is connected to button in ui.
    */
    void stepForwardButtonClicked();
};

#endif // ABSTRACTSOLVER_H
