#include "DijkstraPrimSolver.h"

#include <qDebug>
#include <QListWidgetItem>
#include <QTimer>
#include <QCloseEvent>

#include "Graph.h"
#include "GraphVerticle.h"
#include "GraphEdge.h"


DijkstraPrimSolver::DijkstraPrimSolver(Graph * graph, QWidget * parent)
    : AbstractSolver(graph, parent)
{
	QWidget * rightPanel = new QWidget;
	ui.setupUi(rightPanel);
	addRightPanel(rightPanel);

	initializeLists();
	resetGraph();

	disableStepForward();
	if(checkIfConnected()) chooseStartVerticle();
	else setInstruction(trUtf8("Wprowadzony graf jest niespójny!!!"));
	this->setAlgorithmName(trUtf8("Algorytm Dijkstry-Prima"));
}
DijkstraPrimSolver::~DijkstraPrimSolver()
{

}

void DijkstraPrimSolver::stepForward()
{
	(this->*stepFunction)();
}
void DijkstraPrimSolver::closeEvent(QCloseEvent * event)
{
	resetGraph();
	event->accept();
}
void DijkstraPrimSolver::initializeLists()
{
	foreach(GraphVerticle * v, m_graph->verticles()){
		m_Verticles.append(Verticle(v,true));
		ui.openVerticlesList->addItem(v->symbol());
	}
}
void DijkstraPrimSolver::resetGraph()
{
	m_graph->resetEdgesFormat();
	m_graph->resetVerticlesFormat();
}

bool DijkstraPrimSolver::checkIfConnected()
{
	foreach(GraphVerticle * v, m_graph->verticles()){
		verticles.insert(v, true);
	}
	ccDFS((m_graph->verticles()).at(0));

	foreach(GraphVerticle * v, m_graph->verticles()){
		if(verticles.value(v) == true) return false;
	}

	return true;
}
void DijkstraPrimSolver::chooseStartVerticle()
{
	setInstruction(trUtf8("Wybierz wierzchołek startowy."));
	connect(m_graph, SIGNAL(verticleClicked(GraphVerticle*)), this, SLOT(setStartVerticle(GraphVerticle*)));
}
void DijkstraPrimSolver::setStartVerticle(GraphVerticle * v)
{
	m_startVerticle = findVerticle(v->symbol());
	setAsStart(m_startVerticle);
	setInstruction("...");
	addLogLine(trUtf8("Wybrano wierzchołek '") + m_startVerticle->first->symbol() + trUtf8("' jako startowy."));
	disconnect(m_graph, SIGNAL(verticleClicked(GraphVerticle*)), this, SLOT(setStartVerticle(GraphVerticle*)));
	enableStepForward();
	setAsClosed(m_startVerticle);
}
void DijkstraPrimSolver::addLastClosedVerticleIncidentalEdges()
{
	setInstruction(trUtf8("Do listy krawędzi bieżących dodajemy krawędzie incydentne do ostatnio odwiedzonego wierzchołka."));

	foreach(GraphEdge * e, m_lastClosed->first->incidental()){
		if(!isEdgeOnList(e)) addGraphEdge(e);
		else (e->setStyle(Qt::SolidLine));
	}
	stepFunction = & DijkstraPrimSolver::checkCycles;
}
void DijkstraPrimSolver::checkCycles()
{
	setInstruction(trUtf8("Na liście krawędzi, szukamy tych które tworzą cykle, a następnie usuwamy je."));

	for (int i = 0; i < m_Edges.count(); ++i){
		if(m_Edges.at(i).second == true){
			if(!isOpen(m_Edges.at(i).first->start()->symbol()) && !isOpen(m_Edges.at(i).first->end()->symbol())){
				(m_Edges[i]).second = false;
				for(int j=0; j < ui.activeEdgesList->count(); j++){
					if(ui.activeEdgesList->item(j)->text() == m_Edges.at(i).first->getName()) strikeOutItem(ui.activeEdgesList->item(j));
				}
				addLogLine(trUtf8("Usunięto krawędź '") + m_Edges.at(i).first->getName() + trUtf8("' ponieważ tworzy cykl."));
				m_Edges.at(i).first->resetFormat();
			}
		}
	}
	stepFunction = & DijkstraPrimSolver::chooseMinCostEdge;
}
void DijkstraPrimSolver::chooseMinCostEdge()
{
	int flaga = 1;
	setInstruction(trUtf8("Wybieramy krawędź o najmniejszej wadze."));
	qreal minWeight = m_Edges.at(0).first->weight();
	Edge * minEdge=&m_Edges[0];
	for(int i=0; i < m_Edges.count(); i++){
		if(m_Edges.at(i).second && (m_Edges.at(i).first->weight() < minWeight || flaga)){
			flaga = 0;
			minWeight = m_Edges.at(i).first->weight();
			minEdge = &(m_Edges[i]);
		}
	}
	setAsClosed(minEdge);
	addLogLine(trUtf8("Jako krawędź o najmniejszej wadze wybrano: '") + minEdge->first->getName() + "'.");
	if(isOpen(QString(minEdge->first->start()->symbol()))) setAsClosed(findVerticle(QString(minEdge->first->start()->symbol())));
	else setAsClosed(findVerticle(QString(minEdge->first->end()->symbol())));
}
void DijkstraPrimSolver::end()
{
    addLastClosedVerticleIncidentalEdges(); // ####
	foreach(Edge ed, m_Edges){
		if(ed.second == true){
			ed.second = false;
			ed.first->resetFormat();
		}
	}
	for (int i = 0; i < ui.activeEdgesList->count(); ++i) {
		strikeOutItem(ui.activeEdgesList->item(i));
	}
	setInstruction(trUtf8("Otrzymano minimalne drzewo rozpinające grafu."));
	addLogLine(trUtf8("Otrzymano minimalne drzewo rozpinające grafu. Koniec pracy algorytmu."));
	disableStepForward();
}

void DijkstraPrimSolver::strikeOutItem(QListWidgetItem * item)
{
	QFont font = item->font();
	font.setStrikeOut(true);
	item->setFont(font);
}

void DijkstraPrimSolver::setAsStart(Verticle * vert)
{
	vert->first->setRadius(15);
}
void DijkstraPrimSolver::setAsClosed(Verticle * vert)
{
	vert->first->setColor(Qt::green);
	vert->first->setBorderWidth(3);
	vert->second = false;
	strikeOutItem(ui.openVerticlesList->item(position(vert)));
	addLogLine(trUtf8("Wykreślono wierzchołek '") + vert->first->symbol() + trUtf8("' z listy wierzchołków nieodwiedzonych."));
	ui.closedVerticlesList->addItem(vert->first->symbol());
	addLogLine(trUtf8("Wpisano wierzchołek '") + vert->first->symbol() + trUtf8("' na listę wierzchołków odwiedzonych."));

	m_lastClosed = vert;
	if(ui.closedVerticlesList->count() < ui.openVerticlesList->count()){
		stepFunction = & DijkstraPrimSolver::addLastClosedVerticleIncidentalEdges;
	}
	else{
		stepFunction = & DijkstraPrimSolver::end;
	}
}
Verticle * DijkstraPrimSolver::findVerticle(QString symb)
{
	for(int i=0; i < m_Verticles.count(); i++){
		if(m_Verticles.at(i).first->symbol() == symb) return &(m_Verticles[i]);
	}
	return NULL;
}
void DijkstraPrimSolver::addGraphEdge(GraphEdge * e)
{
	e->setStyle(Qt::DashLine);
	m_Edges.append(Edge(e,true));
	ui.activeEdgesList->addItem(e->getName());
	addLogLine(trUtf8("Dodano krawędź '") + e->getName() + trUtf8("' do listy krawędzi bieżących."));
}
void DijkstraPrimSolver::setAsClosed(Edge * ed)
{
	ed->second = false;
	for(int i=0; i < ui.activeEdgesList->count(); i++){
		if(ui.activeEdgesList->item(i)->text() == ed->first->getName()) strikeOutItem(ui.activeEdgesList->item(i));
	}
	ed->first->setColor(Qt::green);
	ed->first->setWidth(2);
}
bool DijkstraPrimSolver::isEdgeOnList(GraphEdge * e)
{
	foreach(Edge ed, m_Edges){
		if(ed.first->getName() == e->getName()) return true;
	}
	return false;
}
bool DijkstraPrimSolver::isOpen(QString symb)
{
	foreach(Verticle vert, m_Verticles){
		if(vert.first->symbol() == symb){
			return vert.second;
		}
	}
	return true;
}
void DijkstraPrimSolver::ccDFS(GraphVerticle * v)
{
	verticles[v] = false;
	QList<GraphVerticle *> vList;
	foreach(GraphVerticle * ve, v->neighbours()){
		if(verticles.value(ve) == true) vList.append(ve);
	}
	foreach(GraphVerticle * ve, vList){
		if(verticles.value(ve) == true) ccDFS(ve);
	}
}

int DijkstraPrimSolver::position(Verticle * vert)
{
	int i; for(i=0; (m_Verticles.value(i)).first->symbol() != vert->first->symbol();i++);
	return i;
}

