#ifndef DIJKSTAPRIMSOLVER_H
#define DIJKSTRAPRIMSOLVER_H

#include <QtGui/QWidget>
#include "ui_DijkstraPrimSolver.h"

#include "AbstractSolver.h"

class GraphVerticle;
class GraphEdge;

typedef QPair<GraphVerticle *, bool> Verticle;
typedef QPair<GraphEdge *, bool> Edge;

class DijkstraPrimSolver : public AbstractSolver
{
    Q_OBJECT

public:
    DijkstraPrimSolver(Graph * graph, QWidget * parent=0);
    ~DijkstraPrimSolver();

protected:

    virtual void stepForward();
    virtual void closeEvent(QCloseEvent *);

private:
    // Data


    Ui::DijkstraPrimSolverClass ui;

    Verticle * m_lastClosed;
    Verticle * m_startVerticle;
    void (DijkstraPrimSolver::*stepFunction)();

    QList<Verticle> m_Verticles;
    QList<Edge> m_Edges;

    QMap<GraphVerticle *, bool> verticles;

    //Methods

    void initializeLists();

	void resetGraph();
	bool checkIfConnected();
	void chooseStartVerticle();
	void addLastClosedVerticleIncidentalEdges();
	void checkCycles();
	void chooseMinCostEdge();
	void end();

    void strikeOutItem(QListWidgetItem *);

    void setAsStart(Verticle *);
    void setAsCurrent(Verticle *);
    void setAsClosed(Verticle *);
    Verticle * findVerticle(QString);
    void addGraphEdge(GraphEdge *);
    void setAsClosed(Edge *);
    bool isEdgeOnList(GraphEdge *);
    bool isOpen(QString);
    void ccDFS(GraphVerticle *);

    int position(Verticle *);
    int position(Edge *);

private slots:
	void setStartVerticle(GraphVerticle *);
};

#endif // DIJKSTRAPRIMSOLVER_H
