/*
 * GraphEdge.cpp
 *
 *  Created on: 2009-06-07
 *      Author: Wesoly
 */
#include "GraphEdge.h"
#include "GraphVerticle.h"
#include "Graph.h"

#include <cmath>
#include <cstdlib>
#include <QDebug>

GraphEdge::GraphEdge(Graph * graf,GraphVerticle * start,GraphVerticle * end, qreal value) :
    m_startVerticle(start), m_endVerticle(end), m_graf(graf)
    {
    m_weightItem=NULL;

    if(value==std::numeric_limits<qreal>::infinity())
        m_weight=5+rand()%10;
    else
        m_weight=value;
    }
void GraphEdge::setStyle(Qt::PenStyle styl)
{
    QPen p=pen();
    p.setStyle(styl);
    setPen(p);
}
void GraphEdge::redraw()
{
    QLineF linia(m_startVerticle->scenePos(),m_endVerticle->scenePos());
    QPointF vector=linia.p2()-linia.p1();
    double length=linia.length();
    QPointF difference=vector*(Graph::circleRadius+2)/length;
    linia.setP1(linia.p1()+difference);
    linia.setP2(linia.p2()-difference);
    setLine(linia);
    this->setZValue(-1);
    setWidth(2);
    if(m_weightItem==NULL)
        {
        m_weightItem=new QGraphicsSimpleTextItem();
        this->scene()->addItem(m_weightItem);
        m_weightItem->setFont(QFont("Verdana",10));
        m_weightItem->setZValue(20);
        }
    m_weightItem->setText(QString::number(weight(),'f',0));
    //m_weightItem->resetTransform();
    m_weightItem->setPos(linia.pointAt(0.5));
    //qreal angle =linia.angle();
    //    if(angle>90)
    //        angle-=180;
    //    else if(angle<-90)
    //        angle+=180;
    //    m_weightItem->rotate(-angle);
}

GraphEdge::GraphEdge(const GraphEdge &pattern) :
    m_startVerticle(pattern.m_startVerticle),
    m_endVerticle(pattern.m_endVerticle),
    m_graf(pattern.m_graf)
    {

    }

QList<GraphVerticle*> GraphEdge::incidental() const
{
    return m_graf->incidental(this);
}

qreal GraphEdge::weight() const
{
    return (int)m_weight;
}
void GraphEdge::setWidth(qreal width)
{
    QPen tmp=pen();
    tmp.setWidthF(width);
    setPen(tmp);
}
void GraphEdge::setColor(Qt::GlobalColor color)
{
    QPen tmp=pen();
    tmp.setColor(color);
    setPen(tmp);
}
QString GraphEdge::getName() const
{
    return QString(m_startVerticle->symbol()) + QString(m_endVerticle->symbol());
}
void GraphEdge::resetFormat()
{
    setColor(Qt::black);
    setStyle(Qt::SolidLine);
    this->redraw();
}

GraphEdge::~GraphEdge()
{
    delete m_weightItem;
    m_weightItem=NULL;
}
