/*
 * GraphVerticle.cpp
 *
 *  Created on: 2009-06-07
 *      Author: Wesoly
 */

#include "GraphVerticle.h"
#include "GraphEdge.h"
#include "Graph.h"

#include <QString>
#include <QDebug>

GraphVerticle::GraphVerticle(Graph * graf) :
    QGraphicsEllipseItem(-Graph::circleRadius,-Graph::circleRadius,2*Graph::circleRadius,2*Graph::circleRadius)
    {
        m_symbolItem=NULL;
        m_graf=graf;
        QBrush tmp = this->brush();
        tmp.setStyle(Qt::SolidPattern);
        tmp.setColor(Qt::white);
        setBrush(tmp);
    }

void GraphVerticle::redraw()
{
    if(!m_symbolItem)
        {
            m_symbolItem=new QGraphicsSimpleTextItem();
            m_symbolItem->setFont(QFont("Verdana",12));
            m_symbolItem->setParentItem(this);
        }

    m_symbolItem->setText(QString(m_symbol));
    QRectF tmp=m_symbolItem->boundingRect();
    m_symbolItem->setPos(0,0);
    m_symbolItem->resetTransform();
    m_symbolItem->translate(-tmp.width()/2.0,-tmp.height()/2.0);


}
void GraphVerticle::setSymbol(QChar symbol)
{
    m_symbol=symbol;
    redraw();
}
QString GraphVerticle::symbol()
{
    return m_symbol;
}
QString GraphVerticle::toString()
{
    return "verticle|"+QString(symbol())+"|"+QString::number(x())+"|"+QString::number(y());
}
QList<GraphEdge *> GraphVerticle::incidental() const
{
    return m_graf->incidental(this);
}
QList<GraphVerticle *> GraphVerticle::neighbours() const
{
    return m_graf->neighbours(this);
}
void GraphVerticle::setRadius(int rad)
{
    setRect(-rad,-rad,2*rad,2*rad);
}
void GraphVerticle::setColor(Qt::GlobalColor color)
{
    QBrush tmp = this->brush();
    tmp.setColor(color);
    setBrush(tmp);
}
void GraphVerticle::setBorderWidth(int width)
{
    QPen tmp = this->pen();
    tmp.setWidth(width);
    setPen(tmp);
}
void GraphVerticle::resetFormat()
{
    setBorderWidth(0);
    setRadius(Graph::circleRadius);
    setColor(Qt::white);
    setBorderColor(Qt::black);
}
void GraphVerticle::setBorderColor(Qt::GlobalColor color)
{
    QPen tmp = this->pen();
    tmp.setColor(color);
    setPen(tmp);
}
GraphVerticle::~GraphVerticle()
{
    // TODO Auto-generated destructor stub
}
