/*
 * GraphVerticle.h
 *
 *  Created on: 2009-06-07
 *      Author: Wesoly
 */

#ifndef GRAPHVERTICLE_H_
#define GRAPHVERTICLE_H_

#include <QGraphicsEllipseItem>
#include <QGraphicsSimpleTextItem>


class Graph;
class GraphEdge;

/*!
* Class representing a verticle
* Commonly used in \sa Graph, always as a pointer, because many parts of program may use the same verticle
*/
class GraphVerticle : public QGraphicsEllipseItem
{

private:
    Graph * m_graf; //!< Pointer to graph this verticle belongs to
    QChar m_symbol; //!< Single letter verticle symbol, drawed on verticle and used for edge name generation
    QGraphicsSimpleTextItem * m_symbolItem; //!< item for showing sympol
public:
    /*!
    * Constructor
    * @param graf Graph this verticle will belong to
    */
    GraphVerticle(Graph * graf);
    /*!
    * Simple enum used for creating item type
    */
    enum { Type = UserType + 2 };//!< Type

    /*!
    * Method for checking item type
    * @return Enumerated item type, named \sa Type
    */
    int type() const
    {
        // Enable the use of qgraphicsitem_cast with this item.
        return Type;
    }

    /*!
    * Serializes verticle to string, currently unused
    * @return Serialized verticle
    */
    QString toString();

    /*!
    * @return list of incidental edges
    */
    QList<GraphEdge *> incidental() const;

    /*!
    * @return List of connected Verticles
    */
    QList<GraphVerticle *> neighbours() const;

    /*!
    * Changes circle radius
    * @param rad New radius to be aplied
    */
    void setRadius(int rad);

    /*!
    * Changes circle inner color
    * @param color New color to be aplied
    */
    void setColor(Qt::GlobalColor color);

    /*!
    * Changes circle border width
    * @param width New width to be aplied
    */
    void setBorderWidth(int width);

    /*!
    * Changes circle border color
    * @param color New color to be aplied
    */
    void setBorderColor(Qt::GlobalColor color);

    /*!
    * Changes circle symbol
    * @param symbol New symbol to be aplied
    */
    void setSymbol(QChar symbol);

    /*!
    * @return Current symbol as a QString
    */
    QString symbol();

    /*!
    * Redraws item
    */
    void redraw();

    /*!
     * Resets item formating (styles, colors)
     */
    void resetFormat();

    /*!
     * Destructor
     */
    virtual ~GraphVerticle();
};

#endif /* GRAPHVERTICLE_H_ */
