#ifndef MINTYSOLVER_H
#define MINTYSOLVER_H

#include <QtGui/QWidget>
#include "ui_MintySolver.h"

#include "AbstractSolver.h"

class GraphVerticle;
class GraphEdge;

class MintySolver : public AbstractSolver
{
    Q_OBJECT

public:
    MintySolver(Graph *graph, QWidget *parent = 0);
    ~MintySolver();

protected:
    virtual void stepForward();
    virtual void closeEvent(QCloseEvent *);

private:
    // Data
    Ui::MintySolverClass ui;
    QMap<GraphVerticle *, bool> m_verticles;
    QMap<GraphVerticle *, qreal> m_verticlesValues;
    QList<GraphEdge *> m_activeEdges;

    QList<GraphEdge *> m_closedEdges;
    QList<GraphVerticle *> m_closedVerticles;
    GraphVerticle * startVerticle;

    void (MintySolver::*algorithmSteps[4])();
    int m_nextStep;

    //Methods
	void resetGraph();
	void initializeLists();

	//Algorithm steps
	bool checkIfConnected();
	void ccDFS(GraphVerticle *);
	void chooseStartVerticle();
	void findConnections();
	void chooseMinValueConnection();
	void checkStopCondition();
	void end();

	//Verticles & Edges manipulation
	void setAsClosed(GraphVerticle *, qreal);
	void setAsClosed(GraphEdge *);
	void setAsActive(GraphEdge *);
	qreal edgeSum(GraphEdge *);
	QString shortestWay(GraphVerticle *);
	bool isClosed(GraphEdge *);
	GraphVerticle * secondVerticle(GraphEdge *, GraphVerticle *);

private slots:
	void setStartVerticle(GraphVerticle *);
};

#endif // MINTYSOLVER_H
