/*!
 * \file SampleSolver.h
 * \author Krzysztof Wesolowski
 * \author http://kwesoly.net
 * This file contains a sample graph problems solver, which utilizes AbstractSolver class.
 * \sa AbstractSolver
 */

#ifndef SAMPLESOLVER_H_
#define SAMPLESOLVER_H_

#include "AbstractSolver.h"
#include "ui_SampleSolver.h"

/*!
 * This class provides some programistic samples for developers working on graph algorithm visual solvers
 */
class SampleSolver : public AbstractSolver
{
    Q_OBJECT
private:
    Ui::SampleSolverClass ui;
    /*!
     * This method is overriden, it is supposed to solve problem by parts, but this i sample - it just shows messages.
     */
    virtual void stepForward();

    public slots:
    /*!
     * Testing purposes slot
     */
    void testMe();
public:
    /*!
     * Constructor
     * @param graph Graph That will be solved, and also graph for showing extra info (colors, etc)
     * @param parent Parent widget
     */
    SampleSolver(Graph * graph,QWidget * parent=0);


    /*!
     * Destructor
     */
    virtual ~SampleSolver();
};

#endif /* SAMPLESOLVER_H_ */
