/*
 * fleurysolver.cpp
 *
 *  Created on: 2009-07-01
 *      Author: Gorka
 */


#include "fleurysolver.h"
#include<QDebug>
#include"Graph.h"
#include"GraphEdge.h"
#include"GraphVerticle.h"
FleurySolver::FleurySolver(Graph * graph,QWidget * parent)
: AbstractSolver(graph,parent)
{
	QWidget * rPanel=new QWidget(); //tworze nowy Widget
	ui.setupUi(rPanel); //przypisuje ten widget do UI
	addRightPanel(rPanel); //dodaje widget, na jego miejsce



	connect(ui.solveButton, SIGNAL(clicked()), this, SLOT(quickSolve())); //wlaczenie funkcjonalnosci guzika do szybkiego rozwiazywania
	prepareData(); //funkcja przygotowujaca liste wierzcholkow,krawedzi, nazywa wierzcholki, oraz ustala krawedzie jako istniejace

	this->disableStepForward(); // guziki zostana wlaczone, dopiero po wyborze wierzcholka poczatkowego
	ui.solveButton->setDisabled(true);

	//legend.load(":/descriptions/legenda.png");
	//ui.legendLabel->setPixmap(legend); //kwesoly> tylko zakomentowaale nie jest to juz potrzebne

	if(m_isEuler = isEuler(m_graph)) {
		addLogLine("wprowadzono graf eulerowski.");
		setInstruction(trUtf8("Wybierz wierzchołek początkowy."));
		connect(m_graph, SIGNAL(verticleClicked(GraphVerticle*)), this, SLOT(setStart(GraphVerticle*))); // tylko jezeli eulerowski, to aktywuje wybor wierzcholka poczatkowego

	}
	else {
		addLogLine("ERR: Wprowadzono nie-eulerowski graf.");
		setInstruction(trUtf8("Wprowadź graf Eulerowski."));
	}
	this->setAlgorithmName(trUtf8("Algorytm Fleury'ego"));
}

void FleurySolver::stepForward()
{

	if(m_isEuler) { //jezeli jest grafem eulerowskim to wykonaj, wlasciwie mozna by pomina

		//w zaleznosci od obecnego stanu algorytmu, po kliknieciu next, musi wykonac sie inna czynnosc
		switch (m_currentState) {
		case settingStart:
			setInstruction(trUtf8("Wybierz wierzchołek początkowy."));
		//	ui.stanEdit->setText("wybĂłr wierzcholka poczatkowego");
			//komentarz: realne dzialania w tym stanie, zwiazane sa ze slotem setStart!!
			break;
		case isolationChecking:
		//	ui.stanEdit->setText("sprawdzanie czy aktualny wierzcholek jest izolowany");
			setInstruction(trUtf8("Sprawdzamy czy aktualny wierzchołek jest izolowany."));
			if(!isIsolated(m_currentVerticle)) {
				m_currentState = wSetting;
				addLogLine(trUtf8("wierzchołek ")+m_verticleName[ m_currentVerticle ]+" uznany za nieizolowany.");
			}
			else {
				m_currentState = vPopping;
				addLogLine(trUtf8("wierzchołek ")+m_verticleName[ m_currentVerticle ]+" uznany za izolowany.");

			}
			break;
		case wSetting:
		//	ui.stanEdit->setText("wyznaczanie wierzcholka sasiadujacego");
			setInstruction(trUtf8("Wybieramy dowolny wierzchołek sąsiadujący"));
			m_nextVerticle = incidentalVerticle(m_currentVerticle);
			m_currentState=vPushing;
			addLogLine(trUtf8("wierzchołek ") +m_verticleName[ m_nextVerticle ]+ trUtf8(" wybrano jako sąsiadujący do ") + m_verticleName[ m_currentVerticle] );
			break;
		case vPushing:
			setInstruction(trUtf8("Odkładamy obecny wierzchołek na stos."));
		//	ui.stanEdit->setText("odkladanie aktualnego wierzcholka na stos");
			m_stack.push(m_currentVerticle);
			ui.stosEdit->insertPlainText(m_currentVerticle->symbol()+",");
			m_currentState=vertRemoving;
			addLogLine(trUtf8("wierzchołek ") + m_verticleName[ m_currentVerticle] + trUtf8(" został umieszczony na stosie."));
			break;
		case vertRemoving:
			setInstruction(trUtf8("Oznaczamy krawedź pomiędzy obecnym wierzchołkiem, a wierzchołkiem sąsiadującym jako usuniętą."));
		//	ui.stanEdit->setText("usuwanie krawedzi pomiedzy wierzcholkami");
			m_currentEdge = removeEdge(m_nextVerticle, m_currentVerticle); //7.
			m_currentState=vSetting;
			addLogLine(trUtf8("usunięto krawedź ") + m_currentEdge->getName());
			break;
		case vSetting:
			setInstruction(trUtf8("Zmieniamy obecny wierzchołek na wierzchołek sąsiadujący."));
		//	ui.stanEdit->setText("zmiana obecnego wierzcholka na sasiadujacy");
		//	m_currentVerticle->setColor(Qt::white);
			m_currentVerticle = m_nextVerticle;
			m_currentVerticle->setColor(Qt::green);
			m_currentVerticle->setBorderColor(Qt::black);
			m_currentVerticle->setBorderWidth(3);
			m_currentState = isolationChecking;
			addLogLine(trUtf8("zmiana aktualnego wierzchołka na ")+ m_verticleName[ m_currentVerticle]+".");
			break;
		case vPopping:
			if(!m_stack.empty()) {
				setInstruction(trUtf8("Sciągamy wierzchołek ze stosu."));
			//	ui.stanEdit->setText("sciaganie wierzcholka ze stosu");

				m_currentVerticle = m_stack.pop();
				addToResult(m_currentVerticle);
				QString tmp;
				tmp = ui.stosEdit->toPlainText();
				tmp.truncate( tmp.size()-2);
				ui.stosEdit->setText(tmp);

				m_currentState=isolationChecking;
				addLogLine(trUtf8("sciągnięto wierzchołek ") + m_verticleName[ m_currentVerticle] +" ze stosu.");
			}
			else {
				setInstruction(trUtf8("Stos był już pusty - zatem kończymy pracę."));
			//	ui.stanEdit->setText("koniec pracy algorytmu");
				m_currentState = resultWriting;
				addLogLine(trUtf8("stwierdzono stan stosu: pusty - przystępuję do końca pracy algorytmu."));
			}
			break;
		case resultWriting:
			resultString.clear();
			for (int i = m_resultList.size()-1; i >=0; --i) {
				resultString=resultString+m_verticleName[ m_resultList[i] ];
				if(i!=0) resultString=resultString+"->";
			}
			setInstruction(trUtf8("Uzyskaliśmy wynik"));
			ui.trasaEdit->setFontWeight( 99);
			ui.trasaEdit->setText(resultString);
			this->disableStepForward();
			break;
		default:
			break;
		}
	}
	else {
		addLogLine(trUtf8("ERR: Próba realizacji algorytmu Fleurego na nie-eulerowskim grafie."));
		setInstruction(trUtf8("Wprowadź graf Eulerowski."));
	}
}

FleurySolver::~FleurySolver()
{

		m_graph->resetEdgesFormat();
		m_graph->resetVerticlesFormat();
}

void FleurySolver::prepareData() {
	//1. zachowanie listy wierzcholkow oraz krawedzi grafu
	m_verticlesList = m_graph->verticles();
	m_edgesList = m_graph->edges();
	//2.inicjalizacja mapy wartosciami false
	for (int i = 0; i < m_edgesList.size(); ++i) {
		m_flag[ m_edgesList[i] ] = false;
	}
	//ustalenie stanu poczatkowego algorytmu
	m_currentState=settingStart;
	//5.Nazwanie wierzcholkow
	for (int i = 0; i < m_verticlesList.size(); ++i) {
		m_verticleName[ m_verticlesList[i] ] = QString((char)i+65);
	}
}

bool FleurySolver::isEuler(Graph* graph) {
	QList<GraphVerticle*> tmp_verticlesList;
	tmp_verticlesList = graph->verticles();
	int tmp;
	for (int i = 0; i < tmp_verticlesList.size(); ++i) {
		tmp = tmp_verticlesList[i]->incidental().size() % 2;
		if(tmp != 0) return false;
	}
	return true;
}

bool FleurySolver::isIsolated(GraphVerticle* verticle) {
	//TODO do sprawdzenia
	QList<GraphEdge*> tmp_edgesList; //do przechowania krawedzi incydentnych do DANEGO wierzcholka
	tmp_edgesList = verticle->incidental(); //lista krawedzi incydnetny do DANEGO wierzcholka
	for (int i = 0; i < tmp_edgesList.size(); ++i) {
		if(!m_flag[ tmp_edgesList[i] ] ) return false;
		//jezeli ktoras z krawedzi nie jest oflagowana,czyli nie jest usunieta
		//( czyli miala false, czyli !false = true, ehh kac) to wtedy wierzcholek nie jest izolowany, czyli
		//czyli funkcja powinna zwrocic false
	}
	return true; //jezeli nigdzie wczesniej nei zwrocila false, czyli wszytkie byly oflagowane, tzn ze jest izolowany
}

GraphEdge* FleurySolver::removeEdge(GraphEdge* edge) {
	if( m_flag[edge]) return NULL; // zwraca nulla, jezeli krawedz juz zostala wczesniej usunieta
	edge->setColor(Qt::red);
	m_flag[edge] = true;
	return edge;
}

GraphEdge* FleurySolver::removeEdge(GraphVerticle* start, GraphVerticle* end) {
	//TODO sprawdzic
	QList<GraphEdge*> tmp_edgesList; //lista podejrzanych krawedzi;
	tmp_edgesList = start->incidental();
	for (int i = 0; i < tmp_edgesList.size(); ++i) {
		//przeszukuje wszystkie krawedzie incydentne do start, w poszukiwaniu tej, ktora konczy sie w end
		if (tmp_edgesList[i]->end() == end  || tmp_edgesList[i]->start() == end ) //jezeli koncowy jednej z krawedzi, jest zgodny z poszukiwanym koncowym to
		{
			if( m_flag[tmp_edgesList[i]]) {
				; //nie rob nic, jezeli znaleziona krawedz zostala juz wczesniej usunieta (nic tez nie zwracaj, wiec skonczy na return null ewentualnie)
			}
			else { //jezeli nie byla wczesniej usunieta, to ustaw jako usunieta i zwroc
				m_flag[tmp_edgesList[i]] = true; //to ustaw ja jako usunieta, oraz zwroc do niej wskaznik
				ui.krawedzieEdit->insertPlainText(tmp_edgesList[i]->getName() + ",");
				tmp_edgesList[i]->setStyle(Qt::DashLine);
				tmp_edgesList[i]->setColor(Qt::gray);
				tmp_edgesList[i]->setWidth(1);
				return tmp_edgesList[i]; //oraz zwroc do niej wskaznik
			}
		}
	}
	return NULL; //jezeli, zadna z incydentnych do start krawedzi, nei okazala sie konczyc w null, to zwraca null;
}

GraphEdge* FleurySolver::incidentalEdge(GraphVerticle* verticle) {
	//TODO sprawdzic
	QList<GraphEdge*> tmp_edgesList;
	tmp_edgesList = verticle->incidental(); //lista wierzcholkow incydentalnych, sposrod ktorys zostanie zwrocony jeden
	for (int i = 0; i < tmp_edgesList.size(); ++i) {
		if( !m_flag[tmp_edgesList[i]] ) {
			tmp_edgesList[i]->setColor(Qt::green);
			return tmp_edgesList[i];
		}
		//jezeli nie jest prawda, ze dana krawedz zostala usunieta, to ja zwroci
	}
	return NULL; //zwraca null, jezeli wszystkie incydentalne krawedzie zostaly usuniete z grafu
}

GraphVerticle* FleurySolver::incidentalVerticle(GraphVerticle* verticle) {
	//TODO sprawdzic
	QList<GraphEdge*> tmp_edgesList;
	tmp_edgesList = verticle->incidental(); //lista krawedzi incydentalnych, sposrod ktorys zostanie zwrocony jeden
	for (int i = 0; i < tmp_edgesList.size(); ++i) {
		if( !m_flag[tmp_edgesList[i]] ) {
			if(tmp_edgesList[i]->end()!=verticle){
				tmp_edgesList[i]->end()->setBorderColor(Qt::green);
				tmp_edgesList[i]->end()->setBorderWidth(3);
				tmp_edgesList[i]->end()->setColor(Qt::white);
				//TODO
				return tmp_edgesList[i]->end();
			}
			else {
				tmp_edgesList[i]->start()->setBorderColor(Qt::green);
				tmp_edgesList[i]->end()->setBorderWidth(3);
				tmp_edgesList[i]->end()->setColor(Qt::white);
				return tmp_edgesList[i]->start();
			}
		}
		//jezeli nie jest prawda, ze dana krawedz zostala usunieta, to ja zwroci
	}
	return NULL; //zwraca null, jezeli wszystkie incydentalne krawedzie zostaly usuniete z grafu
}

void FleurySolver::setStart(GraphVerticle* verticle) {
	if(m_currentState == settingStart) { // slot ten wykonuje realne dzialanie, tylko gdy algorytm jest w odpowiednim stanie
	m_startVerticle = verticle;
	m_startVerticle->setBorderColor(Qt::black);
	m_startVerticle->setBorderWidth(3);
	m_startVerticle->setRadius(15);
	m_currentVerticle=m_startVerticle;

	addToResult(m_currentVerticle); //po wybraniu , dorzuca go do rozwiazania. [1]
	m_currentVerticle->setColor(Qt::green);
	m_currentVerticle->setBorderColor(Qt::black);
	m_currentVerticle->setBorderWidth(3);
	m_currentState = isolationChecking; //przejscie do kolejnego stanu
	addLogLine("wierzcholek "+ m_verticleName[ m_currentVerticle] +trUtf8(" został oznaczony jako początkowy."));

	this->enableStepForward(); //wybrano wierzcholek poczatkowy, zatem guziki zostana wlaczone
	ui.solveButton->setDisabled(false);

	setInstruction(trUtf8("Klikaj w przycisk 'krok dalej'"));
	}
}

void FleurySolver::addToResult(GraphVerticle* verticle) {
	m_resultList.append(verticle);//po wybraniu , dorzuca go do rozwiazania //TODO moze nawet tutaj to przejdzie.
	//ui.rozwiazanieEdit->insertPlainText(verticle->symbol()+",");
	ui.rozwiazanieEdit->setText(verticle->symbol()+",");

	addLogLine(trUtf8("wierzchołek ") + m_verticleName[ verticle] +trUtf8(" dodano do rozwiązania."));

}
void FleurySolver::quickSolve() {

		m_currentVerticle=m_startVerticle; //powrot na poczatek
		m_stack.clear(); //czyszcze stos, na wypadek gdyby cos juz zostalo tam wpisane
		m_resultList.clear(); //czyszcze rezultat
		for (int i = 0; i < m_edgesList.size(); ++i) { //przywracam wszystkie krawedzie jako istniejace
				m_flag[ m_edgesList[i] ] = false;
			}
		this->disableStepForward(); // tak zeby jakis glupi user nie klinal czegos glupio

		m_currentState = quickSolving; //przejscie w odpowidni stan, wlasciwie formalnosc odkad wprowdzono wylaczanie buttonow
		addToResult(m_currentVerticle); //wierzcholek poczatkowy do rozwiazania, patrz metoda setStart, oraz uprzednie czyszczenie rozwiazania
		addLogLine(trUtf8("aktywowano tryb szybkiego rozwiązania."));

		if(m_isEuler) { //jezeli jest grafem eulerowskim to wykonaj
			while(true) {
				while(!isIsolated(m_currentVerticle)) {
					m_nextVerticle = incidentalVerticle(m_currentVerticle);//5.
					m_stack.push(m_currentVerticle); //6.
					removeEdge(m_nextVerticle, m_currentVerticle); //7.
					m_currentVerticle = m_nextVerticle;
				}
				if(!m_stack.empty()) {
					m_currentVerticle = m_stack.pop();
					addToResult(m_currentVerticle);
				}
				else break;
			}

			resultString.clear();

			for (int i = m_resultList.size()-1; i >=0; --i) {
				resultString=resultString+m_verticleName[ m_resultList[i] ];
				if(i!=0) resultString=resultString+"->";
			}
			ui.trasaEdit2->setFontWeight( 99);
			ui.trasaEdit2->setText(resultString);
			setInstruction(trUtf8("Wyznaczono rozwiązanie."));
			addLogLine(trUtf8("dokonano 'szybkiego rozwiązania'."));
		}
		else {
			addLogLine(trUtf8("ERR: Próba realizacji algorytmu Fleurego na nie-eulerowskim grafie."));
			setInstruction(trUtf8("Wprowadź graf Eulerowski."));
		}
		ui.solveButton->setDisabled(true); //wylaczam ten guzik, zeby nie potrzebnie ktos nie klikal go miliard razy.
}
