
/*!
 * \file fleurysolver.h
 * \author Pawel Gorka
 * \author none
 * This files contains Fleury Algorithm Solver
 * \sa AbstractSolver
 */

#ifndef FLEURYSOLVER_H
#define FLEURYSOLVER_H

#include "AbstractSolver.h"
#include "ui_fleurysolver.h"
#include <QStack>
#include<QMap>
#include<QString>
#include<QPixmap>
class GraphEdge;
class GraphVerticle;

/*!
 * This class provides Fleury Algorithm
 */

class FleurySolver :  public AbstractSolver
{
Q_OBJECT

private: //metody
	Ui::FleurySolverClass ui;
	/*!
	* This method is overriden, it is supposed to solve problem by parts, but this i sample - it just shows messages.
	*/
	virtual void stepForward();

	/*!
	 * this method prepare few things neccessary in further work of algorithm. Makes lists of edges and verticles, make, set algorithm state as start,
	 * give all verticles a name, and set all edges as non-removed
	 * and setting starting edge in algorithm
	 */
	void prepareData();

	/*!
	 * this method checks if graph has an euler cycle
	 * @param graph which will be checked
	 * @return boolean if it is euler
	 */
	bool isEuler(Graph* graph);

    /*!
     * this method checks if verticle is isolated, what is neccesary in algorithm
     * @param verticle which will be checked
     * @return boolean if verticle is isolated
     */
	bool isIsolated(GraphVerticle* verticle);

	/*!
	* this method returns verticle, incidental to the verticle
	* @param verticle which incidental vertivle will be founded
	* @return pointer to the incidental verticle, returns null, if there are no incidental verticles
	*/
	GraphVerticle* incidentalVerticle(GraphVerticle* verticle);

	/*!
	 * this method returns one edge, incidental to the  verticle
	 * @param verticle, which incidental edge is needed
	 * @return pointer to the incidental edge, returns null, if there are no incidental edges;
	 */
	GraphEdge* incidentalEdge(GraphVerticle* verticle);

	/*!
	 * this method sets edge as removed. It sets corresponding boolean in m_flag as true
	 * @param pointer to the edge which should be removed
	 * @return pointer to the 'removed' edge, returns null  if edge was already 'removed'
	 */
	GraphEdge* removeEdge(GraphEdge* edge);

	/*!
	 * this method sets edge between two verticles as removed
	 * @param first - pointer to the first verticle
	 * @param second- pointer to the second verticle
	 * @return pointer to 'removed' edge, if edge was already removed returns null
	 */
	GraphEdge* removeEdge(GraphVerticle* first,GraphVerticle* secibd );
	/*!
	 * this method adds a verticle to the m_resultList, and changes state of ui.rozwiazanieEdit
	 * @param pointer to the verticle, which should be added
	 */
	void addToResult(GraphVerticle* verticle);
private: //zmienne
	Graph* m_graphCopy; //!< local copy of graph, used in fleury algorithm;
	// obejdzie sie (chyba) bez kopii grafu, zamiast usuwac bede je oznaczal jako uzyte
	QStack<GraphVerticle*> m_stack; //!< stack for graph verticles, necessary in algorithm
	QList<GraphEdge*> m_edgesList; //!< local list of edges
	QList<GraphVerticle*> m_verticlesList; //!< local list of verticles
	QList<GraphVerticle*> m_resultList; //!< result of algorithm work;

	GraphVerticle* m_currentVerticle; //!<pointer to current verticle
	GraphVerticle* m_nextVerticle; //!< pointer to next verticle or incident verticle
	GraphVerticle* m_startVerticle; //!< pointer to starting verticle
	GraphEdge* m_currentEdge; //!< pointer to an edge;
	QMap<GraphEdge*, bool> m_flag; //!< map indexed by edges pointers, used to flag edge as removed from graph
	QMap<GraphVerticle*, QString> m_verticleName; //!< map indexed by verticle pointers, with verticle names;
	bool m_isEuler; //!<variable which remembers if graph is euler-graph;
	QString resultString;
	//mapa to zostanie zainicjalizowana wartosciami false w metodzie prepareData();
	QPixmap legend; //!<Pixmap with legend
	/*!
	* Represents states od Fleury algorithm
	*/
	enum AlgorithmState{
		isolationChecking,         //!< cheking if edge is isolated already
		wSetting,//!< setting nearest incident edge
		vPushing,    //!< pushin current edge
		vertRemoving,     //!< removing vertivle from graph
		vSetting, //!< setting new current edge
		vPopping, //!< popping current edge
		resultWriting, //!< writing an result of algorithm work
		settingStart,//!<setting first verticle in Graph
		quickSolving//!< quick solving
	};
	AlgorithmState m_currentState; //!< current state of algorithm, determines next step


public:
	/*!
	* Constructor
	* @param graph Graph That will be solved, and also graph for showing extra info (colors, etc)
	* @param parent Parent widget
	*/
	FleurySolver(Graph * graph,QWidget * parent=0);
	/*!
	* Destructor
	*/
	virtual ~FleurySolver();
private slots:
	/*!
	 * This slot finds an euler-cycle in graph. It doesn't shows how fleury algorithm works step by step but only writes a result.
	 */
	void quickSolve();
public slots:
	/*!
	 * this slot is used to choose a start verticle. It do something only when algorithm is in settingStart state.
	 */
	void setStart(GraphVerticle* verticle);
};

#endif // FLEURYSOLVER_H

