#include "grafyalgorytmy.h"
#include "Graph.h"
#include "SampleSolver.h"
#include "fleurysolver.h"
#include "DijkstraPrimSolver.h"
#include "MintySolver.h"

#include <QDateTime>
#include <QFile>
#include <QFileDialog>
#include <QDebug>

GrafyAlgorytmy::GrafyAlgorytmy(QWidget *parent)
: QWidget(parent)
{
    m_algorithmWindow=NULL;
    ui.setupUi(this);
    m_graf=new Graph();
    ui.graphView->setScene(m_graf);
    ui.graphView->setSceneRect(m_graf->sceneRect());
    ui.graphView->setRenderHints(QPainter::Antialiasing | QPainter::SmoothPixmapTransform | QPainter::HighQualityAntialiasing);

    ui.newEdgeWieghtComboBox->addItems(QString("Jednostkowa = 1|Odleglosc|Odl. Manhattan|Losowa 1-10|Losowa 1-100|Losowa 0-10|Losowa 0-100").split('|'));

    connect(ui.addVerticleButton,SIGNAL(clicked()),m_graf,SLOT(addVerticle()));
    connect(ui.addEdgeButton,SIGNAL(clicked()),m_graf,SLOT(addEdge()));
    connect(ui.removeEdgeButton,SIGNAL(clicked()),m_graf,SLOT(removeEdge()));
    connect(ui.removeVerticleButton,SIGNAL(clicked()),m_graf,SLOT(removeVerticle()));
    connect(m_graf,SIGNAL(showExternInfo(QString)),this,SLOT(addLogLine(const QString &)));
    connect(m_graf,SIGNAL(stateChanged(QString)),ui.statusLabel,SLOT(setText (const QString &)));

    connect(ui.fleuryButton,SIGNAL(clicked()),this,SLOT(launchFleury()));
    connect(ui.dijkstraPrimButton,SIGNAL(clicked()),this,SLOT(launchDijkstraPrim()));
    connect(ui.mintyButton,SIGNAL(clicked()),this,SLOT(launchMinty()));

    connect(ui.graphSaveButton,SIGNAL(clicked()),this,SLOT(saveGraph()));
    connect(ui.graphLoadButton,SIGNAL(clicked()),this,SLOT(loadGraph()));

    connect(ui.newEdgeWieghtComboBox,SIGNAL(currentIndexChanged(int)),this,SLOT(weighSchemeChanged(int)));
}


void GrafyAlgorytmy::addLogLine(QString item)
{
    ui.eventLog->insertItem(0,QDateTime::currentDateTime().toString() + " - " + item);
}
//void GrafyAlgorytmy::launchSample()
//{
//    SampleSolver solver(m_graf,this);
//    solver.exec();
//}
void GrafyAlgorytmy::launchFleury()
{
    FleurySolver solver(m_graf,this);
    solver.exec();
}
void GrafyAlgorytmy::launchDijkstraPrim()
{
    DijkstraPrimSolver solver(m_graf, this);
    solver.exec();
}
void GrafyAlgorytmy::launchMinty()
{
    MintySolver solver(m_graf, this);
    solver.exec();
}
void GrafyAlgorytmy::saveGraph()
{
    QFile plik;
    QString fileName=QFileDialog::getSaveFileName(this,"Wybierz plik do zapisu",QApplication::applicationDirPath()+"/grafy", "Pliki z grafami (*.graf)");
    if( ! fileName.isNull())
        {
        plik.setFileName(fileName);
        plik.open(QIODevice::WriteOnly | QIODevice::Truncate);
        QDataStream strumien(&plik);
        strumien << *m_graf;
        plik.close();
        }
}
void GrafyAlgorytmy::loadGraph()
{
    QFile plik;
    QString fileName=QFileDialog::getOpenFileName(this,"Wybierz plik do zapisu",QApplication::applicationDirPath()+"/grafy", "Pliki z grafami (*.graf)");
    if( ! fileName.isNull())
        {
        plik.setFileName(fileName);
        plik.open(QIODevice::ReadOnly);
        QDataStream strumien(&plik);
        strumien >> (*m_graf);
        plik.close();
        }
}
void GrafyAlgorytmy::weighSchemeChanged(int index)
{
    m_graf->setNewEgdesWeightScheme((Graph::weightScheme)index);
}
GrafyAlgorytmy::~GrafyAlgorytmy()
{
    delete m_graf;
}
