/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.util.StringTokenizer;
import java.util.Vector;

public class Aliases {
    private Vector accAliases = new Vector();
    private Vector r0Aliases = new Vector();
    private Vector r1Aliases = new Vector();
    private Vector r2Aliases = new Vector();
    private Vector r3Aliases = new Vector();
    private Vector r4Aliases = new Vector();
    private Vector r5Aliases = new Vector();
    private Vector r6Aliases = new Vector();
    private Vector r7Aliases = new Vector();
    private static final String[] REPLACEMENTS = new String[]{"A", "R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7"};

    public void addAlias(String to, String alias) {
        if (to.equals("A")) {
            this.accAliases.addElement(alias);
        } else if (to.equals("R0")) {
            this.r0Aliases.addElement(alias);
        } else if (to.equals("R1")) {
            this.r1Aliases.addElement(alias);
        } else if (to.equals("R2")) {
            this.r2Aliases.addElement(alias);
        } else if (to.equals("R3")) {
            this.r3Aliases.addElement(alias);
        } else if (to.equals("R4")) {
            this.r4Aliases.addElement(alias);
        } else if (to.equals("R5")) {
            this.r5Aliases.addElement(alias);
        } else if (to.equals("R6")) {
            this.r6Aliases.addElement(alias);
        } else if (to.equals("R7")) {
            this.r7Aliases.addElement(alias);
        }
    }

    public boolean aliasAlreadyExists(String alias) {
        if (this.aliasAlreadyExists(this.accAliases, alias)) {
            return true;
        }
        if (this.aliasAlreadyExists(this.r0Aliases, alias)) {
            return true;
        }
        if (this.aliasAlreadyExists(this.r1Aliases, alias)) {
            return true;
        }
        if (this.aliasAlreadyExists(this.r2Aliases, alias)) {
            return true;
        }
        if (this.aliasAlreadyExists(this.r3Aliases, alias)) {
            return true;
        }
        if (this.aliasAlreadyExists(this.r4Aliases, alias)) {
            return true;
        }
        if (this.aliasAlreadyExists(this.r5Aliases, alias)) {
            return true;
        }
        if (this.aliasAlreadyExists(this.r6Aliases, alias)) {
            return true;
        }
        return this.aliasAlreadyExists(this.r7Aliases, alias);
    }

    private boolean aliasAlreadyExists(Vector aliases, String alias) {
        for (int i = 0; i < aliases.size(); ++i) {
            if (!alias.equals((String)aliases.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public void removePreviousAlias(String alias) {
        this.removeAlias(this.accAliases, alias);
        this.removeAlias(this.r0Aliases, alias);
        this.removeAlias(this.r1Aliases, alias);
        this.removeAlias(this.r2Aliases, alias);
        this.removeAlias(this.r3Aliases, alias);
        this.removeAlias(this.r4Aliases, alias);
        this.removeAlias(this.r5Aliases, alias);
        this.removeAlias(this.r6Aliases, alias);
        this.removeAlias(this.r7Aliases, alias);
    }

    private void removeAlias(Vector aliases, String alias) {
        for (int i = 0; i < aliases.size(); ++i) {
            if (!alias.equals((String)aliases.elementAt(i))) continue;
            aliases.removeElementAt(i);
            return;
        }
    }

    public String replaceAlias(String line) {
        String temp = this.replaceAlias(this.accAliases, line, 0);
        temp = this.replaceAlias(this.r0Aliases, temp, 1);
        temp = this.replaceAlias(this.r1Aliases, temp, 2);
        temp = this.replaceAlias(this.r2Aliases, temp, 3);
        temp = this.replaceAlias(this.r3Aliases, temp, 4);
        temp = this.replaceAlias(this.r4Aliases, temp, 5);
        temp = this.replaceAlias(this.r5Aliases, temp, 6);
        temp = this.replaceAlias(this.r6Aliases, temp, 7);
        temp = this.replaceAlias(this.r7Aliases, temp, 8);
        return temp;
    }

    private String replaceAlias(Vector aliases, String line, int index) {
        Vector parts = this.breakUpLine(line);
        for (int i = 0; i < aliases.size(); ++i) {
            String alias = (String)aliases.elementAt(i);
            for (int j = 0; j < parts.size(); ++j) {
                String part = (String)parts.elementAt(j);
                String atSymbol = part.charAt(0) == '@' ? "@" : "";
                if (!(atSymbol + alias).equals(part)) continue;
                parts.setElementAt(atSymbol + REPLACEMENTS[index], j);
            }
        }
        return this.rebuildLine(parts);
    }

    private Vector breakUpLine(String line) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        for (int i = 0; i < count; ++i) {
            v.addElement(st.nextToken().trim());
        }
        Vector<String> parts = new Vector<String>();
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            st = new StringTokenizer(s, ",");
            count = st.countTokens();
            for (int j = 0; j < count; ++j) {
                parts.addElement(st.nextToken().trim());
                if (j >= count - 1) continue;
                parts.addElement(",");
            }
        }
        return parts;
    }

    private String rebuildLine(Vector parts) {
        String line = "";
        for (int i = 0; i < parts.size(); ++i) {
            String s = (String)parts.elementAt(i);
            line = s.equals(",") ? line.trim() + "," : line + s + " ";
        }
        return line.trim();
    }
}

