/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import sim8051.ClipboardManager;
import sim8051.Simulator;

public class AssemblyCodeBox
extends JTextArea {
    private ClipboardManager clipboard = new ClipboardManager();
    private final UndoManager undo = new UndoManager();
    private Simulator sim;
    private char specialZero = (char)216;
    private String fontName = null;
    private int fontSize = 12;

    public AssemblyCodeBox(Simulator sim) {
        this.sim = sim;
        this.init();
        this.addUndoRedoFunctionality();
    }

    public void setFontSize(boolean small) {
        this.fontSize = small ? 14 : 21;
        this.setFont(new Font(this.fontName, 0, this.fontSize));
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        if (this.fontName != null) {
            if (b) {
                if (this.fontName.equals("Courier New")) {
                    this.fontName = "Arial";
                    this.setFont(new Font(this.fontName, 0, this.fontSize));
                }
            } else if (this.fontName.equals("Arial")) {
                this.fontName = "Courier New";
                this.setFont(new Font(this.fontName, 0, this.fontSize));
            }
        }
    }

    public void setText(String s) {
        super.setText(s.replace('0', this.specialZero));
    }

    public String getText() {
        return super.getText().replace(this.specialZero, '0');
    }

    public void replaceSelection(String s) {
        super.replaceSelection(s.replace('0', this.specialZero));
    }

    public String getSelectedText() {
        return super.getSelectedText().replace(this.specialZero, '0');
    }

    private void handleMouseClick(MouseEvent evt) {
        if (!this.isEditable()) {
            if (evt.getClickCount() == 2 && evt.getX() < 25) {
                this.sim.setBreakpoint(this.getSelectedText());
            }
        } else {
            this.sim.instructions = null;
            this.sim.codeSaved = false;
        }
    }

    private void handleKeyTyped(KeyEvent evt) {
        if (this.isEditable()) {
            this.sim.instructions = null;
            this.sim.codeSaved = false;
            char c = evt.getKeyChar();
            if (c == '0') {
                evt.consume();
                int caretPosition = this.getCaretPosition();
                this.replaceRange(String.valueOf(this.specialZero), caretPosition, caretPosition);
            }
        }
    }

    public void pasteTextFromClipboard() {
        String s = this.clipboard.paste();
        if (s != null && !s.equals("")) {
            if (this.isEditable()) {
                this.replaceSelection(s);
                this.sim.instructions = null;
                this.sim.codeSaved = false;
            } else {
                this.sim.messageBox.setText("You must click Reset before pasting text.");
            }
        }
    }

    public void copyTextToClipboard() {
        String s = this.getSelectedText();
        if (!s.equals("")) {
            this.clipboard.copy(s);
        }
    }

    public void init() {
        this.fontName = "Arial";
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < fontNames.length; ++i) {
            if (!fontNames[i].equals("Lucida Console")) continue;
            this.fontName = fontNames[i];
            break;
        }
        this.setFont(new Font(this.fontName, 0, 13));
        this.setTabSize(4);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AssemblyCodeBox.this.handleMouseClick(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                AssemblyCodeBox.this.handleKeyTyped(evt);
            }
        });
    }

    private void addUndoRedoFunctionality() {
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                AssemblyCodeBox.this.undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (AssemblyCodeBox.this.undo.canUndo()) {
                        AssemblyCodeBox.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (AssemblyCodeBox.this.undo.canRedo()) {
                        AssemblyCodeBox.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }
}

