/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import sim8051.ClipboardManager;

public class BugFrame
extends JFrame {
    private ClipboardManager clipboard;
    private JButton copy;
    private JTextArea details;
    private JScrollPane detailsScrollPane1;
    private JLabel heading;
    private JLabel heading1;
    private JLabel heading2;
    private JLabel heading3;
    private JLabel heading4;
    private JPanel panel;

    public BugFrame(String bugDetails, ClipboardManager clipboard) {
        this.clipboard = clipboard;
        this.initComponents();
        this.setBounds(300, 50, 500, 600);
        this.setTitle("Software Bug Discovered");
        this.setBugDetails(bugDetails);
    }

    public void setBugDetails(String bugDetails) {
        this.details.setText(bugDetails);
        this.details.selectAll();
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.heading = new JLabel();
        this.heading1 = new JLabel();
        this.heading2 = new JLabel();
        this.heading3 = new JLabel();
        this.heading4 = new JLabel();
        this.detailsScrollPane1 = new JScrollPane();
        this.details = new JTextArea();
        this.copy = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                BugFrame.this.exitForm(evt);
            }
        });
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBackground(Color.BLACK);
        this.heading.setBackground(Color.BLACK);
        this.heading.setFont(new Font("Arial", 1, 12));
        this.heading.setForeground(Color.WHITE);
        this.heading.setText("Sorry. You've discovered a software bug.");
        this.panel.add((Component)this.heading, new GridBagConstraints());
        this.heading1.setBackground(Color.BLACK);
        this.heading1.setFont(new Font("Arial", 1, 12));
        this.heading1.setForeground(Color.WHITE);
        this.heading1.setText("Please report the bug details (below) to");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.panel.add((Component)this.heading1, gridBagConstraints);
        this.heading2.setBackground(Color.BLACK);
        this.heading2.setFont(new Font("Arial", 1, 12));
        this.heading2.setForeground(Color.WHITE);
        this.heading2.setText("http://edsim51.com/bugs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.panel.add((Component)this.heading2, gridBagConstraints);
        this.heading3.setBackground(Color.BLACK);
        this.heading3.setFont(new Font("Arial", 0, 12));
        this.heading3.setForeground(Color.WHITE);
        this.heading3.setText("Click the button below then paste");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.panel.add((Component)this.heading3, gridBagConstraints);
        this.heading4.setBackground(Color.BLACK);
        this.heading4.setFont(new Font("Arial", 0, 12));
        this.heading4.setForeground(Color.WHITE);
        this.heading4.setText("into the comment field at edsim51.com/bugs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.panel.add((Component)this.heading4, gridBagConstraints);
        this.detailsScrollPane1.setMaximumSize(new Dimension(450, 400));
        this.detailsScrollPane1.setMinimumSize(new Dimension(450, 400));
        this.detailsScrollPane1.setPreferredSize(new Dimension(450, 400));
        this.details.setEditable(false);
        this.details.setBorder(new BevelBorder(1));
        this.detailsScrollPane1.setViewportView(this.details);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.panel.add((Component)this.detailsScrollPane1, gridBagConstraints);
        this.copy.setFont(new Font("Arial", 1, 12));
        this.copy.setText("Copy Bug Details");
        this.copy.setToolTipText("Copy the bug details and paste them in the form at edsim51.com/bugs");
        this.copy.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                BugFrame.this.copyMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.panel.add((Component)this.copy, gridBagConstraints);
        this.getContentPane().add((Component)this.panel, "Center");
        this.pack();
    }

    private void copyMouseClicked(MouseEvent evt) {
        this.clipboard.copy(this.details.getText());
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }
}

