/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.util.Vector;
import sim8051.Ram;
import sim8051.sim8051Instructions.ExecutedInstructionInfo;
import sim8051.sim8051Instructions.Instruction;
import sim8051.sim8051Instructions.InstructionInfo;
import sim8051.sim8051Instructions.InstructionSetArray;

public class Cpu {
    public static final int P0 = 128;
    public static final int P1 = 144;
    public static final int P2 = 160;
    public static final int P3 = 176;
    public static final int PSW = 208;
    public static final int ACC = 224;
    public static final int B = 240;
    public static final int SP = 129;
    public static final int DPL = 130;
    public static final int DPH = 131;
    public static final int PCON = 135;
    public static final int TCON = 136;
    public static final int TMOD = 137;
    public static final int TL0 = 138;
    public static final int TL1 = 139;
    public static final int TH0 = 140;
    public static final int TH1 = 141;
    public static final int IE = 168;
    public static final int IP = 184;
    public static final int SCON = 152;
    public static final int SBUF = 153;
    public static final int CY = 215;
    public static final int AC = 214;
    public static final int F0 = 213;
    public static final int RS1 = 212;
    public static final int RS0 = 211;
    public static final int OV = 210;
    public static final int P = 208;
    public static final int TF1 = 143;
    public static final int TR1 = 142;
    public static final int TF0 = 141;
    public static final int TR0 = 140;
    public static final int IE1 = 139;
    public static final int IT1 = 138;
    public static final int IE0 = 137;
    public static final int IT0 = 136;
    public static final int EA = 175;
    public static final int ES = 172;
    public static final int ET1 = 171;
    public static final int EX1 = 170;
    public static final int ET0 = 169;
    public static final int EX0 = 168;
    public static final int PS = 188;
    public static final int PT1 = 187;
    public static final int PX1 = 186;
    public static final int PT0 = 185;
    public static final int PX0 = 184;
    public static final int RD = 183;
    public static final int WR = 182;
    public static final int T1 = 181;
    public static final int T0 = 180;
    public static final int INT1 = 179;
    public static final int INT0 = 178;
    public static final int TXD = 177;
    public static final int RXD = 176;
    public static final int SM0 = 159;
    public static final int SM1 = 158;
    public static final int SM2 = 157;
    public static final int REN = 156;
    public static final int TB8 = 155;
    public static final int RB8 = 154;
    public static final int TI = 153;
    public static final int RI = 152;
    public static final int[] vectorTable = new int[]{0, 3, 11, 19, 27, 35};
    public boolean running = false;
    public Ram dataMemory = new Ram();
    public boolean codeLoaded = false;
    public double machineCycleLength = 1.0;
    private InstructionSetArray allInstructions = new InstructionSetArray();
    private int pc = 0;
    private boolean previousInt0 = true;
    private boolean previousInt1 = true;
    private long totalElapsedTime = 0L;
    private int batchTime = 0;
    private int lastInstructionTime = 0;
    private int numberOfExecutedInstructions = 0;

    public int getPc() {
        return this.pc;
    }

    public void setPc(int pc) {
        this.pc = pc & 0xFFFF;
    }

    private boolean isFlagSet(int interruptSource) {
        try {
            if (interruptSource == 0) {
                return this.dataMemory.getBit(137) == 1;
            }
            if (interruptSource == 1) {
                return this.dataMemory.getBit(141) == 1;
            }
            if (interruptSource == 2) {
                return this.dataMemory.getBit(139) == 1;
            }
            if (interruptSource == 3) {
                return this.dataMemory.getBit(143) == 1;
            }
            if (interruptSource == 4) {
                return this.dataMemory.getBit(152) == 1 || this.dataMemory.getBit(153) == 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void clearFlag(int interruptSource) {
        try {
            if (interruptSource == 1) {
                this.dataMemory.clearBit(141);
            } else if (interruptSource == 3) {
                this.dataMemory.clearBit(143);
            } else if (interruptSource == 0 && this.dataMemory.getBit(136) == 1) {
                this.dataMemory.clearBit(137);
            } else if (interruptSource == 2 && this.dataMemory.getBit(138) == 1) {
                this.dataMemory.clearBit(139);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isHighPriority(int interruptSource) {
        if (interruptSource >= 0 && interruptSource <= 4) {
            try {
                int ip = this.dataMemory.readByte(184);
                return ((ip >>= interruptSource) & 1) == 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isEnabled(int interruptSource) {
        if (interruptSource == 7 || interruptSource >= 0 && interruptSource <= 4) {
            try {
                int ip = this.dataMemory.readByte(168);
                return ((ip >>= interruptSource) & 1) == 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isEnableAllSet() {
        return this.isEnabled(7);
    }

    private int getVector(int interruptSource) {
        if (interruptSource >= 0 && interruptSource <= 4) {
            return vectorTable[interruptSource + 1];
        }
        return 0;
    }

    private void pollExternalInterrupt0() {
        try {
            boolean edgeTriggered;
            boolean bl = edgeTriggered = this.dataMemory.getBit(136) == 1;
            if (edgeTriggered) {
                if (this.previousInt0 && !this.dataMemory.port3.isPortPinHigh(2)) {
                    this.dataMemory.setBit(137);
                }
            } else if (!this.dataMemory.port3.isPortPinHigh(2)) {
                this.dataMemory.setBit(137);
            }
            this.previousInt0 = this.dataMemory.port3.isPortPinHigh(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void pollExternalInterrupt1() {
        try {
            boolean edgeTriggered;
            boolean bl = edgeTriggered = this.dataMemory.getBit(138) == 1;
            if (edgeTriggered) {
                if (this.previousInt1 && !this.dataMemory.port3.isPortPinHigh(3)) {
                    this.dataMemory.setBit(139);
                }
            } else if (!this.dataMemory.port3.isPortPinHigh(3)) {
                this.dataMemory.setBit(139);
            }
            this.previousInt1 = this.dataMemory.port3.isPortPinHigh(3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int vectorToIsr(int currentPc) {
        int i;
        if (!this.isEnableAllSet() || this.dataMemory.getInterruptLevel() == 1) {
            return currentPc;
        }
        for (i = 0; i <= 4; ++i) {
            if (!this.isEnabled(i) || !this.isHighPriority(i) || !this.isFlagSet(i)) continue;
            if (this.dataMemory.getInterruptLevel() == 0) {
                this.dataMemory.setIsrNested(true);
            }
            this.dataMemory.setInterruptLevel(1);
            this.clearFlag(i);
            this.pushReturnAddress();
            return this.getVector(i);
        }
        if (this.dataMemory.getInterruptLevel() == 0) {
            return currentPc;
        }
        for (i = 0; i <= 4; ++i) {
            if (!this.isEnabled(i) || !this.isFlagSet(i)) continue;
            this.dataMemory.setInterruptLevel(0);
            this.clearFlag(i);
            this.pushReturnAddress();
            return this.getVector(i);
        }
        return currentPc;
    }

    private void pushReturnAddress() {
        try {
            int sp = this.dataMemory.readByte(129) + 1;
            if (sp == 256) {
                sp = 0;
            }
            this.dataMemory.writeByte(sp, this.pc & 0xFF);
            if (++sp == 256) {
                sp = 0;
            }
            this.dataMemory.writeByte(129, sp);
            this.dataMemory.writeByte(sp, this.pc >> 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.codeLoaded = false;
        this.pc = 0;
        this.previousInt0 = false;
        this.previousInt1 = false;
        this.totalElapsedTime = 0L;
        this.numberOfExecutedInstructions = 0;
        this.dataMemory.reset();
    }

    public void loadCode(InstructionInfo[] codeMemory) {
        if (codeMemory != null) {
            this.dataMemory.codeMemory = codeMemory;
            this.codeLoaded = true;
            this.pc = 0;
        }
    }

    private void setPortGuiUpdateFlags(boolean b) {
        this.dataMemory.port0.setTimeToUpdateGui(b);
        this.dataMemory.port1.setTimeToUpdateGui(b);
        this.dataMemory.port2.setTimeToUpdateGui(b);
        this.dataMemory.port3.setTimeToUpdateGui(b);
    }

    public String getElapsedTime() {
        long temp = Math.round((double)this.totalElapsedTime * this.machineCycleLength);
        long min = temp / 60000000L;
        long sec = (temp %= 60000000L) / 1000000L;
        long milli = (temp %= 1000000L) / 1000L;
        long micro = temp % 1000L;
        String s = "";
        if (micro != 0L) {
            s = s + micro + "us";
        }
        if (milli != 0L) {
            s = milli + "ms " + s;
        }
        if (sec != 0L) {
            s = sec + "s " + s;
        }
        if (min != 0L) {
            s = min + "m " + s;
        }
        return s;
    }

    public int getNumberOfExecutedInstructions() {
        return this.numberOfExecutedInstructions;
    }

    private boolean isBreakpoint(Vector breakpoints, int pc) {
        if (breakpoints == null) {
            return false;
        }
        for (int i = 0; i < breakpoints.size(); ++i) {
            if ((Integer)breakpoints.elementAt(i) != pc) continue;
            return true;
        }
        return false;
    }

    public ExecutedInstructionInfo executeInstructions(int instructionBatchSize, Vector breakpoints, boolean stopAtMovx) throws Exception {
        this.numberOfExecutedInstructions += instructionBatchSize;
        this.setPortGuiUpdateFlags(false);
        ExecutedInstructionInfo info = new ExecutedInstructionInfo();
        this.batchTime = 0;
        for (int instructionNumber = 0; instructionNumber < instructionBatchSize; ++instructionNumber) {
            int i;
            Instruction instruction = this.allInstructions.array[this.dataMemory.codeMemory[this.pc].getCode()];
            this.lastInstructionTime = instruction.cycles;
            for (i = 0; i < instruction.cycles; ++i) {
                ++this.totalElapsedTime;
                ++this.batchTime;
                this.dataMemory.timer0.step();
                this.dataMemory.timer1.step();
                this.dataMemory.serial.poll();
                this.pollExternalInterrupt0();
                this.pollExternalInterrupt1();
                this.dataMemory.port1.dac.incrementTime();
                this.dataMemory.port3.updateMotor();
                this.dataMemory.port3.adc.convert();
            }
            if (instructionNumber == instructionBatchSize - 1) {
                this.setPortGuiUpdateFlags(true);
                this.dataMemory.port1.dac.repaint();
                this.dataMemory.port3.motor.updateMotorGraphics();
            }
            if (instruction.size > 1) {
                int operand0Position = this.pc + 1;
                if (operand0Position == 65536) {
                    operand0Position = 0;
                }
                instruction.operand0 = this.dataMemory.codeMemory[operand0Position].getCode();
            }
            if (instruction.size > 2) {
                int operand1Position = this.pc + 2;
                if (operand1Position >= 65536) {
                    operand1Position -= 65536;
                }
                instruction.operand1 = this.dataMemory.codeMemory[operand1Position].getCode();
            }
            if (instructionBatchSize == 1) {
                info.pc = this.pc;
                info.preAssembledLine = this.dataMemory.codeMemory[this.pc].getText();
            }
            this.pc = instruction.execute(this.dataMemory, this.pc);
            if (instructionNumber == instructionBatchSize - 1) {
                info.mneumonic = instruction.toString();
            }
            if (this.dataMemory.hasRetiJustBeenExecuted()) {
                this.dataMemory.setRetiJustExecuted(false);
            } else {
                this.pc = this.vectorToIsr(this.pc);
            }
            if (this.pc > 65535) {
                this.pc = 0;
            }
            this.dataMemory.port0.bounceKeys(instruction.cycles);
            this.dataMemory.port2.setCycles(instruction.cycles);
            this.dataMemory.updatePortPins();
            for (i = 0; i < instruction.cycles; ++i) {
                this.dataMemory.port3.uart.pulseClock();
            }
            if (stopAtMovx && instruction.mneumonic.startsWith("MOVX")) {
                info.isMovx = true;
                return info;
            }
            if (!this.isBreakpoint(breakpoints, this.pc)) continue;
            info.isBreakpoint = true;
            return info;
        }
        return info;
    }
}

