/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sim8051.ports.Port;

public class PortPinsDescFrame
extends JFrame
implements MouseListener {
    private int portNumber;
    private Port port;
    private JLabel[] descriptionsLabels = new JLabel[8];
    private JPanel panel = new JPanel();
    private JTextField[] fields = new JTextField[8];

    public PortPinsDescFrame(int portNumber, Port port, String[] descriptions) {
        int i;
        this.portNumber = portNumber;
        this.port = port;
        for (int i2 = 0; i2 < 8; ++i2) {
            this.descriptionsLabels[i2] = new JLabel(descriptions[i2]);
        }
        this.panel.setBackground(Color.WHITE);
        this.panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Font font = new Font("Monospaced", 1, 18);
        JLabel label = new JLabel("PORT " + portNumber);
        label.setFont(font);
        label.setForeground(Color.BLUE);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.gridwidth = 3;
        this.panel.add((Component)label, gbc);
        for (i = 0; i < 8; ++i) {
            JTextField field = new JTextField();
            field.setEditable(false);
            field.setFont(font);
            field.setHorizontalAlignment(0);
            field.setPreferredSize(new Dimension(30, 30));
            this.fields[i] = field;
        }
        for (i = 0; i < 8; ++i) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = i + 1;
            gbc.insets = insets;
            label = new JLabel("P" + portNumber + "." + (7 - i));
            label.setFont(font);
            this.panel.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = i + 1;
            gbc.insets = insets;
            this.panel.add((Component)this.fields[7 - i], gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = i + 1;
            gbc.insets = insets;
            gbc.anchor = 17;
            label = this.descriptionsLabels[7 - i];
            label.setFont(font);
            this.panel.add((Component)label, gbc);
        }
        this.setPinsStates();
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setBackground(Color.WHITE);
        label = new JLabel("always on top");
        label.setFont(font);
        label.setForeground(Color.BLUE);
        checkBoxPanel.add(label);
        JCheckBox alwaysOnTopCheckbox = new JCheckBox();
        alwaysOnTopCheckbox.setSelected(true);
        alwaysOnTopCheckbox.addMouseListener(this);
        checkBoxPanel.add(alwaysOnTopCheckbox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 3;
        this.panel.add((Component)checkBoxPanel, gbc);
        this.getContentPane().add(this.panel);
        this.setTitle("Port " + portNumber);
        this.pack();
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public void setPinDescription(int pinNumber, String description) {
        if (pinNumber >= 0 && pinNumber <= 7) {
            this.descriptionsLabels[pinNumber].setText(description);
        }
    }

    public void setPinToolTip(int pinNumber, String tooltip) {
        if (pinNumber >= 0 && pinNumber <= 7) {
            this.descriptionsLabels[pinNumber].setToolTipText(tooltip);
        }
    }

    public void setPinsStates() {
        for (int i = 0; i < 8; ++i) {
            if (this.port.getPortPin(i) == 1) {
                this.fields[i].setText("1");
                continue;
            }
            this.fields[i].setText("0");
        }
    }

    public void mouseClicked(MouseEvent event) {
        this.setAlwaysOnTop(!this.isAlwaysOnTop());
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }
}

