/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import sim8051.Serial;
import sim8051.Text;
import sim8051.Timer0;
import sim8051.Timer1;
import sim8051.ports.Port0;
import sim8051.ports.Port1;
import sim8051.ports.Port2;
import sim8051.ports.Port3;
import sim8051.sim8051Exceptions.AddressAccessException;
import sim8051.sim8051Exceptions.BitAddressAccessException;
import sim8051.sim8051Instructions.InstructionInfo;

public class Ram {
    public InstructionInfo[] codeMemory;
    private int[] memory = new int[256];
    private boolean retiJustExecuted = false;
    private boolean isrNested = false;
    private int interruptLevel = -1;
    public Port0 port0 = new Port0(this);
    public Port1 port1 = new Port1(this);
    public Port2 port2 = new Port2(this);
    public Port3 port3 = new Port3(this);
    public Timer0 timer0 = new Timer0(this);
    public Timer1 timer1 = new Timer1(this);
    public Serial serial = new Serial(this);

    public Ram() {
        this.reset();
        this.codeMemory = new InstructionInfo[65536];
        for (int i = 0; i < 65536; ++i) {
            InstructionInfo ii;
            this.codeMemory[i] = ii = new InstructionInfo("NOP", 0);
        }
    }

    public String[] getMemoryWindow(boolean isRam) {
        return this.getMemoryWindow(isRam, 0);
    }

    public String[] getMemoryWindow(boolean isRam, int startAddress) {
        String[] s = new String[3];
        String data = "";
        int col = 0;
        if (isRam) {
            s[0] = " 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";
            s[1] = "00\n10\n20\n30\n40\n50\n60\n70";
            for (int i = 0; i < 128; ++i) {
                data = data + Text.inHex(this.memory[i], false, 2, false) + " ";
                if (++col != 16) continue;
                col = 0;
                data = data.trim() + "\n";
            }
        } else {
            if (startAddress < 0) {
                startAddress = 0;
            } else if (startAddress > 65408) {
                startAddress = 65408;
            }
            String columnAddress = "";
            for (int i = startAddress; i < startAddress + 16; ++i) {
                columnAddress = columnAddress + Text.inHex(i, false, 1, false) + "  ";
            }
            String rowAddress = "";
            for (int i = startAddress; i < startAddress + 128; ++i) {
                int code = this.codeMemory[i].getCode();
                data = data + Text.inHex(code, false, 2, false) + " ";
                if (col == 0) {
                    rowAddress = rowAddress + Text.inHex(i, false, 4, false) + "\n";
                }
                if (++col != 16) continue;
                data = data.trim() + "\n";
                col = 0;
            }
            s[0] = " " + columnAddress.trim() + " ";
            s[1] = rowAddress.trim();
        }
        s[2] = data.trim();
        return s;
    }

    public boolean hasRetiJustBeenExecuted() {
        return this.retiJustExecuted;
    }

    public void setRetiJustExecuted(boolean b) {
        this.retiJustExecuted = b;
    }

    public void setIsrNested(boolean b) {
        this.isrNested = b;
    }

    public boolean isIsrNested() {
        return this.isrNested;
    }

    public void setInterruptLevel(int i) {
        this.interruptLevel = i;
    }

    public int getInterruptLevel() {
        return this.interruptLevel;
    }

    public void reset() {
        this.interruptLevel = -1;
        this.memory[224] = 0;
        this.memory[240] = 0;
        this.memory[208] = 0;
        this.memory[129] = 7;
        this.memory[131] = 0;
        this.memory[130] = 0;
        this.memory[184] = 0;
        this.memory[168] = 0;
        this.memory[136] = 0;
        this.memory[137] = 0;
        this.memory[140] = 0;
        this.memory[138] = 0;
        this.memory[141] = 0;
        this.memory[139] = 0;
        this.memory[152] = 0;
        this.memory[153] = 0;
        this.memory[135] = 0;
        this.memory[128] = 255;
        this.memory[144] = 255;
        this.memory[160] = 255;
        this.memory[176] = 255;
        this.retiJustExecuted = false;
        if (this.port1.lcdModule != null) {
            this.port1.lcdModule.reset();
        }
        this.port3.openRxdSwitch();
        this.updatePortPins();
        this.timer0 = new Timer0(this);
        this.timer1 = new Timer1(this);
        this.serial = new Serial(this);
    }

    public int readSbufWriteOnly() {
        return this.memory[153];
    }

    public void writeRegister(int registerNumber, int data) throws Exception {
        if (registerNumber < 0 || registerNumber > 7) {
            throw new AddressAccessException(registerNumber);
        }
        int address = 8 * this.getRegiserBankNumber() + registerNumber;
        this.writeByte(address, data);
    }

    public int readRegister(int registerNumber) throws AddressAccessException {
        if (registerNumber < 0 || registerNumber > 7) {
            throw new AddressAccessException(registerNumber);
        }
        int address = this.getRegisterAddress(registerNumber);
        return this.readByte(address);
    }

    public int getRegisterAddress(int registerNumber) throws AddressAccessException {
        if (registerNumber < 0 || registerNumber > 7) {
            throw new AddressAccessException(registerNumber);
        }
        return 8 * this.getRegiserBankNumber() + registerNumber;
    }

    public String getRegisterName(int address) {
        int register0Address = 0;
        try {
            register0Address = this.getRegisterAddress(0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        int registerNumber = address - register0Address;
        if (registerNumber >= 0 && registerNumber <= 7) {
            return "R" + registerNumber;
        }
        return null;
    }

    public void writeByte(int address, int data) throws Exception {
        if (this.isChangingSerialMode(address &= 0xFF, data &= 0xFF, true)) {
            this.serial.reset();
        }
        this.memory[address] = data;
        if (address == 224) {
            this.updateParity();
        } else if (address == 153) {
            this.serial.setDataToSend();
        } else if (address == 128) {
            this.port0.updatePortPins();
        } else if (address == 144) {
            this.port1.updatePortPins();
        } else if (address == 160) {
            this.port2.updatePortPins();
        } else if (address == 176) {
            this.port3.updatePortPins();
        }
    }

    public int getRegiserBankNumber() {
        try {
            return this.getBit(211) + (this.getBit(212) << 1);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void updatePortPins() {
        try {
            this.port0.updatePortPins();
            this.port1.updatePortPins();
            this.port2.updatePortPins();
            this.port3.updatePortPins();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int readPortLatches(int address) throws AddressAccessException {
        if (address == 128) {
            return this.memory[128];
        }
        if (address == 144) {
            return this.memory[144];
        }
        if (address == 160) {
            return this.memory[160];
        }
        if (address == 176) {
            return this.memory[176];
        }
        throw new AddressAccessException(address);
    }

    public int readPortLatch(int bitAddress) throws BitAddressAccessException {
        if (bitAddress >= 128 && bitAddress <= 135 || bitAddress >= 144 && bitAddress <= 151 || bitAddress >= 160 && bitAddress <= 167 || bitAddress >= 176 && bitAddress <= 183) {
            int bit = bitAddress % 8;
            int byteAddress = bitAddress - bit;
            int data = this.memory[byteAddress];
            data >>= bit;
            return data &= 1;
        }
        throw new BitAddressAccessException(bitAddress);
    }

    public int readByteForLogicInstruction(int address) throws Exception {
        if (address == 128 || address == 144 || address == 160 || address == 176) {
            return this.readPortLatches(address);
        }
        return this.readByte(address);
    }

    public int readByte(int address) throws AddressAccessException {
        if ((address &= 0xFF) < 0 || address > 255) {
            throw new AddressAccessException(address);
        }
        if (address == 128) {
            return this.port0.getPortPins();
        }
        if (address == 144) {
            return this.port1.getPortPins();
        }
        if (address == 160) {
            return this.port2.getPortPins();
        }
        if (address == 176) {
            return this.port3.getPortPins();
        }
        if (address == 153) {
            return this.serial.getSbufReadOnly();
        }
        return this.memory[address];
    }

    public int getBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        if (bitAddress <= 127) {
            return this.getBit(bitAddress / 8 + 32, bitAddress % 8);
        }
        return this.getBit(bitAddress - bitAddress % 8, bitAddress % 8);
    }

    private int getBit(int address, int bit) throws AddressAccessException {
        if (this.isBitAddressable(address)) {
            int data = this.readByte(address);
            data >>= bit;
            return data &= 1;
        }
        BitAddressAccessException ex = new BitAddressAccessException(address);
        ex.isBitAddressableError(true);
        throw ex;
    }

    public void setBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        if (this.isChangingSerialMode(bitAddress, 1, false)) {
            this.serial.reset();
        }
        if (bitAddress <= 127) {
            this.setBit(bitAddress / 8 + 32, bitAddress % 8);
        } else {
            this.setBit(bitAddress - bitAddress % 8, bitAddress % 8);
        }
    }

    public void setBit(int address, int bit) throws AddressAccessException {
        if (this.isBitAddressable(address)) {
            int data = this.memory[address];
            int mask = 1;
            this.memory[address] = data |= (mask <<= bit);
            if (address == 224) {
                this.updateParity();
            }
        } else {
            BitAddressAccessException ex = new BitAddressAccessException(address);
            ex.isBitAddressableError(true);
            throw ex;
        }
    }

    public void clearBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        if (this.isChangingSerialMode(bitAddress, 0, false)) {
            this.serial.reset();
        }
        if (bitAddress <= 127) {
            this.clearBit(bitAddress / 8 + 32, bitAddress % 8);
        } else {
            this.clearBit(bitAddress - bitAddress % 8, bitAddress % 8);
        }
    }

    public void clearBit(int address, int bit) throws AddressAccessException {
        if (this.isBitAddressable(address)) {
            int data = this.memory[address];
            int mask = 1;
            mask = ~(mask << bit);
            this.memory[address] = data &= mask;
            if (address == 224) {
                this.updateParity();
            }
        } else {
            BitAddressAccessException ex = new BitAddressAccessException(address);
            ex.isBitAddressableError(true);
            throw ex;
        }
    }

    public void invertBit(int bitAddress) throws AddressAccessException {
        if (bitAddress < 0 || bitAddress > 255) {
            throw new BitAddressAccessException(bitAddress);
        }
        int bit = this.getBit(bitAddress);
        bit = bit == 1 ? 0 : 1;
        if (this.isChangingSerialMode(bitAddress, bit, false)) {
            this.serial.reset();
        }
        if (bitAddress <= 127) {
            this.invertBit(bitAddress / 8 + 32, bitAddress % 8);
        } else {
            this.invertBit(bitAddress - bitAddress % 8, bitAddress % 8);
        }
    }

    private void invertBit(int address, int bit) throws AddressAccessException {
        if (this.isBitAddressable(address)) {
            int data = this.memory[address];
            int mask = 1;
            this.memory[address] = data ^= (mask <<= bit);
            if (address == 224) {
                this.updateParity();
            }
        } else {
            BitAddressAccessException ex = new BitAddressAccessException(address);
            ex.isBitAddressableError(true);
            throw ex;
        }
    }

    public boolean isBitAddressable(int address) {
        return address >= 32 && address <= 47 || address >= 128 && address % 8 == 0;
    }

    private void updateParity() {
        try {
            if (this.evenNumberOfOnesInAcc()) {
                this.clearBit(208);
            } else {
                this.setBit(208);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean evenNumberOfOnesInAcc() {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            try {
                count += this.getBit(224 + i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count / 2 * 2 == count;
    }

    private int getPortNumber(int address) {
        if (address == 128) {
            return 0;
        }
        if (address == 144) {
            return 1;
        }
        if (address == 160) {
            return 2;
        }
        if (address == 176) {
            return 3;
        }
        return -1;
    }

    private boolean isChangingSerialMode(int address, int data, boolean isByteAddress) {
        try {
            if (isByteAddress) {
                if (address == 152) {
                    int currentMode = this.readByte(152) >> 6;
                    return data >> 6 != currentMode;
                }
            } else {
                if (address == 159) {
                    return this.getBit(159) != data;
                }
                if (address == 158) {
                    return this.getBit(158) != data;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    public int toSignedNumber(int unsignedData) {
        if (unsignedData >= 0 && unsignedData <= 127) {
            return unsignedData;
        }
        return unsignedData - 256;
    }

    public int getNumberOfIdenticalLinesPrevious(String line, int pc) {
        int count = 0;
        for (int i = 0; i < pc; ++i) {
            if (!line.equals(this.codeMemory[i].getText())) continue;
            ++count;
        }
        return count;
    }
}

