/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import sim8051.CodeNotSaved;
import sim8051.Simulator;
import sim8051.settings.SettingsReaderWriter;

public class Sim8051 {
    private static Simulator sim;
    private static JFrame frame;

    public static void main(String[] args) throws Exception {
        frame = new JFrame();
        sim = new Simulator(frame);
        Sim8051.sim.srw = new SettingsReaderWriter(sim);
        Sim8051.sim.settings = Sim8051.sim.srw.readSettings();
        sim.init();
        if (Sim8051.sim.settings.isSmall()) {
            sim.zoomOut();
        } else {
            sim.zoomIn();
        }
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(sim);
        frame.getContentPane().add(pane);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Sim8051.formWindowClosing(evt);
            }
        });
        frame.setTitle(Sim8051.sim.version);
        frame.setVisible(true);
        sim.setAssemblyCodeBoxFocus();
    }

    private static void formWindowClosing(WindowEvent evt) {
        if (!sim.isCodeSaved()) {
            CodeNotSaved cns = new CodeNotSaved(sim, "Source code not saved.\nSave file before exiting?", false);
            int response = cns.showConfirmDialog();
            if (response == cns.NO || response == cns.YES) {
                Sim8051.sim.srw.writeSettings();
                System.exit(0);
            }
            if (Sim8051.sim.unlockedAssemblyCodeFrame != null) {
                Sim8051.sim.unlockedAssemblyCodeFrame.refocus();
            } else {
                sim.setAssemblyCodeBoxFocus();
            }
        } else {
            Sim8051.sim.srw.writeSettings();
            System.exit(0);
        }
    }
}

