/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sim8051.Assembler;
import sim8051.AssemblyAndHexFileFilter;
import sim8051.AssemblyCodeBox;
import sim8051.AssemblyFileFilter;
import sim8051.BugFrame;
import sim8051.ClipboardManager;
import sim8051.CodeNotSaved;
import sim8051.Cpu;
import sim8051.FileHandler;
import sim8051.HexFileFilter;
import sim8051.PortPinsDescFrame;
import sim8051.Sizes;
import sim8051.Text;
import sim8051.UnlockedAssemblyCodeFrame;
import sim8051.UpdateFreqPanel;
import sim8051.lcd.LcdModule;
import sim8051.peripherals.SevenSegDisplay;
import sim8051.ports.Port;
import sim8051.settings.Settings;
import sim8051.settings.SettingsReaderWriter;
import sim8051.sim8051Exceptions.Sim8051Exception;
import sim8051.sim8051Instructions.ExecutedInstructionInfo;
import sim8051.sim8051Instructions.Instruction;

public class Simulator
extends JPanel
implements Runnable {
    public JFrame externalFrame;
    public String version = "EdSim51 - Version 1.19.13";
    public Vector components = new Vector();
    public Cpu cpu;
    public Instruction[] instructions = null;
    public boolean codeSaved = true;
    public AssemblyFileFilter aff = new AssemblyFileFilter();
    public HexFileFilter hff = new HexFileFilter();
    public AssemblyAndHexFileFilter ahff = new AssemblyAndHexFileFilter();
    public UpdateFreqPanel updateFreqPanel;
    public SettingsReaderWriter srw;
    public Settings settings;
    public UnlockedAssemblyCodeFrame unlockedAssemblyCodeFrame;
    private PortPinsDescFrame port0Frame = null;
    private PortPinsDescFrame port1Frame = null;
    private PortPinsDescFrame port2Frame = null;
    private PortPinsDescFrame port3Frame = null;
    private JButton port0DescZoomButton = new JButton("+");
    private JButton port1DescZoomButton = new JButton("+");
    private JButton port2DescZoomButton = new JButton("+");
    private JButton port3DescZoomButton = new JButton("+");
    private boolean showMovxWarning = true;
    private JPanel messageUnlockZoomPanel = new JPanel();
    private JPanel unlockZoomPanel = new JPanel();
    private JButton unlockButton = new JButton();
    private JButton zoomButton = new JButton();
    private JCheckBox bounceBox = new JCheckBox();
    private Sizes sizes = new Sizes();
    private JButton keypadAndGateDisableButton = new JButton();
    private BugFrame bugFrame = null;
    private ClipboardManager clipboard;
    private boolean fieldsEnabled = true;
    private String preAssembledCode;
    private Vector breakpoints = null;
    private Assembler assembler;
    private Thread t;
    private JTextField[] port0PinFields = new JTextField[8];
    private JTextField[] port1PinFields = new JTextField[8];
    private JTextField[] port2PinFields = new JTextField[8];
    private JTextField[] port3PinFields = new JTextField[8];
    private LcdModule lcdModule;
    private GridBagConstraints lcdModuleGBC;
    private JButton ledLcdButton = new JButton();
    private GridBagConstraints ledLcdButtonGBC;
    private JButton removeAllBreakpointsButton = new JButton();
    private SevenSegDisplay[] displays;
    private JTextField[] leds;
    private JButton[] switches;
    private JButton[] controlButtons;
    private String[] baudRates = new String[]{"19200 Baud", "4800 Baud", "2400 Baud", "1200 Baud"};
    private JComboBox baudRateComboBox = new JComboBox<String>(this.baudRates);
    private String[] keypadTypes = new String[]{"Standard", "Pulse", "Radio"};
    private JComboBox keypadTypesComboBox = new JComboBox<String>(this.keypadTypes);
    private AssemblyCodeBox assemblyCodeBox = new AssemblyCodeBox(this);
    private JTextField[] bitFields;
    private JTextField[] eightBitFields;
    private JLabel[] labels;
    private JButton[] keypadButtons;
    private JLabel[] portPinLabels;
    private JTextField[] portPinTextFields;
    private Color blue = new Color(153, 153, 255);
    private Color darkRed = new Color(127, 0, 0);
    private JTextField sysClockField = new JTextField();
    private JLabel R0;
    private JLabel R1;
    private JLabel R2;
    private JLabel R3;
    private JLabel R4;
    private JLabel R5;
    private JLabel R6;
    private JLabel R7;
    private JTextField a0;
    private JTextField a1;
    private JTextField a2;
    private JTextField a3;
    private JTextField acc;
    private JLabel accLabel;
    private JButton adcDisableButton;
    private JLabel adcInputLabel;
    private JPanel adcInputPanel;
    private JLabel adcLabel;
    private JPanel adcPanel;
    private JSlider adcSlider;
    private JTextField adcVoltageField;
    private JLabel addLabel;
    private JLabel addrLabel;
    private JPanel assembly;
    private JScrollPane assemblyCodeBoxPanel;
    private JTextField b;
    private JTextField b0;
    private JTextField b1;
    private JTextField b2;
    private JTextField b3;
    private JLabel bLabel;
    private JLabel baudLabel;
    private JTextField bit0;
    private JTextField bit1;
    private JTextField bit2;
    private JTextField bit3;
    private JTextField bit4;
    private JTextField bit5;
    private JTextField bit6;
    private JTextField bit7;
    private JTextField bitfieldByteAddress;
    private JPanel bitfieldPanel;
    private JTextField c0;
    private JTextField c1;
    private JTextField c2;
    private JTextField c3;
    private JTextField columnAddresses;
    private JPanel controlPanel;
    private JLabel copyright;
    private JTextField d0;
    private JTextField d1;
    private JTextField d2;
    private JTextField d3;
    private JTextField dacVoltageField;
    private JLabel dataLabel;
    private JPanel display0Panel;
    private JPanel display1Panel;
    private JPanel display2Panel;
    private JPanel display3Panel;
    private JTextField dp0;
    private JTextField dp1;
    private JTextField dp2;
    private JTextField dp3;
    private JTextField dph;
    private JLabel dphLabel;
    private JTextField dpl;
    private JLabel dplLabel;
    private JTextField e0;
    private JTextField e1;
    private JTextField e2;
    private JTextField e3;
    private JPanel externalHardware;
    private JPanel externalUartPanel;
    private JTextField f0;
    private JTextField f1;
    private JTextField f2;
    private JTextField f3;
    private JButton fileOpen;
    private JButton fileSave;
    private JTextField g0;
    private JTextField g1;
    private JTextField g2;
    private JTextField g3;
    private JTextField ie;
    private JLabel ieLabel;
    private JTextField ip;
    private JLabel ipLabel;
    private JButton key0;
    private JButton key1;
    private JButton key10;
    private JButton key11;
    private JButton key2;
    private JButton key3;
    private JButton key4;
    private JButton key5;
    private JButton key6;
    private JButton key7;
    private JButton key8;
    private JButton key9;
    private JLabel keypadLabel;
    private JPanel keypadPanel;
    private JLabel latchLabel;
    private JTextField led0;
    private JTextField led1;
    private JTextField led2;
    private JTextField led3;
    private JTextField led4;
    private JTextField led5;
    private JTextField led6;
    private JTextField led7;
    private JLabel ledsLabel;
    private JPanel ledsPanel;
    private JScrollPane messageBoxPanel;
    public JTextField messageBox;
    private JPanel microcontroller;
    private JLabel microcontrollerLabel;
    private JSlider motorCurrent;
    private JLabel motorCurrentHighLabel;
    private JLabel motorCurrentLowLabel;
    private JButton motorDisableButton;
    private JPanel motorGraphicsPanel;
    private JLabel motorLabel;
    private JPanel motorPanel;
    private JPanel multiplexedDisplayPanel;
    private JTextField p0_0;
    private JLabel p0_0Descr;
    private JTextField p0_1;
    private JLabel p0_1Descr;
    private JTextField p0_2;
    private JLabel p0_2Descr;
    private JTextField p0_3;
    private JLabel p0_3Descr;
    private JTextField p0_4;
    private JLabel p0_4Descr;
    private JTextField p0_5;
    private JLabel p0_5Descr;
    private JTextField p0_6;
    private JLabel p0_6Descr;
    private JTextField p0_7;
    private JLabel p0_7Descr;
    private JLabel p0_label0;
    private JLabel p0_label1;
    private JLabel p0_label2;
    private JLabel p0_label3;
    private JLabel p0_label4;
    private JLabel p0_label5;
    private JLabel p0_label6;
    private JLabel p0_label7;
    private JTextField p1_0;
    private JLabel p1_0Descr;
    private JTextField p1_1;
    private JLabel p1_1Descr;
    private JTextField p1_2;
    private JLabel p1_2Descr;
    private JTextField p1_3;
    private JLabel p1_3Descr;
    private JTextField p1_4;
    private JLabel p1_4Descr;
    private JTextField p1_5;
    private JLabel p1_5Descr;
    private JTextField p1_6;
    private JLabel p1_6Descr;
    private JTextField p1_7;
    private JLabel p1_7Descr;
    private JLabel p1_label0;
    private JLabel p1_label1;
    private JLabel p1_label2;
    private JLabel p1_label3;
    private JLabel p1_label4;
    private JLabel p1_label5;
    private JLabel p1_label6;
    private JLabel p1_label7;
    private JTextField p2_0;
    private JLabel p2_0Descr;
    private JTextField p2_1;
    private JLabel p2_1Descr;
    private JTextField p2_2;
    private JLabel p2_2Descr;
    private JTextField p2_3;
    private JLabel p2_3Descr;
    private JTextField p2_4;
    private JLabel p2_4Descr;
    private JTextField p2_5;
    private JLabel p2_5Descr;
    private JTextField p2_6;
    private JLabel p2_6Descr;
    private JTextField p2_7;
    private JLabel p2_7Descr;
    private JLabel p2_label0;
    private JLabel p2_label1;
    private JLabel p2_label2;
    private JLabel p2_label3;
    private JLabel p2_label4;
    private JLabel p2_label5;
    private JLabel p2_label6;
    private JLabel p2_label7;
    private JTextField p3_0;
    private JLabel p3_0Descr;
    private JTextField p3_1;
    private JLabel p3_1Descr;
    private JTextField p3_2;
    private JLabel p3_2Descr;
    private JTextField p3_3;
    private JLabel p3_3Descr;
    private JTextField p3_4;
    private JLabel p3_4Descr;
    private JTextField p3_5;
    private JLabel p3_5Descr;
    private JTextField p3_6;
    private JLabel p3_6Descr;
    private JTextField p3_7;
    private JLabel p3_7Descr;
    private JLabel p3_label0;
    private JLabel p3_label1;
    private JLabel p3_label2;
    private JLabel p3_label3;
    private JLabel p3_label4;
    private JLabel p3_label5;
    private JLabel p3_label6;
    private JLabel p3_label7;
    private JButton parity;
    private JTextField pc;
    private JLabel pcLabel;
    private JTextField pcon;
    private JLabel pconLabel;
    private JLabel pinsLabel;
    private JTextField port0;
    private JLabel port0Label;
    private JPanel port0Panel;
    private JTextField port0pins;
    private JTextField port1;
    private JLabel port1Label;
    private JPanel port1Panel;
    private JTextField port1pins;
    private JTextField port2;
    private JLabel port2Label;
    private JPanel port2Panel;
    private JTextField port2pins;
    private JTextField port3;
    private JLabel port3Label;
    private JPanel port3Panel;
    private JTextField port3pins;
    private JPanel portPinConnectionsPanel;
    private JTextField psw;
    private JLabel pswLabel;
    private JButton copy;
    private JButton paste;
    private JButton quit;
    private JTextField memoryWindowAddressField;
    private JTextField memoryWindowByteField;
    private JTextArea memoryWindow;
    private JLabel receiverLabel;
    private JTextField register0;
    private JTextField register1;
    private JTextField register2;
    private JTextField register3;
    private JTextField register4;
    private JTextField register5;
    private JTextField register6;
    private JTextField register7;
    private JButton reset;
    private JTextArea rowAddresses;
    private JButton run;
    private JTextArea rxDataField;
    private JScrollPane rxPanel;
    private JButton rxReset;
    private JTextField rxd;
    private JLabel rxdLabel;
    private JTextField sbuf;
    private JLabel sbufLabel;
    private JTextField sbufReadOnly;
    private JLabel sbufRonlyLabel;
    private JLabel sbufWonlyLabel;
    private JTextField scon;
    private JLabel sconLabel;
    private JPanel scopeAndLabelPanel;
    private JLabel scopeLabel;
    private JLabel scopeLabel1;
    private JLabel scopeLabel2;
    private JPanel scopePanel;
    private JTextField sp;
    private JLabel spLabel;
    private JButton step;
    private JButton switch0;
    private JButton switch1;
    private JButton switch2;
    private JButton switch3;
    private JButton switch4;
    private JButton switch5;
    private JButton switch6;
    private JButton switch7;
    private JLabel switchesLabel;
    private JLabel switchesLabel1;
    private JPanel switchesPanel;
    private JTextField tcon;
    private JLabel tconLabel;
    private JTextField th0;
    private JLabel th0label;
    private JTextField th1;
    private JLabel th1label;
    private JTextField tl0;
    private JLabel tl0label;
    private JTextField tl1;
    private JLabel tl1label;
    private JTextField tmod;
    private JLabel tmodLabel;
    private JLabel transmitterLabel;
    private JTextArea txDataField;
    private JScrollPane txPanel;
    private JButton txSend;
    private JTextField txd;
    private JLabel txdLabel;
    private JLabel sysClockLabel;
    private JButton memoryTypeButton;

    public Simulator(JFrame externalFrame) {
        this.externalFrame = externalFrame;
    }

    private void organiseComponents() {
        this.components.add(this.bitFields);
        this.components.add(this.eightBitFields);
        this.components.add(this.labels);
    }

    public void init() {
        this.updateFreqPanel = new UpdateFreqPanel(this);
        this.lcdModule = new LcdModule(this.settings.isSmall());
        this.keypadTypesComboBox.setSelectedIndex(this.settings.getKeypadType());
        this.cpu = new Cpu();
        this.assembler = null;
        this.initComponents();
        this.bitFields = new JTextField[10];
        this.bitFields[0] = this.bit0;
        this.bitFields[1] = this.bit1;
        this.bitFields[2] = this.bit2;
        this.bitFields[3] = this.bit3;
        this.bitFields[4] = this.bit4;
        this.bitFields[5] = this.bit5;
        this.bitFields[6] = this.bit6;
        this.bitFields[7] = this.bit7;
        this.bitFields[8] = this.txd;
        this.bitFields[9] = this.rxd;
        this.eightBitFields = new JTextField[36];
        this.eightBitFields[0] = this.b;
        this.eightBitFields[1] = this.acc;
        this.eightBitFields[2] = this.psw;
        this.eightBitFields[3] = this.ip;
        this.eightBitFields[4] = this.ie;
        this.eightBitFields[5] = this.pcon;
        this.eightBitFields[6] = this.dph;
        this.eightBitFields[7] = this.dpl;
        this.eightBitFields[8] = this.sp;
        this.eightBitFields[9] = this.register7;
        this.eightBitFields[10] = this.register6;
        this.eightBitFields[11] = this.register5;
        this.eightBitFields[12] = this.register4;
        this.eightBitFields[13] = this.register3;
        this.eightBitFields[14] = this.register2;
        this.eightBitFields[15] = this.register1;
        this.eightBitFields[16] = this.register0;
        this.eightBitFields[17] = this.tl0;
        this.eightBitFields[18] = this.th0;
        this.eightBitFields[19] = this.tl1;
        this.eightBitFields[20] = this.th1;
        this.eightBitFields[21] = this.tmod;
        this.eightBitFields[22] = this.tcon;
        this.eightBitFields[23] = this.sbuf;
        this.eightBitFields[24] = this.sbufReadOnly;
        this.eightBitFields[25] = this.scon;
        this.eightBitFields[26] = this.port0;
        this.eightBitFields[27] = this.port1;
        this.eightBitFields[28] = this.port2;
        this.eightBitFields[29] = this.port3;
        this.eightBitFields[30] = this.port0pins;
        this.eightBitFields[31] = this.port1pins;
        this.eightBitFields[32] = this.port2pins;
        this.eightBitFields[33] = this.port3pins;
        this.eightBitFields[34] = this.bitfieldByteAddress;
        this.eightBitFields[35] = this.memoryWindowByteField;
        this.labels = new JLabel[54];
        this.labels[0] = this.bLabel;
        this.labels[1] = this.accLabel;
        this.labels[2] = this.pswLabel;
        this.labels[3] = this.ipLabel;
        this.labels[4] = this.ieLabel;
        this.labels[5] = this.pconLabel;
        this.labels[6] = this.dphLabel;
        this.labels[7] = this.dplLabel;
        this.labels[8] = this.spLabel;
        this.labels[9] = this.R7;
        this.labels[10] = this.R6;
        this.labels[11] = this.R5;
        this.labels[12] = this.R4;
        this.labels[13] = this.R3;
        this.labels[14] = this.R2;
        this.labels[15] = this.R1;
        this.labels[16] = this.R0;
        this.labels[17] = this.tl0label;
        this.labels[18] = this.th0label;
        this.labels[19] = this.tl1label;
        this.labels[20] = this.th1label;
        this.labels[21] = this.tmodLabel;
        this.labels[22] = this.tconLabel;
        this.labels[23] = this.sbufLabel;
        this.labels[24] = this.sbufRonlyLabel;
        this.labels[25] = this.sbufWonlyLabel;
        this.labels[26] = this.sconLabel;
        this.labels[27] = this.rxdLabel;
        this.labels[28] = this.txdLabel;
        this.labels[29] = this.port0Label;
        this.labels[30] = this.port1Label;
        this.labels[31] = this.port2Label;
        this.labels[32] = this.port3Label;
        this.labels[33] = this.pinsLabel;
        this.labels[34] = this.latchLabel;
        this.labels[35] = this.pcLabel;
        this.labels[36] = this.addrLabel;
        this.labels[37] = this.addLabel;
        this.labels[38] = this.dataLabel;
        this.labels[39] = this.adcLabel;
        this.labels[40] = this.adcInputLabel;
        this.labels[41] = this.keypadLabel;
        this.labels[42] = this.switchesLabel;
        this.labels[43] = this.switchesLabel1;
        this.labels[44] = this.ledsLabel;
        this.labels[45] = this.receiverLabel;
        this.labels[46] = this.transmitterLabel;
        this.labels[47] = this.baudLabel;
        this.labels[48] = this.motorCurrentHighLabel;
        this.labels[49] = this.motorCurrentLowLabel;
        this.labels[50] = this.motorLabel;
        this.labels[51] = this.scopeLabel;
        this.labels[52] = this.scopeLabel1;
        this.labels[53] = this.scopeLabel2;
        this.portPinLabels = new JLabel[64];
        this.portPinLabels[0] = this.p0_7Descr;
        this.portPinLabels[1] = this.p0_6Descr;
        this.portPinLabels[2] = this.p0_5Descr;
        this.portPinLabels[3] = this.p0_4Descr;
        this.portPinLabels[4] = this.p0_3Descr;
        this.portPinLabels[5] = this.p0_2Descr;
        this.portPinLabels[6] = this.p0_1Descr;
        this.portPinLabels[7] = this.p0_0Descr;
        this.portPinLabels[8] = this.p1_7Descr;
        this.portPinLabels[9] = this.p1_6Descr;
        this.portPinLabels[10] = this.p1_5Descr;
        this.portPinLabels[11] = this.p1_4Descr;
        this.portPinLabels[12] = this.p1_3Descr;
        this.portPinLabels[13] = this.p1_2Descr;
        this.portPinLabels[14] = this.p1_1Descr;
        this.portPinLabels[15] = this.p1_0Descr;
        this.portPinLabels[16] = this.p2_7Descr;
        this.portPinLabels[17] = this.p2_6Descr;
        this.portPinLabels[18] = this.p2_5Descr;
        this.portPinLabels[19] = this.p2_4Descr;
        this.portPinLabels[20] = this.p2_3Descr;
        this.portPinLabels[21] = this.p2_2Descr;
        this.portPinLabels[22] = this.p2_1Descr;
        this.portPinLabels[23] = this.p2_0Descr;
        this.portPinLabels[24] = this.p3_7Descr;
        this.portPinLabels[25] = this.p3_6Descr;
        this.portPinLabels[26] = this.p3_5Descr;
        this.portPinLabels[27] = this.p3_4Descr;
        this.portPinLabels[28] = this.p3_3Descr;
        this.portPinLabels[29] = this.p3_2Descr;
        this.portPinLabels[30] = this.p3_1Descr;
        this.portPinLabels[31] = this.p3_0Descr;
        this.portPinLabels[32] = this.p0_label7;
        this.portPinLabels[33] = this.p0_label6;
        this.portPinLabels[34] = this.p0_label5;
        this.portPinLabels[35] = this.p0_label4;
        this.portPinLabels[36] = this.p0_label3;
        this.portPinLabels[37] = this.p0_label2;
        this.portPinLabels[38] = this.p0_label1;
        this.portPinLabels[39] = this.p0_label0;
        this.portPinLabels[40] = this.p1_label7;
        this.portPinLabels[41] = this.p1_label6;
        this.portPinLabels[42] = this.p1_label5;
        this.portPinLabels[43] = this.p1_label4;
        this.portPinLabels[44] = this.p1_label3;
        this.portPinLabels[45] = this.p1_label2;
        this.portPinLabels[46] = this.p1_label1;
        this.portPinLabels[47] = this.p1_label0;
        this.portPinLabels[48] = this.p2_label7;
        this.portPinLabels[49] = this.p2_label6;
        this.portPinLabels[50] = this.p2_label5;
        this.portPinLabels[51] = this.p2_label4;
        this.portPinLabels[52] = this.p2_label3;
        this.portPinLabels[53] = this.p2_label2;
        this.portPinLabels[54] = this.p2_label1;
        this.portPinLabels[55] = this.p2_label0;
        this.portPinLabels[56] = this.p3_label7;
        this.portPinLabels[57] = this.p3_label6;
        this.portPinLabels[58] = this.p3_label5;
        this.portPinLabels[59] = this.p3_label4;
        this.portPinLabels[60] = this.p3_label3;
        this.portPinLabels[61] = this.p3_label2;
        this.portPinLabels[62] = this.p3_label1;
        this.portPinLabels[63] = this.p3_label0;
        this.removeAllBreakpointsButton.setEnabled(false);
        FocusManager focusManager = FocusManager.getCurrentManager();
        focusManager.clearGlobalFocusOwner();
        this.rowAddresses.setText("00\n10\n20\n30\n40\n50\n60\n70");
        this.updateMemoryWindow();
        this.initHardware();
        this.port0PinFields[0] = this.p0_0;
        this.port0PinFields[1] = this.p0_1;
        this.port0PinFields[2] = this.p0_2;
        this.port0PinFields[3] = this.p0_3;
        this.port0PinFields[4] = this.p0_4;
        this.port0PinFields[5] = this.p0_5;
        this.port0PinFields[6] = this.p0_6;
        this.port0PinFields[7] = this.p0_7;
        this.port1PinFields[0] = this.p1_0;
        this.port1PinFields[1] = this.p1_1;
        this.port1PinFields[2] = this.p1_2;
        this.port1PinFields[3] = this.p1_3;
        this.port1PinFields[4] = this.p1_4;
        this.port1PinFields[5] = this.p1_5;
        this.port1PinFields[6] = this.p1_6;
        this.port1PinFields[7] = this.p1_7;
        this.port2PinFields[0] = this.p2_0;
        this.port2PinFields[1] = this.p2_1;
        this.port2PinFields[2] = this.p2_2;
        this.port2PinFields[3] = this.p2_3;
        this.port2PinFields[4] = this.p2_4;
        this.port2PinFields[5] = this.p2_5;
        this.port2PinFields[6] = this.p2_6;
        this.port2PinFields[7] = this.p2_7;
        this.port3PinFields[0] = this.p3_0;
        this.port3PinFields[1] = this.p3_1;
        this.port3PinFields[2] = this.p3_2;
        this.port3PinFields[3] = this.p3_3;
        this.port3PinFields[4] = this.p3_4;
        this.port3PinFields[5] = this.p3_5;
        this.port3PinFields[6] = this.p3_6;
        this.port3PinFields[7] = this.p3_7;
        this.portPinTextFields = new JTextField[32];
        this.portPinTextFields[0] = this.p0_0;
        this.portPinTextFields[1] = this.p0_1;
        this.portPinTextFields[2] = this.p0_2;
        this.portPinTextFields[3] = this.p0_3;
        this.portPinTextFields[4] = this.p0_4;
        this.portPinTextFields[5] = this.p0_5;
        this.portPinTextFields[6] = this.p0_6;
        this.portPinTextFields[7] = this.p0_7;
        this.portPinTextFields[8] = this.p1_0;
        this.portPinTextFields[9] = this.p1_1;
        this.portPinTextFields[10] = this.p1_2;
        this.portPinTextFields[11] = this.p1_3;
        this.portPinTextFields[12] = this.p1_4;
        this.portPinTextFields[13] = this.p1_5;
        this.portPinTextFields[14] = this.p1_6;
        this.portPinTextFields[15] = this.p1_7;
        this.portPinTextFields[16] = this.p2_0;
        this.portPinTextFields[17] = this.p2_1;
        this.portPinTextFields[18] = this.p2_2;
        this.portPinTextFields[19] = this.p2_3;
        this.portPinTextFields[20] = this.p2_4;
        this.portPinTextFields[21] = this.p2_5;
        this.portPinTextFields[22] = this.p2_6;
        this.portPinTextFields[23] = this.p2_7;
        this.portPinTextFields[24] = this.p3_0;
        this.portPinTextFields[25] = this.p3_1;
        this.portPinTextFields[26] = this.p3_2;
        this.portPinTextFields[27] = this.p3_3;
        this.portPinTextFields[28] = this.p3_4;
        this.portPinTextFields[29] = this.p3_5;
        this.portPinTextFields[30] = this.p3_6;
        this.portPinTextFields[31] = this.p3_7;
        this.fileOpen.addActionListener(new FileAction(this));
        this.fileSave.addActionListener(new FileAction(this));
        this.clipboard = new ClipboardManager();
        this.setRegistersToolTipText();
        this.cpu.dataMemory.port3.uart.setParity(this.settings.getParity());
        this.parity.setText(this.cpu.dataMemory.port3.uart.getParityString());
        this.cpu.dataMemory.port3.uart.setBaudRate(this.baudRates[this.settings.getBaudRateIndex()]);
        if (this.settings.isMotorEnabled()) {
            this.colourBlueMotorDisableButton();
            this.cpu.dataMemory.port3.motor.enableMotor();
        } else {
            this.colourGreyMotorDisableButton();
            this.cpu.dataMemory.port3.motor.disableMotor();
        }
        if (this.settings.isKeypadAndGateEnabled()) {
            this.colourBluelueKeypadAndGateDisableButton();
            this.cpu.dataMemory.port3.keypadAndGateEnabled = true;
        } else {
            this.colourGreyKeypadAndGateDisableButton();
            this.cpu.dataMemory.port3.keypadAndGateEnabled = false;
        }
        this.controlButtons = new JButton[8];
        this.controlButtons[0] = this.reset;
        this.controlButtons[1] = this.step;
        this.controlButtons[2] = this.run;
        this.controlButtons[3] = this.fileOpen;
        this.controlButtons[4] = this.fileSave;
        this.controlButtons[5] = this.copy;
        this.controlButtons[6] = this.paste;
        this.controlButtons[7] = this.quit;
        this.organiseComponents();
    }

    public void setAssemblyCodeBoxFocus() {
        this.assemblyCodeBox.requestFocusInWindow();
    }

    public boolean isCodeSaved() {
        return this.codeSaved || this.assemblyCodeBox.getText().equals("");
    }

    public String getCode() {
        return this.assemblyCodeBox.getText();
    }

    public void setMessageBox(String text) {
        this.messageBox.setText(text);
    }

    private void resetHardware() {
        JButton b;
        int i;
        for (i = 0; i < 8; ++i) {
            this.cpu.dataMemory.port2.openSwitch(i);
            b = this.getSwitch(i);
            b.setBackground(new Color(153, 153, 255));
            b.setBorder(new BevelBorder(0));
        }
        this.cpu.dataMemory.port2.stopAllBouncing();
        for (i = 0; i < 12; ++i) {
            this.cpu.dataMemory.port0.keypad.openKey(i);
            b = this.getKey(i);
            b.setBackground(new Color(153, 153, 255));
            b.setBorder(new BevelBorder(0));
        }
        this.cpu.dataMemory.port3.addADC(this.adcSlider);
        this.cpu.dataMemory.port3.uart.resetReceiver();
        this.cpu.dataMemory.port3.uart.resetTransmitter();
        this.txSend.setText("Tx Send");
        this.txSend.setToolTipText("Click to transmit text in the Tx window (text is terminated by '\r' char)");
        this.txDataField.setEditable(true);
        this.txDataField.setBackground(Color.WHITE);
        this.cpu.dataMemory.updatePortPins();
    }

    public void zoomIn() {
        int i;
        Rectangle r = this.externalFrame.getBounds();
        if (r == null) {
            this.externalFrame.setBounds(0, 0, this.sizes.mainWindowWidthLarge, this.sizes.mainWindowHeightLarge);
            this.setBounds(0, 0, this.sizes.mainWindowWidthLarge, this.sizes.mainWindowHeightLarge);
        } else {
            r.setSize(this.sizes.mainWindowWidthLarge, this.sizes.mainWindowHeightLarge);
            this.externalFrame.setBounds(r);
            this.setBounds(r);
        }
        this.microcontroller.setMaximumSize(this.sizes.microLarge);
        this.microcontroller.setMinimumSize(this.sizes.microLarge);
        this.microcontroller.setPreferredSize(this.sizes.microLarge);
        this.microcontrollerLabel.setFont(this.sizes.microLabelLarge);
        this.sysClockLabel.setFont(this.sizes.fontBoldLarge);
        this.copyright.setFont(this.sizes.copyrightFontLarge);
        for (i = 0; i < this.bitFields.length; ++i) {
            this.bitFields[i].setMaximumSize(this.sizes.microBitFieldLarge);
            this.bitFields[i].setMinimumSize(this.sizes.microBitFieldLarge);
            this.bitFields[i].setPreferredSize(this.sizes.microBitFieldLarge);
            this.bitFields[i].setFont(this.sizes.fontLarge);
        }
        for (i = 0; i < this.eightBitFields.length; ++i) {
            this.eightBitFields[i].setMaximumSize(this.sizes.microEightBitFieldLarge);
            this.eightBitFields[i].setMinimumSize(this.sizes.microEightBitFieldLarge);
            this.eightBitFields[i].setPreferredSize(this.sizes.microEightBitFieldLarge);
            this.eightBitFields[i].setFont(this.sizes.fontLarge);
        }
        this.sysClockField.setMaximumSize(this.sizes.microSixteenBitFieldLarge);
        this.sysClockField.setMinimumSize(this.sizes.microSixteenBitFieldLarge);
        this.sysClockField.setPreferredSize(this.sizes.microSixteenBitFieldLarge);
        this.sysClockField.setFont(this.sizes.fontLarge);
        for (i = 0; i < this.labels.length; ++i) {
            this.labels[i].setFont(this.sizes.fontBoldLarge);
        }
        this.pc.setMaximumSize(this.sizes.microSixteenBitFieldLarge);
        this.pc.setMinimumSize(this.sizes.microSixteenBitFieldLarge);
        this.pc.setPreferredSize(this.sizes.microSixteenBitFieldLarge);
        this.pc.setFont(this.sizes.fontLarge);
        this.memoryWindowAddressField.setMaximumSize(this.sizes.microSixteenBitFieldLarge);
        this.memoryWindowAddressField.setMinimumSize(this.sizes.microSixteenBitFieldLarge);
        this.memoryWindowAddressField.setPreferredSize(this.sizes.microSixteenBitFieldLarge);
        this.memoryWindowAddressField.setFont(this.sizes.fontLarge);
        this.memoryTypeButton.setMaximumSize(this.sizes.memoryTypeButtonLarge);
        this.memoryTypeButton.setMinimumSize(this.sizes.memoryTypeButtonLarge);
        this.memoryTypeButton.setPreferredSize(this.sizes.memoryTypeButtonLarge);
        this.memoryTypeButton.setFont(this.sizes.fontBoldLarge);
        this.columnAddresses.setFont(this.sizes.fontBoldLarge);
        this.memoryWindow.setFont(this.sizes.fontLarge);
        this.rowAddresses.setFont(this.sizes.fontBoldLarge);
        this.removeAllBreakpointsButton.setMaximumSize(this.sizes.removeAllBreakpointsButtonLarge);
        this.removeAllBreakpointsButton.setMinimumSize(this.sizes.removeAllBreakpointsButtonLarge);
        this.removeAllBreakpointsButton.setPreferredSize(this.sizes.removeAllBreakpointsButtonLarge);
        this.removeAllBreakpointsButton.setFont(this.sizes.fontBoldLarge);
        this.updateFreqPanel.setLabelFont(this.sizes.fontBoldLarge);
        this.updateFreqPanel.setMenuFont(this.sizes.comboBoxFontLarge);
        this.updateFreqPanel.setUpdateFreqComboBoxSize(this.sizes.updateFreqComboBoxLarge);
        this.externalHardware.setMaximumSize(this.sizes.externalHardwareLarge);
        this.externalHardware.setMinimumSize(this.sizes.externalHardwareLarge);
        this.externalHardware.setPreferredSize(this.sizes.externalHardwareLarge);
        this.adcPanel.setMaximumSize(this.sizes.adcPanelLarge);
        this.adcPanel.setMinimumSize(this.sizes.adcPanelLarge);
        this.adcPanel.setPreferredSize(this.sizes.adcPanelLarge);
        this.adcSlider.setMaximumSize(this.sizes.adcSliderLarge);
        this.adcSlider.setMinimumSize(this.sizes.adcSliderLarge);
        this.adcSlider.setPreferredSize(this.sizes.adcSliderLarge);
        this.adcDisableButton.setMaximumSize(this.sizes.adcDisableButtonLarge);
        this.adcDisableButton.setMinimumSize(this.sizes.adcDisableButtonLarge);
        this.adcDisableButton.setPreferredSize(this.sizes.adcDisableButtonLarge);
        this.adcDisableButton.setFont(this.sizes.fontBoldLarge);
        this.adcVoltageField.setMaximumSize(this.sizes.voltageFieldLarge);
        this.adcVoltageField.setMinimumSize(this.sizes.voltageFieldLarge);
        this.adcVoltageField.setPreferredSize(this.sizes.voltageFieldLarge);
        this.adcVoltageField.setFont(this.sizes.voltageFieldFontLarge);
        this.multiplexedDisplayPanel.setMaximumSize(this.sizes.multiplexedDisplayPanelLarge);
        this.multiplexedDisplayPanel.setMinimumSize(this.sizes.multiplexedDisplayPanelLarge);
        this.multiplexedDisplayPanel.setPreferredSize(this.sizes.multiplexedDisplayPanelLarge);
        this.display0Panel.setMaximumSize(this.sizes.displayPanelLarge);
        this.display0Panel.setMinimumSize(this.sizes.displayPanelLarge);
        this.display0Panel.setPreferredSize(this.sizes.displayPanelLarge);
        this.display1Panel.setMaximumSize(this.sizes.displayPanelLarge);
        this.display1Panel.setMinimumSize(this.sizes.displayPanelLarge);
        this.display1Panel.setPreferredSize(this.sizes.displayPanelLarge);
        this.display2Panel.setMaximumSize(this.sizes.displayPanelLarge);
        this.display2Panel.setMinimumSize(this.sizes.displayPanelLarge);
        this.display2Panel.setPreferredSize(this.sizes.displayPanelLarge);
        this.display3Panel.setMaximumSize(this.sizes.displayPanelLarge);
        this.display3Panel.setMinimumSize(this.sizes.displayPanelLarge);
        this.display3Panel.setPreferredSize(this.sizes.displayPanelLarge);
        for (i = 0; i < this.displays.length; ++i) {
            this.displays[i].setSegmentSize(this.sizes.horizontalSevenSegmentLarge, this.sizes.verticalSevenSegmentLarge, this.sizes.dpSegmentLarge);
        }
        this.ledLcdButton.setMaximumSize(this.sizes.ledLcdButtonLarge);
        this.ledLcdButton.setMinimumSize(this.sizes.ledLcdButtonLarge);
        this.ledLcdButton.setPreferredSize(this.sizes.ledLcdButtonLarge);
        this.ledLcdButton.setFont(this.sizes.fontBoldLarge);
        this.ledLcdButtonGBC.insets = new Insets(0, 0, 0, 105);
        this.externalHardware.remove(this.ledLcdButton);
        this.externalHardware.add((Component)this.ledLcdButton, this.ledLcdButtonGBC);
        this.lcdModuleGBC.insets = new Insets(0, 0, 0, 45);
        this.externalHardware.remove(this.lcdModule.getModuleGraphics());
        this.externalHardware.add((Component)this.lcdModule.getModuleGraphics(), this.lcdModuleGBC);
        this.externalUartPanel.setMaximumSize(this.sizes.externalUartLarge);
        this.externalUartPanel.setMinimumSize(this.sizes.externalUartLarge);
        this.externalUartPanel.setPreferredSize(this.sizes.externalUartLarge);
        this.rxReset.setMaximumSize(this.sizes.externalUartButtonLarge);
        this.rxReset.setMinimumSize(this.sizes.externalUartButtonLarge);
        this.rxReset.setPreferredSize(this.sizes.externalUartButtonLarge);
        this.rxReset.setFont(this.sizes.fontBoldLarge);
        this.txSend.setMaximumSize(this.sizes.externalUartButtonLarge);
        this.txSend.setMinimumSize(this.sizes.externalUartButtonLarge);
        this.txSend.setPreferredSize(this.sizes.externalUartButtonLarge);
        this.txSend.setFont(this.sizes.fontBoldLarge);
        this.rxPanel.setMaximumSize(this.sizes.externalUartDataFieldLarge);
        this.rxPanel.setMinimumSize(this.sizes.externalUartDataFieldLarge);
        this.rxPanel.setPreferredSize(this.sizes.externalUartDataFieldLarge);
        this.txPanel.setMaximumSize(this.sizes.externalUartDataFieldLarge);
        this.txPanel.setMinimumSize(this.sizes.externalUartDataFieldLarge);
        this.txPanel.setPreferredSize(this.sizes.externalUartDataFieldLarge);
        this.parity.setMaximumSize(this.sizes.externalUartParityButtonLarge);
        this.parity.setMinimumSize(this.sizes.externalUartParityButtonLarge);
        this.parity.setPreferredSize(this.sizes.externalUartParityButtonLarge);
        this.parity.setFont(this.sizes.fontBoldLarge);
        this.baudRateComboBox.setMaximumSize(this.sizes.externalUartComboBoxLarge);
        this.baudRateComboBox.setMinimumSize(this.sizes.externalUartComboBoxLarge);
        this.baudRateComboBox.setPreferredSize(this.sizes.externalUartComboBoxLarge);
        this.baudRateComboBox.setFont(this.sizes.comboBoxFontLarge);
        for (i = 0; i < this.keypadButtons.length; ++i) {
            this.keypadButtons[i].setMaximumSize(this.sizes.keypadButtonLarge);
            this.keypadButtons[i].setMinimumSize(this.sizes.keypadButtonLarge);
            this.keypadButtons[i].setPreferredSize(this.sizes.keypadButtonLarge);
            this.keypadButtons[i].setFont(this.sizes.fontBoldLarge);
        }
        this.keypadAndGateDisableButton.setMaximumSize(this.sizes.keypadAndGateDisableButtonLarge);
        this.keypadAndGateDisableButton.setMinimumSize(this.sizes.keypadAndGateDisableButtonLarge);
        this.keypadAndGateDisableButton.setPreferredSize(this.sizes.keypadAndGateDisableButtonLarge);
        this.keypadAndGateDisableButton.setFont(this.sizes.fontBoldLarge);
        this.keypadTypesComboBox.setMaximumSize(this.sizes.keypadTypesComboBoxLarge);
        this.keypadTypesComboBox.setMinimumSize(this.sizes.keypadTypesComboBoxLarge);
        this.keypadTypesComboBox.setPreferredSize(this.sizes.keypadTypesComboBoxLarge);
        this.keypadTypesComboBox.setFont(this.sizes.comboBoxFontLarge);
        for (i = 0; i < this.leds.length; ++i) {
            this.leds[i].setMaximumSize(this.sizes.ledLarge);
            this.leds[i].setMinimumSize(this.sizes.ledLarge);
            this.leds[i].setPreferredSize(this.sizes.ledLarge);
        }
        for (i = 0; i < this.switches.length; ++i) {
            this.switches[i].setMaximumSize(this.sizes.switchLarge);
            this.switches[i].setMinimumSize(this.sizes.switchLarge);
            this.switches[i].setPreferredSize(this.sizes.switchLarge);
            this.switches[i].setFont(this.sizes.switchFontLarge);
        }
        this.motorPanel.setMaximumSize(this.sizes.motorPanelLarge);
        this.motorPanel.setMinimumSize(this.sizes.motorPanelLarge);
        this.motorPanel.setPreferredSize(this.sizes.motorPanelLarge);
        this.cpu.dataMemory.port3.motor.setPanelSize(false);
        this.motorGraphicsPanel.setMaximumSize(this.cpu.dataMemory.port3.motor.getPanelSize());
        this.motorGraphicsPanel.setMinimumSize(this.cpu.dataMemory.port3.motor.getPanelSize());
        this.motorGraphicsPanel.setPreferredSize(this.cpu.dataMemory.port3.motor.getPanelSize());
        this.motorCurrent.setMaximumSize(this.sizes.motorCurrentLarge);
        this.motorCurrent.setMinimumSize(this.sizes.motorCurrentLarge);
        this.motorCurrent.setPreferredSize(this.sizes.motorCurrentLarge);
        this.motorDisableButton.setMaximumSize(this.sizes.motorDisableButtonLarge);
        this.motorDisableButton.setMinimumSize(this.sizes.motorDisableButtonLarge);
        this.motorDisableButton.setPreferredSize(this.sizes.motorDisableButtonLarge);
        this.motorDisableButton.setFont(this.sizes.fontBoldLarge);
        this.cpu.dataMemory.port1.dac.setScale(false);
        this.scopePanel.setMaximumSize(this.sizes.scopePanelLarge);
        this.scopePanel.setMinimumSize(this.sizes.scopePanelLarge);
        this.scopePanel.setPreferredSize(this.sizes.scopePanelLarge);
        this.dacVoltageField.setMaximumSize(this.sizes.voltageFieldLarge);
        this.dacVoltageField.setMinimumSize(this.sizes.voltageFieldLarge);
        this.dacVoltageField.setPreferredSize(this.sizes.voltageFieldLarge);
        this.dacVoltageField.setFont(this.sizes.voltageFieldFontLarge);
        this.assembly.setMaximumSize(this.sizes.assemblyLarge);
        this.assembly.setMinimumSize(this.sizes.assemblyLarge);
        this.assembly.setPreferredSize(this.sizes.assemblyLarge);
        this.assemblyCodeBoxPanel.setMaximumSize(this.sizes.assemblyCodeBoxPanelLarge);
        this.assemblyCodeBoxPanel.setMinimumSize(this.sizes.assemblyCodeBoxPanelLarge);
        this.assemblyCodeBoxPanel.setPreferredSize(this.sizes.assemblyCodeBoxPanelLarge);
        this.assemblyCodeBox.setFontSize(false);
        this.messageBoxPanel.setMaximumSize(this.sizes.messageBoxPanelLarge);
        this.messageBoxPanel.setMinimumSize(this.sizes.messageBoxPanelLarge);
        this.messageBoxPanel.setPreferredSize(this.sizes.messageBoxPanelLarge);
        this.messageBox.setFont(this.sizes.fontLarge);
        this.unlockButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.unlockButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.unlockButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.unlockButton.setFont(this.sizes.fontBoldLarge);
        this.zoomButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.zoomButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.zoomButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsLarge);
        this.zoomButton.setFont(this.sizes.fontBoldLarge);
        this.controlPanel.setMaximumSize(this.sizes.controlPanelLarge);
        this.controlPanel.setMinimumSize(this.sizes.controlPanelLarge);
        this.controlPanel.setPreferredSize(this.sizes.controlPanelLarge);
        for (i = 0; i < this.controlButtons.length; ++i) {
            this.controlButtons[i].setMaximumSize(this.sizes.controlButtonLarge);
            this.controlButtons[i].setMinimumSize(this.sizes.controlButtonLarge);
            this.controlButtons[i].setPreferredSize(this.sizes.controlButtonLarge);
            this.controlButtons[i].setFont(this.sizes.fontBoldLarge);
        }
        this.portPinConnectionsPanel.setMaximumSize(this.sizes.portPinConnectionsPanelLarge);
        this.portPinConnectionsPanel.setMinimumSize(this.sizes.portPinConnectionsPanelLarge);
        this.portPinConnectionsPanel.setPreferredSize(this.sizes.portPinConnectionsPanelLarge);
        this.port0Panel.setMaximumSize(this.sizes.port0PanelLarge);
        this.port0Panel.setMinimumSize(this.sizes.port0PanelLarge);
        this.port0Panel.setPreferredSize(this.sizes.port0PanelLarge);
        this.port1Panel.setMaximumSize(this.sizes.port1PanelLarge);
        this.port1Panel.setMinimumSize(this.sizes.port1PanelLarge);
        this.port1Panel.setPreferredSize(this.sizes.port1PanelLarge);
        this.port2Panel.setMaximumSize(this.sizes.port2PanelLarge);
        this.port2Panel.setMinimumSize(this.sizes.port2PanelLarge);
        this.port2Panel.setPreferredSize(this.sizes.port2PanelLarge);
        this.port3Panel.setMaximumSize(this.sizes.port3PanelLarge);
        this.port3Panel.setMinimumSize(this.sizes.port3PanelLarge);
        this.port3Panel.setPreferredSize(this.sizes.port3PanelLarge);
        for (i = 0; i < this.portPinLabels.length; ++i) {
            this.portPinLabels[i].setFont(this.sizes.portPinFontLarge);
        }
        this.lcdModule.getModuleGraphics().setSmall(false);
    }

    public void zoomOut() {
        int i;
        Rectangle r = this.externalFrame.getBounds();
        if (r == null) {
            this.externalFrame.setBounds(0, 0, this.sizes.mainWindowWidthSmall, this.sizes.mainWindowHeightSmall);
            this.setBounds(0, 0, this.sizes.mainWindowWidthSmall, this.sizes.mainWindowHeightSmall);
        } else {
            r.setSize(this.sizes.mainWindowWidthSmall, this.sizes.mainWindowHeightSmall);
            this.externalFrame.setBounds(r);
            this.setBounds(r);
        }
        this.microcontroller.setMaximumSize(this.sizes.microSmall);
        this.microcontroller.setMinimumSize(this.sizes.microSmall);
        this.microcontroller.setPreferredSize(this.sizes.microSmall);
        this.microcontrollerLabel.setFont(this.sizes.microLabelSmall);
        this.sysClockLabel.setFont(this.sizes.fontBoldSmall);
        this.copyright.setFont(this.sizes.copyrightFontSmall);
        for (i = 0; i < this.bitFields.length; ++i) {
            this.bitFields[i].setMaximumSize(this.sizes.microBitFieldSmall);
            this.bitFields[i].setMinimumSize(this.sizes.microBitFieldSmall);
            this.bitFields[i].setPreferredSize(this.sizes.microBitFieldSmall);
            this.bitFields[i].setFont(this.sizes.fontSmall);
        }
        for (i = 0; i < this.eightBitFields.length; ++i) {
            this.eightBitFields[i].setMaximumSize(this.sizes.microEightBitFieldSmall);
            this.eightBitFields[i].setMinimumSize(this.sizes.microEightBitFieldSmall);
            this.eightBitFields[i].setPreferredSize(this.sizes.microEightBitFieldSmall);
            this.eightBitFields[i].setFont(this.sizes.fontSmall);
        }
        this.sysClockField.setMaximumSize(this.sizes.microSixteenBitFieldSmall);
        this.sysClockField.setMinimumSize(this.sizes.microSixteenBitFieldSmall);
        this.sysClockField.setPreferredSize(this.sizes.microSixteenBitFieldSmall);
        this.sysClockField.setFont(this.sizes.fontSmall);
        for (i = 0; i < this.labels.length; ++i) {
            this.labels[i].setFont(this.sizes.fontBoldSmall);
        }
        this.pc.setMaximumSize(this.sizes.microSixteenBitFieldSmall);
        this.pc.setMinimumSize(this.sizes.microSixteenBitFieldSmall);
        this.pc.setPreferredSize(this.sizes.microSixteenBitFieldSmall);
        this.pc.setFont(this.sizes.fontSmall);
        this.memoryWindowAddressField.setMaximumSize(this.sizes.microSixteenBitFieldSmall);
        this.memoryWindowAddressField.setMinimumSize(this.sizes.microSixteenBitFieldSmall);
        this.memoryWindowAddressField.setPreferredSize(this.sizes.microSixteenBitFieldSmall);
        this.memoryWindowAddressField.setFont(this.sizes.fontSmall);
        this.memoryTypeButton.setMaximumSize(this.sizes.memoryTypeButtonSmall);
        this.memoryTypeButton.setMinimumSize(this.sizes.memoryTypeButtonSmall);
        this.memoryTypeButton.setPreferredSize(this.sizes.memoryTypeButtonSmall);
        this.memoryTypeButton.setFont(this.sizes.fontBoldSmall);
        this.columnAddresses.setFont(this.sizes.fontBoldSmall);
        this.memoryWindow.setFont(this.sizes.fontSmall);
        this.rowAddresses.setFont(this.sizes.fontBoldSmall);
        this.removeAllBreakpointsButton.setMaximumSize(this.sizes.removeAllBreakpointsButtonSmall);
        this.removeAllBreakpointsButton.setMinimumSize(this.sizes.removeAllBreakpointsButtonSmall);
        this.removeAllBreakpointsButton.setPreferredSize(this.sizes.removeAllBreakpointsButtonSmall);
        this.removeAllBreakpointsButton.setFont(this.sizes.fontBoldSmall);
        this.updateFreqPanel.setLabelFont(this.sizes.fontBoldSmall);
        this.updateFreqPanel.setMenuFont(this.sizes.comboBoxFontSmall);
        this.updateFreqPanel.setUpdateFreqComboBoxSize(this.sizes.updateFreqComboBoxSmall);
        this.externalHardware.setMaximumSize(this.sizes.externalHardwareSmall);
        this.externalHardware.setMinimumSize(this.sizes.externalHardwareSmall);
        this.externalHardware.setPreferredSize(this.sizes.externalHardwareSmall);
        this.adcPanel.setMaximumSize(this.sizes.adcPanelSmall);
        this.adcPanel.setMinimumSize(this.sizes.adcPanelSmall);
        this.adcPanel.setPreferredSize(this.sizes.adcPanelSmall);
        this.adcSlider.setMaximumSize(this.sizes.adcSliderSmall);
        this.adcSlider.setMinimumSize(this.sizes.adcSliderSmall);
        this.adcSlider.setPreferredSize(this.sizes.adcSliderSmall);
        this.adcDisableButton.setMaximumSize(this.sizes.adcDisableButtonSmall);
        this.adcDisableButton.setMinimumSize(this.sizes.adcDisableButtonSmall);
        this.adcDisableButton.setPreferredSize(this.sizes.adcDisableButtonSmall);
        this.adcDisableButton.setFont(this.sizes.fontBoldSmall);
        this.adcVoltageField.setMaximumSize(this.sizes.voltageFieldSmall);
        this.adcVoltageField.setMinimumSize(this.sizes.voltageFieldSmall);
        this.adcVoltageField.setPreferredSize(this.sizes.voltageFieldSmall);
        this.adcVoltageField.setFont(this.sizes.voltageFieldFontSmall);
        this.multiplexedDisplayPanel.setMaximumSize(this.sizes.multiplexedDisplayPanelSmall);
        this.multiplexedDisplayPanel.setMinimumSize(this.sizes.multiplexedDisplayPanelSmall);
        this.multiplexedDisplayPanel.setPreferredSize(this.sizes.multiplexedDisplayPanelSmall);
        this.display0Panel.setMaximumSize(this.sizes.displayPanelSmall);
        this.display0Panel.setMinimumSize(this.sizes.displayPanelSmall);
        this.display0Panel.setPreferredSize(this.sizes.displayPanelSmall);
        this.display0Panel.setMaximumSize(this.sizes.displayPanelSmall);
        this.display0Panel.setMinimumSize(this.sizes.displayPanelSmall);
        this.display0Panel.setPreferredSize(this.sizes.displayPanelSmall);
        this.display1Panel.setMaximumSize(this.sizes.displayPanelSmall);
        this.display1Panel.setMinimumSize(this.sizes.displayPanelSmall);
        this.display1Panel.setPreferredSize(this.sizes.displayPanelSmall);
        this.display2Panel.setMaximumSize(this.sizes.displayPanelSmall);
        this.display2Panel.setMinimumSize(this.sizes.displayPanelSmall);
        this.display2Panel.setPreferredSize(this.sizes.displayPanelSmall);
        this.display3Panel.setMaximumSize(this.sizes.displayPanelSmall);
        this.display3Panel.setMinimumSize(this.sizes.displayPanelSmall);
        this.display3Panel.setPreferredSize(this.sizes.displayPanelSmall);
        for (i = 0; i < this.displays.length; ++i) {
            this.displays[i].setSegmentSize(this.sizes.horizontalSevenSegmentSmall, this.sizes.verticalSevenSegmentSmall, this.sizes.dpSegmentSmall);
        }
        this.ledLcdButton.setMaximumSize(this.sizes.ledLcdButtonSmall);
        this.ledLcdButton.setMinimumSize(this.sizes.ledLcdButtonSmall);
        this.ledLcdButton.setPreferredSize(this.sizes.ledLcdButtonSmall);
        this.ledLcdButton.setFont(this.sizes.fontBoldSmall);
        this.ledLcdButtonGBC.insets = new Insets(0, 0, 0, 70);
        this.externalHardware.remove(this.ledLcdButton);
        this.externalHardware.add((Component)this.ledLcdButton, this.ledLcdButtonGBC);
        this.lcdModuleGBC.insets = new Insets(0, 0, 0, 25);
        this.externalHardware.remove(this.lcdModule.getModuleGraphics());
        this.externalHardware.add((Component)this.lcdModule.getModuleGraphics(), this.lcdModuleGBC);
        this.externalUartPanel.setMaximumSize(this.sizes.externalUartSmall);
        this.externalUartPanel.setMinimumSize(this.sizes.externalUartSmall);
        this.externalUartPanel.setPreferredSize(this.sizes.externalUartSmall);
        this.rxReset.setMaximumSize(this.sizes.externalUartButtonSmall);
        this.rxReset.setMinimumSize(this.sizes.externalUartButtonSmall);
        this.rxReset.setPreferredSize(this.sizes.externalUartButtonSmall);
        this.rxReset.setFont(this.sizes.fontBoldSmall);
        this.txSend.setMaximumSize(this.sizes.externalUartButtonSmall);
        this.txSend.setMinimumSize(this.sizes.externalUartButtonSmall);
        this.txSend.setPreferredSize(this.sizes.externalUartButtonSmall);
        this.txSend.setFont(this.sizes.fontBoldSmall);
        this.rxPanel.setMaximumSize(this.sizes.externalUartDataFieldSmall);
        this.rxPanel.setMinimumSize(this.sizes.externalUartDataFieldSmall);
        this.rxPanel.setPreferredSize(this.sizes.externalUartDataFieldSmall);
        this.txPanel.setMaximumSize(this.sizes.externalUartDataFieldSmall);
        this.txPanel.setMinimumSize(this.sizes.externalUartDataFieldSmall);
        this.txPanel.setPreferredSize(this.sizes.externalUartDataFieldSmall);
        this.parity.setMaximumSize(this.sizes.externalUartParityButtonSmall);
        this.parity.setMinimumSize(this.sizes.externalUartParityButtonSmall);
        this.parity.setPreferredSize(this.sizes.externalUartParityButtonSmall);
        this.parity.setFont(this.sizes.fontBoldSmall);
        this.baudRateComboBox.setMaximumSize(this.sizes.externalUartComboBoxSmall);
        this.baudRateComboBox.setMinimumSize(this.sizes.externalUartComboBoxSmall);
        this.baudRateComboBox.setPreferredSize(this.sizes.externalUartComboBoxSmall);
        this.baudRateComboBox.setFont(this.sizes.comboBoxFontSmall);
        for (i = 0; i < this.keypadButtons.length; ++i) {
            this.keypadButtons[i].setMaximumSize(this.sizes.keypadButtonSmall);
            this.keypadButtons[i].setMinimumSize(this.sizes.keypadButtonSmall);
            this.keypadButtons[i].setPreferredSize(this.sizes.keypadButtonSmall);
            this.keypadButtons[i].setFont(this.sizes.fontBoldSmall);
        }
        this.keypadAndGateDisableButton.setMaximumSize(this.sizes.keypadAndGateDisableButtonSmall);
        this.keypadAndGateDisableButton.setMinimumSize(this.sizes.keypadAndGateDisableButtonSmall);
        this.keypadAndGateDisableButton.setPreferredSize(this.sizes.keypadAndGateDisableButtonSmall);
        this.keypadAndGateDisableButton.setFont(this.sizes.fontBoldSmall);
        this.keypadTypesComboBox.setMaximumSize(this.sizes.keypadTypesComboBoxSmall);
        this.keypadTypesComboBox.setMinimumSize(this.sizes.keypadTypesComboBoxSmall);
        this.keypadTypesComboBox.setPreferredSize(this.sizes.keypadTypesComboBoxSmall);
        this.keypadTypesComboBox.setFont(this.sizes.comboBoxFontSmall);
        for (i = 0; i < this.leds.length; ++i) {
            this.leds[i].setMaximumSize(this.sizes.ledSmall);
            this.leds[i].setMinimumSize(this.sizes.ledSmall);
            this.leds[i].setPreferredSize(this.sizes.ledSmall);
        }
        for (i = 0; i < this.switches.length; ++i) {
            this.switches[i].setMaximumSize(this.sizes.switchSmall);
            this.switches[i].setMinimumSize(this.sizes.switchSmall);
            this.switches[i].setPreferredSize(this.sizes.switchSmall);
            this.switches[i].setFont(this.sizes.switchFontSmall);
        }
        this.motorPanel.setMaximumSize(this.sizes.motorPanelSmall);
        this.motorPanel.setMinimumSize(this.sizes.motorPanelSmall);
        this.motorPanel.setPreferredSize(this.sizes.motorPanelSmall);
        this.cpu.dataMemory.port3.motor.setPanelSize(true);
        this.motorGraphicsPanel.setMaximumSize(this.cpu.dataMemory.port3.motor.getPanelSize());
        this.motorGraphicsPanel.setMinimumSize(this.cpu.dataMemory.port3.motor.getPanelSize());
        this.motorGraphicsPanel.setPreferredSize(this.cpu.dataMemory.port3.motor.getPanelSize());
        this.motorCurrent.setMaximumSize(this.sizes.motorCurrentSmall);
        this.motorCurrent.setMinimumSize(this.sizes.motorCurrentSmall);
        this.motorCurrent.setPreferredSize(this.sizes.motorCurrentSmall);
        this.motorDisableButton.setMaximumSize(this.sizes.motorDisableButtonSmall);
        this.motorDisableButton.setMinimumSize(this.sizes.motorDisableButtonSmall);
        this.motorDisableButton.setPreferredSize(this.sizes.motorDisableButtonSmall);
        this.motorDisableButton.setFont(this.sizes.fontBoldSmall);
        this.cpu.dataMemory.port1.dac.setScale(true);
        this.scopePanel.setMaximumSize(this.sizes.scopePanelSmall);
        this.scopePanel.setMinimumSize(this.sizes.scopePanelSmall);
        this.scopePanel.setPreferredSize(this.sizes.scopePanelSmall);
        this.dacVoltageField.setMaximumSize(this.sizes.voltageFieldSmall);
        this.dacVoltageField.setMinimumSize(this.sizes.voltageFieldSmall);
        this.dacVoltageField.setPreferredSize(this.sizes.voltageFieldSmall);
        this.dacVoltageField.setFont(this.sizes.voltageFieldFontSmall);
        this.assembly.setMaximumSize(this.sizes.assemblySmall);
        this.assembly.setMinimumSize(this.sizes.assemblySmall);
        this.assembly.setPreferredSize(this.sizes.assemblySmall);
        this.assemblyCodeBoxPanel.setMaximumSize(this.sizes.assemblyCodeBoxPanelSmall);
        this.assemblyCodeBoxPanel.setMinimumSize(this.sizes.assemblyCodeBoxPanelSmall);
        this.assemblyCodeBoxPanel.setPreferredSize(this.sizes.assemblyCodeBoxPanelSmall);
        this.assemblyCodeBox.setFontSize(true);
        this.messageBoxPanel.setMaximumSize(this.sizes.messageBoxPanelSmall);
        this.messageBoxPanel.setMinimumSize(this.sizes.messageBoxPanelSmall);
        this.messageBoxPanel.setPreferredSize(this.sizes.messageBoxPanelSmall);
        this.messageBox.setFont(this.sizes.fontSmall);
        this.unlockButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.unlockButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.unlockButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.unlockButton.setFont(this.sizes.fontBoldSmall);
        this.zoomButton.setMaximumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.zoomButton.setMinimumSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.zoomButton.setPreferredSize(this.sizes.zoomAndUnlockButtonsSmall);
        this.zoomButton.setFont(this.sizes.fontBoldSmall);
        this.controlPanel.setMaximumSize(this.sizes.controlPanelSmall);
        this.controlPanel.setMinimumSize(this.sizes.controlPanelSmall);
        this.controlPanel.setPreferredSize(this.sizes.controlPanelSmall);
        for (i = 0; i < this.controlButtons.length; ++i) {
            this.controlButtons[i].setMaximumSize(this.sizes.controlButtonSmall);
            this.controlButtons[i].setMinimumSize(this.sizes.controlButtonSmall);
            this.controlButtons[i].setPreferredSize(this.sizes.controlButtonSmall);
            this.controlButtons[i].setFont(this.sizes.fontBoldSmall);
        }
        this.portPinConnectionsPanel.setMaximumSize(this.sizes.portPinConnectionsPanelSmall);
        this.portPinConnectionsPanel.setMinimumSize(this.sizes.portPinConnectionsPanelSmall);
        this.portPinConnectionsPanel.setPreferredSize(this.sizes.portPinConnectionsPanelSmall);
        this.port0Panel.setMaximumSize(this.sizes.port0PanelSmall);
        this.port0Panel.setMinimumSize(this.sizes.port0PanelSmall);
        this.port0Panel.setPreferredSize(this.sizes.port0PanelSmall);
        this.port1Panel.setMaximumSize(this.sizes.port1PanelSmall);
        this.port1Panel.setMinimumSize(this.sizes.port1PanelSmall);
        this.port1Panel.setPreferredSize(this.sizes.port1PanelSmall);
        this.port2Panel.setMaximumSize(this.sizes.port2PanelSmall);
        this.port2Panel.setMinimumSize(this.sizes.port2PanelSmall);
        this.port2Panel.setPreferredSize(this.sizes.port2PanelSmall);
        this.port3Panel.setMaximumSize(this.sizes.port3PanelSmall);
        this.port3Panel.setMinimumSize(this.sizes.port3PanelSmall);
        this.port3Panel.setPreferredSize(this.sizes.port3PanelSmall);
        for (i = 0; i < this.portPinLabels.length; ++i) {
            this.portPinLabels[i].setFont(this.sizes.portPinFontSmall);
        }
        this.lcdModule.getModuleGraphics().setSmall(true);
    }

    private void zoomWindowButtonPressed() {
        if (this.settings.isSmall()) {
            this.settings.setSmall(false);
            this.zoomButton.setText("-");
            this.zoomButton.setToolTipText("Zoom out main window");
            this.zoomIn();
        } else {
            this.settings.setSmall(true);
            this.zoomButton.setText("+");
            this.zoomButton.setToolTipText("Zoom in main window");
            this.zoomOut();
        }
    }

    private void openUnlockedAssemblyCodeBox() {
        if (this.unlockedAssemblyCodeFrame == null) {
            this.unlockedAssemblyCodeFrame = new UnlockedAssemblyCodeFrame(this);
        }
        this.assemblyCodeBoxPanel.remove(this.assemblyCodeBox);
        this.assembly.repaint();
        this.unlockedAssemblyCodeFrame.addSourceWindow(this.assemblyCodeBox);
        this.unlockedAssemblyCodeFrame.setVisible(true);
    }

    public void unlockedAssemblyCodeBoxClosed() {
        this.assemblyCodeBoxPanel.remove(this.assemblyCodeBox);
        this.assemblyCodeBoxPanel.setViewportView(this.assemblyCodeBox);
        this.assemblyCodeBox.requestFocusInWindow();
    }

    private void setRegistersToolTipText() {
        try {
            this.R0.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(0)));
            this.R1.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(1)));
            this.R2.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(2)));
            this.R3.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(3)));
            this.R4.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(4)));
            this.R5.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(5)));
            this.R6.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(6)));
            this.R7.setToolTipText("addr: " + Text.inHex(this.cpu.dataMemory.getRegisterAddress(7)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initHardware() {
        SevenSegDisplay display3;
        SevenSegDisplay display2;
        SevenSegDisplay display1;
        SevenSegDisplay display0;
        this.displays = new SevenSegDisplay[4];
        this.displays[0] = display0 = new SevenSegDisplay(this.a0, this.b0, this.c0, this.d0, this.e0, this.f0, this.g0, this.dp0);
        this.displays[1] = display1 = new SevenSegDisplay(this.a1, this.b1, this.c1, this.d1, this.e1, this.f1, this.g1, this.dp1);
        this.displays[2] = display2 = new SevenSegDisplay(this.a2, this.b2, this.c2, this.d2, this.e2, this.f2, this.g2, this.dp2);
        this.displays[3] = display3 = new SevenSegDisplay(this.a3, this.b3, this.c3, this.d3, this.e3, this.f3, this.g3, this.dp3);
        this.cpu.dataMemory.port1.addLcdModule(this.lcdModule);
        this.cpu.dataMemory.port1.addLedDisplays(this.displays);
        this.cpu.dataMemory.port3.addDisplays(this.displays);
        this.leds = new JTextField[8];
        this.leds[0] = this.led0;
        this.leds[1] = this.led1;
        this.leds[2] = this.led2;
        this.leds[3] = this.led3;
        this.leds[4] = this.led4;
        this.leds[5] = this.led5;
        this.leds[6] = this.led6;
        this.leds[7] = this.led7;
        this.cpu.dataMemory.port1.addLeds(this.leds);
        this.cpu.dataMemory.port1.addDAC(Color.BLACK, Color.GREEN, this.settings.isSmall());
        this.scopePanel.add(this.cpu.dataMemory.port1.dac);
        this.cpu.dataMemory.port3.addMotor(this.settings.isSmall());
        this.motorGraphicsPanel.add(this.cpu.dataMemory.port3.motor.graphicsPanel);
        this.cpu.dataMemory.port3.addADC(this.adcSlider);
        this.sysClockField.setText(String.valueOf(this.settings.getSystemFreq()));
        this.cpu.dataMemory.port3.addExternalUart(this.rxDataField, this.txDataField, this.settings.getSystemFreq());
        this.cpu.dataMemory.port3.addComparator();
        this.cpu.dataMemory.updatePortPins();
    }

    /*
     * Opcode count of 20615 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void initComponents() {
        this.memoryTypeButton = new JButton();
        this.externalHardware = new JPanel();
        this.keypadPanel = new JPanel();
        this.key0 = new JButton();
        this.key1 = new JButton();
        this.key2 = new JButton();
        this.key3 = new JButton();
        this.key4 = new JButton();
        this.key5 = new JButton();
        this.key6 = new JButton();
        this.key7 = new JButton();
        this.key8 = new JButton();
        this.key9 = new JButton();
        this.key10 = new JButton();
        this.key11 = new JButton();
        this.keypadButtons = new JButton[12];
        this.keypadButtons[0] = this.key0;
        this.keypadButtons[1] = this.key1;
        this.keypadButtons[2] = this.key2;
        this.keypadButtons[3] = this.key3;
        this.keypadButtons[4] = this.key4;
        this.keypadButtons[5] = this.key5;
        this.keypadButtons[6] = this.key6;
        this.keypadButtons[7] = this.key7;
        this.keypadButtons[8] = this.key8;
        this.keypadButtons[9] = this.key9;
        this.keypadButtons[10] = this.key10;
        this.keypadButtons[11] = this.key11;
        this.motorPanel = new JPanel();
        this.motorCurrent = new JSlider();
        this.motorCurrentHighLabel = new JLabel();
        this.motorCurrentLowLabel = new JLabel();
        this.motorLabel = new JLabel();
        this.motorGraphicsPanel = new JPanel();
        this.switchesPanel = new JPanel();
        this.switch0 = new JButton();
        this.switch1 = new JButton();
        this.switch2 = new JButton();
        this.switch3 = new JButton();
        this.switch4 = new JButton();
        this.switch5 = new JButton();
        this.switch6 = new JButton();
        this.switch7 = new JButton();
        this.switches = new JButton[8];
        this.switches[0] = this.switch0;
        this.switches[1] = this.switch1;
        this.switches[2] = this.switch2;
        this.switches[3] = this.switch3;
        this.switches[4] = this.switch4;
        this.switches[5] = this.switch5;
        this.switches[6] = this.switch6;
        this.switches[7] = this.switch7;
        this.switchesLabel = new JLabel();
        this.switchesLabel1 = new JLabel();
        this.ledsPanel = new JPanel();
        this.led0 = new JTextField();
        this.led1 = new JTextField();
        this.led2 = new JTextField();
        this.led3 = new JTextField();
        this.led4 = new JTextField();
        this.led5 = new JTextField();
        this.led6 = new JTextField();
        this.led7 = new JTextField();
        this.ledsLabel = new JLabel();
        this.motorDisableButton = new JButton();
        this.keypadAndGateDisableButton = new JButton();
        this.adcPanel = new JPanel();
        this.adcSlider = new JSlider();
        this.adcLabel = new JLabel();
        this.adcInputPanel = new JPanel();
        this.adcInputLabel = new JLabel();
        this.adcVoltageField = new JTextField();
        this.keypadLabel = new JLabel();
        this.externalUartPanel = new JPanel();
        this.baudLabel = new JLabel();
        this.receiverLabel = new JLabel();
        this.transmitterLabel = new JLabel();
        this.rxReset = new JButton();
        this.txSend = new JButton();
        this.rxPanel = new JScrollPane();
        this.rxDataField = new JTextArea();
        this.txPanel = new JScrollPane();
        this.txDataField = new JTextArea();
        this.parity = new JButton();
        this.multiplexedDisplayPanel = new JPanel();
        this.display0Panel = new JPanel();
        this.a0 = new JTextField();
        this.b0 = new JTextField();
        this.c0 = new JTextField();
        this.d0 = new JTextField();
        this.e0 = new JTextField();
        this.f0 = new JTextField();
        this.g0 = new JTextField();
        this.dp0 = new JTextField();
        this.display1Panel = new JPanel();
        this.a1 = new JTextField();
        this.b1 = new JTextField();
        this.c1 = new JTextField();
        this.d1 = new JTextField();
        this.e1 = new JTextField();
        this.f1 = new JTextField();
        this.g1 = new JTextField();
        this.dp1 = new JTextField();
        this.display2Panel = new JPanel();
        this.a2 = new JTextField();
        this.b2 = new JTextField();
        this.c2 = new JTextField();
        this.d2 = new JTextField();
        this.e2 = new JTextField();
        this.f2 = new JTextField();
        this.g2 = new JTextField();
        this.dp2 = new JTextField();
        this.display3Panel = new JPanel();
        this.a3 = new JTextField();
        this.b3 = new JTextField();
        this.c3 = new JTextField();
        this.d3 = new JTextField();
        this.e3 = new JTextField();
        this.f3 = new JTextField();
        this.g3 = new JTextField();
        this.dp3 = new JTextField();
        this.adcDisableButton = new JButton();
        this.scopeAndLabelPanel = new JPanel();
        this.scopeLabel = new JLabel();
        this.scopeLabel1 = new JLabel();
        this.scopeLabel2 = new JLabel();
        this.dacVoltageField = new JTextField();
        this.scopePanel = new JPanel();
        this.microcontroller = new JPanel();
        this.R7 = new JLabel();
        this.R6 = new JLabel();
        this.R5 = new JLabel();
        this.R4 = new JLabel();
        this.R3 = new JLabel();
        this.R2 = new JLabel();
        this.R1 = new JLabel();
        this.R0 = new JLabel();
        this.register7 = new JTextField();
        this.register6 = new JTextField();
        this.register5 = new JTextField();
        this.register4 = new JTextField();
        this.register3 = new JTextField();
        this.register2 = new JTextField();
        this.register1 = new JTextField();
        this.register0 = new JTextField();
        this.accLabel = new JLabel();
        this.acc = new JTextField();
        this.pswLabel = new JLabel();
        this.port1 = new JTextField();
        this.port1Label = new JLabel();
        this.port1pins = new JTextField();
        this.latchLabel = new JLabel();
        this.addrLabel = new JLabel();
        this.microcontrollerLabel = new JLabel();
        this.port2Label = new JLabel();
        this.port2 = new JTextField();
        this.port2pins = new JTextField();
        this.port3pins = new JTextField();
        this.port0pins = new JTextField();
        this.port3 = new JTextField();
        this.port0 = new JTextField();
        this.port3Label = new JLabel();
        this.port0Label = new JLabel();
        this.memoryWindow = new JTextArea();
        this.columnAddresses = new JTextField();
        this.rowAddresses = new JTextArea();
        this.pinsLabel = new JLabel();
        this.memoryWindowByteField = new JTextField();
        this.memoryWindowAddressField = new JTextField();
        this.addLabel = new JLabel();
        this.dataLabel = new JLabel();
        this.th0 = new JTextField();
        this.th0label = new JLabel();
        this.tl0label = new JLabel();
        this.tl0 = new JTextField();
        this.tmod = new JTextField();
        this.tmodLabel = new JLabel();
        this.th1 = new JTextField();
        this.tl1 = new JTextField();
        this.th1label = new JLabel();
        this.tl1label = new JLabel();
        this.tconLabel = new JLabel();
        this.tcon = new JTextField();
        this.scon = new JTextField();
        this.sconLabel = new JLabel();
        this.sbufLabel = new JLabel();
        this.sbuf = new JTextField();
        this.txd = new JTextField();
        this.rxdLabel = new JLabel();
        this.txdLabel = new JLabel();
        this.sbufReadOnly = new JTextField();
        this.sbufRonlyLabel = new JLabel();
        this.sbufWonlyLabel = new JLabel();
        this.rxd = new JTextField();
        this.pc = new JTextField();
        this.pcLabel = new JLabel();
        this.psw = new JTextField();
        this.spLabel = new JLabel();
        this.sp = new JTextField();
        this.ipLabel = new JLabel();
        this.ip = new JTextField();
        this.ieLabel = new JLabel();
        this.ie = new JTextField();
        this.bitfieldPanel = new JPanel();
        this.bit0 = new JTextField();
        this.bit1 = new JTextField();
        this.bit2 = new JTextField();
        this.bit3 = new JTextField();
        this.bit4 = new JTextField();
        this.bit5 = new JTextField();
        this.bit6 = new JTextField();
        this.bit7 = new JTextField();
        this.bitfieldByteAddress = new JTextField();
        this.copyright = new JLabel();
        this.dph = new JTextField();
        this.dphLabel = new JLabel();
        this.dpl = new JTextField();
        this.dplLabel = new JLabel();
        this.b = new JTextField();
        this.bLabel = new JLabel();
        this.pcon = new JTextField();
        this.pconLabel = new JLabel();
        this.assembly = new JPanel();
        this.messageBoxPanel = new JScrollPane();
        this.messageBox = new JTextField();
        this.portPinConnectionsPanel = new JPanel();
        this.port0Panel = new JPanel();
        this.p0_label0 = new JLabel();
        this.p0_label1 = new JLabel();
        this.p0_label2 = new JLabel();
        this.p0_label3 = new JLabel();
        this.p0_label4 = new JLabel();
        this.p0_label5 = new JLabel();
        this.p0_label6 = new JLabel();
        this.p0_label7 = new JLabel();
        this.p0_0 = new JTextField();
        this.p0_1 = new JTextField();
        this.p0_2 = new JTextField();
        this.p0_3 = new JTextField();
        this.p0_4 = new JTextField();
        this.p0_5 = new JTextField();
        this.p0_6 = new JTextField();
        this.p0_7 = new JTextField();
        this.p0_0Descr = new JLabel();
        this.p0_1Descr = new JLabel();
        this.p0_2Descr = new JLabel();
        this.p0_3Descr = new JLabel();
        this.p0_4Descr = new JLabel();
        this.p0_5Descr = new JLabel();
        this.p0_6Descr = new JLabel();
        this.p0_7Descr = new JLabel();
        this.port1Panel = new JPanel();
        this.p1_label0 = new JLabel();
        this.p1_label1 = new JLabel();
        this.p1_label2 = new JLabel();
        this.p1_label3 = new JLabel();
        this.p1_label4 = new JLabel();
        this.p1_label5 = new JLabel();
        this.p1_label6 = new JLabel();
        this.p1_label7 = new JLabel();
        this.p1_0 = new JTextField();
        this.p1_1 = new JTextField();
        this.p1_2 = new JTextField();
        this.p1_3 = new JTextField();
        this.p1_4 = new JTextField();
        this.p1_5 = new JTextField();
        this.p1_6 = new JTextField();
        this.p1_7 = new JTextField();
        this.p1_0Descr = new JLabel();
        this.p1_1Descr = new JLabel();
        this.p1_2Descr = new JLabel();
        this.p1_3Descr = new JLabel();
        this.p1_4Descr = new JLabel();
        this.p1_5Descr = new JLabel();
        this.p1_6Descr = new JLabel();
        this.p1_7Descr = new JLabel();
        this.port2Panel = new JPanel();
        this.p2_label0 = new JLabel();
        this.p2_label1 = new JLabel();
        this.p2_label2 = new JLabel();
        this.p2_label3 = new JLabel();
        this.p2_label4 = new JLabel();
        this.p2_label5 = new JLabel();
        this.p2_label6 = new JLabel();
        this.p2_label7 = new JLabel();
        this.p2_0 = new JTextField();
        this.p2_1 = new JTextField();
        this.p2_2 = new JTextField();
        this.p2_3 = new JTextField();
        this.p2_4 = new JTextField();
        this.p2_5 = new JTextField();
        this.p2_6 = new JTextField();
        this.p2_7 = new JTextField();
        this.p2_0Descr = new JLabel();
        this.p2_1Descr = new JLabel();
        this.p2_2Descr = new JLabel();
        this.p2_3Descr = new JLabel();
        this.p2_4Descr = new JLabel();
        this.p2_5Descr = new JLabel();
        this.p2_6Descr = new JLabel();
        this.p2_7Descr = new JLabel();
        this.port3Panel = new JPanel();
        this.p3_label0 = new JLabel();
        this.p3_label1 = new JLabel();
        this.p3_label2 = new JLabel();
        this.p3_label3 = new JLabel();
        this.p3_label4 = new JLabel();
        this.p3_label5 = new JLabel();
        this.p3_label6 = new JLabel();
        this.p3_label7 = new JLabel();
        this.p3_0 = new JTextField();
        this.p3_1 = new JTextField();
        this.p3_2 = new JTextField();
        this.p3_3 = new JTextField();
        this.p3_4 = new JTextField();
        this.p3_5 = new JTextField();
        this.p3_6 = new JTextField();
        this.p3_7 = new JTextField();
        this.p3_0Descr = new JLabel();
        this.p3_1Descr = new JLabel();
        this.p3_2Descr = new JLabel();
        this.p3_3Descr = new JLabel();
        this.p3_4Descr = new JLabel();
        this.p3_5Descr = new JLabel();
        this.p3_6Descr = new JLabel();
        this.p3_7Descr = new JLabel();
        this.controlPanel = new JPanel();
        this.run = new JButton();
        this.copy = new JButton();
        this.paste = new JButton();
        this.quit = new JButton();
        this.fileOpen = new JButton();
        this.reset = new JButton();
        this.step = new JButton();
        this.fileSave = new JButton();
        this.assemblyCodeBoxPanel = new JScrollPane();
        this.sysClockLabel = new JLabel("System Clock (MHz)");
        this.setLayout(new GridBagLayout());
        this.externalHardware.setLayout(new GridBagLayout());
        this.externalHardware.setBackground(new Color(204, 255, 102));
        this.externalHardware.setBorder(new BevelBorder(0));
        this.externalHardware.setMaximumSize(new Dimension(1024, 210));
        this.externalHardware.setMinimumSize(new Dimension(1024, 210));
        this.externalHardware.setPreferredSize(new Dimension(1024, 210));
        this.keypadPanel.setLayout(new GridBagLayout());
        this.keypadPanel.setBackground(new Color(153, 255, 102));
        this.keypadPanel.setToolTipText("Connected to P0");
        this.keypadPanel.setMaximumSize(new Dimension(48, 64));
        this.key0.setBackground(new Color(153, 153, 255));
        this.key0.setText(this.settings.getKeypadLabel(0));
        this.key0.setToolTipText("Right-click to change label");
        this.key0.setBorder(new BevelBorder(0));
        this.key0.setMargin(new Insets(1, 1, 1, 1));
        this.key0.setMaximumSize(new Dimension(16, 16));
        this.key0.setMinimumSize(new Dimension(16, 16));
        this.key0.setPreferredSize(new Dimension(16, 16));
        this.key0.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key0MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.keypadPanel.add((Component)this.key0, gridBagConstraints);
        this.key1.setBackground(new Color(153, 153, 255));
        this.key1.setText(this.settings.getKeypadLabel(1));
        this.key1.setToolTipText("Right-click to change label");
        this.key1.setBorder(new BevelBorder(0));
        this.key1.setMargin(new Insets(1, 1, 1, 1));
        this.key1.setMaximumSize(new Dimension(16, 16));
        this.key1.setMinimumSize(new Dimension(16, 16));
        this.key1.setPreferredSize(new Dimension(16, 16));
        this.key1.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.keypadPanel.add((Component)this.key1, gridBagConstraints);
        this.key2.setBackground(new Color(153, 153, 255));
        this.key2.setText(this.settings.getKeypadLabel(2));
        this.key2.setToolTipText("Right-click to change label");
        this.key2.setBorder(new BevelBorder(0));
        this.key2.setMargin(new Insets(1, 1, 1, 1));
        this.key2.setMaximumSize(new Dimension(16, 16));
        this.key2.setMinimumSize(new Dimension(16, 16));
        this.key2.setPreferredSize(new Dimension(16, 16));
        this.key2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key2MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.keypadPanel.add((Component)this.key2, gridBagConstraints);
        this.key3.setBackground(new Color(153, 153, 255));
        this.key3.setText(this.settings.getKeypadLabel(3));
        this.key3.setToolTipText("Right-click to change label");
        this.key3.setBorder(new BevelBorder(0));
        this.key3.setMargin(new Insets(1, 1, 1, 1));
        this.key3.setMaximumSize(new Dimension(16, 16));
        this.key3.setMinimumSize(new Dimension(16, 16));
        this.key3.setPreferredSize(new Dimension(16, 16));
        this.key3.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key3MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.keypadPanel.add((Component)this.key3, gridBagConstraints);
        this.key4.setBackground(new Color(153, 153, 255));
        this.key4.setText(this.settings.getKeypadLabel(4));
        this.key4.setToolTipText("Right-click to change label");
        this.key4.setBorder(new BevelBorder(0));
        this.key4.setMargin(new Insets(1, 1, 1, 1));
        this.key4.setMaximumSize(new Dimension(16, 16));
        this.key4.setMinimumSize(new Dimension(16, 16));
        this.key4.setPreferredSize(new Dimension(16, 16));
        this.key4.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key4MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.keypadPanel.add((Component)this.key4, gridBagConstraints);
        this.key5.setBackground(new Color(153, 153, 255));
        this.key5.setText(this.settings.getKeypadLabel(5));
        this.key5.setToolTipText("Right-click to change label");
        this.key5.setBorder(new BevelBorder(0));
        this.key5.setMargin(new Insets(1, 1, 1, 1));
        this.key5.setMaximumSize(new Dimension(16, 16));
        this.key5.setMinimumSize(new Dimension(16, 16));
        this.key5.setPreferredSize(new Dimension(16, 16));
        this.key5.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key5MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.keypadPanel.add((Component)this.key5, gridBagConstraints);
        this.key6.setBackground(new Color(153, 153, 255));
        this.key6.setText(this.settings.getKeypadLabel(6));
        this.key6.setToolTipText("Right-click to change label");
        this.key6.setBorder(new BevelBorder(0));
        this.key6.setMargin(new Insets(1, 1, 1, 1));
        this.key6.setMaximumSize(new Dimension(16, 16));
        this.key6.setMinimumSize(new Dimension(16, 16));
        this.key6.setPreferredSize(new Dimension(16, 16));
        this.key6.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key6MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.keypadPanel.add((Component)this.key6, gridBagConstraints);
        this.key7.setBackground(new Color(153, 153, 255));
        this.key7.setText(this.settings.getKeypadLabel(7));
        this.key7.setToolTipText("Right-click to change label");
        this.key7.setBorder(new BevelBorder(0));
        this.key7.setMargin(new Insets(1, 1, 1, 1));
        this.key7.setMaximumSize(new Dimension(16, 16));
        this.key7.setMinimumSize(new Dimension(16, 16));
        this.key7.setPreferredSize(new Dimension(16, 16));
        this.key7.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key7MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.keypadPanel.add((Component)this.key7, gridBagConstraints);
        this.key8.setBackground(new Color(153, 153, 255));
        this.key8.setText(this.settings.getKeypadLabel(8));
        this.key8.setToolTipText("Right-click to change label");
        this.key8.setBorder(new BevelBorder(0));
        this.key8.setMargin(new Insets(1, 1, 1, 1));
        this.key8.setMaximumSize(new Dimension(16, 16));
        this.key8.setMinimumSize(new Dimension(16, 16));
        this.key8.setPreferredSize(new Dimension(16, 16));
        this.key8.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key8MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.keypadPanel.add((Component)this.key8, gridBagConstraints);
        this.key9.setBackground(new Color(153, 153, 255));
        this.key9.setText(this.settings.getKeypadLabel(9));
        this.key9.setToolTipText("Right-click to change label");
        this.key9.setBorder(new BevelBorder(0));
        this.key9.setMargin(new Insets(1, 1, 1, 1));
        this.key9.setMaximumSize(new Dimension(16, 16));
        this.key9.setMinimumSize(new Dimension(16, 16));
        this.key9.setPreferredSize(new Dimension(16, 16));
        this.key9.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key9MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.keypadPanel.add((Component)this.key9, gridBagConstraints);
        this.key10.setBackground(new Color(153, 153, 255));
        this.key10.setText(this.settings.getKeypadLabel(10));
        this.key10.setToolTipText("Right-click to change label");
        this.key10.setBorder(new BevelBorder(0));
        this.key10.setMargin(new Insets(1, 1, 1, 1));
        this.key10.setMaximumSize(new Dimension(16, 16));
        this.key10.setMinimumSize(new Dimension(16, 16));
        this.key10.setPreferredSize(new Dimension(16, 16));
        this.key10.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key10MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.keypadPanel.add((Component)this.key10, gridBagConstraints);
        this.key11.setBackground(new Color(153, 153, 255));
        this.key11.setText(this.settings.getKeypadLabel(11));
        this.key11.setToolTipText("Right-click to change label");
        this.key11.setBorder(new BevelBorder(0));
        this.key11.setMargin(new Insets(1, 1, 1, 1));
        this.key11.setMaximumSize(new Dimension(16, 16));
        this.key11.setMinimumSize(new Dimension(16, 16));
        this.key11.setPreferredSize(new Dimension(16, 16));
        this.key11.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Simulator.this.key11MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                if (Simulator.this.settings.getKeypadType() == 1) {
                    Simulator.this.openAllKeys();
                    Simulator.this.keypadGuiUpdate();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.keypadPanel.add((Component)this.key11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.externalHardware.add((Component)this.keypadPanel, gridBagConstraints);
        this.keypadAndGateDisableButton.setFont(new Font("Dialog", 1, 10));
        this.keypadAndGateDisableButton.setToolTipText("Enable keypad AND gate for interrupt-driven keypad (display multiplexing will not work as both AND gate and display-select decoder share P3.3)");
        this.keypadAndGateDisableButton.setMargin(new Insets(1, 2, 1, 2));
        this.keypadAndGateDisableButton.setMaximumSize(new Dimension(90, 21));
        this.keypadAndGateDisableButton.setMinimumSize(new Dimension(90, 21));
        this.keypadAndGateDisableButton.setPreferredSize(new Dimension(90, 21));
        this.keypadAndGateDisableButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.keypadAndGateDisableMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.externalHardware.add((Component)this.keypadAndGateDisableButton, gridBagConstraints);
        this.keypadTypesComboBox.setFont(new Font("Monospaced", 1, 10));
        this.keypadTypesComboBox.setMaximumSize(new Dimension(80, 18));
        this.keypadTypesComboBox.setMinimumSize(new Dimension(80, 18));
        this.keypadTypesComboBox.setPreferredSize(new Dimension(80, 18));
        this.keypadTypesComboBox.setToolTipText("Select the keypad mode from the list");
        this.keypadTypesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.keypadTypesComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.externalHardware.add((Component)this.keypadTypesComboBox, gridBagConstraints);
        this.bounceBox.setText("Key/Switch Bounce");
        this.bounceBox.setSelected(this.settings.isBounce());
        this.bounceBox.setBackground(this.externalHardware.getBackground());
        this.bounceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bounceBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.externalHardware.add((Component)this.bounceBox, gridBagConstraints);
        this.motorPanel.setLayout(new GridBagLayout());
        this.motorPanel.setBackground(new Color(255, 255, 255));
        this.motorPanel.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(0, 0, 0), 2)));
        this.motorPanel.setToolTipText("Motor control on P3.1 and P3.0");
        this.motorPanel.setMaximumSize(new Dimension(125, 110));
        this.motorPanel.setMinimumSize(new Dimension(125, 110));
        this.motorPanel.setPreferredSize(new Dimension(125, 110));
        this.motorCurrent.setMaximum(10);
        this.motorCurrent.setMinimum(0);
        this.motorCurrent.setValue(5);
        this.motorCurrent.setOrientation(1);
        this.motorCurrent.setToolTipText("Motor current potentiometer");
        this.motorCurrent.setMaximumSize(new Dimension(16, 70));
        this.motorCurrent.setMinimumSize(new Dimension(16, 70));
        this.motorCurrent.setPreferredSize(new Dimension(16, 70));
        this.motorCurrent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Simulator.this.motorCurrentStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.motorPanel.add((Component)this.motorCurrent, gridBagConstraints);
        this.motorCurrentHighLabel.setFont(new Font("Monospaced", 1, 12));
        this.motorCurrentHighLabel.setHorizontalAlignment(0);
        this.motorCurrentHighLabel.setText("MAX");
        this.motorCurrentHighLabel.setToolTipText("Max current - motor runs fastest");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.motorPanel.add((Component)this.motorCurrentHighLabel, gridBagConstraints);
        this.motorCurrentLowLabel.setFont(new Font("Monospaced", 1, 12));
        this.motorCurrentLowLabel.setHorizontalAlignment(0);
        this.motorCurrentLowLabel.setText("MIN");
        this.motorCurrentLowLabel.setToolTipText("Min current - motor runs slowest");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.motorPanel.add((Component)this.motorCurrentLowLabel, gridBagConstraints);
        this.motorLabel.setFont(new Font("Monospaced", 1, 12));
        this.motorLabel.setHorizontalAlignment(0);
        this.motorLabel.setText("DC Motor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 15;
        this.motorPanel.add((Component)this.motorLabel, gridBagConstraints);
        this.motorGraphicsPanel.setLayout(new GridBagLayout());
        this.motorGraphicsPanel.setToolTipText("Motor sensor on P3.5 - when red sensor output is 0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(0, 4, 0, 6);
        this.motorPanel.add((Component)this.motorGraphicsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.externalHardware.add((Component)this.motorPanel, gridBagConstraints);
        this.switchesPanel.setLayout(new GridBagLayout());
        this.switchesPanel.setBackground(new Color(204, 255, 102));
        this.switchesPanel.setToolTipText("Connected to P2 - make sure these swithes are open (blue) when using the ADC");
        this.switch0.setBackground(new Color(153, 153, 255));
        this.switch0.setFont(new Font("Monospaced", 1, 10));
        this.switch0.setText(this.settings.getSwitchLabel(0));
        this.switch0.setToolTipText("SW0: Right-click to change label");
        this.switch0.setBorder(new BevelBorder(0));
        this.switch0.setMargin(new Insets(1, 1, 1, 1));
        this.switch0.setMaximumSize(new Dimension(12, 12));
        this.switch0.setMinimumSize(new Dimension(12, 12));
        this.switch0.setPreferredSize(new Dimension(12, 12));
        this.switch0.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch0MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.switchesPanel.add((Component)this.switch0, gridBagConstraints);
        this.switch1.setBackground(new Color(153, 153, 255));
        this.switch1.setFont(new Font("Monospaced", 1, 10));
        this.switch1.setText(this.settings.getSwitchLabel(1));
        this.switch1.setToolTipText("SW1: Right-click to change label");
        this.switch1.setBorder(new BevelBorder(0));
        this.switch1.setMargin(new Insets(1, 1, 1, 1));
        this.switch1.setMaximumSize(new Dimension(12, 12));
        this.switch1.setMinimumSize(new Dimension(12, 12));
        this.switch1.setPreferredSize(new Dimension(12, 12));
        this.switch1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch1MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.switchesPanel.add((Component)this.switch1, gridBagConstraints);
        this.switch2.setBackground(new Color(153, 153, 255));
        this.switch2.setFont(new Font("Monospaced", 1, 10));
        this.switch2.setText(this.settings.getSwitchLabel(2));
        this.switch2.setToolTipText("SW2: Right-click to change label");
        this.switch2.setBorder(new BevelBorder(0));
        this.switch2.setMargin(new Insets(1, 1, 1, 1));
        this.switch2.setMaximumSize(new Dimension(12, 12));
        this.switch2.setMinimumSize(new Dimension(12, 12));
        this.switch2.setPreferredSize(new Dimension(12, 12));
        this.switch2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch2MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.switchesPanel.add((Component)this.switch2, gridBagConstraints);
        this.switch3.setBackground(new Color(153, 153, 255));
        this.switch3.setFont(new Font("Monospaced", 1, 10));
        this.switch3.setText(this.settings.getSwitchLabel(3));
        this.switch3.setToolTipText("SW3: Right-click to change label");
        this.switch3.setBorder(new BevelBorder(0));
        this.switch3.setMargin(new Insets(1, 1, 1, 1));
        this.switch3.setMaximumSize(new Dimension(12, 12));
        this.switch3.setMinimumSize(new Dimension(12, 12));
        this.switch3.setPreferredSize(new Dimension(12, 12));
        this.switch3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch3MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.switchesPanel.add((Component)this.switch3, gridBagConstraints);
        this.switch4.setBackground(new Color(153, 153, 255));
        this.switch4.setFont(new Font("Monospaced", 1, 10));
        this.switch4.setText(this.settings.getSwitchLabel(4));
        this.switch4.setToolTipText("SW4: Right-click to change label");
        this.switch4.setBorder(new BevelBorder(0));
        this.switch4.setMargin(new Insets(1, 1, 1, 1));
        this.switch4.setMaximumSize(new Dimension(12, 12));
        this.switch4.setMinimumSize(new Dimension(12, 12));
        this.switch4.setPreferredSize(new Dimension(12, 12));
        this.switch4.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch4MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.switchesPanel.add((Component)this.switch4, gridBagConstraints);
        this.switch5.setBackground(new Color(153, 153, 255));
        this.switch5.setFont(new Font("Monospaced", 1, 10));
        this.switch5.setText(this.settings.getSwitchLabel(5));
        this.switch5.setToolTipText("SW5: Right-click to change label");
        this.switch5.setBorder(new BevelBorder(0));
        this.switch5.setMargin(new Insets(1, 1, 1, 1));
        this.switch5.setMaximumSize(new Dimension(12, 12));
        this.switch5.setMinimumSize(new Dimension(12, 12));
        this.switch5.setPreferredSize(new Dimension(12, 12));
        this.switch5.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch5MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.switchesPanel.add((Component)this.switch5, gridBagConstraints);
        this.switch6.setBackground(new Color(153, 153, 255));
        this.switch6.setFont(new Font("Monospaced", 1, 10));
        this.switch6.setText(this.settings.getSwitchLabel(6));
        this.switch6.setToolTipText("SW6: Right-click to change label");
        this.switch6.setBorder(new BevelBorder(0));
        this.switch6.setMargin(new Insets(1, 1, 1, 1));
        this.switch6.setMaximumSize(new Dimension(12, 12));
        this.switch6.setMinimumSize(new Dimension(12, 12));
        this.switch6.setPreferredSize(new Dimension(12, 12));
        this.switch6.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch6MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.switchesPanel.add((Component)this.switch6, gridBagConstraints);
        this.switch7.setBackground(new Color(153, 153, 255));
        this.switch7.setFont(new Font("Monospaced", 1, 10));
        this.switch7.setText(this.settings.getSwitchLabel(7));
        this.switch7.setToolTipText("SW7: Right-click to change label");
        this.switch7.setBorder(new BevelBorder(0));
        this.switch7.setMargin(new Insets(1, 1, 1, 1));
        this.switch7.setMaximumSize(new Dimension(12, 12));
        this.switch7.setMinimumSize(new Dimension(12, 12));
        this.switch7.setPreferredSize(new Dimension(12, 12));
        this.switch7.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.switch7MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.switchesPanel.add((Component)this.switch7, gridBagConstraints);
        this.switchesLabel.setFont(new Font("Monospaced", 1, 12));
        this.switchesLabel.setHorizontalAlignment(0);
        this.switchesLabel.setText("Switch");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        this.switchesPanel.add((Component)this.switchesLabel, gridBagConstraints);
        this.switchesLabel1.setFont(new Font("Monospaced", 1, 12));
        this.switchesLabel1.setHorizontalAlignment(0);
        this.switchesLabel1.setText("Bank");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.switchesPanel.add((Component)this.switchesLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.externalHardware.add((Component)this.switchesPanel, gridBagConstraints);
        this.ledsPanel.setLayout(new GridBagLayout());
        this.ledsPanel.setBackground(new Color(204, 255, 102));
        this.led0.setEditable(false);
        this.led0.setToolTipText("LED 0");
        this.led0.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led0.setMaximumSize(new Dimension(10, 10));
        this.led0.setMinimumSize(new Dimension(10, 10));
        this.led0.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.ledsPanel.add((Component)this.led0, gridBagConstraints);
        this.led1.setEditable(false);
        this.led1.setToolTipText("LED 1");
        this.led1.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led1.setMaximumSize(new Dimension(10, 10));
        this.led1.setMinimumSize(new Dimension(10, 10));
        this.led1.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.ledsPanel.add((Component)this.led1, gridBagConstraints);
        this.led2.setEditable(false);
        this.led2.setToolTipText("LED 2");
        this.led2.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led2.setMaximumSize(new Dimension(10, 10));
        this.led2.setMinimumSize(new Dimension(10, 10));
        this.led2.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.ledsPanel.add((Component)this.led2, gridBagConstraints);
        this.led3.setEditable(false);
        this.led3.setToolTipText("LED 3");
        this.led3.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led3.setMaximumSize(new Dimension(10, 10));
        this.led3.setMinimumSize(new Dimension(10, 10));
        this.led3.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.ledsPanel.add((Component)this.led3, gridBagConstraints);
        this.led4.setEditable(false);
        this.led4.setToolTipText("LED 4");
        this.led4.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led4.setMaximumSize(new Dimension(10, 10));
        this.led4.setMinimumSize(new Dimension(10, 10));
        this.led4.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.ledsPanel.add((Component)this.led4, gridBagConstraints);
        this.led5.setEditable(false);
        this.led5.setToolTipText("LED 5");
        this.led5.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led5.setMaximumSize(new Dimension(10, 10));
        this.led5.setMinimumSize(new Dimension(10, 10));
        this.led5.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.ledsPanel.add((Component)this.led5, gridBagConstraints);
        this.led6.setEditable(false);
        this.led6.setToolTipText("LED 6");
        this.led6.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led6.setMaximumSize(new Dimension(10, 10));
        this.led6.setMinimumSize(new Dimension(10, 10));
        this.led6.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.ledsPanel.add((Component)this.led6, gridBagConstraints);
        this.led7.setEditable(false);
        this.led7.setToolTipText("LED 7");
        this.led7.setBorder(new LineBorder(new Color(153, 204, 255), 2));
        this.led7.setMaximumSize(new Dimension(10, 10));
        this.led7.setMinimumSize(new Dimension(10, 10));
        this.led7.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.ledsPanel.add((Component)this.led7, gridBagConstraints);
        this.ledsLabel.setFont(new Font("Monospaced", 1, 12));
        this.ledsLabel.setHorizontalAlignment(0);
        this.ledsLabel.setText("LEDs");
        this.ledsLabel.setToolTipText("LEDs connected to P1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.ledsPanel.add((Component)this.ledsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.externalHardware.add((Component)this.ledsPanel, gridBagConstraints);
        this.motorDisableButton.setFont(new Font("Dialog", 1, 10));
        this.motorDisableButton.setMargin(new Insets(1, 2, 1, 2));
        this.motorDisableButton.setMaximumSize(new Dimension(90, 21));
        this.motorDisableButton.setMinimumSize(new Dimension(90, 21));
        this.motorDisableButton.setPreferredSize(new Dimension(90, 21));
        this.motorDisableButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.motorDisableMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.externalHardware.add((Component)this.motorDisableButton, gridBagConstraints);
        this.adcPanel.setLayout(new GridBagLayout());
        this.adcPanel.setBackground(new Color(255, 255, 255));
        this.adcPanel.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(0, 0, 0), 2)));
        this.adcPanel.setToolTipText("Connected to P2 - make sure the switch bank switches are open (blue) when using the ADC");
        this.adcPanel.setMaximumSize(new Dimension(85, 100));
        this.adcPanel.setMinimumSize(new Dimension(85, 100));
        this.adcPanel.setPreferredSize(new Dimension(85, 100));
        this.adcSlider.setMaximum(255);
        this.adcSlider.setOrientation(1);
        this.adcSlider.setToolTipText("Analogue voltage applied to both the ADC analogue input and the comparator non-inverting input");
        this.adcSlider.setValue(0);
        this.adcSlider.setMaximumSize(new Dimension(16, 70));
        this.adcSlider.setMinimumSize(new Dimension(16, 70));
        this.adcSlider.setPreferredSize(new Dimension(16, 70));
        this.adcSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                Simulator.this.adcSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.adcPanel.add((Component)this.adcSlider, gridBagConstraints);
        this.adcLabel.setFont(new Font("Monospaced", 1, 12));
        this.adcLabel.setHorizontalAlignment(0);
        this.adcLabel.setText("ADC");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.adcPanel.add((Component)this.adcLabel, gridBagConstraints);
        this.adcInputPanel.setLayout(new GridBagLayout());
        this.adcInputPanel.setBackground(new Color(255, 255, 255));
        this.adcInputLabel.setFont(new Font("Monospaced", 1, 12));
        this.adcInputLabel.setHorizontalAlignment(0);
        this.adcInputLabel.setText("input");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        this.adcInputPanel.add((Component)this.adcInputLabel, gridBagConstraints);
        this.adcVoltageField.setFont(new Font("Monospaced", 0, 10));
        this.adcVoltageField.setText("0.00 V");
        this.adcVoltageField.setToolTipText("Analogue input voltage");
        this.adcVoltageField.setMaximumSize(new Dimension(42, 19));
        this.adcVoltageField.setMinimumSize(new Dimension(42, 19));
        this.adcVoltageField.setPreferredSize(new Dimension(42, 19));
        this.adcVoltageField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.adcVoltageFieldActionPerformed(evt);
            }
        });
        this.adcVoltageField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.adcVoltageFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.adcInputPanel.add((Component)this.adcVoltageField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.adcPanel.add((Component)this.adcInputPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        this.externalHardware.add((Component)this.adcPanel, gridBagConstraints);
        this.keypadLabel.setFont(new Font("Monospaced", 1, 12));
        this.keypadLabel.setHorizontalAlignment(0);
        this.keypadLabel.setText("Keypad");
        this.keypadLabel.setToolTipText("Connected to P0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.externalHardware.add((Component)this.keypadLabel, gridBagConstraints);
        this.externalUartPanel.setLayout(new GridBagLayout());
        this.externalUartPanel.setBackground(new Color(153, 153, 255));
        this.externalUartPanel.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(0, 0, 0), 2)));
        this.externalUartPanel.setToolTipText("External UART");
        this.externalUartPanel.setMaximumSize(new Dimension(310, 115));
        this.externalUartPanel.setMinimumSize(new Dimension(310, 115));
        this.externalUartPanel.setPreferredSize(new Dimension(310, 115));
        this.baudLabel.setFont(new Font("Monospaced", 1, 12));
        this.baudLabel.setHorizontalAlignment(0);
        this.baudLabel.setText("8-bit UART @");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.externalUartPanel.add((Component)this.baudLabel, gridBagConstraints);
        this.receiverLabel.setFont(new Font("Monospaced", 1, 12));
        this.receiverLabel.setHorizontalAlignment(0);
        this.receiverLabel.setText("Rx");
        this.receiverLabel.setToolTipText("Connected to 8051 TXD (P3.1)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 3);
        this.externalUartPanel.add((Component)this.receiverLabel, gridBagConstraints);
        this.transmitterLabel.setFont(new Font("Monospaced", 1, 12));
        this.transmitterLabel.setHorizontalAlignment(0);
        this.transmitterLabel.setText("Tx");
        this.transmitterLabel.setToolTipText("Connected to 8051 RXD (P3.0)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 3);
        this.externalUartPanel.add((Component)this.transmitterLabel, gridBagConstraints);
        this.rxReset.setFont(new Font("Monospaced", 1, 12));
        this.rxReset.setText("Rx Reset");
        this.rxReset.setToolTipText("Click to clear the Rx window");
        this.rxReset.setMargin(new Insets(2, 2, 2, 2));
        this.rxReset.setMaximumSize(new Dimension(67, 17));
        this.rxReset.setMinimumSize(new Dimension(67, 17));
        this.rxReset.setPreferredSize(new Dimension(67, 17));
        this.rxReset.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.rxResetMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.externalUartPanel.add((Component)this.rxReset, gridBagConstraints);
        this.txSend.setFont(new Font("Monospaced", 1, 12));
        this.txSend.setText("Tx Send");
        this.txSend.setToolTipText("Click to transmit text in the Tx window (text is terminated by '\\r' char)");
        this.txSend.setMargin(new Insets(2, 2, 2, 2));
        this.txSend.setMaximumSize(new Dimension(67, 17));
        this.txSend.setMinimumSize(new Dimension(67, 17));
        this.txSend.setPreferredSize(new Dimension(67, 17));
        this.txSend.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.txSendMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.externalUartPanel.add((Component)this.txSend, gridBagConstraints);
        this.rxPanel.setMaximumSize(new Dimension(200, 40));
        this.rxPanel.setMinimumSize(new Dimension(200, 40));
        this.rxPanel.setPreferredSize(new Dimension(200, 40));
        this.rxDataField.setBackground(new Color(204, 204, 204));
        this.rxDataField.setEditable(false);
        this.rxDataField.setTabSize(4);
        this.rxDataField.setToolTipText("Received Data");
        this.rxPanel.setViewportView(this.rxDataField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 0, 1, 0);
        this.externalUartPanel.add((Component)this.rxPanel, gridBagConstraints);
        this.txPanel.setMaximumSize(new Dimension(200, 40));
        this.txPanel.setMinimumSize(new Dimension(200, 40));
        this.txPanel.setPreferredSize(new Dimension(200, 40));
        this.txDataField.setTabSize(4);
        this.txDataField.setToolTipText("Data For Transmission");
        this.txPanel.setViewportView(this.txDataField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.externalUartPanel.add((Component)this.txPanel, gridBagConstraints);
        this.parity.setFont(new Font("Monospaced", 1, 12));
        this.parity.setToolTipText("Click to change between no parity, odd parity and  even parity");
        this.parity.setMargin(new Insets(2, 2, 2, 2));
        this.parity.setMaximumSize(new Dimension(87, 17));
        this.parity.setMinimumSize(new Dimension(87, 17));
        this.parity.setPreferredSize(new Dimension(87, 17));
        this.parity.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.parityMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.externalUartPanel.add((Component)this.parity, gridBagConstraints);
        this.baudRateComboBox.setFont(new Font("Monospaced", 1, 10));
        this.baudRateComboBox.setMaximumSize(new Dimension(85, 18));
        this.baudRateComboBox.setMinimumSize(new Dimension(85, 18));
        this.baudRateComboBox.setPreferredSize(new Dimension(85, 18));
        this.baudRateComboBox.setToolTipText("Select a Baud rate from the list");
        this.baudRateComboBox.setSelectedIndex(this.settings.getBaudRateIndex());
        this.baudRateComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.baudRateComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.externalUartPanel.add((Component)this.baudRateComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.externalHardware.add((Component)this.externalUartPanel, gridBagConstraints);
        this.multiplexedDisplayPanel.setLayout(new GridBagLayout());
        this.multiplexedDisplayPanel.setBorder(new BevelBorder(0));
        this.multiplexedDisplayPanel.setBackground(new Color(0, 0, 0));
        this.display0Panel.setLayout(new GridBagLayout());
        this.display0Panel.setBackground(new Color(0, 0, 0));
        this.display0Panel.setToolTipText("Display 0");
        this.a0.setEditable(false);
        this.a0.setMaximumSize(new Dimension(20, 5));
        this.a0.setMinimumSize(new Dimension(20, 5));
        this.a0.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.display0Panel.add((Component)this.a0, gridBagConstraints);
        this.b0.setEditable(false);
        this.b0.setMaximumSize(new Dimension(5, 12));
        this.b0.setMinimumSize(new Dimension(5, 12));
        this.b0.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.display0Panel.add((Component)this.b0, gridBagConstraints);
        this.c0.setEditable(false);
        this.c0.setMaximumSize(new Dimension(5, 12));
        this.c0.setMinimumSize(new Dimension(5, 12));
        this.c0.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.display0Panel.add((Component)this.c0, gridBagConstraints);
        this.d0.setEditable(false);
        this.d0.setMaximumSize(new Dimension(20, 5));
        this.d0.setMinimumSize(new Dimension(20, 5));
        this.d0.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.display0Panel.add((Component)this.d0, gridBagConstraints);
        this.e0.setEditable(false);
        this.e0.setMaximumSize(new Dimension(5, 12));
        this.e0.setMinimumSize(new Dimension(5, 12));
        this.e0.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.display0Panel.add((Component)this.e0, gridBagConstraints);
        this.f0.setEditable(false);
        this.f0.setMaximumSize(new Dimension(5, 12));
        this.f0.setMinimumSize(new Dimension(5, 12));
        this.f0.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.display0Panel.add((Component)this.f0, gridBagConstraints);
        this.g0.setEditable(false);
        this.g0.setMaximumSize(new Dimension(20, 5));
        this.g0.setMinimumSize(new Dimension(20, 5));
        this.g0.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.display0Panel.add((Component)this.g0, gridBagConstraints);
        this.dp0.setEditable(false);
        this.dp0.setMaximumSize(new Dimension(5, 5));
        this.dp0.setMinimumSize(new Dimension(5, 5));
        this.dp0.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.display0Panel.add((Component)this.dp0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.multiplexedDisplayPanel.add((Component)this.display0Panel, gridBagConstraints);
        this.display1Panel.setLayout(new GridBagLayout());
        this.display1Panel.setBackground(new Color(0, 0, 0));
        this.display1Panel.setToolTipText("Display 1");
        this.display1Panel.setMaximumSize(new Dimension(40, 47));
        this.display1Panel.setMinimumSize(new Dimension(40, 47));
        this.display1Panel.setPreferredSize(new Dimension(40, 47));
        this.a1.setEditable(false);
        this.a1.setMaximumSize(new Dimension(20, 5));
        this.a1.setMinimumSize(new Dimension(20, 5));
        this.a1.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.display1Panel.add((Component)this.a1, gridBagConstraints);
        this.b1.setEditable(false);
        this.b1.setMaximumSize(new Dimension(5, 12));
        this.b1.setMinimumSize(new Dimension(5, 12));
        this.b1.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.display1Panel.add((Component)this.b1, gridBagConstraints);
        this.c1.setEditable(false);
        this.c1.setMaximumSize(new Dimension(5, 12));
        this.c1.setMinimumSize(new Dimension(5, 12));
        this.c1.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.display1Panel.add((Component)this.c1, gridBagConstraints);
        this.d1.setEditable(false);
        this.d1.setMaximumSize(new Dimension(20, 5));
        this.d1.setMinimumSize(new Dimension(20, 5));
        this.d1.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.display1Panel.add((Component)this.d1, gridBagConstraints);
        this.e1.setEditable(false);
        this.e1.setMaximumSize(new Dimension(5, 12));
        this.e1.setMinimumSize(new Dimension(5, 12));
        this.e1.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.display1Panel.add((Component)this.e1, gridBagConstraints);
        this.f1.setEditable(false);
        this.f1.setMaximumSize(new Dimension(5, 12));
        this.f1.setMinimumSize(new Dimension(5, 12));
        this.f1.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.display1Panel.add((Component)this.f1, gridBagConstraints);
        this.g1.setEditable(false);
        this.g1.setMaximumSize(new Dimension(20, 5));
        this.g1.setMinimumSize(new Dimension(20, 5));
        this.g1.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.display1Panel.add((Component)this.g1, gridBagConstraints);
        this.dp1.setEditable(false);
        this.dp1.setMaximumSize(new Dimension(5, 5));
        this.dp1.setMinimumSize(new Dimension(5, 5));
        this.dp1.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.display1Panel.add((Component)this.dp1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.multiplexedDisplayPanel.add((Component)this.display1Panel, gridBagConstraints);
        this.display2Panel.setLayout(new GridBagLayout());
        this.display2Panel.setBackground(new Color(0, 0, 0));
        this.display2Panel.setToolTipText("Display 2");
        this.display2Panel.setMaximumSize(new Dimension(40, 47));
        this.display2Panel.setMinimumSize(new Dimension(40, 47));
        this.display2Panel.setPreferredSize(new Dimension(40, 47));
        this.a2.setEditable(false);
        this.a2.setMaximumSize(new Dimension(20, 5));
        this.a2.setMinimumSize(new Dimension(20, 5));
        this.a2.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.display2Panel.add((Component)this.a2, gridBagConstraints);
        this.b2.setEditable(false);
        this.b2.setMaximumSize(new Dimension(5, 12));
        this.b2.setMinimumSize(new Dimension(5, 12));
        this.b2.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.display2Panel.add((Component)this.b2, gridBagConstraints);
        this.c2.setEditable(false);
        this.c2.setMaximumSize(new Dimension(5, 12));
        this.c2.setMinimumSize(new Dimension(5, 12));
        this.c2.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.display2Panel.add((Component)this.c2, gridBagConstraints);
        this.d2.setEditable(false);
        this.d2.setMaximumSize(new Dimension(20, 5));
        this.d2.setMinimumSize(new Dimension(20, 5));
        this.d2.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.display2Panel.add((Component)this.d2, gridBagConstraints);
        this.e2.setEditable(false);
        this.e2.setMaximumSize(new Dimension(5, 12));
        this.e2.setMinimumSize(new Dimension(5, 12));
        this.e2.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.display2Panel.add((Component)this.e2, gridBagConstraints);
        this.f2.setEditable(false);
        this.f2.setMaximumSize(new Dimension(5, 12));
        this.f2.setMinimumSize(new Dimension(5, 12));
        this.f2.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.display2Panel.add((Component)this.f2, gridBagConstraints);
        this.g2.setEditable(false);
        this.g2.setMaximumSize(new Dimension(20, 5));
        this.g2.setMinimumSize(new Dimension(20, 5));
        this.g2.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.display2Panel.add((Component)this.g2, gridBagConstraints);
        this.dp2.setEditable(false);
        this.dp2.setMaximumSize(new Dimension(5, 5));
        this.dp2.setMinimumSize(new Dimension(5, 5));
        this.dp2.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.display2Panel.add((Component)this.dp2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.multiplexedDisplayPanel.add((Component)this.display2Panel, gridBagConstraints);
        this.display3Panel.setLayout(new GridBagLayout());
        this.display3Panel.setBackground(new Color(0, 0, 0));
        this.display3Panel.setToolTipText("Display 3");
        this.display3Panel.setMaximumSize(new Dimension(40, 47));
        this.display3Panel.setMinimumSize(new Dimension(40, 47));
        this.display3Panel.setPreferredSize(new Dimension(40, 47));
        this.a3.setEditable(false);
        this.a3.setMaximumSize(new Dimension(20, 5));
        this.a3.setMinimumSize(new Dimension(20, 5));
        this.a3.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.display3Panel.add((Component)this.a3, gridBagConstraints);
        this.b3.setEditable(false);
        this.b3.setMaximumSize(new Dimension(5, 12));
        this.b3.setMinimumSize(new Dimension(5, 12));
        this.b3.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.display3Panel.add((Component)this.b3, gridBagConstraints);
        this.c3.setEditable(false);
        this.c3.setMaximumSize(new Dimension(5, 12));
        this.c3.setMinimumSize(new Dimension(5, 12));
        this.c3.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.display3Panel.add((Component)this.c3, gridBagConstraints);
        this.d3.setEditable(false);
        this.d3.setMaximumSize(new Dimension(20, 5));
        this.d3.setMinimumSize(new Dimension(20, 5));
        this.d3.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.display3Panel.add((Component)this.d3, gridBagConstraints);
        this.e3.setEditable(false);
        this.e3.setMaximumSize(new Dimension(5, 12));
        this.e3.setMinimumSize(new Dimension(5, 12));
        this.e3.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.display3Panel.add((Component)this.e3, gridBagConstraints);
        this.f3.setEditable(false);
        this.f3.setMaximumSize(new Dimension(5, 12));
        this.f3.setMinimumSize(new Dimension(5, 12));
        this.f3.setPreferredSize(new Dimension(5, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.display3Panel.add((Component)this.f3, gridBagConstraints);
        this.g3.setEditable(false);
        this.g3.setMaximumSize(new Dimension(20, 5));
        this.g3.setMinimumSize(new Dimension(20, 5));
        this.g3.setPreferredSize(new Dimension(20, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.display3Panel.add((Component)this.g3, gridBagConstraints);
        this.dp3.setEditable(false);
        this.dp3.setMaximumSize(new Dimension(5, 5));
        this.dp3.setMinimumSize(new Dimension(5, 5));
        this.dp3.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.display3Panel.add((Component)this.dp3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.multiplexedDisplayPanel.add((Component)this.display3Panel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.externalHardware.add((Component)this.multiplexedDisplayPanel, gridBagConstraints);
        this.lcdModuleGBC = new GridBagConstraints();
        this.lcdModuleGBC.gridx = 1;
        this.lcdModuleGBC.gridy = 1;
        this.lcdModuleGBC.insets = new Insets(0, 0, 0, 10);
        this.lcdModuleGBC.anchor = 12;
        this.externalHardware.add((Component)this.lcdModule.getModuleGraphics(), this.lcdModuleGBC);
        this.changeDisplay(this.settings.isLedDisplayVisible());
        this.ledLcdButton.setBackground(new Color(153, 153, 255));
        this.ledLcdButton.setFont(new Font("Dialog", 1, 12));
        this.ledLcdButton.setBorder(new BevelBorder(0));
        this.ledLcdButton.setMaximumSize(new Dimension(170, 21));
        this.ledLcdButton.setMinimumSize(new Dimension(170, 21));
        this.ledLcdButton.setPreferredSize(new Dimension(170, 21));
        if (this.settings.isLedDisplayVisible()) {
            this.ledLcdButton.setText("7 Segment LED Displays");
            this.ledLcdButton.setToolTipText("Click to change to LCD Module");
        } else {
            this.ledLcdButton.setText("HD44780 LCD Module");
            this.ledLcdButton.setToolTipText("Click to change to LED Display");
        }
        this.ledLcdButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.ledLcdMouseClicked(evt);
            }
        });
        this.ledLcdButtonGBC = new GridBagConstraints();
        this.ledLcdButtonGBC.gridx = 1;
        this.ledLcdButtonGBC.gridy = 0;
        this.ledLcdButtonGBC.anchor = 13;
        this.ledLcdButtonGBC.insets = new Insets(0, 0, 0, 70);
        this.externalHardware.add((Component)this.ledLcdButton, this.ledLcdButtonGBC);
        this.adcDisableButton.setBackground(new Color(153, 153, 255));
        this.adcDisableButton.setFont(new Font("Dialog", 1, 10));
        this.adcDisableButton.setBorder(new BevelBorder(0));
        if (this.settings.isAdcEnabled()) {
            this.enableAdcPanel();
        } else {
            this.disableAdcPanel();
        }
        this.adcDisableButton.setMargin(new Insets(1, 2, 1, 2));
        this.adcDisableButton.setMaximumSize(new Dimension(120, 21));
        this.adcDisableButton.setMinimumSize(new Dimension(120, 21));
        this.adcDisableButton.setPreferredSize(new Dimension(120, 21));
        this.adcDisableButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.adcDisableMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.externalHardware.add((Component)this.adcDisableButton, gridBagConstraints);
        this.scopeAndLabelPanel.setLayout(new GridBagLayout());
        this.scopeAndLabelPanel.setBackground(new Color(153, 153, 255));
        this.scopeAndLabelPanel.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(0, 0, 0), 2)));
        this.scopeLabel.setFont(new Font("Monospaced", 1, 12));
        this.scopeLabel.setHorizontalAlignment(0);
        this.scopeLabel.setText("DAC output on scope");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 15;
        this.scopeAndLabelPanel.add((Component)this.scopeLabel, gridBagConstraints);
        this.scopeLabel1.setFont(new Font("Monospaced", 1, 12));
        this.scopeLabel1.setHorizontalAlignment(0);
        this.scopeLabel1.setText("5.0 V");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.scopeAndLabelPanel.add((Component)this.scopeLabel1, gridBagConstraints);
        this.scopeLabel2.setFont(new Font("Monospaced", 1, 12));
        this.scopeLabel2.setHorizontalAlignment(0);
        this.scopeLabel2.setText("0.0 V");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        this.scopeAndLabelPanel.add((Component)this.scopeLabel2, gridBagConstraints);
        this.dacVoltageField.setEditable(false);
        this.dacVoltageField.setFont(new Font("Monospaced", 0, 10));
        this.dacVoltageField.setHorizontalAlignment(4);
        this.dacVoltageField.setText("0.00 V");
        this.dacVoltageField.setToolTipText("DAC output voltage");
        this.dacVoltageField.setMaximumSize(new Dimension(42, 19));
        this.dacVoltageField.setMinimumSize(new Dimension(42, 19));
        this.dacVoltageField.setPreferredSize(new Dimension(42, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.scopeAndLabelPanel.add((Component)this.dacVoltageField, gridBagConstraints);
        this.scopePanel.setLayout(new GridBagLayout());
        this.scopePanel.setBackground(new Color(255, 255, 255));
        this.scopePanel.setToolTipText("Scope updates as instructions are executed or whenever DAC inputs (P1) are manually altered");
        this.scopePanel.setMaximumSize(new Dimension(300, 175));
        this.scopePanel.setMinimumSize(new Dimension(300, 175));
        this.scopePanel.setPreferredSize(new Dimension(300, 175));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.scopeAndLabelPanel.add((Component)this.scopePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 11;
        this.externalHardware.add((Component)this.scopeAndLabelPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.externalHardware, gridBagConstraints);
        this.microcontroller.setLayout(new GridBagLayout());
        this.microcontroller.setBackground(new Color(255, 255, 255));
        this.microcontroller.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(51, 102, 255), 2)));
        this.microcontroller.setMaximumSize(new Dimension(420, 480));
        this.microcontroller.setMinimumSize(new Dimension(420, 480));
        this.microcontroller.setPreferredSize(new Dimension(420, 480));
        this.R7.setText("R7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R7, gridBagConstraints);
        this.R6.setText("R6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R6, gridBagConstraints);
        this.R5.setText("R5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R5, gridBagConstraints);
        this.R4.setText("R4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R4, gridBagConstraints);
        this.R3.setText("R3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R3, gridBagConstraints);
        this.R2.setText("R2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R2, gridBagConstraints);
        this.R1.setText("R1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R1, gridBagConstraints);
        this.R0.setText("R0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = this.sizes.insets;
        this.microcontroller.add((Component)this.R0, gridBagConstraints);
        this.register7.setFont(new Font("Monospaced", 0, 12));
        this.register7.setHorizontalAlignment(4);
        this.register7.setText("0x00");
        this.register7.setMaximumSize(new Dimension(40, 19));
        this.register7.setMinimumSize(new Dimension(40, 19));
        this.register7.setPreferredSize(new Dimension(40, 19));
        this.register7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register7ActionPerformed(evt);
            }
        });
        this.register7.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register7FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register7, gridBagConstraints);
        this.register6.setFont(new Font("Monospaced", 0, 12));
        this.register6.setHorizontalAlignment(4);
        this.register6.setText("0x00");
        this.register6.setMaximumSize(new Dimension(40, 19));
        this.register6.setMinimumSize(new Dimension(40, 19));
        this.register6.setPreferredSize(new Dimension(40, 19));
        this.register6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register6ActionPerformed(evt);
            }
        });
        this.register6.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register6FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register6, gridBagConstraints);
        this.register5.setFont(new Font("Monospaced", 0, 12));
        this.register5.setHorizontalAlignment(4);
        this.register5.setText("0x00");
        this.register5.setMaximumSize(new Dimension(40, 19));
        this.register5.setMinimumSize(new Dimension(40, 19));
        this.register5.setPreferredSize(new Dimension(40, 19));
        this.register5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register5ActionPerformed(evt);
            }
        });
        this.register5.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register5FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register5, gridBagConstraints);
        this.register4.setFont(new Font("Monospaced", 0, 12));
        this.register4.setHorizontalAlignment(4);
        this.register4.setText("0x00");
        this.register4.setMaximumSize(new Dimension(40, 19));
        this.register4.setMinimumSize(new Dimension(40, 19));
        this.register4.setPreferredSize(new Dimension(40, 19));
        this.register4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register4ActionPerformed(evt);
            }
        });
        this.register4.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register4FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register4, gridBagConstraints);
        this.register3.setFont(new Font("Monospaced", 0, 12));
        this.register3.setHorizontalAlignment(4);
        this.register3.setText("0x00");
        this.register3.setMaximumSize(new Dimension(40, 19));
        this.register3.setMinimumSize(new Dimension(40, 19));
        this.register3.setPreferredSize(new Dimension(40, 19));
        this.register3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register3ActionPerformed(evt);
            }
        });
        this.register3.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register3FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register3, gridBagConstraints);
        this.register2.setFont(new Font("Monospaced", 0, 12));
        this.register2.setHorizontalAlignment(4);
        this.register2.setText("0x00");
        this.register2.setMaximumSize(new Dimension(40, 19));
        this.register2.setMinimumSize(new Dimension(40, 19));
        this.register2.setPreferredSize(new Dimension(40, 19));
        this.register2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register2ActionPerformed(evt);
            }
        });
        this.register2.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register2FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register2, gridBagConstraints);
        this.register1.setFont(new Font("Monospaced", 0, 12));
        this.register1.setHorizontalAlignment(4);
        this.register1.setText("0x00");
        this.register1.setMaximumSize(new Dimension(40, 19));
        this.register1.setMinimumSize(new Dimension(40, 19));
        this.register1.setPreferredSize(new Dimension(40, 19));
        this.register1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register1ActionPerformed(evt);
            }
        });
        this.register1.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register1FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register1, gridBagConstraints);
        this.register0.setFont(new Font("Monospaced", 0, 12));
        this.register0.setHorizontalAlignment(4);
        this.register0.setText("0x00");
        this.register0.setMaximumSize(new Dimension(40, 19));
        this.register0.setMinimumSize(new Dimension(40, 19));
        this.register0.setPreferredSize(new Dimension(40, 19));
        this.register0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.register0ActionPerformed(evt);
            }
        });
        this.register0.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.register0FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.register0, gridBagConstraints);
        this.accLabel.setText("ACC");
        this.accLabel.setToolTipText("addr: " + Text.inHex(224));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.accLabel, gridBagConstraints);
        this.acc.setFont(new Font("Monospaced", 0, 12));
        this.acc.setHorizontalAlignment(4);
        this.acc.setText("0x00");
        this.acc.setMaximumSize(new Dimension(40, 19));
        this.acc.setMinimumSize(new Dimension(40, 19));
        this.acc.setPreferredSize(new Dimension(40, 19));
        this.acc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.accActionPerformed(evt);
            }
        });
        this.acc.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.accFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.acc, gridBagConstraints);
        this.pswLabel.setText("PSW");
        this.pswLabel.setToolTipText("addr: " + Text.inHex(208));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.pswLabel, gridBagConstraints);
        this.port1.setFont(new Font("Monospaced", 0, 12));
        this.port1.setHorizontalAlignment(4);
        this.port1.setText("0xFF");
        this.port1.setMaximumSize(new Dimension(40, 19));
        this.port1.setMinimumSize(new Dimension(40, 19));
        this.port1.setPreferredSize(new Dimension(40, 19));
        this.port1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.port1ActionPerformed(evt);
            }
        });
        this.port1.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.port1FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        this.microcontroller.add((Component)this.port1, gridBagConstraints);
        this.port1Label.setText("P1");
        this.port1Label.setToolTipText("addr: " + Text.inHex(144));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.port1Label, gridBagConstraints);
        this.port1pins.setEditable(false);
        this.port1pins.setFont(new Font("Monospaced", 0, 12));
        this.port1pins.setHorizontalAlignment(4);
        this.port1pins.setText("0xFF");
        this.port1pins.setMaximumSize(new Dimension(40, 19));
        this.port1pins.setMinimumSize(new Dimension(40, 19));
        this.port1pins.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        this.microcontroller.add((Component)this.port1pins, gridBagConstraints);
        this.latchLabel.setHorizontalAlignment(0);
        this.latchLabel.setText("bits");
        this.latchLabel.setToolTipText("internal port latches");
        this.latchLabel.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.microcontroller.add((Component)this.latchLabel, gridBagConstraints);
        this.addrLabel.setHorizontalAlignment(0);
        if (this.settings.isDataMemoryDisplayed()) {
            this.addrLabel.setText("Modify RAM");
        } else {
            this.addrLabel.setText("Modify Code");
        }
        this.addrLabel.setToolTipText("Enter the address you want to modify in the blue box");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        this.microcontroller.add((Component)this.addrLabel, gridBagConstraints);
        this.microcontrollerLabel.setFont(new Font("Dialog", 1, 14));
        this.microcontrollerLabel.setText("8051");
        this.microcontrollerLabel.setForeground(Color.BLUE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 13;
        this.microcontroller.add((Component)this.microcontrollerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        this.microcontroller.add((Component)this.sysClockLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.sysClockField.setHorizontalAlignment(0);
        this.microcontroller.add((Component)this.sysClockField, gridBagConstraints);
        this.sysClockField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.readSysClockField();
            }
        });
        this.sysClockField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.readSysClockField();
            }
        });
        this.port2Label.setText("P2");
        this.port2Label.setToolTipText("addr: " + Text.inHex(160));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.port2Label, gridBagConstraints);
        this.port2.setFont(new Font("Monospaced", 0, 12));
        this.port2.setHorizontalAlignment(4);
        this.port2.setText("0xFF");
        this.port2.setMaximumSize(new Dimension(40, 19));
        this.port2.setMinimumSize(new Dimension(40, 19));
        this.port2.setPreferredSize(new Dimension(40, 19));
        this.port2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.port2ActionPerformed(evt);
            }
        });
        this.port2.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.port2FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        this.microcontroller.add((Component)this.port2, gridBagConstraints);
        this.port2pins.setEditable(false);
        this.port2pins.setFont(new Font("Monospaced", 0, 12));
        this.port2pins.setHorizontalAlignment(4);
        this.port2pins.setText("0xFF");
        this.port2pins.setMaximumSize(new Dimension(40, 19));
        this.port2pins.setMinimumSize(new Dimension(40, 19));
        this.port2pins.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.microcontroller.add((Component)this.port2pins, gridBagConstraints);
        this.port3pins.setEditable(false);
        this.port3pins.setFont(new Font("Monospaced", 0, 12));
        this.port3pins.setHorizontalAlignment(4);
        this.port3pins.setText("0xFF");
        this.port3pins.setMaximumSize(new Dimension(40, 19));
        this.port3pins.setMinimumSize(new Dimension(40, 19));
        this.port3pins.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.microcontroller.add((Component)this.port3pins, gridBagConstraints);
        this.port0pins.setEditable(false);
        this.port0pins.setFont(new Font("Monospaced", 0, 12));
        this.port0pins.setHorizontalAlignment(4);
        this.port0pins.setText("0xFF");
        this.port0pins.setMaximumSize(new Dimension(40, 19));
        this.port0pins.setMinimumSize(new Dimension(40, 19));
        this.port0pins.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        this.microcontroller.add((Component)this.port0pins, gridBagConstraints);
        this.port3.setFont(new Font("Monospaced", 0, 12));
        this.port3.setHorizontalAlignment(4);
        this.port3.setText("0xFF");
        this.port3.setMaximumSize(new Dimension(40, 19));
        this.port3.setMinimumSize(new Dimension(40, 19));
        this.port3.setPreferredSize(new Dimension(40, 19));
        this.port3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.port3ActionPerformed(evt);
            }
        });
        this.port3.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.port3FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.microcontroller.add((Component)this.port3, gridBagConstraints);
        this.port0.setFont(new Font("Monospaced", 0, 12));
        this.port0.setHorizontalAlignment(4);
        this.port0.setText("0xFF");
        this.port0.setMaximumSize(new Dimension(40, 19));
        this.port0.setMinimumSize(new Dimension(40, 19));
        this.port0.setPreferredSize(new Dimension(40, 19));
        this.port0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.port0ActionPerformed(evt);
            }
        });
        this.port0.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.port0FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        this.microcontroller.add((Component)this.port0, gridBagConstraints);
        this.port3Label.setText("P3 ");
        this.port3Label.setToolTipText("addr: " + Text.inHex(176));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.port3Label, gridBagConstraints);
        this.port0Label.setText("P0");
        this.port0Label.setToolTipText("addr: " + Text.inHex(128));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.port0Label, gridBagConstraints);
        this.memoryWindow.setBackground(new Color(204, 204, 204));
        this.memoryWindow.setEditable(false);
        this.memoryWindow.setFont(new Font("Monospaced", 0, 12));
        this.memoryWindow.setRows(8);
        this.memoryWindow.setBorder(new CompoundBorder(new BevelBorder(1), new LineBorder(new Color(0, 0, 0))));
        this.memoryWindow.setToolTipText("Memory Window");
        if (this.settings.isDataMemoryDisplayed()) {
            this.memoryWindow.setBackground(Color.LIGHT_GRAY);
        } else {
            this.memoryWindow.setBackground(new Color(153, 153, 255));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.anchor = 18;
        this.microcontroller.add((Component)this.memoryWindow, gridBagConstraints);
        this.columnAddresses.setBackground(new Color(153, 153, 255));
        this.columnAddresses.setEditable(false);
        this.columnAddresses.setFont(new Font("Monospaced", 1, 12));
        this.columnAddresses.setText(" 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ");
        this.columnAddresses.setBorder(new BevelBorder(0));
        if (this.settings.isDataMemoryDisplayed()) {
            this.columnAddresses.setBackground(new Color(153, 153, 255));
        } else {
            this.columnAddresses.setBackground(Color.LIGHT_GRAY);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.columnAddresses, gridBagConstraints);
        this.rowAddresses.setBackground(new Color(153, 153, 255));
        this.rowAddresses.setEditable(false);
        this.rowAddresses.setFont(new Font("Monospaced", 1, 12));
        this.rowAddresses.setRows(7);
        this.rowAddresses.setBorder(new BevelBorder(0));
        if (this.settings.isDataMemoryDisplayed()) {
            this.rowAddresses.setBackground(new Color(153, 153, 255));
        } else {
            this.rowAddresses.setBackground(Color.LIGHT_GRAY);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.anchor = 13;
        this.microcontroller.add((Component)this.rowAddresses, gridBagConstraints);
        this.pinsLabel.setHorizontalAlignment(0);
        this.pinsLabel.setText("pins");
        this.pinsLabel.setToolTipText("external port pins");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.microcontroller.add((Component)this.pinsLabel, gridBagConstraints);
        this.memoryWindowByteField.setFont(new Font("Monospaced", 0, 12));
        this.memoryWindowByteField.setHorizontalAlignment(4);
        this.memoryWindowByteField.setText("0x00");
        this.memoryWindowByteField.setMaximumSize(new Dimension(40, 19));
        this.memoryWindowByteField.setMinimumSize(new Dimension(40, 19));
        this.memoryWindowByteField.setPreferredSize(new Dimension(40, 19));
        this.memoryWindowByteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.memoryWindowByteFieldActionPerformed(evt);
            }
        });
        this.memoryWindowByteField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.memoryWindowByteFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 14;
        this.microcontroller.add((Component)this.memoryWindowByteField, gridBagConstraints);
        this.memoryWindowAddressField.setFont(new Font("Monospaced", 0, 12));
        this.memoryWindowAddressField.setHorizontalAlignment(4);
        if (this.settings.isDataMemoryDisplayed()) {
            this.memoryWindowAddressField.setText("0x00");
        } else {
            this.memoryWindowAddressField.setText(Text.inHex(this.settings.getCodeWindowStartAddress(), true, 4));
        }
        this.memoryWindowAddressField.setBorder(new LineBorder(new Color(153, 153, 255), 2));
        this.memoryWindowAddressField.setMaximumSize(new Dimension(60, 19));
        this.memoryWindowAddressField.setMinimumSize(new Dimension(60, 19));
        this.memoryWindowAddressField.setPreferredSize(new Dimension(60, 19));
        this.memoryWindowAddressField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.memoryWindowAddressFieldActionPerformed(evt);
            }
        });
        this.memoryWindowAddressField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.memoryWindowAddressFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.memoryWindowAddressField, gridBagConstraints);
        this.addLabel.setHorizontalAlignment(4);
        this.addLabel.setText("addr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.microcontroller.add((Component)this.addLabel, gridBagConstraints);
        this.dataLabel.setHorizontalAlignment(2);
        this.dataLabel.setText("value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.dataLabel, gridBagConstraints);
        this.memoryTypeButton.setFont(new Font("Monospaced", 1, 12));
        if (this.settings.isDataMemoryDisplayed()) {
            this.memoryTypeButton.setText("Data Memory");
        } else {
            this.memoryTypeButton.setText("Code Memory");
        }
        this.memoryTypeButton.setToolTipText("Click to change between data memory and code memory.");
        this.memoryTypeButton.setBorder(new BevelBorder(0));
        this.memoryTypeButton.setMaximumSize(new Dimension(90, 19));
        this.memoryTypeButton.setMinimumSize(new Dimension(90, 19));
        this.memoryTypeButton.setPreferredSize(new Dimension(90, 19));
        this.memoryTypeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.memoryTypeButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.memoryTypeButton, gridBagConstraints);
        this.th0.setFont(new Font("Monospaced", 0, 12));
        this.th0.setHorizontalAlignment(4);
        this.th0.setText("0x00");
        this.th0.setMaximumSize(new Dimension(40, 19));
        this.th0.setMinimumSize(new Dimension(40, 19));
        this.th0.setPreferredSize(new Dimension(40, 19));
        this.th0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.th0ActionPerformed(evt);
            }
        });
        this.th0.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.th0FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.th0, gridBagConstraints);
        this.th0label.setText("TH0");
        this.th0label.setToolTipText("addr: " + Text.inHex(140));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.microcontroller.add((Component)this.th0label, gridBagConstraints);
        this.tl0label.setText("TL0");
        this.tl0label.setToolTipText("addr: " + Text.inHex(138));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        this.microcontroller.add((Component)this.tl0label, gridBagConstraints);
        this.tl0.setFont(new Font("Monospaced", 0, 12));
        this.tl0.setHorizontalAlignment(4);
        this.tl0.setText("0x00");
        this.tl0.setMaximumSize(new Dimension(40, 19));
        this.tl0.setMinimumSize(new Dimension(40, 19));
        this.tl0.setPreferredSize(new Dimension(40, 19));
        this.tl0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.tl0ActionPerformed(evt);
            }
        });
        this.tl0.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.tl0FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.tl0, gridBagConstraints);
        this.tmod.setFont(new Font("Monospaced", 0, 12));
        this.tmod.setHorizontalAlignment(4);
        this.tmod.setText("0x00");
        this.tmod.setMaximumSize(new Dimension(40, 19));
        this.tmod.setMinimumSize(new Dimension(40, 19));
        this.tmod.setPreferredSize(new Dimension(40, 19));
        this.tmod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.tmodActionPerformed(evt);
            }
        });
        this.tmod.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.tmodFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.tmod, gridBagConstraints);
        this.tmodLabel.setText("TMOD");
        this.tmodLabel.setToolTipText("addr: " + Text.inHex(137));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        this.microcontroller.add((Component)this.tmodLabel, gridBagConstraints);
        this.th1.setFont(new Font("Monospaced", 0, 12));
        this.th1.setHorizontalAlignment(4);
        this.th1.setText("0x00");
        this.th1.setMaximumSize(new Dimension(40, 19));
        this.th1.setMinimumSize(new Dimension(40, 19));
        this.th1.setPreferredSize(new Dimension(40, 19));
        this.th1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.th1ActionPerformed(evt);
            }
        });
        this.th1.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.th1FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.th1, gridBagConstraints);
        this.tl1.setFont(new Font("Monospaced", 0, 12));
        this.tl1.setHorizontalAlignment(4);
        this.tl1.setText("0x00");
        this.tl1.setMaximumSize(new Dimension(40, 19));
        this.tl1.setMinimumSize(new Dimension(40, 19));
        this.tl1.setPreferredSize(new Dimension(40, 19));
        this.tl1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.tl1ActionPerformed(evt);
            }
        });
        this.tl1.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.tl1FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.tl1, gridBagConstraints);
        this.th1label.setText("TH1");
        this.th1label.setToolTipText("addr: " + Text.inHex(141));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        this.microcontroller.add((Component)this.th1label, gridBagConstraints);
        this.tl1label.setText("TL1");
        this.tl1label.setToolTipText("addr: " + Text.inHex(139));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        this.microcontroller.add((Component)this.tl1label, gridBagConstraints);
        this.tconLabel.setText("TCON");
        this.tconLabel.setToolTipText("addr: " + Text.inHex(136));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        this.microcontroller.add((Component)this.tconLabel, gridBagConstraints);
        this.tcon.setFont(new Font("Monospaced", 0, 12));
        this.tcon.setHorizontalAlignment(4);
        this.tcon.setText("0x00");
        this.tcon.setMaximumSize(new Dimension(40, 19));
        this.tcon.setMinimumSize(new Dimension(40, 19));
        this.tcon.setPreferredSize(new Dimension(40, 19));
        this.tcon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.tconActionPerformed(evt);
            }
        });
        this.tcon.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.tconFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.tcon, gridBagConstraints);
        this.scon.setFont(new Font("Monospaced", 0, 12));
        this.scon.setHorizontalAlignment(4);
        this.scon.setText("0x00");
        this.scon.setMaximumSize(new Dimension(40, 19));
        this.scon.setMinimumSize(new Dimension(40, 19));
        this.scon.setPreferredSize(new Dimension(40, 19));
        this.scon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.sconActionPerformed(evt);
            }
        });
        this.scon.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.sconFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.scon, gridBagConstraints);
        this.sconLabel.setText("SCON");
        this.sconLabel.setToolTipText("addr: " + Text.inHex(152));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.microcontroller.add((Component)this.sconLabel, gridBagConstraints);
        this.sbufLabel.setText("SBUF");
        this.sbufLabel.setToolTipText("addr: " + Text.inHex(153));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 15;
        this.microcontroller.add((Component)this.sbufLabel, gridBagConstraints);
        this.sbuf.setFont(new Font("Monospaced", 0, 12));
        this.sbuf.setHorizontalAlignment(4);
        this.sbuf.setText("0x00");
        this.sbuf.setMaximumSize(new Dimension(40, 19));
        this.sbuf.setMinimumSize(new Dimension(40, 19));
        this.sbuf.setPreferredSize(new Dimension(40, 19));
        this.sbuf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.sbufActionPerformed(evt);
            }
        });
        this.sbuf.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.sbufFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        this.microcontroller.add((Component)this.sbuf, gridBagConstraints);
        this.txd.setEditable(false);
        this.txd.setFont(new Font("Monospaced", 0, 12));
        this.txd.setHorizontalAlignment(4);
        this.txd.setText("1");
        this.txd.setMaximumSize(new Dimension(15, 19));
        this.txd.setMinimumSize(new Dimension(15, 19));
        this.txd.setPreferredSize(new Dimension(15, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.microcontroller.add((Component)this.txd, gridBagConstraints);
        this.rxdLabel.setText("RXD");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 15;
        this.microcontroller.add((Component)this.rxdLabel, gridBagConstraints);
        this.txdLabel.setText("TXD");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 15;
        this.microcontroller.add((Component)this.txdLabel, gridBagConstraints);
        this.sbufReadOnly.setEditable(false);
        this.sbufReadOnly.setFont(new Font("Monospaced", 0, 12));
        this.sbufReadOnly.setHorizontalAlignment(4);
        this.sbufReadOnly.setText("0x00");
        this.sbufReadOnly.setMaximumSize(new Dimension(40, 19));
        this.sbufReadOnly.setMinimumSize(new Dimension(40, 19));
        this.sbufReadOnly.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        this.microcontroller.add((Component)this.sbufReadOnly, gridBagConstraints);
        this.sbufRonlyLabel.setText("R/O");
        this.sbufRonlyLabel.setToolTipText("read-only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        this.microcontroller.add((Component)this.sbufRonlyLabel, gridBagConstraints);
        this.sbufWonlyLabel.setText("W/O");
        this.sbufWonlyLabel.setToolTipText("write-only");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        this.microcontroller.add((Component)this.sbufWonlyLabel, gridBagConstraints);
        this.rxd.setEditable(false);
        this.rxd.setFont(new Font("Monospaced", 0, 12));
        this.rxd.setHorizontalAlignment(4);
        this.rxd.setText("1");
        this.rxd.setMaximumSize(new Dimension(15, 19));
        this.rxd.setMinimumSize(new Dimension(15, 19));
        this.rxd.setPreferredSize(new Dimension(15, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.microcontroller.add((Component)this.rxd, gridBagConstraints);
        this.pc.setFont(new Font("Monospaced", 0, 12));
        this.pc.setHorizontalAlignment(4);
        this.pc.setText("0x0000");
        this.pc.setMaximumSize(new Dimension(60, 19));
        this.pc.setMinimumSize(new Dimension(60, 19));
        this.pc.setPreferredSize(new Dimension(60, 19));
        this.pc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.pcActionPerformed(evt);
            }
        });
        this.pc.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.pcFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 2;
        this.microcontroller.add((Component)this.pc, gridBagConstraints);
        this.pcLabel.setText("PC");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 2;
        this.microcontroller.add((Component)this.pcLabel, gridBagConstraints);
        this.psw.setFont(new Font("Monospaced", 0, 12));
        this.psw.setHorizontalAlignment(4);
        this.psw.setText("0x00");
        this.psw.setMaximumSize(new Dimension(40, 19));
        this.psw.setMinimumSize(new Dimension(40, 19));
        this.psw.setPreferredSize(new Dimension(40, 19));
        this.psw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.pswActionPerformed(evt);
            }
        });
        this.psw.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.pswFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.psw, gridBagConstraints);
        this.spLabel.setText("SP");
        this.spLabel.setToolTipText("addr: " + Text.inHex(129));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.spLabel, gridBagConstraints);
        this.sp.setFont(new Font("Monospaced", 0, 12));
        this.sp.setHorizontalAlignment(4);
        this.sp.setText("0x07");
        this.sp.setMaximumSize(new Dimension(40, 19));
        this.sp.setMinimumSize(new Dimension(40, 19));
        this.sp.setPreferredSize(new Dimension(40, 19));
        this.sp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.spActionPerformed(evt);
            }
        });
        this.sp.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.spFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.sp, gridBagConstraints);
        this.ipLabel.setText("IP");
        this.ipLabel.setToolTipText("addr: " + Text.inHex(184));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.ipLabel, gridBagConstraints);
        this.ip.setFont(new Font("Monospaced", 0, 12));
        this.ip.setHorizontalAlignment(4);
        this.ip.setText("0x00");
        this.ip.setMaximumSize(new Dimension(40, 19));
        this.ip.setMinimumSize(new Dimension(40, 19));
        this.ip.setPreferredSize(new Dimension(40, 19));
        this.ip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.ipActionPerformed(evt);
            }
        });
        this.ip.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.ipFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.ip, gridBagConstraints);
        this.ieLabel.setText("IE");
        this.ieLabel.setToolTipText("addr: " + Text.inHex(168));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.ieLabel, gridBagConstraints);
        this.ie.setFont(new Font("Monospaced", 0, 12));
        this.ie.setHorizontalAlignment(4);
        this.ie.setText("0x00");
        this.ie.setMaximumSize(new Dimension(40, 19));
        this.ie.setMinimumSize(new Dimension(40, 19));
        this.ie.setPreferredSize(new Dimension(40, 19));
        this.ie.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.ieActionPerformed(evt);
            }
        });
        this.ie.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.ieFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.ie, gridBagConstraints);
        this.bitfieldPanel.setLayout(new GridBagLayout());
        this.bitfieldPanel.setBackground(new Color(255, 255, 255));
        this.bit0.setFont(new Font("Monospaced", 0, 12));
        this.bit0.setHorizontalAlignment(0);
        this.bit0.setText("0");
        this.bit0.setToolTipText("ACC.0");
        this.bit0.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit0.setMaximumSize(new Dimension(15, 19));
        this.bit0.setMinimumSize(new Dimension(15, 19));
        this.bit0.setPreferredSize(new Dimension(15, 19));
        this.bit0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit0ActionPerformed(evt);
            }
        });
        this.bit0.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit0FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        this.bitfieldPanel.add((Component)this.bit0, gridBagConstraints);
        this.bit1.setFont(new Font("Monospaced", 0, 12));
        this.bit1.setHorizontalAlignment(0);
        this.bit1.setText("0");
        this.bit1.setToolTipText("ACC.1");
        this.bit1.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit1.setMaximumSize(new Dimension(15, 19));
        this.bit1.setMinimumSize(new Dimension(15, 19));
        this.bit1.setPreferredSize(new Dimension(15, 19));
        this.bit1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit1ActionPerformed(evt);
            }
        });
        this.bit1.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit1FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit1, gridBagConstraints);
        this.bit2.setFont(new Font("Monospaced", 0, 12));
        this.bit2.setHorizontalAlignment(0);
        this.bit2.setText("0");
        this.bit2.setToolTipText("ACC.2");
        this.bit2.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit2.setMaximumSize(new Dimension(15, 19));
        this.bit2.setMinimumSize(new Dimension(15, 19));
        this.bit2.setPreferredSize(new Dimension(15, 19));
        this.bit2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit2ActionPerformed(evt);
            }
        });
        this.bit2.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit2FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit2, gridBagConstraints);
        this.bit3.setFont(new Font("Monospaced", 0, 12));
        this.bit3.setHorizontalAlignment(0);
        this.bit3.setText("0");
        this.bit3.setToolTipText("ACC.3");
        this.bit3.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit3.setMaximumSize(new Dimension(15, 19));
        this.bit3.setMinimumSize(new Dimension(15, 19));
        this.bit3.setPreferredSize(new Dimension(15, 19));
        this.bit3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit3ActionPerformed(evt);
            }
        });
        this.bit3.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit3FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 1);
        this.bitfieldPanel.add((Component)this.bit3, gridBagConstraints);
        this.bit4.setFont(new Font("Monospaced", 0, 12));
        this.bit4.setHorizontalAlignment(0);
        this.bit4.setText("0");
        this.bit4.setToolTipText("ACC.4");
        this.bit4.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit4.setMaximumSize(new Dimension(15, 19));
        this.bit4.setMinimumSize(new Dimension(15, 19));
        this.bit4.setPreferredSize(new Dimension(15, 19));
        this.bit4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit4ActionPerformed(evt);
            }
        });
        this.bit4.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit4FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.bitfieldPanel.add((Component)this.bit4, gridBagConstraints);
        this.bit5.setFont(new Font("Monospaced", 0, 12));
        this.bit5.setHorizontalAlignment(0);
        this.bit5.setText("0");
        this.bit5.setToolTipText("ACC.5");
        this.bit5.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit5.setMaximumSize(new Dimension(15, 19));
        this.bit5.setMinimumSize(new Dimension(15, 19));
        this.bit5.setPreferredSize(new Dimension(15, 19));
        this.bit5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit5ActionPerformed(evt);
            }
        });
        this.bit5.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit5FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit5, gridBagConstraints);
        this.bit6.setFont(new Font("Monospaced", 0, 12));
        this.bit6.setHorizontalAlignment(0);
        this.bit6.setText("0");
        this.bit6.setToolTipText("ACC.6");
        this.bit6.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit6.setMaximumSize(new Dimension(15, 19));
        this.bit6.setMinimumSize(new Dimension(15, 19));
        this.bit6.setPreferredSize(new Dimension(15, 19));
        this.bit6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit6ActionPerformed(evt);
            }
        });
        this.bit6.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit6FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit6, gridBagConstraints);
        this.bit7.setFont(new Font("Monospaced", 0, 12));
        this.bit7.setHorizontalAlignment(0);
        this.bit7.setText("0");
        this.bit7.setToolTipText("ACC.7");
        this.bit7.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.bit7.setMaximumSize(new Dimension(15, 19));
        this.bit7.setMinimumSize(new Dimension(15, 19));
        this.bit7.setPreferredSize(new Dimension(15, 19));
        this.bit7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bit7ActionPerformed(evt);
            }
        });
        this.bit7.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bit7FocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.bitfieldPanel.add((Component)this.bit7, gridBagConstraints);
        this.bitfieldByteAddress.setFont(new Font("Monospaced", 0, 12));
        this.bitfieldByteAddress.setHorizontalAlignment(0);
        this.bitfieldByteAddress.setText(this.settings.getBitfieldByteAddressString());
        this.bitfieldByteAddress.setToolTipText("addr: " + Text.inHex(this.getBitFieldByteAddress()));
        this.updateBitFieldData();
        this.bitfieldByteAddress.setBorder(new LineBorder(new Color(153, 153, 255), 2));
        this.bitfieldByteAddress.setMaximumSize(new Dimension(40, 19));
        this.bitfieldByteAddress.setMinimumSize(new Dimension(40, 19));
        this.bitfieldByteAddress.setPreferredSize(new Dimension(40, 19));
        this.bitfieldByteAddress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bitfieldByteAddressActionPerformed(evt);
            }
        });
        this.bitfieldByteAddress.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bitfieldByteAddressFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.bitfieldPanel.add((Component)this.bitfieldByteAddress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.gridheight = 2;
        this.microcontroller.add((Component)this.bitfieldPanel, gridBagConstraints);
        this.removeAllBreakpointsButton.setMaximumSize(new Dimension(162, 20));
        this.removeAllBreakpointsButton.setMinimumSize(new Dimension(162, 20));
        this.removeAllBreakpointsButton.setPreferredSize(new Dimension(162, 20));
        this.removeAllBreakpointsButton.setFont(new Font("Monospaced", 1, 12));
        this.removeAllBreakpointsButton.setText("Remove All Breakpoints");
        this.removeAllBreakpointsButton.setMargin(new Insets(1, 1, 1, 1));
        this.removeAllBreakpointsButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.removeAllBreakpointsButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 14;
        this.microcontroller.add((Component)this.removeAllBreakpointsButton, gridBagConstraints);
        this.copyright.setFont(new Font("Dialog", 0, 12));
        this.copyright.setText("Copyright \u00a9 2005-2009 James Rogers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.anchor = 16;
        this.microcontroller.add((Component)this.copyright, gridBagConstraints);
        this.dph.setFont(new Font("Monospaced", 0, 12));
        this.dph.setHorizontalAlignment(4);
        this.dph.setText("0x00");
        this.dph.setMaximumSize(new Dimension(40, 19));
        this.dph.setMinimumSize(new Dimension(40, 19));
        this.dph.setPreferredSize(new Dimension(40, 19));
        this.dph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.dphActionPerformed(evt);
            }
        });
        this.dph.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.dphFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.dph, gridBagConstraints);
        this.dphLabel.setText("DPH");
        this.dphLabel.setToolTipText("addr: " + Text.inHex(131));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.dphLabel, gridBagConstraints);
        this.dpl.setFont(new Font("Monospaced", 0, 12));
        this.dpl.setHorizontalAlignment(4);
        this.dpl.setText("0x00");
        this.dpl.setMaximumSize(new Dimension(40, 19));
        this.dpl.setMinimumSize(new Dimension(40, 19));
        this.dpl.setPreferredSize(new Dimension(40, 19));
        this.dpl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.dplActionPerformed(evt);
            }
        });
        this.dpl.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.dplFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.dpl, gridBagConstraints);
        this.dplLabel.setText("DPL");
        this.dplLabel.setToolTipText("addr: " + Text.inHex(130));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.dplLabel, gridBagConstraints);
        this.b.setFont(new Font("Monospaced", 0, 12));
        this.b.setHorizontalAlignment(4);
        this.b.setText("0x00");
        this.b.setMaximumSize(new Dimension(40, 19));
        this.b.setMinimumSize(new Dimension(40, 19));
        this.b.setPreferredSize(new Dimension(40, 19));
        this.b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.bActionPerformed(evt);
            }
        });
        this.b.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.bFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.b, gridBagConstraints);
        this.bLabel.setText("B");
        this.bLabel.setToolTipText("addr: " + Text.inHex(240));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.bLabel, gridBagConstraints);
        this.pcon.setFont(new Font("Monospaced", 0, 12));
        this.pcon.setHorizontalAlignment(4);
        this.pcon.setText("0x00");
        this.pcon.setMaximumSize(new Dimension(40, 19));
        this.pcon.setMinimumSize(new Dimension(40, 19));
        this.pcon.setPreferredSize(new Dimension(40, 19));
        this.pcon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Simulator.this.pconActionPerformed(evt);
            }
        });
        this.pcon.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                Simulator.this.pconFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.microcontroller.add((Component)this.pcon, gridBagConstraints);
        this.pconLabel.setText("PCON");
        this.pconLabel.setToolTipText("addr: " + Text.inHex(135));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.microcontroller.add((Component)this.pconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        this.microcontroller.add((Component)this.updateFreqPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.microcontroller, gridBagConstraints);
        this.assembly.setLayout(new GridBagLayout());
        this.assembly.setBackground(new Color(102, 153, 255));
        this.assembly.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.assembly.setMaximumSize(new Dimension(610, 480));
        this.assembly.setMinimumSize(new Dimension(610, 480));
        this.assembly.setPreferredSize(new Dimension(610, 480));
        this.messageUnlockZoomPanel.setLayout(new GridBagLayout());
        this.messageBox.setEditable(false);
        this.messageBox.setFont(new Font("Monospaced", 0, 12));
        this.messageBoxPanel.setMaximumSize(new Dimension(305, 40));
        this.messageBoxPanel.setMinimumSize(new Dimension(305, 40));
        this.messageBoxPanel.setPreferredSize(new Dimension(305, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.messageBoxPanel.setViewportView(this.messageBox);
        this.messageBoxPanel.setHorizontalScrollBarPolicy(32);
        this.messageUnlockZoomPanel.add((Component)this.messageBoxPanel, gridBagConstraints);
        this.unlockZoomPanel.setLayout(new GridBagLayout());
        this.unlockButton.setText("U");
        this.unlockButton.setToolTipText("Unlock the source code pane");
        this.unlockButton.setFont(new Font("Monospaced", 1, 12));
        this.unlockButton.setMargin(new Insets(1, 1, 1, 1));
        this.unlockButton.setMaximumSize(new Dimension(15, 15));
        this.unlockButton.setMinimumSize(new Dimension(15, 15));
        this.unlockButton.setPreferredSize(new Dimension(15, 15));
        this.unlockButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.openUnlockedAssemblyCodeBox();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.unlockZoomPanel.add((Component)this.unlockButton, gridBagConstraints);
        if (this.settings.isSmall()) {
            this.zoomButton.setText("+");
            this.zoomButton.setToolTipText("Zoom in main window");
        } else {
            this.zoomButton.setText("-");
            this.zoomButton.setToolTipText("Zoom out main window");
        }
        this.zoomButton.setFont(new Font("Monospaced", 1, 12));
        this.zoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.zoomButton.setMaximumSize(new Dimension(15, 15));
        this.zoomButton.setMinimumSize(new Dimension(15, 15));
        this.zoomButton.setPreferredSize(new Dimension(15, 15));
        this.zoomButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.zoomWindowButtonPressed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.unlockZoomPanel.add((Component)this.zoomButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.messageUnlockZoomPanel.add((Component)this.unlockZoomPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.assembly.add((Component)this.messageUnlockZoomPanel, gridBagConstraints);
        this.portPinConnectionsPanel.setLayout(new GridBagLayout());
        this.portPinConnectionsPanel.setBackground(new Color(0, 0, 0));
        this.portPinConnectionsPanel.setBorder(new LineBorder(new Color(255, 255, 255), 2));
        this.portPinConnectionsPanel.setMaximumSize(new Dimension(290, 480));
        this.portPinConnectionsPanel.setMinimumSize(new Dimension(290, 480));
        this.portPinConnectionsPanel.setPreferredSize(new Dimension(290, 480));
        this.port0DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port0DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port0DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port0DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port0DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        this.portPinConnectionsPanel.add((Component)this.port0DescZoomButton, gridBagConstraints);
        this.port0DescZoomButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                String[] descs = new String[]{Simulator.this.p0_0Descr.getText(), Simulator.this.p0_1Descr.getText(), Simulator.this.p0_2Descr.getText(), Simulator.this.p0_3Descr.getText(), Simulator.this.p0_4Descr.getText(), Simulator.this.p0_5Descr.getText(), Simulator.this.p0_6Descr.getText(), Simulator.this.p0_7Descr.getText()};
                if (Simulator.this.port0Frame == null) {
                    Simulator.this.port0Frame = new PortPinsDescFrame(0, Simulator.this.cpu.dataMemory.port0, descs);
                    Simulator.this.port0Frame.setPinToolTip(7, Simulator.this.p0_7Descr.getToolTipText());
                } else {
                    Simulator.this.port0Frame.setVisible(true);
                }
            }
        });
        this.port1DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port1DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port1DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port1DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port1DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        this.portPinConnectionsPanel.add((Component)this.port1DescZoomButton, gridBagConstraints);
        this.port1DescZoomButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                String[] descs = new String[]{Simulator.this.p1_0Descr.getText(), Simulator.this.p1_1Descr.getText(), Simulator.this.p1_2Descr.getText(), Simulator.this.p1_3Descr.getText(), Simulator.this.p1_4Descr.getText(), Simulator.this.p1_5Descr.getText(), Simulator.this.p1_6Descr.getText(), Simulator.this.p1_7Descr.getText()};
                if (Simulator.this.port1Frame == null) {
                    Simulator.this.port1Frame = new PortPinsDescFrame(1, Simulator.this.cpu.dataMemory.port1, descs);
                } else {
                    Simulator.this.port1Frame.setVisible(true);
                }
            }
        });
        this.port2DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port2DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port2DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port2DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port2DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        this.portPinConnectionsPanel.add((Component)this.port2DescZoomButton, gridBagConstraints);
        this.port2DescZoomButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                String[] descs = new String[]{Simulator.this.p2_0Descr.getText(), Simulator.this.p2_1Descr.getText(), Simulator.this.p2_2Descr.getText(), Simulator.this.p2_3Descr.getText(), Simulator.this.p2_4Descr.getText(), Simulator.this.p2_5Descr.getText(), Simulator.this.p2_6Descr.getText(), Simulator.this.p2_7Descr.getText()};
                if (Simulator.this.port2Frame == null) {
                    Simulator.this.port2Frame = new PortPinsDescFrame(2, Simulator.this.cpu.dataMemory.port2, descs);
                } else {
                    Simulator.this.port2Frame.setVisible(true);
                }
            }
        });
        this.port3DescZoomButton.setFont(new Font("Monospaced", 1, 12));
        this.port3DescZoomButton.setMargin(new Insets(1, 1, 1, 1));
        this.port3DescZoomButton.setMaximumSize(new Dimension(15, 15));
        this.port3DescZoomButton.setMinimumSize(new Dimension(15, 15));
        this.port3DescZoomButton.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        this.portPinConnectionsPanel.add((Component)this.port3DescZoomButton, gridBagConstraints);
        this.port3DescZoomButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                String[] descs = new String[]{Simulator.this.p3_0Descr.getText(), Simulator.this.p3_1Descr.getText(), Simulator.this.p3_2Descr.getText(), Simulator.this.p3_3Descr.getText(), Simulator.this.p3_4Descr.getText(), Simulator.this.p3_5Descr.getText(), Simulator.this.p3_6Descr.getText(), Simulator.this.p3_7Descr.getText()};
                if (Simulator.this.port3Frame == null) {
                    Simulator.this.port3Frame = new PortPinsDescFrame(3, Simulator.this.cpu.dataMemory.port3, descs);
                    Simulator.this.port3Frame.setPinToolTip(3, Simulator.this.p3_3Descr.getToolTipText());
                } else {
                    Simulator.this.port3Frame.setVisible(true);
                }
            }
        });
        this.port0Panel.setLayout(new GridBagLayout());
        this.port0Panel.setBackground(new Color(0, 0, 0));
        this.port0Panel.setMaximumSize(new Dimension(250, 120));
        this.port0Panel.setMinimumSize(new Dimension(250, 120));
        this.port0Panel.setPreferredSize(new Dimension(250, 120));
        this.p0_label0.setBackground(new Color(0, 0, 0));
        this.p0_label0.setFont(new Font("Monospaced", 1, 10));
        this.p0_label0.setForeground(new Color(255, 255, 255));
        this.p0_label0.setText("P0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.port0Panel.add((Component)this.p0_label0, gridBagConstraints);
        this.p0_label1.setBackground(new Color(0, 0, 0));
        this.p0_label1.setFont(new Font("Monospaced", 1, 10));
        this.p0_label1.setForeground(new Color(255, 255, 255));
        this.p0_label1.setText("P0.1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.port0Panel.add((Component)this.p0_label1, gridBagConstraints);
        this.p0_label2.setBackground(new Color(0, 0, 0));
        this.p0_label2.setFont(new Font("Monospaced", 1, 10));
        this.p0_label2.setForeground(new Color(255, 255, 255));
        this.p0_label2.setText("P0.2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.port0Panel.add((Component)this.p0_label2, gridBagConstraints);
        this.p0_label3.setBackground(new Color(0, 0, 0));
        this.p0_label3.setFont(new Font("Monospaced", 1, 10));
        this.p0_label3.setForeground(new Color(255, 255, 255));
        this.p0_label3.setText("P0.3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.port0Panel.add((Component)this.p0_label3, gridBagConstraints);
        this.p0_label4.setBackground(new Color(0, 0, 0));
        this.p0_label4.setFont(new Font("Monospaced", 1, 10));
        this.p0_label4.setForeground(new Color(255, 255, 255));
        this.p0_label4.setText("P0.4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.port0Panel.add((Component)this.p0_label4, gridBagConstraints);
        this.p0_label5.setBackground(new Color(0, 0, 0));
        this.p0_label5.setFont(new Font("Monospaced", 1, 10));
        this.p0_label5.setForeground(new Color(255, 255, 255));
        this.p0_label5.setText("P0.5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.port0Panel.add((Component)this.p0_label5, gridBagConstraints);
        this.p0_label6.setBackground(new Color(0, 0, 0));
        this.p0_label6.setFont(new Font("Monospaced", 1, 10));
        this.p0_label6.setForeground(new Color(255, 255, 255));
        this.p0_label6.setText("P0.6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.port0Panel.add((Component)this.p0_label6, gridBagConstraints);
        this.p0_label7.setBackground(new Color(0, 0, 0));
        this.p0_label7.setFont(new Font("Monospaced", 1, 10));
        this.p0_label7.setForeground(new Color(255, 255, 255));
        this.p0_label7.setText("P0.7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.port0Panel.add((Component)this.p0_label7, gridBagConstraints);
        this.p0_0.setEditable(false);
        this.p0_0.setFont(new Font("Monospaced", 0, 10));
        this.p0_0.setHorizontalAlignment(0);
        this.p0_0.setText("1");
        this.p0_0.setMaximumSize(new Dimension(15, 15));
        this.p0_0.setMinimumSize(new Dimension(15, 15));
        this.p0_0.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.port0Panel.add((Component)this.p0_0, gridBagConstraints);
        this.p0_1.setEditable(false);
        this.p0_1.setFont(new Font("Monospaced", 0, 10));
        this.p0_1.setHorizontalAlignment(0);
        this.p0_1.setText("1");
        this.p0_1.setMaximumSize(new Dimension(15, 15));
        this.p0_1.setMinimumSize(new Dimension(15, 15));
        this.p0_1.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.port0Panel.add((Component)this.p0_1, gridBagConstraints);
        this.p0_2.setEditable(false);
        this.p0_2.setFont(new Font("Monospaced", 0, 10));
        this.p0_2.setHorizontalAlignment(0);
        this.p0_2.setText("1");
        this.p0_2.setMaximumSize(new Dimension(15, 15));
        this.p0_2.setMinimumSize(new Dimension(15, 15));
        this.p0_2.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.port0Panel.add((Component)this.p0_2, gridBagConstraints);
        this.p0_3.setEditable(false);
        this.p0_3.setFont(new Font("Monospaced", 0, 10));
        this.p0_3.setHorizontalAlignment(0);
        this.p0_3.setText("1");
        this.p0_3.setMaximumSize(new Dimension(15, 15));
        this.p0_3.setMinimumSize(new Dimension(15, 15));
        this.p0_3.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.port0Panel.add((Component)this.p0_3, gridBagConstraints);
        this.p0_4.setEditable(false);
        this.p0_4.setFont(new Font("Monospaced", 0, 10));
        this.p0_4.setHorizontalAlignment(0);
        this.p0_4.setText("1");
        this.p0_4.setMaximumSize(new Dimension(15, 15));
        this.p0_4.setMinimumSize(new Dimension(15, 15));
        this.p0_4.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.port0Panel.add((Component)this.p0_4, gridBagConstraints);
        this.p0_5.setEditable(false);
        this.p0_5.setFont(new Font("Monospaced", 0, 10));
        this.p0_5.setHorizontalAlignment(0);
        this.p0_5.setText("1");
        this.p0_5.setMaximumSize(new Dimension(15, 15));
        this.p0_5.setMinimumSize(new Dimension(15, 15));
        this.p0_5.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.port0Panel.add((Component)this.p0_5, gridBagConstraints);
        this.p0_6.setEditable(false);
        this.p0_6.setFont(new Font("Monospaced", 0, 10));
        this.p0_6.setHorizontalAlignment(0);
        this.p0_6.setText("1");
        this.p0_6.setMaximumSize(new Dimension(15, 15));
        this.p0_6.setMinimumSize(new Dimension(15, 15));
        this.p0_6.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.port0Panel.add((Component)this.p0_6, gridBagConstraints);
        this.p0_7.setEditable(false);
        this.p0_7.setFont(new Font("Monospaced", 0, 10));
        this.p0_7.setHorizontalAlignment(0);
        this.p0_7.setText("1");
        this.p0_7.setMaximumSize(new Dimension(15, 15));
        this.p0_7.setMinimumSize(new Dimension(15, 15));
        this.p0_7.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.port0Panel.add((Component)this.p0_7, gridBagConstraints);
        this.p0_0Descr.setBackground(new Color(0, 0, 0));
        this.p0_0Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_0Descr.setForeground(new Color(255, 255, 255));
        this.p0_0Descr.setText("keypad row 0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_0Descr, gridBagConstraints);
        this.p0_1Descr.setBackground(new Color(0, 0, 0));
        this.p0_1Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_1Descr.setForeground(new Color(255, 255, 255));
        this.p0_1Descr.setText("keypad row 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_1Descr, gridBagConstraints);
        this.p0_2Descr.setBackground(new Color(0, 0, 0));
        this.p0_2Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_2Descr.setForeground(new Color(255, 255, 255));
        this.p0_2Descr.setText("keypad row 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_2Descr, gridBagConstraints);
        this.p0_3Descr.setBackground(new Color(0, 0, 0));
        this.p0_3Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_3Descr.setForeground(new Color(255, 255, 255));
        this.p0_3Descr.setText("keypad row 3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_3Descr, gridBagConstraints);
        this.p0_4Descr.setBackground(new Color(0, 0, 0));
        this.p0_4Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_4Descr.setForeground(new Color(255, 255, 255));
        this.p0_4Descr.setText("keypad column 0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_4Descr, gridBagConstraints);
        this.p0_5Descr.setBackground(new Color(0, 0, 0));
        this.p0_5Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_5Descr.setForeground(new Color(255, 255, 255));
        this.p0_5Descr.setText("keypad column 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_5Descr, gridBagConstraints);
        this.p0_6Descr.setBackground(new Color(0, 0, 0));
        this.p0_6Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_6Descr.setForeground(new Color(255, 255, 255));
        this.p0_6Descr.setText("keypad column 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_6Descr, gridBagConstraints);
        this.p0_7Descr.setBackground(new Color(0, 0, 0));
        this.p0_7Descr.setFont(new Font("Monospaced", 1, 10));
        this.p0_7Descr.setForeground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.port0Panel.add((Component)this.p0_7Descr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port0Panel, gridBagConstraints);
        this.port1Panel.setLayout(new GridBagLayout());
        this.port1Panel.setBackground(new Color(0, 0, 0));
        this.port1Panel.setMaximumSize(new Dimension(214, 120));
        this.port1Panel.setMinimumSize(new Dimension(214, 120));
        this.port1Panel.setPreferredSize(new Dimension(214, 120));
        this.p1_label0.setBackground(new Color(0, 0, 0));
        this.p1_label0.setFont(new Font("Monospaced", 1, 10));
        this.p1_label0.setForeground(new Color(153, 153, 255));
        this.p1_label0.setText("P1.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.port1Panel.add((Component)this.p1_label0, gridBagConstraints);
        this.p1_label1.setBackground(new Color(0, 0, 0));
        this.p1_label1.setFont(new Font("Monospaced", 1, 10));
        this.p1_label1.setForeground(new Color(153, 153, 255));
        this.p1_label1.setText("P1.1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.port1Panel.add((Component)this.p1_label1, gridBagConstraints);
        this.p1_label2.setBackground(new Color(0, 0, 0));
        this.p1_label2.setFont(new Font("Monospaced", 1, 10));
        this.p1_label2.setForeground(new Color(153, 153, 255));
        this.p1_label2.setText("P1.2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.port1Panel.add((Component)this.p1_label2, gridBagConstraints);
        this.p1_label3.setBackground(new Color(0, 0, 0));
        this.p1_label3.setFont(new Font("Monospaced", 1, 10));
        this.p1_label3.setForeground(new Color(153, 153, 255));
        this.p1_label3.setText("P1.3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.port1Panel.add((Component)this.p1_label3, gridBagConstraints);
        this.p1_label4.setBackground(new Color(0, 0, 0));
        this.p1_label4.setFont(new Font("Monospaced", 1, 10));
        this.p1_label4.setForeground(new Color(153, 153, 255));
        this.p1_label4.setText("P1.4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.port1Panel.add((Component)this.p1_label4, gridBagConstraints);
        this.p1_label5.setBackground(new Color(0, 0, 0));
        this.p1_label5.setFont(new Font("Monospaced", 1, 10));
        this.p1_label5.setForeground(new Color(153, 153, 255));
        this.p1_label5.setText("P1.5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.port1Panel.add((Component)this.p1_label5, gridBagConstraints);
        this.p1_label6.setBackground(new Color(0, 0, 0));
        this.p1_label6.setFont(new Font("Monospaced", 1, 10));
        this.p1_label6.setForeground(new Color(153, 153, 255));
        this.p1_label6.setText("P1.6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.port1Panel.add((Component)this.p1_label6, gridBagConstraints);
        this.p1_label7.setBackground(new Color(0, 0, 0));
        this.p1_label7.setFont(new Font("Monospaced", 1, 10));
        this.p1_label7.setForeground(new Color(153, 153, 255));
        this.p1_label7.setText("P1.7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.port1Panel.add((Component)this.p1_label7, gridBagConstraints);
        this.p1_0.setEditable(false);
        this.p1_0.setFont(new Font("Monospaced", 0, 10));
        this.p1_0.setHorizontalAlignment(0);
        this.p1_0.setText("1");
        this.p1_0.setMaximumSize(new Dimension(15, 15));
        this.p1_0.setMinimumSize(new Dimension(15, 15));
        this.p1_0.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.port1Panel.add((Component)this.p1_0, gridBagConstraints);
        this.p1_1.setEditable(false);
        this.p1_1.setFont(new Font("Monospaced", 0, 10));
        this.p1_1.setHorizontalAlignment(0);
        this.p1_1.setText("1");
        this.p1_1.setMaximumSize(new Dimension(15, 15));
        this.p1_1.setMinimumSize(new Dimension(15, 15));
        this.p1_1.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.port1Panel.add((Component)this.p1_1, gridBagConstraints);
        this.p1_2.setEditable(false);
        this.p1_2.setFont(new Font("Monospaced", 0, 10));
        this.p1_2.setHorizontalAlignment(0);
        this.p1_2.setText("1");
        this.p1_2.setMaximumSize(new Dimension(15, 15));
        this.p1_2.setMinimumSize(new Dimension(15, 15));
        this.p1_2.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.port1Panel.add((Component)this.p1_2, gridBagConstraints);
        this.p1_3.setEditable(false);
        this.p1_3.setFont(new Font("Monospaced", 0, 10));
        this.p1_3.setHorizontalAlignment(0);
        this.p1_3.setText("1");
        this.p1_3.setMaximumSize(new Dimension(15, 15));
        this.p1_3.setMinimumSize(new Dimension(15, 15));
        this.p1_3.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.port1Panel.add((Component)this.p1_3, gridBagConstraints);
        this.p1_4.setEditable(false);
        this.p1_4.setFont(new Font("Monospaced", 0, 10));
        this.p1_4.setHorizontalAlignment(0);
        this.p1_4.setText("1");
        this.p1_4.setMaximumSize(new Dimension(15, 15));
        this.p1_4.setMinimumSize(new Dimension(15, 15));
        this.p1_4.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.port1Panel.add((Component)this.p1_4, gridBagConstraints);
        this.p1_5.setEditable(false);
        this.p1_5.setFont(new Font("Monospaced", 0, 10));
        this.p1_5.setHorizontalAlignment(0);
        this.p1_5.setText("1");
        this.p1_5.setMaximumSize(new Dimension(15, 15));
        this.p1_5.setMinimumSize(new Dimension(15, 15));
        this.p1_5.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.port1Panel.add((Component)this.p1_5, gridBagConstraints);
        this.p1_6.setEditable(false);
        this.p1_6.setFont(new Font("Monospaced", 0, 10));
        this.p1_6.setHorizontalAlignment(0);
        this.p1_6.setText("1");
        this.p1_6.setMaximumSize(new Dimension(15, 15));
        this.p1_6.setMinimumSize(new Dimension(15, 15));
        this.p1_6.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.port1Panel.add((Component)this.p1_6, gridBagConstraints);
        this.p1_7.setEditable(false);
        this.p1_7.setFont(new Font("Monospaced", 0, 10));
        this.p1_7.setHorizontalAlignment(0);
        this.p1_7.setText("1");
        this.p1_7.setMaximumSize(new Dimension(15, 15));
        this.p1_7.setMinimumSize(new Dimension(15, 15));
        this.p1_7.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.port1Panel.add((Component)this.p1_7, gridBagConstraints);
        this.p1_0Descr.setBackground(new Color(0, 0, 0));
        this.p1_0Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_0Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_0Descr, gridBagConstraints);
        this.p1_1Descr.setBackground(new Color(0, 0, 0));
        this.p1_1Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_1Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_1Descr, gridBagConstraints);
        this.p1_2Descr.setBackground(new Color(0, 0, 0));
        this.p1_2Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_2Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_2Descr, gridBagConstraints);
        this.p1_3Descr.setBackground(new Color(0, 0, 0));
        this.p1_3Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_3Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_3Descr, gridBagConstraints);
        this.p1_4Descr.setBackground(new Color(0, 0, 0));
        this.p1_4Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_4Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_4Descr, gridBagConstraints);
        this.p1_5Descr.setBackground(new Color(0, 0, 0));
        this.p1_5Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_5Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_5Descr, gridBagConstraints);
        this.p1_6Descr.setBackground(new Color(0, 0, 0));
        this.p1_6Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_6Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_6Descr, gridBagConstraints);
        this.p1_7Descr.setBackground(new Color(0, 0, 0));
        this.p1_7Descr.setFont(new Font("Monospaced", 1, 10));
        this.p1_7Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.port1Panel.add((Component)this.p1_7Descr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port1Panel, gridBagConstraints);
        this.port2Panel.setLayout(new GridBagLayout());
        this.port2Panel.setBackground(new Color(0, 0, 0));
        this.port2Panel.setMaximumSize(new Dimension(166, 120));
        this.port2Panel.setMinimumSize(new Dimension(166, 120));
        this.port2Panel.setPreferredSize(new Dimension(166, 120));
        this.p2_label0.setBackground(new Color(0, 0, 0));
        this.p2_label0.setFont(new Font("Monospaced", 1, 10));
        this.p2_label0.setForeground(new Color(255, 255, 255));
        this.p2_label0.setText("P2.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.port2Panel.add((Component)this.p2_label0, gridBagConstraints);
        this.p2_label1.setBackground(new Color(0, 0, 0));
        this.p2_label1.setFont(new Font("Monospaced", 1, 10));
        this.p2_label1.setForeground(new Color(255, 255, 255));
        this.p2_label1.setText("P2.1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.port2Panel.add((Component)this.p2_label1, gridBagConstraints);
        this.p2_label2.setBackground(new Color(0, 0, 0));
        this.p2_label2.setFont(new Font("Monospaced", 1, 10));
        this.p2_label2.setForeground(new Color(255, 255, 255));
        this.p2_label2.setText("P2.2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.port2Panel.add((Component)this.p2_label2, gridBagConstraints);
        this.p2_label3.setBackground(new Color(0, 0, 0));
        this.p2_label3.setFont(new Font("Monospaced", 1, 10));
        this.p2_label3.setForeground(new Color(255, 255, 255));
        this.p2_label3.setText("P2.3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.port2Panel.add((Component)this.p2_label3, gridBagConstraints);
        this.p2_label4.setBackground(new Color(0, 0, 0));
        this.p2_label4.setFont(new Font("Monospaced", 1, 10));
        this.p2_label4.setForeground(new Color(255, 255, 255));
        this.p2_label4.setText("P2.4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.port2Panel.add((Component)this.p2_label4, gridBagConstraints);
        this.p2_label5.setBackground(new Color(0, 0, 0));
        this.p2_label5.setFont(new Font("Monospaced", 1, 10));
        this.p2_label5.setForeground(new Color(255, 255, 255));
        this.p2_label5.setText("P2.5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.port2Panel.add((Component)this.p2_label5, gridBagConstraints);
        this.p2_label6.setBackground(new Color(0, 0, 0));
        this.p2_label6.setFont(new Font("Monospaced", 1, 10));
        this.p2_label6.setForeground(new Color(255, 255, 255));
        this.p2_label6.setText("P2.6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.port2Panel.add((Component)this.p2_label6, gridBagConstraints);
        this.p2_label7.setBackground(new Color(0, 0, 0));
        this.p2_label7.setFont(new Font("Monospaced", 1, 10));
        this.p2_label7.setForeground(new Color(255, 255, 255));
        this.p2_label7.setText("P2.7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.port2Panel.add((Component)this.p2_label7, gridBagConstraints);
        this.p2_0.setEditable(false);
        this.p2_0.setFont(new Font("Monospaced", 0, 10));
        this.p2_0.setHorizontalAlignment(0);
        this.p2_0.setText("1");
        this.p2_0.setMaximumSize(new Dimension(15, 15));
        this.p2_0.setMinimumSize(new Dimension(15, 15));
        this.p2_0.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.port2Panel.add((Component)this.p2_0, gridBagConstraints);
        this.p2_1.setEditable(false);
        this.p2_1.setFont(new Font("Monospaced", 0, 10));
        this.p2_1.setHorizontalAlignment(0);
        this.p2_1.setText("1");
        this.p2_1.setMaximumSize(new Dimension(15, 15));
        this.p2_1.setMinimumSize(new Dimension(15, 15));
        this.p2_1.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.port2Panel.add((Component)this.p2_1, gridBagConstraints);
        this.p2_2.setEditable(false);
        this.p2_2.setFont(new Font("Monospaced", 0, 10));
        this.p2_2.setHorizontalAlignment(0);
        this.p2_2.setText("1");
        this.p2_2.setMaximumSize(new Dimension(15, 15));
        this.p2_2.setMinimumSize(new Dimension(15, 15));
        this.p2_2.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.port2Panel.add((Component)this.p2_2, gridBagConstraints);
        this.p2_3.setEditable(false);
        this.p2_3.setFont(new Font("Monospaced", 0, 10));
        this.p2_3.setHorizontalAlignment(0);
        this.p2_3.setText("1");
        this.p2_3.setMaximumSize(new Dimension(15, 15));
        this.p2_3.setMinimumSize(new Dimension(15, 15));
        this.p2_3.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.port2Panel.add((Component)this.p2_3, gridBagConstraints);
        this.p2_4.setEditable(false);
        this.p2_4.setFont(new Font("Monospaced", 0, 10));
        this.p2_4.setHorizontalAlignment(0);
        this.p2_4.setText("1");
        this.p2_4.setMaximumSize(new Dimension(15, 15));
        this.p2_4.setMinimumSize(new Dimension(15, 15));
        this.p2_4.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.port2Panel.add((Component)this.p2_4, gridBagConstraints);
        this.p2_5.setEditable(false);
        this.p2_5.setFont(new Font("Monospaced", 0, 10));
        this.p2_5.setHorizontalAlignment(0);
        this.p2_5.setText("1");
        this.p2_5.setMaximumSize(new Dimension(15, 15));
        this.p2_5.setMinimumSize(new Dimension(15, 15));
        this.p2_5.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.port2Panel.add((Component)this.p2_5, gridBagConstraints);
        this.p2_6.setEditable(false);
        this.p2_6.setFont(new Font("Monospaced", 0, 10));
        this.p2_6.setHorizontalAlignment(0);
        this.p2_6.setText("1");
        this.p2_6.setMaximumSize(new Dimension(15, 15));
        this.p2_6.setMinimumSize(new Dimension(15, 15));
        this.p2_6.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.port2Panel.add((Component)this.p2_6, gridBagConstraints);
        this.p2_7.setEditable(false);
        this.p2_7.setFont(new Font("Monospaced", 0, 10));
        this.p2_7.setHorizontalAlignment(0);
        this.p2_7.setText("1");
        this.p2_7.setMaximumSize(new Dimension(15, 15));
        this.p2_7.setMinimumSize(new Dimension(15, 15));
        this.p2_7.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.port2Panel.add((Component)this.p2_7, gridBagConstraints);
        this.p2_0Descr.setBackground(new Color(0, 0, 0));
        this.p2_0Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_0Descr.setForeground(new Color(255, 255, 255));
        this.p2_0Descr.setText("switch 0/ADC bit 0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_0Descr, gridBagConstraints);
        this.p2_1Descr.setBackground(new Color(0, 0, 0));
        this.p2_1Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_1Descr.setForeground(new Color(255, 255, 255));
        this.p2_1Descr.setText("switch 1/ADC bit 1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_1Descr, gridBagConstraints);
        this.p2_2Descr.setBackground(new Color(0, 0, 0));
        this.p2_2Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_2Descr.setForeground(new Color(255, 255, 255));
        this.p2_2Descr.setText("switch 2/ADC bit 2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_2Descr, gridBagConstraints);
        this.p2_3Descr.setBackground(new Color(0, 0, 0));
        this.p2_3Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_3Descr.setForeground(new Color(255, 255, 255));
        this.p2_3Descr.setText("switch 3/ADC bit 3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_3Descr, gridBagConstraints);
        this.p2_4Descr.setBackground(new Color(0, 0, 0));
        this.p2_4Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_4Descr.setForeground(new Color(255, 255, 255));
        this.p2_4Descr.setText("switch 4/ADC bit 4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_4Descr, gridBagConstraints);
        this.p2_5Descr.setBackground(new Color(0, 0, 0));
        this.p2_5Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_5Descr.setForeground(new Color(255, 255, 255));
        this.p2_5Descr.setText("switch 5/ADC bit 5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_5Descr, gridBagConstraints);
        this.p2_6Descr.setBackground(new Color(0, 0, 0));
        this.p2_6Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_6Descr.setForeground(new Color(255, 255, 255));
        this.p2_6Descr.setText("switch 6/ADC bit 6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_6Descr, gridBagConstraints);
        this.p2_7Descr.setBackground(new Color(0, 0, 0));
        this.p2_7Descr.setFont(new Font("Monospaced", 1, 10));
        this.p2_7Descr.setForeground(new Color(255, 255, 255));
        this.p2_7Descr.setText("switch 7/ADC bit 7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.port2Panel.add((Component)this.p2_7Descr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port2Panel, gridBagConstraints);
        this.port3Panel.setLayout(new GridBagLayout());
        this.port3Panel.setBackground(new Color(0, 0, 0));
        this.port3Panel.setMaximumSize(new Dimension(250, 120));
        this.port3Panel.setMinimumSize(new Dimension(250, 120));
        this.port3Panel.setPreferredSize(new Dimension(250, 120));
        this.p3_label0.setBackground(new Color(0, 0, 0));
        this.p3_label0.setFont(new Font("Monospaced", 1, 10));
        this.p3_label0.setForeground(new Color(153, 153, 255));
        this.p3_label0.setText("P3.0");
        this.p3_label0.setToolTipText("RXD");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.port3Panel.add((Component)this.p3_label0, gridBagConstraints);
        this.p3_label1.setBackground(new Color(0, 0, 0));
        this.p3_label1.setFont(new Font("Monospaced", 1, 10));
        this.p3_label1.setForeground(new Color(153, 153, 255));
        this.p3_label1.setText("P3.1");
        this.p3_label1.setToolTipText("TXD");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.port3Panel.add((Component)this.p3_label1, gridBagConstraints);
        this.p3_label2.setBackground(new Color(0, 0, 0));
        this.p3_label2.setFont(new Font("Monospaced", 1, 10));
        this.p3_label2.setForeground(new Color(153, 153, 255));
        this.p3_label2.setText("P3.2");
        this.p3_label2.setToolTipText("INT0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.port3Panel.add((Component)this.p3_label2, gridBagConstraints);
        this.p3_label3.setBackground(new Color(0, 0, 0));
        this.p3_label3.setFont(new Font("Monospaced", 1, 10));
        this.p3_label3.setForeground(new Color(153, 153, 255));
        this.p3_label3.setText("P3.3");
        this.p3_label3.setToolTipText("INT1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.port3Panel.add((Component)this.p3_label3, gridBagConstraints);
        this.p3_label4.setBackground(new Color(0, 0, 0));
        this.p3_label4.setFont(new Font("Monospaced", 1, 10));
        this.p3_label4.setForeground(new Color(153, 153, 255));
        this.p3_label4.setText("P3.4");
        this.p3_label4.setToolTipText("T0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.port3Panel.add((Component)this.p3_label4, gridBagConstraints);
        this.p3_label5.setBackground(new Color(0, 0, 0));
        this.p3_label5.setFont(new Font("Monospaced", 1, 10));
        this.p3_label5.setForeground(new Color(153, 153, 255));
        this.p3_label5.setText("P3.5");
        this.p3_label5.setToolTipText("T1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.port3Panel.add((Component)this.p3_label5, gridBagConstraints);
        this.p3_label6.setBackground(new Color(0, 0, 0));
        this.p3_label6.setFont(new Font("Monospaced", 1, 10));
        this.p3_label6.setForeground(new Color(153, 153, 255));
        this.p3_label6.setText("P3.6");
        this.p3_label6.setToolTipText("WR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.port3Panel.add((Component)this.p3_label6, gridBagConstraints);
        this.p3_label7.setBackground(new Color(0, 0, 0));
        this.p3_label7.setFont(new Font("Monospaced", 1, 10));
        this.p3_label7.setForeground(new Color(153, 153, 255));
        this.p3_label7.setText("P3.7");
        this.p3_label7.setToolTipText("RD");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.port3Panel.add((Component)this.p3_label7, gridBagConstraints);
        this.p3_0.setEditable(false);
        this.p3_0.setFont(new Font("Monospaced", 0, 10));
        this.p3_0.setHorizontalAlignment(0);
        this.p3_0.setText("1");
        this.p3_0.setMaximumSize(new Dimension(15, 15));
        this.p3_0.setMinimumSize(new Dimension(15, 15));
        this.p3_0.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.port3Panel.add((Component)this.p3_0, gridBagConstraints);
        this.p3_1.setEditable(false);
        this.p3_1.setFont(new Font("Monospaced", 0, 10));
        this.p3_1.setHorizontalAlignment(0);
        this.p3_1.setText("1");
        this.p3_1.setMaximumSize(new Dimension(15, 15));
        this.p3_1.setMinimumSize(new Dimension(15, 15));
        this.p3_1.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.port3Panel.add((Component)this.p3_1, gridBagConstraints);
        this.p3_2.setEditable(false);
        this.p3_2.setFont(new Font("Monospaced", 0, 10));
        this.p3_2.setHorizontalAlignment(0);
        this.p3_2.setText("1");
        this.p3_2.setMaximumSize(new Dimension(15, 15));
        this.p3_2.setMinimumSize(new Dimension(15, 15));
        this.p3_2.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.port3Panel.add((Component)this.p3_2, gridBagConstraints);
        this.p3_3.setEditable(false);
        this.p3_3.setFont(new Font("Monospaced", 0, 10));
        this.p3_3.setHorizontalAlignment(0);
        this.p3_3.setText("1");
        this.p3_3.setMaximumSize(new Dimension(15, 15));
        this.p3_3.setMinimumSize(new Dimension(15, 15));
        this.p3_3.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.port3Panel.add((Component)this.p3_3, gridBagConstraints);
        this.p3_4.setEditable(false);
        this.p3_4.setFont(new Font("Monospaced", 0, 10));
        this.p3_4.setHorizontalAlignment(0);
        this.p3_4.setText("1");
        this.p3_4.setMaximumSize(new Dimension(15, 15));
        this.p3_4.setMinimumSize(new Dimension(15, 15));
        this.p3_4.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.port3Panel.add((Component)this.p3_4, gridBagConstraints);
        this.p3_5.setEditable(false);
        this.p3_5.setFont(new Font("Monospaced", 0, 10));
        this.p3_5.setHorizontalAlignment(0);
        this.p3_5.setText("1");
        this.p3_5.setMaximumSize(new Dimension(15, 15));
        this.p3_5.setMinimumSize(new Dimension(15, 15));
        this.p3_5.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.port3Panel.add((Component)this.p3_5, gridBagConstraints);
        this.p3_6.setEditable(false);
        this.p3_6.setFont(new Font("Monospaced", 0, 10));
        this.p3_6.setHorizontalAlignment(0);
        this.p3_6.setText("1");
        this.p3_6.setMaximumSize(new Dimension(15, 15));
        this.p3_6.setMinimumSize(new Dimension(15, 15));
        this.p3_6.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.port3Panel.add((Component)this.p3_6, gridBagConstraints);
        this.p3_7.setEditable(false);
        this.p3_7.setFont(new Font("Monospaced", 0, 10));
        this.p3_7.setHorizontalAlignment(0);
        this.p3_7.setText("1");
        this.p3_7.setMaximumSize(new Dimension(15, 15));
        this.p3_7.setMinimumSize(new Dimension(15, 15));
        this.p3_7.setPreferredSize(new Dimension(15, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.port3Panel.add((Component)this.p3_7, gridBagConstraints);
        this.p3_0Descr.setBackground(new Color(0, 0, 0));
        this.p3_0Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_0Descr.setForeground(new Color(153, 153, 255));
        this.p3_0Descr.setText("motor control bit 0/ext. UART Tx");
        this.p3_0Descr.setToolTipText("Hence motor and UART may not be used at the same time");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_0Descr, gridBagConstraints);
        this.p3_1Descr.setBackground(new Color(0, 0, 0));
        this.p3_1Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_1Descr.setForeground(new Color(153, 153, 255));
        this.p3_1Descr.setText("motor control bit 1/ext. UART Rx");
        this.p3_1Descr.setToolTipText("Hence motor and UART may not be used at the same time");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_1Descr, gridBagConstraints);
        this.p3_2Descr.setBackground(new Color(0, 0, 0));
        this.p3_2Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_2Descr.setForeground(new Color(153, 153, 255));
        this.p3_2Descr.setText("ADC INTR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_2Descr, gridBagConstraints);
        this.p3_3Descr.setBackground(new Color(0, 0, 0));
        this.p3_3Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_3Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_3Descr, gridBagConstraints);
        this.p3_4Descr.setBackground(new Color(0, 0, 0));
        this.p3_4Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_4Descr.setForeground(new Color(153, 153, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_4Descr, gridBagConstraints);
        this.p3_5Descr.setBackground(new Color(0, 0, 0));
        this.p3_5Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_5Descr.setForeground(new Color(153, 153, 255));
        this.p3_5Descr.setText("motor sensor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_5Descr, gridBagConstraints);
        this.p3_6Descr.setBackground(new Color(0, 0, 0));
        this.p3_6Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_6Descr.setForeground(new Color(153, 153, 255));
        this.p3_6Descr.setText("ADC WR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_6Descr, gridBagConstraints);
        this.p3_7Descr.setBackground(new Color(0, 0, 0));
        this.p3_7Descr.setFont(new Font("Monospaced", 1, 10));
        this.p3_7Descr.setForeground(new Color(153, 153, 255));
        this.p3_7Descr.setText("ADC RD/comparator output");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.port3Panel.add((Component)this.p3_7Descr, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.portPinConnectionsPanel.add((Component)this.port3Panel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 11;
        this.assembly.add((Component)this.portPinConnectionsPanel, gridBagConstraints);
        this.controlPanel.setLayout(new GridBagLayout());
        this.controlPanel.setBackground(new Color(102, 153, 255));
        this.controlPanel.setMaximumSize(new Dimension(320, 20));
        this.controlPanel.setMinimumSize(new Dimension(320, 20));
        this.controlPanel.setPreferredSize(new Dimension(320, 20));
        this.run.setFont(new Font("Monospaced", 1, 12));
        this.run.setText("Run");
        this.run.setToolTipText("Execute instruction at quarter second intervals.");
        this.run.setBorder(new BevelBorder(0));
        this.run.setMaximumSize(new Dimension(40, 19));
        this.run.setMinimumSize(new Dimension(40, 19));
        this.run.setPreferredSize(new Dimension(40, 19));
        this.run.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.runMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.run, gridBagConstraints);
        this.quit.setBackground(new Color(255, 102, 102));
        this.quit.setFont(new Font("Monospaced", 1, 12));
        this.quit.setText("Exit");
        this.quit.setToolTipText("Close simulator.");
        this.quit.setBorder(new BevelBorder(0));
        this.quit.setMaximumSize(new Dimension(40, 19));
        this.quit.setMinimumSize(new Dimension(40, 19));
        this.quit.setPreferredSize(new Dimension(40, 19));
        this.quit.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.quitMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.quit, gridBagConstraints);
        this.copy.setFont(new Font("Monospaced", 1, 12));
        this.copy.setText("Copy");
        this.copy.setToolTipText("Copy assembly code to clipboard.");
        this.copy.setBorder(new BevelBorder(0));
        this.copy.setMaximumSize(new Dimension(40, 19));
        this.copy.setMinimumSize(new Dimension(40, 19));
        this.copy.setPreferredSize(new Dimension(40, 19));
        this.copy.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.copyMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.copy, gridBagConstraints);
        this.paste.setFont(new Font("Monospaced", 1, 12));
        this.paste.setText("Paste");
        this.paste.setToolTipText("Paste text from clipboard into assembly code box below.");
        this.paste.setBorder(new BevelBorder(0));
        this.paste.setMaximumSize(new Dimension(40, 19));
        this.paste.setMinimumSize(new Dimension(40, 19));
        this.paste.setPreferredSize(new Dimension(40, 19));
        this.paste.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.pasteMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.paste, gridBagConstraints);
        this.fileOpen.setBackground(new Color(153, 153, 255));
        this.fileOpen.setFont(new Font("Monospaced", 1, 12));
        this.fileOpen.setText("Load");
        this.fileOpen.setToolTipText("Load an assembly source file.");
        this.fileOpen.setBorder(new BevelBorder(0));
        this.fileOpen.setMaximumSize(new Dimension(40, 19));
        this.fileOpen.setMinimumSize(new Dimension(40, 19));
        this.fileOpen.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.fileOpen, gridBagConstraints);
        this.reset.setFont(new Font("Monospaced", 1, 12));
        this.reset.setText("Reset");
        this.reset.setToolTipText("Reset 8051 and external hardware.");
        this.reset.setBorder(new BevelBorder(0));
        this.reset.setMaximumSize(new Dimension(40, 19));
        this.reset.setMinimumSize(new Dimension(40, 19));
        this.reset.setPreferredSize(new Dimension(40, 19));
        this.reset.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.resetMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.reset, gridBagConstraints);
        this.step.setFont(new Font("Monospaced", 1, 12));
        this.step.setText("Assm");
        this.step.setToolTipText("Assemble source code.");
        this.step.setBorder(new BevelBorder(0));
        this.step.setMaximumSize(new Dimension(40, 19));
        this.step.setMinimumSize(new Dimension(40, 19));
        this.step.setPreferredSize(new Dimension(40, 19));
        this.step.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Simulator.this.stepMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.step, gridBagConstraints);
        this.fileSave.setBackground(new Color(153, 153, 255));
        this.fileSave.setFont(new Font("Monospaced", 1, 12));
        this.fileSave.setText("Save");
        this.fileSave.setToolTipText("Save assembly source file.");
        this.fileSave.setBorder(new BevelBorder(0));
        this.fileSave.setMaximumSize(new Dimension(40, 19));
        this.fileSave.setMinimumSize(new Dimension(40, 19));
        this.fileSave.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.fileSave, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.assembly.add((Component)this.controlPanel, gridBagConstraints);
        this.assemblyCodeBoxPanel.setMaximumSize(new Dimension(320, 420));
        this.assemblyCodeBoxPanel.setMinimumSize(new Dimension(320, 420));
        this.assemblyCodeBoxPanel.setPreferredSize(new Dimension(320, 420));
        this.assemblyCodeBoxPanel.setWheelScrollingEnabled(true);
        this.assemblyCodeBoxPanel.setViewportView(this.assemblyCodeBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.assembly.add((Component)this.assemblyCodeBoxPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.assembly, gridBagConstraints);
    }

    private void keypadTypesComboBoxActionPerformed(ActionEvent evt) {
        this.settings.setKeypadType(this.keypadTypesComboBox.getSelectedIndex());
        this.openAllKeys();
        this.keypadGuiUpdate();
    }

    private void baudRateComboBoxActionPerformed(ActionEvent evt) {
        this.cpu.dataMemory.port3.uart.setBaudRate((String)this.baudRateComboBox.getSelectedItem());
        this.settings.setBaudRateIndex(this.baudRateComboBox.getSelectedIndex());
    }

    private void removeAllBreakpointsButtonMouseClicked(MouseEvent evt) {
        if (this.breakpoints == null || this.breakpoints.size() == 0) {
            return;
        }
        String assembly = this.assemblyCodeBox.getText();
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            int address = (Integer)this.breakpoints.elementAt(i);
            String s = Text.inHex(address, false, 4);
            assembly = assembly.replace(s + "*", s + "|");
        }
        this.breakpoints = null;
        this.assemblyCodeBox.setText(assembly);
        this.removeAllBreakpointsButton.setEnabled(false);
        if (!this.cpu.running) {
            this.highlightNextInstruction(this.cpu.getPc());
        }
    }

    private void bFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.b, 240, true);
    }

    private void pconFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.pcon, 135, true);
    }

    private void pconActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.pcon, 135, true);
    }

    private void bActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.b, 240, true);
    }

    private void parityMouseClicked(MouseEvent evt) {
        this.parity.setText(this.cpu.dataMemory.port3.uart.changeParity());
        this.settings.setParity(this.cpu.dataMemory.port3.uart.getParity());
    }

    private void dplFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.dpl, 130, true);
    }

    private void dplActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.dpl, 130, true);
    }

    private void dphFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.dph, 131, true);
    }

    private void dphActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.dph, 131, true);
    }

    private void ieFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.ie, 168, true);
    }

    private void ieActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.ie, 168, true);
    }

    private void stepMouseClicked(MouseEvent evt) {
        this.assemblyCodeBox.setEditable(false);
        this.assemblyCodeBox.setBackground(Color.LIGHT_GRAY);
        this.messageBox.setBackground(new Color(204, 204, 204));
        this.step();
    }

    private void motorCurrentStateChanged(ChangeEvent evt) {
        this.cpu.dataMemory.port3.motor.setMotorCurrent(12 - this.motorCurrent.getValue());
    }

    private void changeDisplay(boolean toLed) {
        if (toLed) {
            this.multiplexedDisplayPanel.setVisible(true);
            this.lcdModule.getModuleGraphics().setVisible(false);
            this.ledLcdButton.setText("7 Segment LED Displays");
            this.ledLcdButton.setToolTipText("Click to change to LCD Display");
            this.p0_7Descr.setText("display-select decoder CS/DAC WR");
            this.p0_7Descr.setToolTipText("1 enables decoder - 0 enables DAC inputs");
            if (this.port0Frame != null) {
                this.port0Frame.setPinDescription(7, "display-select decoder CS/DAC WR");
                this.port0Frame.setPinToolTip(7, "1 enables decoder - 0 enables DAC inputs");
            }
            this.p1_7Descr.setText("LED 7/segment dp/DAC bit 7");
            this.p1_6Descr.setText("LED 6/segment g/DAC bit 6");
            this.p1_5Descr.setText("LED 5/segment f/DAC bit 5");
            this.p1_4Descr.setText("LED 4/segment e/DAC bit 4");
            this.p1_3Descr.setText("LED 3/segment d/DAC bit 3");
            this.p1_2Descr.setText("LED 2/segment c/DAC bit 2");
            this.p1_1Descr.setText("LED 1/segment b/DAC bit 1");
            this.p1_0Descr.setText("LED 0/segment a/DAC bit 0");
            if (this.port1Frame != null) {
                this.port1Frame.setPinDescription(7, "LED 7/segment dp/DAC bit 7");
                this.port1Frame.setPinDescription(6, "LED 6/segment g/DAC bit 6");
                this.port1Frame.setPinDescription(5, "LED 5/segment f/DAC bit 5");
                this.port1Frame.setPinDescription(4, "LED 4/segment e/DAC bit 4");
                this.port1Frame.setPinDescription(3, "LED 3/segment d/DAC bit 3");
                this.port1Frame.setPinDescription(2, "LED 2/segment c/DAC bit 2");
                this.port1Frame.setPinDescription(1, "LED 1/segment b/DAC bit 1");
                this.port1Frame.setPinDescription(0, "LED 0/segment a/DAC bit 0");
            }
            this.p3_4Descr.setText("display-select decoder input 1");
            this.p3_3Descr.setText("dsp-select decoder i-p 0/AND o-p");
            this.p3_3Descr.setToolTipText("display-select decoder input 0 and keypad AND gate output");
            if (this.port3Frame != null) {
                this.port3Frame.setPinDescription(4, "display-select decoder input 1");
                this.port3Frame.setPinDescription(3, "dsp-select decoder i-p 0/AND o-p");
                this.port3Frame.setPinToolTip(3, "display-select decoder input 0 and keypad AND gate output");
            }
        } else {
            this.multiplexedDisplayPanel.setVisible(false);
            this.lcdModule.getModuleGraphics().setVisible(true);
            this.ledLcdButton.setText("HD44780 LCD Module");
            this.ledLcdButton.setToolTipText("Click to change to LED Display");
            this.p0_7Descr.setText("DAC WR                          ");
            this.p0_7Descr.setToolTipText("0 enables DAC inputs");
            if (this.port0Frame != null) {
                this.port0Frame.setPinDescription(7, "DAC WR                          ");
                this.port0Frame.setPinToolTip(7, "0 enables DAC inputs");
            }
            this.p1_7Descr.setText("LED 7/LCD DB7/DAC bit 7   ");
            this.p1_6Descr.setText("LED 6/LCD DB6/DAC bit 6");
            this.p1_5Descr.setText("LED 5/LCD DB5/DAC bit 5");
            this.p1_4Descr.setText("LED 4/LCD DB4/DAC bit 4");
            this.p1_3Descr.setText("LED 3/LCD RS/DAC bit 3");
            this.p1_2Descr.setText("LED 2/LCD E/DAC bit 2");
            this.p1_1Descr.setText("LED 1/DAC bit 1");
            this.p1_0Descr.setText("LED 0/DAC bit 0");
            if (this.port1Frame != null) {
                this.port1Frame.setPinDescription(7, "LED 7/LCD DB7/DAC bit 7   ");
                this.port1Frame.setPinDescription(6, "LED 6/LCD DB6/DAC bit 6");
                this.port1Frame.setPinDescription(5, "LED 5/LCD DB5/DAC bit 5");
                this.port1Frame.setPinDescription(4, "LED 4/LCD DB4/DAC bit 4");
                this.port1Frame.setPinDescription(3, "LED 3/LCD RS/DAC bit 3");
                this.port1Frame.setPinDescription(2, "LED 2/LCD E/DAC bit 2");
                this.port1Frame.setPinDescription(1, "LED 1/DAC bit 1");
                this.port1Frame.setPinDescription(0, "LED 0/DAC bit 0");
            }
            this.p3_4Descr.setText("");
            this.p3_3Descr.setText("AND GATE output");
            this.p3_3Descr.setToolTipText("");
            if (this.port3Frame != null) {
                this.port3Frame.setPinDescription(4, "");
                this.port3Frame.setPinDescription(3, "AND GATE output");
                this.port3Frame.setPinToolTip(3, "");
            }
        }
    }

    private void ledLcdMouseClicked(MouseEvent evt) {
        this.settings.setLedDisplayVisible(!this.settings.isLedDisplayVisible());
        this.changeDisplay(this.settings.isLedDisplayVisible());
    }

    private void adcDisableMouseClicked(MouseEvent evt) {
        if (this.settings.isAdcEnabled()) {
            this.settings.setAdcEnabled(false);
            this.cpu.dataMemory.port3.comparator.enableComparator();
            this.cpu.dataMemory.port3.adc.disableAdc();
            this.disableAdcPanel();
        } else {
            this.settings.setAdcEnabled(true);
            this.cpu.dataMemory.port3.comparator.disableComparator();
            this.cpu.dataMemory.port3.adc.enableAdc();
            this.enableAdcPanel();
        }
        this.cpu.dataMemory.port3.updatePortPins();
        this.updateAllControllerPanelFields();
    }

    private void enableAdcPanel() {
        this.adcDisableButton.setText("ADC Enabled");
        this.adcDisableButton.setToolTipText("Click to disable ADC and enable comparator (Note: ADC RD input and comparator output share the same port pin)");
        this.adcLabel.setText("ADC");
    }

    private void disableAdcPanel() {
        this.adcDisableButton.setText("Comparator Enabled");
        this.adcDisableButton.setToolTipText("Click to enable ADC and disable comparator (Note: ADC RD input and comparator output share the same port pin)");
        this.adcLabel.setText("Comparator");
    }

    private void rxResetMouseClicked(MouseEvent evt) {
        this.cpu.dataMemory.port3.uart.resetReceiver();
    }

    private void txSendMouseClicked(MouseEvent evt) {
        if (this.txSend.getText().equals("Tx Send")) {
            this.cpu.dataMemory.port3.uart.startTransmission();
            this.txSend.setText("Tx Reset");
            this.txSend.setToolTipText("Click to clear the Tx window");
            this.txDataField.setEditable(false);
            this.txDataField.setBackground(new Color(204, 204, 204));
        } else {
            this.cpu.dataMemory.port3.uart.resetTransmitter();
            this.txSend.setText("Tx Send");
            this.txSend.setToolTipText("Click to transmit text in the Tx window (text is terminated by '\\r' char)");
            this.txDataField.setEditable(true);
            this.txDataField.setBackground(Color.WHITE);
            this.txDataField.setText("");
        }
    }

    private void readSysClockField() {
        try {
            double d = Double.parseDouble(this.sysClockField.getText());
            if (d >= 0.001 && d <= 999.0) {
                this.settings.setSystemFreq(d);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.sysClockField.setText(String.valueOf(this.settings.getSystemFreq()));
        this.cpu.machineCycleLength = 12.0 / this.settings.getSystemFreq();
        this.cpu.dataMemory.port3.uart.setSystemFreq(this.settings.getSystemFreq());
        this.resetMouseClicked();
    }

    private void updatePcViaUser() {
        int pcValue = Text.parseNumericData(this.pc.getText());
        this.cpu.setPc(pcValue);
        this.pc.setText(Text.inHex(this.cpu.getPc(), true, 4));
        this.highlightNextInstruction(this.cpu.getPc());
    }

    private void pcActionPerformed(ActionEvent evt) {
        this.updatePcViaUser();
    }

    public void pcFocusLost(FocusEvent evt) {
        this.updatePcViaUser();
    }

    private void bit0FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(0);
    }

    private void bit0ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(0);
    }

    private void bit1FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(1);
    }

    private void bit1ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(1);
    }

    private void bit2FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(2);
    }

    private void bit2ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(2);
    }

    private void bit3FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(3);
    }

    private void bit3ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(3);
    }

    private void bit4FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(4);
    }

    private void bit4ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(4);
    }

    private void bit5FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(5);
    }

    private void bit5ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(5);
    }

    private void bit6FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(6);
    }

    private void bit6ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(6);
    }

    private void bit7FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaBitField(7);
    }

    private void bit7ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaBitField(7);
    }

    private void bitfieldByteAddressFocusLost(FocusEvent evt) {
        this.updateBitFieldData();
    }

    private void bitfieldByteAddressActionPerformed(ActionEvent evt) {
        this.updateBitFieldData();
    }

    private void ipFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.ip, 184, true);
    }

    private void ipActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.ip, 184, true);
    }

    private void spFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.sp, 129, true);
    }

    private void spActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.sp, 129, true);
    }

    private void pswFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.psw, 208, true);
    }

    private void pswActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.psw, 208, true);
    }

    private void bounceBoxActionPerformed(ActionEvent evt) {
        if (!this.bounceBox.isSelected()) {
            int i;
            for (i = 0; i < 8; ++i) {
                this.stopSwitchBouncing(i);
            }
            for (i = 0; i < 12; ++i) {
                this.stopKeyBouncing(i);
            }
        }
        this.settings.setBounce(this.bounceBox.isSelected());
    }

    private String voltageToString(int voltage) {
        voltage = voltage * 500 / 255;
        String textVoltage = String.valueOf(voltage / 100) + ".";
        int decimal = voltage % 100;
        if (decimal < 10) {
            textVoltage = textVoltage + "0";
        }
        if ((textVoltage = textVoltage + String.valueOf(decimal)).length() < 4) {
            textVoltage = textVoltage + "0";
        }
        textVoltage = textVoltage + " V";
        return textVoltage;
    }

    private void adcInputChanged() {
        int voltage = this.adcSlider.getValue();
        String textVoltage = this.voltageToString(voltage);
        this.adcVoltageField.setText(String.valueOf(textVoltage));
        this.cpu.dataMemory.port3.comparator.setNonInvertingInput(this.adcSlider.getValue());
        this.cpu.dataMemory.port3.updatePortPins();
        this.updateAllControllerPanelFields();
    }

    private void adcSliderStateChanged(ChangeEvent evt) {
        this.adcInputChanged();
    }

    private void adcVoltageFieldActionPerformed(ActionEvent evt) {
        this.adcVoltageFieldChanged();
    }

    private void adcVoltageFieldFocusLost(FocusEvent evt) {
        this.adcVoltageFieldChanged();
    }

    private void adcVoltageFieldChanged() {
        String s = this.adcVoltageField.getText().trim().toUpperCase();
        if (s.endsWith("V")) {
            s = s.substring(0, s.length() - 1).trim();
        }
        try {
            float voltage = Float.parseFloat(s);
            if (voltage < 0.0f) {
                voltage = 0.0f;
            } else if (voltage > 5.0f) {
                voltage = 5.0f;
            }
            int intVoltage = Math.round(voltage * 51.0f);
            this.adcSlider.setValue(intVoltage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adcInputChanged();
    }

    private void keypadAndGateDisableMouseClicked(MouseEvent evt) {
        if (this.settings.isKeypadAndGateEnabled()) {
            this.settings.setKeypadAndGateEnabled(false);
            this.cpu.dataMemory.port3.keypadAndGateEnabled = false;
            this.colourGreyKeypadAndGateDisableButton();
        } else {
            this.settings.setKeypadAndGateEnabled(true);
            this.cpu.dataMemory.port3.keypadAndGateEnabled = true;
            this.colourBluelueKeypadAndGateDisableButton();
        }
        this.cpu.dataMemory.port3.updatePortPins();
        this.port0pins.setText(Text.inHex(this.cpu.dataMemory.port0.getPortPins()));
        this.port3pins.setText(Text.inHex(this.cpu.dataMemory.port3.getPortPins()));
        this.updatePortPinFields();
    }

    private void colourGreyKeypadAndGateDisableButton() {
        this.keypadAndGateDisableButton.setBackground(Color.GRAY);
        this.keypadAndGateDisableButton.setBorder(new BevelBorder(1));
        this.keypadAndGateDisableButton.setText("AND Disabled");
    }

    private void colourBluelueKeypadAndGateDisableButton() {
        this.keypadAndGateDisableButton.setBackground(new Color(153, 153, 255));
        this.keypadAndGateDisableButton.setBorder(new BevelBorder(0));
        this.keypadAndGateDisableButton.setText("AND Enabled");
    }

    private void motorDisableMouseClicked(MouseEvent evt) {
        if (this.settings.isMotorEnabled()) {
            this.settings.setMotorEnabled(false);
            this.cpu.dataMemory.port3.motor.disableMotor();
            this.colourGreyMotorDisableButton();
        } else {
            this.settings.setMotorEnabled(true);
            this.cpu.dataMemory.port3.motor.enableMotor();
            this.colourBlueMotorDisableButton();
        }
    }

    private void colourGreyMotorDisableButton() {
        this.motorDisableButton.setBackground(Color.GRAY);
        this.motorDisableButton.setBorder(new BevelBorder(1));
        this.motorDisableButton.setText("Motor Disabled");
    }

    private void colourBlueMotorDisableButton() {
        this.motorDisableButton.setBackground(new Color(153, 153, 255));
        this.motorDisableButton.setBorder(new BevelBorder(0));
        this.motorDisableButton.setText("Motor Enabled");
    }

    private void memoryTypeButtonMouseClicked(MouseEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.settings.setDataMemoryDisplayed(false);
            this.memoryTypeButton.setText("Code Memory");
            this.addrLabel.setText("Modify Code");
            this.memoryWindowAddressField.setText(Text.inHex(this.settings.getCodeWindowStartAddress(), true, 4));
            this.updateCodeByteField();
            this.memoryWindow.setBackground(new Color(153, 153, 255));
            this.columnAddresses.setBackground(Color.LIGHT_GRAY);
            this.rowAddresses.setBackground(Color.LIGHT_GRAY);
        } else {
            this.settings.setDataMemoryDisplayed(true);
            this.memoryTypeButton.setText("Data Memory");
            this.addrLabel.setText("Modify RAM");
            this.memoryWindowAddressField.setText("0x00");
            this.updateRamByteField();
            this.memoryWindow.setBackground(Color.LIGHT_GRAY);
            this.columnAddresses.setBackground(new Color(153, 153, 255));
            this.rowAddresses.setBackground(new Color(153, 153, 255));
        }
        this.updateMemoryWindow();
    }

    private void key11MousePressed(MouseEvent evt) {
        this.keypadPressed(11, this.key11, evt);
    }

    private void key10MousePressed(MouseEvent evt) {
        this.keypadPressed(10, this.key10, evt);
    }

    private void key9MousePressed(MouseEvent evt) {
        this.keypadPressed(9, this.key9, evt);
    }

    private void key8MousePressed(MouseEvent evt) {
        this.keypadPressed(8, this.key8, evt);
    }

    private void key7MousePressed(MouseEvent evt) {
        this.keypadPressed(7, this.key7, evt);
    }

    private void key6MousePressed(MouseEvent evt) {
        this.keypadPressed(6, this.key6, evt);
    }

    private void key5MousePressed(MouseEvent evt) {
        this.keypadPressed(5, this.key5, evt);
    }

    private void key4MousePressed(MouseEvent evt) {
        this.keypadPressed(4, this.key4, evt);
    }

    private void key3MousePressed(MouseEvent evt) {
        this.keypadPressed(3, this.key3, evt);
    }

    private void key2MousePressed(MouseEvent evt) {
        this.keypadPressed(2, this.key2, evt);
    }

    private void key1MousePressed(MouseEvent evt) {
        this.keypadPressed(1, this.key1, evt);
    }

    private void key0MousePressed(MouseEvent evt) {
        this.keypadPressed(0, this.key0, evt);
    }

    private void sconFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.scon, 152, true);
    }

    private void sconActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.scon, 152, true);
    }

    private void sbufFocusLost(FocusEvent evt) {
        this.updateSbufFromField();
    }

    private void sbufActionPerformed(ActionEvent evt) {
        this.updateSbufFromField();
    }

    private void tconFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tcon, 136, true);
    }

    private void tconActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tcon, 136, true);
    }

    private void tmodFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tmod, 137, true);
    }

    private void tmodActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tmod, 137, true);
    }

    private void tl1FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tl1, 139, true);
    }

    private void tl1ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tl1, 139, true);
    }

    private void th1FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.th1, 141, true);
    }

    private void th1ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.th1, 141, true);
    }

    private void tl0FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.tl0, 138, true);
    }

    private void tl0ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.tl0, 138, true);
    }

    private void th0FocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.th0, 140, true);
    }

    private void th0ActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.th0, 140, true);
    }

    private void memoryWindowByteFieldActionPerformed(ActionEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByte();
        } else {
            this.updateCodeByte();
        }
    }

    private void memoryWindowByteFieldFocusLost(FocusEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByte();
        } else {
            this.updateCodeByte();
        }
    }

    private void memoryWindowAddressFieldFocusLost(FocusEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByteField();
        } else {
            this.updateCodeByteField();
        }
    }

    private void memoryWindowAddressFieldActionPerformed(ActionEvent evt) {
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateRamByteField();
        } else {
            this.updateCodeByteField();
        }
    }

    private void updateRamByte() {
        int data = Text.parseNumericData(this.memoryWindowByteField.getText());
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        try {
            this.cpu.dataMemory.writeByte(address, data);
            this.updateAllControllerPanelFields();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateRamByteField();
    }

    private void updateCodeByte() {
        int data = Text.parseNumericData(this.memoryWindowByteField.getText());
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        try {
            this.cpu.dataMemory.codeMemory[address].setCode(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateCodeByteField();
    }

    private void updateRamByteField() {
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        if (address < 0 || address > 128) {
            address = 0;
        }
        try {
            this.memoryWindowByteField.setText(Text.inHex(this.cpu.dataMemory.readByte(address)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.memoryWindowAddressField.setText(Text.inHex(address));
    }

    private void updateCodeByteField() {
        int address = Text.parseNumericData(this.memoryWindowAddressField.getText());
        if (address < 0 || address > 65536) {
            address = 0;
        }
        try {
            int code = this.cpu.dataMemory.codeMemory[address].getCode();
            this.memoryWindowByteField.setText(Text.inHex(code));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.memoryWindowAddressField.setText(Text.inHex(address, true, 4));
        this.settings.setCodeWindowStartAddress(address);
        this.updateMemoryWindow();
    }

    private void updateMemoryWindow() {
        String[] s = this.cpu.dataMemory.getMemoryWindow(this.settings.isDataMemoryDisplayed(), this.settings.getCodeWindowStartAddress());
        this.columnAddresses.setText(s[0]);
        this.rowAddresses.setText(s[1]);
        this.memoryWindow.setText(s[2]);
    }

    private int getBitFieldByteAddress() {
        String location = this.bitfieldByteAddress.getText().trim().toUpperCase();
        int address = Assembler.getSfrAddress(location);
        if (address == -1 && location.length() == 2) {
            int registerNumber = location.charAt(1) - 48;
            if (location.charAt(0) == 'R' && registerNumber >= 0 && registerNumber <= 7) {
                try {
                    address = this.cpu.dataMemory.getRegisterAddress(registerNumber);
                }
                catch (Exception ex) {}
            } else {
                address = -1;
            }
        }
        if (address == -1 && (address = Text.parseNumericData(location)) == 0x1000000) {
            address = 224;
        }
        return address;
    }

    private void updateBitFieldData() {
        int address = this.getBitFieldByteAddress();
        this.bitfieldByteAddress.setToolTipText("addr: " + Text.inHex(address));
        String location = Assembler.getSfrName(address);
        if (location.equals("")) {
            location = this.cpu.dataMemory.getRegisterName(address);
        }
        if (location == null) {
            location = Text.inHex(address);
        }
        this.bitfieldByteAddress.setText(location);
        this.settings.setBitfieldByteAddressString(location);
        try {
            int data = address == 128 || address == 144 || address == 160 || address == 176 ? this.cpu.dataMemory.readPortLatches(address) : (address == 153 ? this.cpu.dataMemory.readSbufWriteOnly() : this.cpu.dataMemory.readByte(address));
            boolean isBitAddressable = this.cpu.dataMemory.isBitAddressable(address);
            boolean editable = this.fieldsEnabled && isBitAddressable;
            for (int i = 0; i < 8; ++i) {
                JTextField bitTextField = this.getBitTextField(i);
                bitTextField.setText(String.valueOf(data >> i & 1));
                bitTextField.setEditable(editable);
                String bitAddressName = isBitAddressable ? Assembler.getSbitName(address + i) : this.getNonBitAddressableSbitName(location, i);
                if (bitAddressName.equals("")) {
                    bitTextField.setToolTipText(String.valueOf(i));
                    continue;
                }
                bitTextField.setToolTipText(bitAddressName);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private String getNonBitAddressableSbitName(String sfrName, int bitNumber) {
        if (sfrName.equals("PCON")) {
            return this.getPconBitName(bitNumber);
        }
        if (sfrName.equals("TMOD")) {
            return this.getTmodBitName(bitNumber);
        }
        return "";
    }

    private String getPconBitName(int bitNumber) {
        if (bitNumber == 7) {
            return "SMOD";
        }
        return "";
    }

    private String getTmodBitName(int bitNumber) {
        switch (bitNumber) {
            case 7: {
                return "T1: G";
            }
            case 6: {
                return "T1: C/T";
            }
            case 5: {
                return "T1: M1";
            }
            case 4: {
                return "T1: M0";
            }
            case 3: {
                return "T0: G";
            }
            case 2: {
                return "T0: C/T";
            }
            case 1: {
                return "T0: M1";
            }
            case 0: {
                return "T0: M0";
            }
        }
        return "";
    }

    private void updateDataMemoryViaBitField(int bitNumber) {
        JTextField bitTextField = this.getBitTextField(bitNumber);
        int byteAddress = this.getBitFieldByteAddress();
        try {
            if (bitTextField.getText().trim().equals("1")) {
                this.cpu.dataMemory.setBit(byteAddress, bitNumber);
            }
            if (bitTextField.getText().trim().equals("0")) {
                this.cpu.dataMemory.clearBit(byteAddress, bitNumber);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (byteAddress == 208) {
            this.setRegistersToolTipText();
        }
        this.cpu.dataMemory.updatePortPins();
        this.updateAllControllerPanelFields();
    }

    private JTextField getBitTextField(int bitNumber) {
        switch (bitNumber) {
            case 0: {
                return this.bit0;
            }
            case 1: {
                return this.bit1;
            }
            case 2: {
                return this.bit2;
            }
            case 3: {
                return this.bit3;
            }
            case 4: {
                return this.bit4;
            }
            case 5: {
                return this.bit5;
            }
            case 6: {
                return this.bit6;
            }
        }
        return this.bit7;
    }

    private void switch7MouseClicked(MouseEvent evt) {
        this.switchClicked(7, this.switch7, evt);
    }

    private void switch6MouseClicked(MouseEvent evt) {
        this.switchClicked(6, this.switch6, evt);
    }

    private void switch5MouseClicked(MouseEvent evt) {
        this.switchClicked(5, this.switch5, evt);
    }

    private void switch4MouseClicked(MouseEvent evt) {
        this.switchClicked(4, this.switch4, evt);
    }

    private void switch3MouseClicked(MouseEvent evt) {
        this.switchClicked(3, this.switch3, evt);
    }

    private void switch2MouseClicked(MouseEvent evt) {
        this.switchClicked(2, this.switch2, evt);
    }

    private void switch1MouseClicked(MouseEvent evt) {
        this.switchClicked(1, this.switch1, evt);
    }

    private void switch0MouseClicked(MouseEvent evt) {
        this.switchClicked(0, this.switch0, evt);
    }

    private JButton getKey(int keyNumber) {
        switch (keyNumber) {
            case 0: {
                return this.key0;
            }
            case 1: {
                return this.key1;
            }
            case 2: {
                return this.key2;
            }
            case 3: {
                return this.key3;
            }
            case 4: {
                return this.key4;
            }
            case 5: {
                return this.key5;
            }
            case 6: {
                return this.key6;
            }
            case 7: {
                return this.key7;
            }
            case 8: {
                return this.key8;
            }
            case 9: {
                return this.key9;
            }
            case 10: {
                return this.key10;
            }
        }
        return this.key11;
    }

    private void openAllKeysExcept(int keyToRemainClosed) {
        for (int i = 0; i < 12; ++i) {
            if (i == keyToRemainClosed) continue;
            this.openKey(i);
        }
    }

    private void openAllKeys() {
        this.openAllKeysExcept(-1);
    }

    private void updateButtonGui(int buttonNumber, JButton button, String type) {
        String newLabel = JOptionPane.showInputDialog(button, "Current Label: " + button.getText(), "Update " + type + " Label", 3);
        if (newLabel == null) {
            newLabel = "";
        }
        if (!(newLabel = newLabel.trim()).equals("")) {
            button.setText(String.valueOf(newLabel.charAt(0)));
            if (type.equals("Key")) {
                this.settings.setKeypadLabel(buttonNumber, newLabel.charAt(0));
            } else {
                this.settings.setSwitchLabel(buttonNumber, newLabel.charAt(0));
            }
        }
    }

    private void keypadPressed(int keyNumber, JButton keyGui, MouseEvent evt) {
        boolean rightClick;
        boolean bl = rightClick = (evt.getModifiers() & 4) == 4;
        if (rightClick) {
            this.updateButtonGui(keyNumber, keyGui, "Key");
        } else {
            boolean keyOpen;
            if (this.settings.getKeypadType() == 2) {
                this.openAllKeysExcept(keyNumber);
            }
            if (keyOpen = this.cpu.dataMemory.port0.keypad.isKeyOpen(keyNumber)) {
                if (this.settings.getKeypadType() == 0 && this.bounceBox.isSelected()) {
                    this.cpu.dataMemory.port0.keypad.startKeyBounce(keyNumber);
                }
                this.closeKey(keyNumber);
            } else {
                this.cpu.dataMemory.port0.keypad.stopKeyBounce(keyNumber);
                this.openKey(keyNumber);
            }
            this.keypadGuiUpdate();
        }
    }

    private void stopKeyBouncing(int keyNumber) {
        if (this.cpu.dataMemory.port0.keypad.isKeyBouncing(keyNumber)) {
            this.cpu.dataMemory.port0.keypad.stopKeyBounce(keyNumber);
            this.closeKey(keyNumber);
        }
    }

    private void closeKey(int keyNumber) {
        JButton key = this.getKey(keyNumber);
        this.cpu.dataMemory.port0.keypad.closeKey(keyNumber);
        key.setBorder(new BevelBorder(1));
        if (this.cpu.dataMemory.port0.keypad.isKeyBouncing(keyNumber)) {
            key.setBackground(this.darkRed);
        } else {
            key.setBackground(Color.GRAY);
        }
    }

    private void openKey(int keyNumber) {
        JButton key = this.getKey(keyNumber);
        this.cpu.dataMemory.port0.keypad.openKey(keyNumber);
        key.setBorder(new BevelBorder(0));
        if (this.cpu.dataMemory.port0.keypad.isKeyBouncing(keyNumber)) {
            key.setBackground(Color.RED);
        } else {
            key.setBackground(this.blue);
        }
    }

    private void keypadGuiUpdate() {
        this.cpu.dataMemory.port0.updatePortPins();
        this.port0pins.setText(Text.inHex(this.cpu.dataMemory.port0.getPortPins()));
        this.port3pins.setText(Text.inHex(this.cpu.dataMemory.port3.getPortPins()));
        this.updatePortPinFields();
    }

    private JButton getSwitch(int switchNumber) {
        switch (switchNumber) {
            case 0: {
                return this.switch0;
            }
            case 1: {
                return this.switch1;
            }
            case 2: {
                return this.switch2;
            }
            case 3: {
                return this.switch3;
            }
            case 4: {
                return this.switch4;
            }
            case 5: {
                return this.switch5;
            }
            case 6: {
                return this.switch6;
            }
        }
        return this.switch7;
    }

    private void switchClicked(int switchNumber, JButton switchGui, MouseEvent evt) {
        boolean rightClick;
        boolean bl = rightClick = (evt.getModifiers() & 4) == 4;
        if (rightClick) {
            this.updateButtonGui(switchNumber, switchGui, "Switch");
        } else if (!this.isSwitchOpen(switchNumber) || this.isSwitchBouncing(switchNumber)) {
            this.cpu.dataMemory.port2.stopSwitchBounce(switchNumber);
            this.openSwitch(switchNumber);
        } else {
            if (this.bounceBox.isSelected()) {
                this.cpu.dataMemory.port2.startSwitchBounce(switchNumber);
            }
            this.closeSwitch(switchNumber);
        }
    }

    private void stopSwitchBouncing(int switchNumber) {
        if (this.isSwitchBouncing(switchNumber)) {
            this.cpu.dataMemory.port2.stopSwitchBounce(switchNumber);
            this.closeSwitch(switchNumber);
        }
    }

    private boolean isSwitchOpen(int switchNumber) {
        return this.cpu.dataMemory.port2.isSwitchOpen(switchNumber);
    }

    private boolean isSwitchBouncing(int switchNumber) {
        return this.cpu.dataMemory.port2.isSwitchBouncing(switchNumber);
    }

    private void closeSwitch(int switchNumber) {
        JButton aSwitch = this.getSwitch(switchNumber);
        this.cpu.dataMemory.port2.closeSwitch(switchNumber);
        if (this.isSwitchBouncing(switchNumber)) {
            aSwitch.setBackground(this.darkRed);
        } else {
            aSwitch.setBackground(Color.GRAY);
        }
        aSwitch.setBorder(new BevelBorder(1));
        this.port2pins.setText(Text.inHex(this.cpu.dataMemory.port2.getPortPins()));
        this.updatePortPinFields();
    }

    private void openSwitch(int switchNumber) {
        JButton aSwitch = this.getSwitch(switchNumber);
        this.cpu.dataMemory.port2.openSwitch(switchNumber);
        if (this.isSwitchBouncing(switchNumber)) {
            aSwitch.setBackground(Color.RED);
        } else {
            aSwitch.setBackground(this.blue);
        }
        aSwitch.setBorder(new BevelBorder(0));
        this.port2pins.setText(Text.inHex(this.cpu.dataMemory.port2.getPortPins()));
        this.updatePortPinFields();
    }

    private void toggleSwitch(int switchNumber) {
        if (this.isSwitchOpen(switchNumber)) {
            this.closeSwitch(switchNumber);
        } else {
            this.openSwitch(switchNumber);
        }
    }

    private void copyMouseClicked(MouseEvent evt) {
        this.assemblyCodeBox.copyTextToClipboard();
    }

    private void pasteMouseClicked(MouseEvent evt) {
        this.assemblyCodeBox.pasteTextFromClipboard();
    }

    private void quitMouseClicked(MouseEvent evt) {
        if (!this.isCodeSaved()) {
            CodeNotSaved cns = new CodeNotSaved(this, "Source code not saved.\nSave file before exiting?", false);
            int response = cns.showConfirmDialog();
            if (response == cns.NO || response == cns.YES) {
                this.srw.writeSettings();
                System.exit(0);
            }
            if (this.unlockedAssemblyCodeFrame != null) {
                this.unlockedAssemblyCodeFrame.refocus();
            } else {
                this.setAssemblyCodeBoxFocus();
            }
        } else {
            this.srw.writeSettings();
            System.exit(0);
        }
    }

    private void port0FocusLost(FocusEvent evt) {
        this.updatePortFromField(0);
    }

    private void port0ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(0);
    }

    private void port2FocusLost(FocusEvent evt) {
        this.updatePortFromField(2);
    }

    private void port2ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(2);
    }

    private void port3FocusLost(FocusEvent evt) {
        this.updatePortFromField(3);
    }

    private void port3ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(3);
    }

    private void port1FocusLost(FocusEvent evt) {
        this.updatePortFromField(1);
        this.updateDacOutputTextField();
    }

    private void port1ActionPerformed(ActionEvent evt) {
        this.updatePortFromField(1);
        this.updateDacOutputTextField();
    }

    private void updateSbufFromField() {
        int data = Text.parseNumericData(this.sbuf.getText());
        if (data != 0x1000000) {
            try {
                this.cpu.dataMemory.writeByte(153, data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sbuf.setText(Text.inHex(this.cpu.dataMemory.readSbufWriteOnly()));
    }

    private void updatePortFromField(int portNumber) {
        int address;
        Port port;
        JTextField pins;
        JTextField latches;
        if (portNumber < 0 || portNumber > 3) {
            return;
        }
        if (portNumber == 0) {
            latches = this.port0;
            pins = this.port0pins;
            port = this.cpu.dataMemory.port0;
            address = 128;
        } else if (portNumber == 1) {
            latches = this.port1;
            pins = this.port1pins;
            port = this.cpu.dataMemory.port1;
            address = 144;
        } else if (portNumber == 2) {
            latches = this.port2;
            pins = this.port2pins;
            port = this.cpu.dataMemory.port2;
            address = 160;
        } else {
            latches = this.port3;
            pins = this.port3pins;
            port = this.cpu.dataMemory.port3;
            address = 176;
        }
        try {
            port.writePort(latches.getText());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            latches.setText(Text.inHex(this.cpu.dataMemory.readPortLatches(address)));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.updateTextField(pins, port.getPortPins(), true);
        this.updatePortPinFields();
        this.updateBitFieldData();
    }

    private void register0FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register0, 0);
    }

    private void register1FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register1, 1);
    }

    private void register2FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register2, 2);
    }

    private void register3FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register3, 3);
    }

    private void register4FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register4, 4);
    }

    private void register5FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register5, 5);
    }

    private void register6FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register6, 6);
    }

    private void register7FocusLost(FocusEvent evt) {
        this.updateRegisterViaTextField(this.register7, 7);
    }

    private void runMouseClicked(MouseEvent evt) {
        if (this.cpu.running) {
            this.enableButtons(true);
            this.enableAllControllerPanelFields(true);
            this.highlightNextInstruction(this.cpu.getPc());
            this.cpu.running = false;
            this.run.setText("Run");
        } else {
            this.assemblyCodeBox.select(0, 0);
            this.enableButtons(false);
            this.assemblyCodeBox.setEditable(false);
            this.assemblyCodeBox.setBackground(new Color(204, 204, 255));
            this.enableAllControllerPanelFields(false);
            this.cpu.running = true;
            this.run.setText("Pause");
            this.start();
        }
    }

    private void enableButtons(boolean b) {
        this.reset.setEnabled(b);
        this.step.setEnabled(b);
        this.fileOpen.setEnabled(b);
        this.fileSave.setEnabled(b);
        this.copy.setEnabled(b);
        this.paste.setEnabled(b);
    }

    public void resetMouseClicked() {
        this.enableButtons(true);
        this.enableAllControllerPanelFields(true);
        this.highlightNextInstruction(this.cpu.getPc());
        this.run.setText("Run");
        this.step.setText("Assm");
        this.step.setToolTipText("Assemble source code.");
        this.cpu.running = false;
        this.assembler = null;
        this.cpu.reset();
        this.messageBox.setBackground(new Color(204, 204, 204));
        this.messageBox.setText("Reset: PC = 0x0000");
        this.pc.setText("0x0000");
        this.resetHardware();
        this.updateAllControllerPanelFields();
        if (!this.assemblyCodeBox.isEditable()) {
            this.assemblyCodeBox.setEditable(true);
            this.assemblyCodeBox.setBackground(Color.WHITE);
            this.assemblyCodeBox.setText(this.preAssembledCode);
            if (!this.assemblyCodeBox.hasFocus()) {
                this.assemblyCodeBox.requestFocusInWindow();
            }
            this.assemblyCodeBox.setCaretPosition(0);
        }
    }

    private void resetMouseClicked(MouseEvent evt) {
        this.resetMouseClicked();
    }

    public void start() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
    }

    public void run() {
        while (this.cpu.running) {
            try {
                boolean isBreakpoint = this.step(this.settings.getInstructionBatchSize(), false);
                Thread.sleep(250L);
                if (!isBreakpoint) continue;
                this.step.setEnabled(true);
                this.reset.setEnabled(true);
                this.enableAllControllerPanelFields(true);
                this.highlightNextInstruction(this.cpu.getPc());
                this.cpu.running = false;
                this.run.setText("Run");
            }
            catch (Exception exception) {}
        }
        this.t = null;
    }

    private void step() {
        this.step(1, true);
    }

    private boolean step(int instructionBatchSize, boolean showExecutedInstruction) {
        boolean isBreakpoint = false;
        if (this.assembler == null) {
            this.assembler = new Assembler(this, this.assemblyCodeBox.getText());
        }
        if (!this.cpu.codeLoaded) {
            try {
                this.pc.setText("0x0000");
                this.preAssembledCode = this.assemblyCodeBox.getText();
                this.cpu.loadCode(this.assembler.assemble());
                this.assemblyCodeBox.setText(this.assembler.codeWithPc);
                this.showAllBreakpoints();
                this.highlightNextInstruction(0);
                if (!this.settings.isDataMemoryDisplayed()) {
                    this.updateMemoryWindow();
                    this.updateCodeByteField();
                }
                this.messageBox.setBackground(Color.LIGHT_GRAY);
                this.messageBox.setText("No errors");
                this.step.setText("Step");
                this.step.setToolTipText("Execute next instruction.");
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
            return false;
        }
        try {
            ExecutedInstructionInfo info = this.cpu.executeInstructions(instructionBatchSize, this.breakpoints, this.showMovxWarning);
            boolean bl = isBreakpoint = info.isBreakpoint || info.isMovx;
            if (this.showMovxWarning && info.isMovx) {
                int option = JOptionPane.showConfirmDialog(this, "MOVX instruction executed.\nSince the simulator has no external memory,\nMOVX instructions are not implemented,\nexcept for the PC being incremented.\n\nShow this warning every time a\nMOVX instruction is executed?", "Warning! MOVX instruction executed.", 0, 2);
                this.showMovxWarning = option == 0;
            }
            this.messageBox.setBackground(Color.LIGHT_GRAY);
            if (showExecutedInstruction) {
                this.messageBox.setText("Executed " + Text.inHex(info.pc, true, 4) + ": " + info.mneumonic);
            } else {
                this.messageBox.setText("Time: " + this.cpu.getElapsedTime() + " - Instructions: " + this.cpu.getNumberOfExecutedInstructions());
            }
            this.updateKeysSwitches();
            if (!this.cpu.running) {
                this.highlightNextInstruction(this.cpu.getPc());
            }
            this.pc.setText(Text.inHex(this.cpu.getPc(), true, 4));
        }
        catch (Exception ex) {
            this.handleException(ex);
            return false;
        }
        this.updateAllControllerPanelFields();
        return isBreakpoint;
    }

    private void updateKeysSwitches() {
        if (this.bounceBox.isSelected()) {
            int i;
            for (i = 0; i < 8; ++i) {
                if (this.cpu.dataMemory.port2.isSwitchOpen(i)) {
                    this.openSwitch(i);
                    continue;
                }
                this.closeSwitch(i);
            }
            for (i = 0; i < 12; ++i) {
                if (this.cpu.dataMemory.port0.keypad.isKeyOpen(i)) {
                    this.openKey(i);
                    continue;
                }
                this.closeKey(i);
            }
        }
    }

    private void handleException(Exception ex) {
        this.resetMouseClicked();
        String nonEdSimErrorMessage = this.version + "\n\n" + ex.toString() + "\n\n" + Text.getErrorStackTrace(ex);
        try {
            this.highlightError((Sim8051Exception)ex);
            this.messageBox.setBackground(Color.RED);
            this.messageBox.setText(Text.lessJavaErrorMessage(ex.toString()));
        }
        catch (Exception ex1) {
            if (!(ex1 instanceof ClassCastException)) {
                nonEdSimErrorMessage = this.version + "\n\nHandling of the following exception:\n" + ex.toString() + "\n\n" + Text.getErrorStackTrace(ex) + "\n\nresulted in the following exception:\n" + ex1.toString() + "\n\n" + Text.getErrorStackTrace(ex1);
            }
            this.messageBox.setText("");
            if (this.bugFrame == null) {
                this.bugFrame = new BugFrame(nonEdSimErrorMessage, this.clipboard);
            } else {
                this.bugFrame.setBugDetails(nonEdSimErrorMessage);
            }
            this.bugFrame.setVisible(true);
        }
    }

    private void highlightError(Sim8051Exception ex) {
        int errorStart = ex.getErrorStart(this.preAssembledCode);
        int errorEnd = ex.getErrorEnd(this.preAssembledCode);
        if (errorStart != -1) {
            this.assemblyCodeBox.requestFocusInWindow();
            this.assemblyCodeBox.select(errorStart, errorEnd + 1);
            this.assemblyCodeBox.setSelectionColor(Color.RED);
        } else {
            this.assemblyCodeBox.select(0, 0);
        }
    }

    private void highlightNextInstruction(int pc) {
        int selectionPosition = this.getNextInstructionPosition(pc);
        if (!this.assemblyCodeBox.hasFocus()) {
            this.assemblyCodeBox.requestFocusInWindow();
        }
        if (selectionPosition != -1) {
            this.assemblyCodeBox.select(selectionPosition, selectionPosition + 4);
            this.assemblyCodeBox.setSelectionColor(Color.CYAN);
        } else {
            this.assemblyCodeBox.setCaretPosition(0);
        }
    }

    private void accFocusLost(FocusEvent evt) {
        this.updateDataMemoryViaTextField(this.acc, 224, true);
    }

    private void accActionPerformed(ActionEvent evt) {
        this.updateDataMemoryViaTextField(this.acc, 224, true);
    }

    private void register0ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register0, 0);
    }

    private void register1ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register1, 1);
    }

    private void register2ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register2, 2);
    }

    private void register3ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register3, 3);
    }

    private void register4ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register4, 4);
    }

    private void register5ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register5, 5);
    }

    private void register6ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register6, 6);
    }

    private void register7ActionPerformed(ActionEvent evt) {
        this.updateRegisterViaTextField(this.register7, 7);
    }

    private void updateRegisterViaTextField(JTextField field, int registerNumber) {
        int data = Text.parseNumericData(field.getText());
        try {
            this.cpu.dataMemory.writeRegister(registerNumber, data);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            field.setText(Text.inHex(this.cpu.dataMemory.readRegister(registerNumber)));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.updateMemoryWindow();
        this.updateBitFieldData();
    }

    private void updateDataMemoryViaTextField(JTextField field, int address, boolean isByteAddress) {
        int data = Text.parseNumericData(field.getText());
        if (isByteAddress) {
            try {
                this.cpu.dataMemory.writeByte(address, data);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (address == 224) {
                this.updateTextFieldViaDataMemory(this.psw, 208, true);
            } else if (address == 208) {
                this.setRegistersToolTipText();
            }
        } else {
            try {
                if (data == 1) {
                    this.cpu.dataMemory.setBit(address);
                } else if (data == 0) {
                    this.cpu.dataMemory.clearBit(address);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.updateTextFieldViaDataMemory(field, address, isByteAddress);
        this.updateBitFieldData();
    }

    private void updateTextFieldViaDataMemory(JTextField field, int address, boolean isByteAddress) {
        try {
            int i = isByteAddress ? this.cpu.dataMemory.readByte(address) : this.cpu.dataMemory.getBit(address);
            this.updateTextField(field, i, isByteAddress);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void updateTextField(JTextField field, int data, boolean isByteAddress) {
        try {
            if (isByteAddress) {
                field.setText(Text.inHex(data));
            } else if (data == 0) {
                field.setText("0");
            } else if (data == 1) {
                field.setText("1");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void updateAllControllerPanelFields() {
        int registerAddressOffset = this.cpu.dataMemory.getRegiserBankNumber() * 8;
        this.updateTextFieldViaDataMemory(this.register0, registerAddressOffset + 0, true);
        this.updateTextFieldViaDataMemory(this.register1, registerAddressOffset + 1, true);
        this.updateTextFieldViaDataMemory(this.register2, registerAddressOffset + 2, true);
        this.updateTextFieldViaDataMemory(this.register3, registerAddressOffset + 3, true);
        this.updateTextFieldViaDataMemory(this.register4, registerAddressOffset + 4, true);
        this.updateTextFieldViaDataMemory(this.register5, registerAddressOffset + 5, true);
        this.updateTextFieldViaDataMemory(this.register6, registerAddressOffset + 6, true);
        this.updateTextFieldViaDataMemory(this.register7, registerAddressOffset + 7, true);
        this.updateTextFieldViaDataMemory(this.acc, 224, true);
        this.updateTextFieldViaDataMemory(this.psw, 208, true);
        this.updateTextFieldViaDataMemory(this.sp, 129, true);
        this.updateTextFieldViaDataMemory(this.ip, 184, true);
        this.updateTextFieldViaDataMemory(this.ie, 168, true);
        this.updateTextFieldViaDataMemory(this.dph, 131, true);
        this.updateTextFieldViaDataMemory(this.dpl, 130, true);
        this.updateTextFieldViaDataMemory(this.b, 240, true);
        this.updateTextFieldViaDataMemory(this.pcon, 135, true);
        this.updateTextFieldViaDataMemory(this.tmod, 137, true);
        this.updateTextFieldViaDataMemory(this.tcon, 136, true);
        this.updateTextFieldViaDataMemory(this.th0, 140, true);
        this.updateTextFieldViaDataMemory(this.tl0, 138, true);
        this.updateTextFieldViaDataMemory(this.th1, 141, true);
        this.updateTextFieldViaDataMemory(this.tl1, 139, true);
        this.updateTextFieldViaDataMemory(this.scon, 152, true);
        this.updateTextFieldViaDataMemory(this.txd, 177, false);
        this.updateTextFieldViaDataMemory(this.rxd, 176, false);
        try {
            this.sbufReadOnly.setText(Text.inHex(this.cpu.dataMemory.serial.getSbufReadOnly()));
            this.sbuf.setText(Text.inHex(this.cpu.dataMemory.readSbufWriteOnly()));
            this.port0.setText(Text.inHex(this.cpu.dataMemory.readPortLatches(128)));
            this.port0pins.setText(Text.inHex(this.cpu.dataMemory.port0.getPortPins()));
            this.port1.setText(Text.inHex(this.cpu.dataMemory.readPortLatches(144)));
            this.port1pins.setText(Text.inHex(this.cpu.dataMemory.port1.getPortPins()));
            this.port2.setText(Text.inHex(this.cpu.dataMemory.readPortLatches(160)));
            this.port2pins.setText(Text.inHex(this.cpu.dataMemory.port2.getPortPins()));
            this.port3.setText(Text.inHex(this.cpu.dataMemory.readPortLatches(176)));
            this.port3pins.setText(Text.inHex(this.cpu.dataMemory.port3.getPortPins()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatePortPinFields();
        if (this.settings.isDataMemoryDisplayed()) {
            this.updateMemoryWindow();
        }
        this.updateBitFieldData();
        this.updateDacOutputTextField();
    }

    private void enableAllControllerPanelFields(boolean aFlag) {
        this.register0.setEditable(aFlag);
        this.register1.setEditable(aFlag);
        this.register2.setEditable(aFlag);
        this.register3.setEditable(aFlag);
        this.register4.setEditable(aFlag);
        this.register5.setEditable(aFlag);
        this.register6.setEditable(aFlag);
        this.register7.setEditable(aFlag);
        this.acc.setEditable(aFlag);
        this.psw.setEditable(aFlag);
        this.sp.setEditable(aFlag);
        this.ip.setEditable(aFlag);
        this.ie.setEditable(aFlag);
        this.dph.setEditable(aFlag);
        this.dpl.setEditable(aFlag);
        this.b.setEditable(aFlag);
        this.pcon.setEditable(aFlag);
        this.tmod.setEditable(aFlag);
        this.tcon.setEditable(aFlag);
        this.th0.setEditable(aFlag);
        this.tl0.setEditable(aFlag);
        this.th1.setEditable(aFlag);
        this.tl1.setEditable(aFlag);
        this.port0.setEditable(aFlag);
        this.port1.setEditable(aFlag);
        this.port2.setEditable(aFlag);
        this.port3.setEditable(aFlag);
        this.scon.setEditable(aFlag);
        this.sbuf.setEditable(aFlag);
        this.memoryWindowAddressField.setEditable(aFlag);
        this.memoryWindowByteField.setEditable(aFlag);
        this.bitfieldByteAddress.setEditable(aFlag);
        int address = this.getBitFieldByteAddress();
        if (!aFlag || this.cpu.dataMemory.isBitAddressable(address)) {
            for (int i = 0; i < 8; ++i) {
                JTextField field = this.getBitTextField(i);
                field.setEditable(aFlag);
            }
        }
        this.pc.setEditable(aFlag);
        this.fieldsEnabled = aFlag;
    }

    private void updateDacOutputTextField() {
        int voltage = this.cpu.dataMemory.port1.dac.getData();
        this.dacVoltageField.setText(this.voltageToString(voltage));
    }

    private void updatePortPinFields() {
        for (int i = 0; i < 8; ++i) {
            this.port0PinFields[i].setText(String.valueOf(this.cpu.dataMemory.port0.getPortPin(i)));
            this.port1PinFields[i].setText(String.valueOf(this.cpu.dataMemory.port1.getPortPin(i)));
            this.port2PinFields[i].setText(String.valueOf(this.cpu.dataMemory.port2.getPortPin(i)));
            this.port3PinFields[i].setText(String.valueOf(this.cpu.dataMemory.port3.getPortPin(i)));
        }
        if (this.port0Frame != null) {
            this.port0Frame.setPinsStates();
        }
        if (this.port1Frame != null) {
            this.port1Frame.setPinsStates();
        }
        if (this.port2Frame != null) {
            this.port2Frame.setPinsStates();
        }
        if (this.port3Frame != null) {
            this.port3Frame.setPinsStates();
        }
    }

    private int getNextInstructionPosition(int pc) {
        return Text.getPcIndex(this.assemblyCodeBox.getText(), pc);
    }

    private void showAllBreakpoints() {
        if (this.breakpoints == null) {
            return;
        }
        String assembly = this.assemblyCodeBox.getText();
        for (int i = 0; i < this.breakpoints.size(); ++i) {
            String breakAddress = Text.inHex((Integer)this.breakpoints.elementAt(i), false, 4);
            if (assembly.indexOf(breakAddress + "|") == -1) {
                this.breakpoints.removeElementAt(i);
                --i;
                continue;
            }
            assembly = assembly.replace(breakAddress + "|", breakAddress + "*");
        }
        this.assemblyCodeBox.setText(assembly);
    }

    public void setBreakpoint(String s) {
        int codeAddress;
        if (this.breakpoints == null) {
            this.breakpoints = new Vector();
        }
        if ((codeAddress = Text.parseNumericData(s + "H")) != 0x1000000) {
            String assembly = this.assemblyCodeBox.getText();
            for (int i = 0; i < this.breakpoints.size(); ++i) {
                if ((Integer)this.breakpoints.elementAt(i) != codeAddress) continue;
                this.breakpoints.removeElementAt(i);
                if (this.breakpoints.size() == 0) {
                    this.removeAllBreakpointsButton.setEnabled(false);
                }
                assembly = assembly.replace(s + "*", s + "|");
                this.assemblyCodeBox.setText(assembly);
                this.highlightNextInstruction(this.cpu.getPc());
                return;
            }
            this.breakpoints.addElement(new Integer(codeAddress));
            this.removeAllBreakpointsButton.setEnabled(true);
            assembly = assembly.replace(s + "|", s + "*");
            this.assemblyCodeBox.setText(assembly);
            this.highlightNextInstruction(codeAddress);
        }
    }

    public void loadFileToAssemblyCodeBox() {
        this.resetMouseClicked();
        this.messageBox.setText("Loading ... please wait");
        FileHandler handler = new FileHandler(this);
        FileHandler.ReturnedData rd = handler.readFile();
        if (rd != null) {
            if (rd.success) {
                this.assemblyCodeBox.setText(rd.fileContents);
                if (!this.assemblyCodeBox.hasFocus()) {
                    this.assemblyCodeBox.requestFocusInWindow();
                }
                this.assemblyCodeBox.setCaretPosition(0);
                this.messageBox.setText("");
                this.codeSaved = true;
            } else {
                this.messageBox.setText(Text.lessJavaErrorMessage(rd.message));
                this.highlightHexFileReadError(rd.fileContents, rd.errorLine);
            }
        } else {
            this.messageBox.setText("");
        }
        if (this.unlockedAssemblyCodeFrame != null) {
            this.unlockedAssemblyCodeFrame.refocus();
        }
    }

    private void highlightHexFileReadError(String fileContents, String errorLine) {
        if (fileContents == null || errorLine == null || fileContents.equals("") || errorLine.equals("")) {
            return;
        }
        this.assemblyCodeBox.setText(fileContents);
        int start = fileContents.indexOf(errorLine);
        if (start == -1) {
            return;
        }
        if (!this.assemblyCodeBox.hasFocus()) {
            this.assemblyCodeBox.requestFocusInWindow();
        }
        this.assemblyCodeBox.select(start, start + errorLine.length() + 1);
        this.assemblyCodeBox.setSelectionColor(Color.RED);
    }

    private void saveFile() {
        FileHandler handler = new FileHandler(this);
        this.resetMouseClicked();
        this.messageBox.setText("Saving ... please wait");
        FileHandler.ReturnedData rd = handler.saveFile(this.assemblyCodeBox.getText());
        this.messageBox.setText(Text.lessJavaErrorMessage(rd.message));
        this.codeSaved = rd.success;
        if (this.unlockedAssemblyCodeFrame != null) {
            this.unlockedAssemblyCodeFrame.refocus();
        }
    }

    class FileAction
    implements ActionListener {
        int returnValue;
        Simulator sim;

        FileAction(Simulator sim) {
            this.sim = sim;
        }

        public void actionPerformed(ActionEvent e) {
            Simulator.this.messageBox.setBackground(new Color(204, 204, 204));
            if (e.getSource() == Simulator.this.fileOpen) {
                if (!Simulator.this.isCodeSaved()) {
                    CodeNotSaved cns = new CodeNotSaved(this.sim, "Existing source code not saved.\nSave file before loading another?", true);
                    cns.showConfirmDialog();
                    if (Simulator.this.unlockedAssemblyCodeFrame != null) {
                        Simulator.this.unlockedAssemblyCodeFrame.refocus();
                    }
                } else {
                    Simulator.this.loadFileToAssemblyCodeBox();
                }
            } else {
                Simulator.this.saveFile();
            }
            Simulator.this.assemblyCodeBox.requestFocusInWindow();
        }
    }
}

