/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import java.util.Vector;

public class Text {
    public static final int ERROR = 0x1000000;

    public static void print(Object o) {
        System.out.println(o);
    }

    public static String lessJavaErrorMessage(String errorMessage) {
        if (errorMessage == null || errorMessage.equals("")) {
            return errorMessage;
        }
        int colonIndex = errorMessage.indexOf(58);
        if (colonIndex == -1) {
            return errorMessage;
        }
        return errorMessage.substring(colonIndex + 1).trim();
    }

    public static String getErrorStackTrace(Exception ex) {
        StackTraceElement[] ste = ex.getStackTrace();
        String s = "";
        for (int i = 0; i < ste.length; ++i) {
            s = s + ste[i].toString() + "\n";
        }
        return s.trim();
    }

    public static String putSpaceBetweenDoubleNewLines(String s) {
        int i;
        if (s == null || s.equals("")) {
            return s;
        }
        Vector<Character> v = new Vector<Character>();
        for (i = 0; i < s.length(); ++i) {
            char character = s.charAt(i);
            if (character == '\n' && i + 1 != s.length() && s.charAt(i + 1) == '\n') {
                v.addElement(new Character('\n'));
                v.addElement(new Character(' '));
                continue;
            }
            v.addElement(new Character(character));
        }
        char[] characters = new char[v.size()];
        for (i = 0; i < v.size(); ++i) {
            characters[i] = ((Character)v.elementAt(i)).charValue();
        }
        return new String(characters);
    }

    public static String addLeadingZeros(int data) {
        String s = "";
        if (data >= 0) {
            if (data < 10) {
                s = "00";
            } else if (data < 100) {
                s = "0";
            }
        }
        s = s + String.valueOf(data);
        return s;
    }

    public static String inHex(int data) {
        return Text.inHex(data, true, 2);
    }

    public static String inHex(int data, boolean withPrefix) {
        return Text.inHex(data, withPrefix, 2);
    }

    public static String inHex(int data, boolean withPrefix, int numberOfHexDigits) {
        return Text.inHex(data, withPrefix, numberOfHexDigits, true);
    }

    public static String inHex(int data, boolean withPrefix, int numberOfHexDigits, boolean addLeadingZero) {
        String hex = Integer.toHexString(data).toUpperCase();
        if (hex.length() > numberOfHexDigits) {
            hex = hex.substring(hex.length() - numberOfHexDigits);
        } else {
            while (hex.length() < numberOfHexDigits) {
                hex = "0" + hex;
            }
        }
        if (withPrefix) {
            hex = "0x" + hex;
        } else if (addLeadingZero && hex.length() > 0 && hex.charAt(0) >= 'A' && hex.charAt(0) <= 'F') {
            hex = "0" + hex;
        }
        return hex;
    }

    private static int removeSingleQuotes(String s) {
        if (s.length() == 4 && s.charAt(0) == '\'' && s.charAt(1) == '\\' && s.charAt(3) == '\'') {
            char c = s.charAt(2);
            if (c == 'b') {
                return 8;
            }
            if (c == 'f') {
                return 12;
            }
            if (c == 'n') {
                return 10;
            }
            if (c == 'r') {
                return 13;
            }
            if (c == 't') {
                return 9;
            }
        } else if (s.length() == 3 && s.charAt(0) == '\'' && s.charAt(2) == '\'') {
            return s.charAt(1);
        }
        return 0x1000000;
    }

    public static int parseNumericData(String s) {
        return Text.parseNumericData(s, false);
    }

    public static int parseNumericData(String s, boolean fromAssembly) {
        s = s.trim();
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            int singleCharatcer = Text.removeSingleQuotes(s);
            if (singleCharatcer != 0x1000000) {
                return singleCharatcer;
            }
            if ((s = s.toUpperCase()).endsWith("H") || s.startsWith("0X")) {
                if (s.endsWith("H")) {
                    if (fromAssembly && (s.charAt(0) < '0' || s.charAt(0) > '9')) {
                        return 0x1000000;
                    }
                    s = s.substring(0, s.length() - 1);
                } else if (s.startsWith("0X")) {
                    s = s.substring(2);
                }
                try {
                    return Integer.parseInt(s, 16);
                }
                catch (Exception ex2) {
                    return 0x1000000;
                }
            }
            if (!s.startsWith("B") && s.endsWith("B")) {
                int data = 0;
                int bit = 0;
                for (int i = s.length() - 2; i >= 0; --i) {
                    if (s.charAt(i) == '1') {
                        data += 1 << bit;
                        ++bit;
                        continue;
                    }
                    if (s.charAt(i) == '0') {
                        ++bit;
                        continue;
                    }
                    return 0x1000000;
                }
                return data;
            }
            return 0x1000000;
        }
    }

    public static int getPcIndex(String text, int pc) {
        String pcString = Text.inHex(pc, false, 4);
        int index = (text = Text.padComments(text)).indexOf(pcString + "|");
        if (index == -1) {
            index = text.indexOf(pcString + "*");
        }
        return index;
    }

    private static String padComments(String s) {
        int commentIndex = 0;
        while ((commentIndex = s.indexOf(59)) != -1) {
            int newLineIndex = s.indexOf(10, commentIndex);
            if (newLineIndex == -1) {
                newLineIndex = s.length();
            }
            String temp = s.substring(0, commentIndex);
            for (int i = commentIndex; i < newLineIndex; ++i) {
                temp = temp + " ";
            }
            s = temp = temp + s.substring(newLineIndex, s.length());
        }
        return s;
    }

    public static String toUpperCaseExceptingQuotedText(String s) {
        if (s.startsWith("DB ")) {
            return s;
        }
        if (s.startsWith("db ")) {
            return "DB " + s.substring(3);
        }
        if (s.indexOf(39) == -1) {
            return s.toUpperCase();
        }
        String upperCase = "";
        for (int i = 0; i < s.length(); ++i) {
            int singleCharLength = Text.getQuotedTextLength(s.substring(i));
            if (singleCharLength != -1) {
                upperCase = upperCase + s.substring(i, i + singleCharLength + 2);
                i = i + singleCharLength + 1;
                continue;
            }
            upperCase = upperCase + s.substring(i, i + 1).toUpperCase();
        }
        return upperCase;
    }

    private static int getQuotedTextLength(String s) {
        if (s.length() == 3) {
            if (s.charAt(0) == '\'' && s.charAt(2) == '\'') {
                return 1;
            }
        } else if (s.length() == 4 && s.charAt(0) == '\'' && s.charAt(1) == '\\' && s.charAt(3) == '\'') {
            return 2;
        }
        return -1;
    }
}

