/*
 * Decompiled with CFR 0.152.
 */
package sim8051;

import sim8051.Ram;

public class Timer0 {
    private boolean t0;
    private Ram dataMemory;

    Timer0(Ram dataMemory) {
        this.dataMemory = dataMemory;
        this.updateT0();
    }

    private void updateT0() {
        int pin = 0;
        try {
            pin = this.dataMemory.port3.getPortPins();
            pin >>= 4;
            pin &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.t0 = pin == 1;
    }

    public int getMode() {
        int tmod = 0;
        try {
            tmod = this.dataMemory.readByte(137);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmod & 3;
    }

    public boolean isRunning() {
        int trBit = 0;
        try {
            trBit = this.dataMemory.getBit(140);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trBit == 1;
    }

    private boolean getGateBit() {
        int gate = 0;
        try {
            gate = this.dataMemory.readByte(137);
            gate >>= 3;
            gate &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gate == 1;
    }

    private boolean getInt0pin() {
        int int0 = 0;
        try {
            int0 = this.dataMemory.port3.getPortPins();
            int0 >>= 2;
            int0 &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return int0 == 1;
    }

    private boolean isCounter() {
        int timerCounter = 0;
        try {
            timerCounter = this.dataMemory.readByte(137);
            timerCounter >>= 2;
            timerCounter &= 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timerCounter == 1;
    }

    public void step() {
        boolean tr0 = false;
        boolean gate = false;
        boolean int0 = false;
        try {
            tr0 = this.dataMemory.getBit(140) == 1;
            gate = this.getGateBit();
            int0 = this.getInt0pin();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!tr0 || gate && !int0) {
            return;
        }
        boolean prevT0 = this.t0;
        this.updateT0();
        int th0 = 0;
        int tl0 = 0;
        int lowByteOverflowValue = 256;
        boolean tf0 = false;
        boolean tf1 = false;
        try {
            th0 = this.dataMemory.readByte(140);
            tl0 = this.dataMemory.readByte(138);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.getMode() == 3 && ++th0 == 256) {
            th0 = 0;
            tf1 = true;
        }
        if (!this.isCounter() || prevT0 && !this.t0) {
            if (this.getMode() == 3) {
                if (++tl0 == 256) {
                    tl0 = 0;
                    tf0 = true;
                }
            } else {
                lowByteOverflowValue = this.getMode() == 0 ? 32 : 256;
                if (++tl0 >= lowByteOverflowValue) {
                    if (this.getMode() == 2) {
                        tl0 = th0;
                        tf0 = true;
                    } else {
                        tl0 = 0;
                        if (++th0 == 256) {
                            th0 = 0;
                            tf0 = true;
                        }
                    }
                }
            }
        }
        try {
            this.dataMemory.writeByte(140, th0);
            this.dataMemory.writeByte(138, tl0);
            if (tf0) {
                this.dataMemory.setBit(141);
            }
            if (tf1) {
                this.dataMemory.setBit(143);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

